/* rygel-l16-transcoder.c generated by valac 0.12.0, the Vala compiler
 * generated from rygel-l16-transcoder.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gst/gst.h>
#include <libgupnp-av/gupnp-av.h>
#include <gst/pbutils/pbutils.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define RYGEL_TYPE_TRANSCODER (rygel_transcoder_get_type ())
#define RYGEL_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoder))
#define RYGEL_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))
#define RYGEL_IS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODER))
#define RYGEL_IS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODER))
#define RYGEL_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))

typedef struct _RygelTranscoder RygelTranscoder;
typedef struct _RygelTranscoderClass RygelTranscoderClass;
typedef struct _RygelTranscoderPrivate RygelTranscoderPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_L16_TRANSCODER (rygel_l16_transcoder_get_type ())
#define RYGEL_L16_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_L16_TRANSCODER, RygelL16Transcoder))
#define RYGEL_L16_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_L16_TRANSCODER, RygelL16TranscoderClass))
#define RYGEL_IS_L16_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_L16_TRANSCODER))
#define RYGEL_IS_L16_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_L16_TRANSCODER))
#define RYGEL_L16_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_L16_TRANSCODER, RygelL16TranscoderClass))

typedef struct _RygelL16Transcoder RygelL16Transcoder;
typedef struct _RygelL16TranscoderClass RygelL16TranscoderClass;
typedef struct _RygelL16TranscoderPrivate RygelL16TranscoderPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;

#define RYGEL_TYPE_VIDEO_ITEM (rygel_video_item_get_type ())
#define RYGEL_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem))
#define RYGEL_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))
#define RYGEL_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))

typedef struct _RygelVideoItem RygelVideoItem;
typedef struct _RygelVideoItemClass RygelVideoItemClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;
typedef struct _RygelAudioItemPrivate RygelAudioItemPrivate;
#define _gst_caps_unref0(var) ((var == NULL) ? NULL : (var = (gst_caps_unref (var), NULL)))
#define _gst_encoding_profile_unref0(var) ((var == NULL) ? NULL : (var = (gst_encoding_profile_unref (var), NULL)))

struct _RygelTranscoder {
	GObject parent_instance;
	RygelTranscoderPrivate * priv;
};

struct _RygelTranscoderClass {
	GObjectClass parent_class;
	GstElement* (*create_source) (RygelTranscoder* self, RygelMediaItem* item, GstElement* src, GError** error);
	GUPnPDIDLLiteResource* (*add_resource) (RygelTranscoder* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error);
	guint (*get_distance) (RygelTranscoder* self, RygelMediaItem* item);
	GstEncodingProfile* (*get_encoding_profile) (RygelTranscoder* self);
};

struct _RygelL16Transcoder {
	RygelTranscoder parent_instance;
	RygelL16TranscoderPrivate * priv;
};

struct _RygelL16TranscoderClass {
	RygelTranscoderClass parent_class;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* ref_id;
	gchar* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	gchar* date;
	gchar* mime_type;
	gchar* dlna_profile;
	GRegex* address_regex;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	GstElement* (*create_stream_source) (RygelMediaItem* self);
	gboolean (*streamable) (RygelMediaItem* self);
	void (*add_uri) (RygelMediaItem* self, const gchar* uri);
	GUPnPDIDLLiteResource* (*add_resource) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
	void (*add_proxy_resources) (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
	GUPnPProtocolInfo* (*get_protocol_info) (RygelMediaItem* self, const gchar* uri, const gchar* protocol);
	void (*add_resources) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
};

struct _RygelAudioItem {
	RygelMediaItem parent_instance;
	RygelAudioItemPrivate * priv;
	glong duration;
	gint bitrate;
	gint sample_freq;
	gint bits_per_sample;
	gint channels;
};

struct _RygelAudioItemClass {
	RygelMediaItemClass parent_class;
};


static gpointer rygel_l16_transcoder_parent_class = NULL;

GType rygel_transcoder_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_l16_transcoder_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_L16_TRANSCODER_DUMMY_PROPERTY
};
#define RYGEL_L16_TRANSCODER_CHANNELS 2
#define RYGEL_L16_TRANSCODER_FREQUENCY 44100
#define RYGEL_L16_TRANSCODER_WIDTH 16
#define RYGEL_L16_TRANSCODER_DEPTH 16
#define RYGEL_L16_TRANSCODER_SIGNED TRUE
#define RYGEL_L16_TRANSCODER_ENDIANNESS ((gint) G_BIG_ENDIAN)
RygelL16Transcoder* rygel_l16_transcoder_new (void);
RygelL16Transcoder* rygel_l16_transcoder_construct (GType object_type);
#define RYGEL_AUDIO_ITEM_UPNP_CLASS "object.item.audioItem"
RygelTranscoder* rygel_transcoder_construct (GType object_type, const gchar* mime_type, const gchar* dlna_profile, const gchar* upnp_class);
static GUPnPDIDLLiteResource* rygel_l16_transcoder_real_add_resource (RygelTranscoder* base, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error);
GUPnPDIDLLiteResource* rygel_transcoder_add_resource (RygelTranscoder* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error);
static guint rygel_l16_transcoder_real_get_distance (RygelTranscoder* base, RygelMediaItem* item);
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
GType rygel_video_item_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
static GstEncodingProfile* rygel_l16_transcoder_real_get_encoding_profile (RygelTranscoder* base);


RygelL16Transcoder* rygel_l16_transcoder_construct (GType object_type) {
	RygelL16Transcoder * self = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* mime_type;
	_tmp0_ = g_strdup_printf ("%i", RYGEL_L16_TRANSCODER_WIDTH);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat ("audio/L", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp3_, ";rate=", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf ("%i", RYGEL_L16_TRANSCODER_FREQUENCY);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp5_, _tmp7_, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp9_, ";channels=", NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strdup_printf ("%i", RYGEL_L16_TRANSCODER_CHANNELS);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat (_tmp11_, _tmp13_, NULL);
	_tmp15_ = _tmp14_;
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	mime_type = _tmp15_;
	self = (RygelL16Transcoder*) rygel_transcoder_construct (object_type, mime_type, "LPCM", RYGEL_AUDIO_ITEM_UPNP_CLASS);
	_g_free0 (mime_type);
	return self;
}


RygelL16Transcoder* rygel_l16_transcoder_new (void) {
	return rygel_l16_transcoder_construct (RYGEL_TYPE_L16_TRANSCODER);
}


static GUPnPDIDLLiteResource* rygel_l16_transcoder_real_add_resource (RygelTranscoder* base, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error) {
	RygelL16Transcoder * self;
	GUPnPDIDLLiteResource* result = NULL;
	GUPnPDIDLLiteResource* _tmp0_ = NULL;
	GUPnPDIDLLiteResource* resource;
	GError * _inner_error_ = NULL;
	self = (RygelL16Transcoder*) base;
	g_return_val_if_fail (didl_item != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	g_return_val_if_fail (manager != NULL, NULL);
	_tmp0_ = RYGEL_TRANSCODER_CLASS (rygel_l16_transcoder_parent_class)->add_resource (RYGEL_TRANSCODER (self), didl_item, item, manager, &_inner_error_);
	resource = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	if (resource == NULL) {
		result = NULL;
		_g_object_unref0 (resource);
		return result;
	}
	gupnp_didl_lite_resource_set_sample_freq (resource, RYGEL_L16_TRANSCODER_FREQUENCY);
	gupnp_didl_lite_resource_set_audio_channels (resource, RYGEL_L16_TRANSCODER_CHANNELS);
	gupnp_didl_lite_resource_set_bits_per_sample (resource, RYGEL_L16_TRANSCODER_WIDTH);
	gupnp_didl_lite_resource_set_bitrate (resource, ((RYGEL_L16_TRANSCODER_FREQUENCY * RYGEL_L16_TRANSCODER_CHANNELS) * RYGEL_L16_TRANSCODER_WIDTH) / 8);
	result = resource;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static guint rygel_l16_transcoder_real_get_distance (RygelTranscoder* base, RygelMediaItem* item) {
	RygelL16Transcoder * self;
	guint result = 0U;
	gboolean _tmp0_ = FALSE;
	RygelMediaItem* _tmp1_;
	RygelAudioItem* _tmp2_;
	RygelAudioItem* audio_item;
	guint distance;
	self = (RygelL16Transcoder*) base;
	g_return_val_if_fail (item != NULL, 0U);
	if (!RYGEL_IS_AUDIO_ITEM (item)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = RYGEL_IS_VIDEO_ITEM (item);
	}
	if (_tmp0_) {
		result = G_MAXUINT;
		return result;
	}
	_tmp1_ = item;
	_tmp2_ = _g_object_ref0 (RYGEL_IS_AUDIO_ITEM (_tmp1_) ? ((RygelAudioItem*) _tmp1_) : NULL);
	audio_item = _tmp2_;
	distance = 0;
	if (audio_item->sample_freq > 0) {
		gint _tmp3_;
		_tmp3_ = abs (audio_item->sample_freq - RYGEL_L16_TRANSCODER_FREQUENCY);
		distance = distance + ((guint) _tmp3_);
	}
	if (audio_item->channels > 0) {
		gint _tmp4_;
		_tmp4_ = abs (audio_item->channels - RYGEL_L16_TRANSCODER_CHANNELS);
		distance = distance + ((guint) _tmp4_);
	}
	if (audio_item->bits_per_sample > 0) {
		gint _tmp5_;
		_tmp5_ = abs (audio_item->bits_per_sample - RYGEL_L16_TRANSCODER_WIDTH);
		distance = distance + ((guint) _tmp5_);
	}
	result = distance;
	_g_object_unref0 (audio_item);
	return result;
}


static gchar* bool_to_string (gboolean self) {
	gchar* result = NULL;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}


static GstEncodingProfile* rygel_l16_transcoder_real_get_encoding_profile (RygelTranscoder* base) {
	RygelL16Transcoder * self;
	GstEncodingProfile* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_ = NULL;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* caps_str;
	GstCaps* _tmp34_ = NULL;
	GstCaps* format;
	GstEncodingAudioProfile* _tmp35_ = NULL;
	GstEncodingAudioProfile* encoding_profile;
	self = (RygelL16Transcoder*) base;
	_tmp0_ = g_strdup_printf ("%i", RYGEL_L16_TRANSCODER_CHANNELS);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat ("audio/x-raw-int" ",channels=", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp3_, ",rate=", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf ("%i", RYGEL_L16_TRANSCODER_FREQUENCY);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp5_, _tmp7_, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp9_, ",width=", NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strdup_printf ("%i", RYGEL_L16_TRANSCODER_WIDTH);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat (_tmp11_, _tmp13_, NULL);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_strconcat (_tmp15_, ",depth=", NULL);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_strdup_printf ("%i", RYGEL_L16_TRANSCODER_DEPTH);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_strconcat (_tmp17_, _tmp19_, NULL);
	_tmp21_ = _tmp20_;
	_tmp22_ = g_strconcat (_tmp21_, ",signed=", NULL);
	_tmp23_ = _tmp22_;
	_tmp24_ = bool_to_string (RYGEL_L16_TRANSCODER_SIGNED);
	_tmp25_ = _tmp24_;
	_tmp26_ = g_strconcat (_tmp23_, _tmp25_, NULL);
	_tmp27_ = _tmp26_;
	_tmp28_ = g_strconcat (_tmp27_, ",endianness=", NULL);
	_tmp29_ = _tmp28_;
	_tmp30_ = g_strdup_printf ("%i", RYGEL_L16_TRANSCODER_ENDIANNESS);
	_tmp31_ = _tmp30_;
	_tmp32_ = g_strconcat (_tmp29_, _tmp31_, NULL);
	_tmp33_ = _tmp32_;
	_g_free0 (_tmp31_);
	_g_free0 (_tmp29_);
	_g_free0 (_tmp27_);
	_g_free0 (_tmp25_);
	_g_free0 (_tmp23_);
	_g_free0 (_tmp21_);
	_g_free0 (_tmp19_);
	_g_free0 (_tmp17_);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	caps_str = _tmp33_;
	_tmp34_ = gst_caps_from_string (caps_str);
	format = _tmp34_;
	_tmp35_ = gst_encoding_audio_profile_new (format, NULL, NULL, (guint) 1);
	encoding_profile = _tmp35_;
	result = (GstEncodingProfile*) encoding_profile;
	_gst_caps_unref0 (format);
	_g_free0 (caps_str);
	return result;
}


static void rygel_l16_transcoder_class_init (RygelL16TranscoderClass * klass) {
	rygel_l16_transcoder_parent_class = g_type_class_peek_parent (klass);
	RYGEL_TRANSCODER_CLASS (klass)->add_resource = rygel_l16_transcoder_real_add_resource;
	RYGEL_TRANSCODER_CLASS (klass)->get_distance = rygel_l16_transcoder_real_get_distance;
	RYGEL_TRANSCODER_CLASS (klass)->get_encoding_profile = rygel_l16_transcoder_real_get_encoding_profile;
}


static void rygel_l16_transcoder_instance_init (RygelL16Transcoder * self) {
}


/**
 * Transcoder for linear PCM audio (LPCM).
 */
GType rygel_l16_transcoder_get_type (void) {
	static volatile gsize rygel_l16_transcoder_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_l16_transcoder_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelL16TranscoderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_l16_transcoder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelL16Transcoder), 0, (GInstanceInitFunc) rygel_l16_transcoder_instance_init, NULL };
		GType rygel_l16_transcoder_type_id;
		rygel_l16_transcoder_type_id = g_type_register_static (RYGEL_TYPE_TRANSCODER, "RygelL16Transcoder", &g_define_type_info, 0);
		g_once_init_leave (&rygel_l16_transcoder_type_id__volatile, rygel_l16_transcoder_type_id);
	}
	return rygel_l16_transcoder_type_id__volatile;
}



