/* rygel-http-response.c generated by valac 0.12.0, the Vala compiler
 * generated from rygel-http-response.vala, do not modify */

/*
 * Copyright (C) 2008 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <libsoup/soup.h>
#include <gst/gst.h>
#include <stdlib.h>
#include <string.h>
#include <gst/base/gstbasesink.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_HTTP_RESPONSE (rygel_http_response_get_type ())
#define RYGEL_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse))
#define RYGEL_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))
#define RYGEL_IS_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_IS_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_HTTP_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))

typedef struct _RygelHTTPResponse RygelHTTPResponse;
typedef struct _RygelHTTPResponseClass RygelHTTPResponseClass;
typedef struct _RygelHTTPResponsePrivate RygelHTTPResponsePrivate;

#define RYGEL_TYPE_HTTP_SEEK (rygel_http_seek_get_type ())
#define RYGEL_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeek))
#define RYGEL_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))
#define RYGEL_IS_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_IS_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_HTTP_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))

typedef struct _RygelHTTPSeek RygelHTTPSeek;
typedef struct _RygelHTTPSeekClass RygelHTTPSeekClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;

#define RYGEL_TYPE_HTTP_GET_HANDLER (rygel_http_get_handler_get_type ())
#define RYGEL_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler))
#define RYGEL_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))
#define RYGEL_IS_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_IS_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_HTTP_GET_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))

typedef struct _RygelHTTPGetHandler RygelHTTPGetHandler;
typedef struct _RygelHTTPGetHandlerClass RygelHTTPGetHandlerClass;
typedef struct _RygelHTTPGetPrivate RygelHTTPGetPrivate;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelHTTPGetHandlerPrivate RygelHTTPGetHandlerPrivate;

#define RYGEL_TYPE_HTTP_BYTE_SEEK (rygel_http_byte_seek_get_type ())
#define RYGEL_HTTP_BYTE_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeek))
#define RYGEL_HTTP_BYTE_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeekClass))
#define RYGEL_IS_HTTP_BYTE_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK))
#define RYGEL_IS_HTTP_BYTE_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK))
#define RYGEL_HTTP_BYTE_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeekClass))

typedef struct _RygelHTTPByteSeek RygelHTTPByteSeek;
typedef struct _RygelHTTPByteSeekClass RygelHTTPByteSeekClass;
typedef struct _RygelHttpResponseRunData RygelHttpResponseRunData;

#define RYGEL_TYPE_HTTP_GST_SINK (rygel_http_gst_sink_get_type ())
#define RYGEL_HTTP_GST_SINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GST_SINK, RygelHTTPGstSink))
#define RYGEL_HTTP_GST_SINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GST_SINK, RygelHTTPGstSinkClass))
#define RYGEL_IS_HTTP_GST_SINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GST_SINK))
#define RYGEL_IS_HTTP_GST_SINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GST_SINK))
#define RYGEL_HTTP_GST_SINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GST_SINK, RygelHTTPGstSinkClass))

typedef struct _RygelHTTPGstSink RygelHTTPGstSink;
typedef struct _RygelHTTPGstSinkClass RygelHTTPGstSinkClass;
typedef struct _RygelHTTPGstSinkPrivate RygelHTTPGstSinkPrivate;
#define _gst_caps_unref0(var) ((var == NULL) ? NULL : (var = (gst_caps_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_HTTP_TIME_SEEK (rygel_http_time_seek_get_type ())
#define RYGEL_HTTP_TIME_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeek))
#define RYGEL_HTTP_TIME_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeekClass))
#define RYGEL_IS_HTTP_TIME_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_TIME_SEEK))
#define RYGEL_IS_HTTP_TIME_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_TIME_SEEK))
#define RYGEL_HTTP_TIME_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeekClass))

typedef struct _RygelHTTPTimeSeek RygelHTTPTimeSeek;
typedef struct _RygelHTTPTimeSeekClass RygelHTTPTimeSeekClass;

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelHTTPResponse {
	GObject parent_instance;
	RygelHTTPResponsePrivate * priv;
	SoupMessage* msg;
	RygelHTTPSeek* seek;
};

struct _RygelHTTPResponseClass {
	GObjectClass parent_class;
	void (*end) (RygelHTTPResponse* self, gboolean aborted, guint status);
};

struct _RygelHTTPResponsePrivate {
	SoupServer* _server;
	GCancellable* _cancellable;
	GSourceFunc run_continue;
	gpointer run_continue_target;
	GDestroyNotify run_continue_target_destroy_notify;
	gint _priority;
	GstPipeline* pipeline;
	guint bus_watch_id;
};

struct _RygelHTTPGet {
	GObject parent_instance;
	RygelHTTPGetPrivate * priv;
	SoupServer* server;
	SoupMessage* msg;
	GCancellable* cancellable;
	RygelMediaItem* item;
	RygelHTTPSeek* seek;
};

struct _RygelHTTPGetClass {
	GObjectClass parent_class;
};

struct _RygelHTTPGetHandler {
	GObject parent_instance;
	RygelHTTPGetHandlerPrivate * priv;
	GCancellable* cancellable;
};

struct _RygelHTTPGetHandlerClass {
	GObjectClass parent_class;
};

struct _RygelHttpResponseRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPResponse* self;
	gboolean _tmp0_;
	gint64 _tmp1_;
};

struct _RygelHTTPGstSink {
	GstBaseSink parent_instance;
	RygelHTTPGstSinkPrivate * priv;
	GCancellable* cancellable;
};

struct _RygelHTTPGstSinkClass {
	GstBaseSinkClass parent_class;
};

typedef enum  {
	RYGEL_GST_ERROR_MISSING_PLUGIN,
	RYGEL_GST_ERROR_LINK
} RygelGstError;
#define RYGEL_GST_ERROR rygel_gst_error_quark ()

static gpointer rygel_http_response_parent_class = NULL;
static RygelStateMachineIface* rygel_http_response_rygel_state_machine_parent_iface = NULL;

GType rygel_state_machine_get_type (void) G_GNUC_CONST;
GType rygel_http_response_get_type (void) G_GNUC_CONST;
GType rygel_http_seek_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_RESPONSE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponsePrivate))
enum  {
	RYGEL_HTTP_RESPONSE_DUMMY_PROPERTY,
	RYGEL_HTTP_RESPONSE_SERVER,
	RYGEL_HTTP_RESPONSE_CANCELLABLE,
	RYGEL_HTTP_RESPONSE_PRIORITY
};
GType rygel_http_get_get_type (void) G_GNUC_CONST;
GType rygel_http_get_handler_get_type (void) G_GNUC_CONST;
RygelHTTPResponse* rygel_http_response_new (RygelHTTPGet* request, RygelHTTPGetHandler* request_handler, GstElement* src, GError** error);
RygelHTTPResponse* rygel_http_response_construct (GType object_type, RygelHTTPGet* request, RygelHTTPGetHandler* request_handler, GstElement* src, GError** error);
gpointer rygel_media_item_ref (gpointer instance);
void rygel_media_item_unref (gpointer instance);
GParamSpec* rygel_param_spec_media_item (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_media_item (GValue* value, gpointer v_object);
void rygel_value_take_media_item (GValue* value, gpointer v_object);
gpointer rygel_value_get_media_item (const GValue* value);
GType rygel_media_item_get_type (void) G_GNUC_CONST;
static void rygel_http_response_set_server (RygelHTTPResponse* self, SoupServer* value);
void rygel_state_machine_set_cancellable (RygelStateMachine* self, GCancellable* value);
GType rygel_http_byte_seek_get_type (void) G_GNUC_CONST;
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
static void rygel_http_response_on_cancelled (RygelHTTPResponse* self, GCancellable* cancellable);
static void _rygel_http_response_on_cancelled_g_cancellable_cancelled (GCancellable* _sender, gpointer self);
static void rygel_http_response_prepare_pipeline (RygelHTTPResponse* self, const gchar* name, GstElement* src, GError** error);
static void rygel_http_response_real_run_data_free (gpointer _data);
static void rygel_http_response_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_http_response_real_run_co (RygelHttpResponseRunData* data);
gint64 rygel_http_seek_get_start (RygelHTTPSeek* self);
void rygel_state_machine_run (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_state_machine_run_finish (RygelStateMachine* self, GAsyncResult* _res_);
static gboolean _rygel_http_response_real_run_co_gsource_func (gpointer self);
void rygel_http_response_push_data (RygelHTTPResponse* self, guint8* data, int data_length1);
SoupServer* rygel_http_response_get_server (RygelHTTPResponse* self);
void rygel_http_response_end (RygelHTTPResponse* self, gboolean aborted, guint status);
static void rygel_http_response_real_end (RygelHTTPResponse* self, gboolean aborted, guint status);
#define RYGEL_HTTP_GST_SINK_NAME "http-gst-sink"
GType rygel_http_gst_sink_get_type (void) G_GNUC_CONST;
RygelHTTPGstSink* rygel_http_gst_sink_new (RygelHTTPResponse* response);
RygelHTTPGstSink* rygel_http_gst_sink_construct (GType object_type, RygelHTTPResponse* response);
static void rygel_http_response_src_pad_added (RygelHTTPResponse* self, GstElement* src, GstPad* src_pad);
static void _rygel_http_response_src_pad_added_gst_element_pad_added (GstElement* _sender, GstPad* pad, gpointer self);
GQuark rygel_gst_error_quark (void);
static gboolean rygel_http_response_bus_handler (RygelHTTPResponse* self, GstBus* bus, GstMessage* message);
static gboolean _rygel_http_response_bus_handler_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self);
GstElement* rygel_gst_utils_get_rtp_depayloader (GstCaps* caps);
static gboolean rygel_http_response_perform_seek (RygelHTTPResponse* self);
gint rygel_http_response_get_priority (RygelHTTPResponse* self);
static gboolean _lambda3_ (RygelHTTPResponse* self);
static gboolean __lambda3__gsource_func (gpointer self);
GType rygel_http_time_seek_get_type (void) G_GNUC_CONST;
gint64 rygel_http_seek_get_stop (RygelHTTPSeek* self);
static void rygel_http_response_finalize (GObject* obj);
static void _vala_rygel_http_response_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_http_response_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _rygel_http_response_on_cancelled_g_cancellable_cancelled (GCancellable* _sender, gpointer self) {
	rygel_http_response_on_cancelled (self, _sender);
}


RygelHTTPResponse* rygel_http_response_construct (GType object_type, RygelHTTPGet* request, RygelHTTPGetHandler* request_handler, GstElement* src, GError** error) {
	RygelHTTPResponse * self = NULL;
	SoupMessage* _tmp0_;
	RygelHTTPSeek* _tmp1_;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GCancellable* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (request != NULL, NULL);
	g_return_val_if_fail (request_handler != NULL, NULL);
	g_return_val_if_fail (src != NULL, NULL);
	self = (RygelHTTPResponse*) g_object_new (object_type, NULL);
	rygel_http_response_set_server (self, request->server);
	_tmp0_ = _g_object_ref0 (request->msg);
	_g_object_unref0 (self->msg);
	self->msg = _tmp0_;
	rygel_state_machine_set_cancellable ((RygelStateMachine*) self, request_handler->cancellable);
	_tmp1_ = _g_object_ref0 (request->seek);
	_g_object_unref0 (self->seek);
	self->seek = _tmp1_;
	_tmp2_ = soup_message_headers_get_one (request->msg->request_headers, "Range");
	if (_tmp2_ != NULL) {
		soup_message_set_status (self->msg, (guint) SOUP_STATUS_PARTIAL_CONTENT);
	} else {
		soup_message_set_status (self->msg, (guint) SOUP_STATUS_OK);
	}
	if (self->seek != NULL) {
		_tmp3_ = RYGEL_IS_HTTP_BYTE_SEEK (self->seek);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		soup_message_headers_set_encoding (self->msg->response_headers, SOUP_ENCODING_CONTENT_LENGTH);
	} else {
		soup_message_headers_set_encoding (self->msg->response_headers, SOUP_ENCODING_EOF);
	}
	_tmp4_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
	if (_tmp4_ != NULL) {
		GCancellable* _tmp5_ = NULL;
		_tmp5_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
		g_signal_connect_object (_tmp5_, "cancelled", (GCallback) _rygel_http_response_on_cancelled_g_cancellable_cancelled, self, 0);
	}
	soup_message_body_set_accumulate (self->msg->response_body, FALSE);
	rygel_http_response_prepare_pipeline (self, "RygelHTTPGstResponse", src, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	return self;
}


RygelHTTPResponse* rygel_http_response_new (RygelHTTPGet* request, RygelHTTPGetHandler* request_handler, GstElement* src, GError** error) {
	return rygel_http_response_construct (RYGEL_TYPE_HTTP_RESPONSE, request, request_handler, src, error);
}


static void rygel_http_response_real_run_data_free (gpointer _data) {
	RygelHttpResponseRunData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (RygelHttpResponseRunData, data);
}


static void rygel_http_response_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHTTPResponse * self;
	RygelHttpResponseRunData* _data_;
	self = (RygelHTTPResponse*) base;
	_data_ = g_slice_new0 (RygelHttpResponseRunData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_response_real_run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_response_real_run_data_free);
	_data_->self = _g_object_ref0 (self);
	rygel_http_response_real_run_co (_data_);
}


static void rygel_http_response_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelHttpResponseRunData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean _rygel_http_response_real_run_co_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_http_response_real_run_co (self);
	return result;
}


static gboolean rygel_http_response_real_run_co (RygelHttpResponseRunData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (data->self->seek != NULL) {
		data->_tmp1_ = rygel_http_seek_get_start (data->self->seek);
		data->_tmp0_ = data->_tmp1_ > 0;
	} else {
		data->_tmp0_ = FALSE;
	}
	if (data->_tmp0_) {
		gst_element_set_state ((GstElement*) data->self->priv->pipeline, GST_STATE_PAUSED);
	} else {
		gst_element_set_state ((GstElement*) data->self->priv->pipeline, GST_STATE_PLAYING);
	}
	(data->self->priv->run_continue_target_destroy_notify == NULL) ? NULL : (data->self->priv->run_continue_target_destroy_notify (data->self->priv->run_continue_target), NULL);
	data->self->priv->run_continue = NULL;
	data->self->priv->run_continue_target = NULL;
	data->self->priv->run_continue_target_destroy_notify = NULL;
	data->self->priv->run_continue = _rygel_http_response_real_run_co_gsource_func;
	data->self->priv->run_continue_target = data;
	data->self->priv->run_continue_target_destroy_notify = NULL;
	data->_state_ = 1;
	return FALSE;
	_state_1:
	;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


void rygel_http_response_push_data (RygelHTTPResponse* self, guint8* data, int data_length1) {
	g_return_if_fail (self != NULL);
	soup_message_body_append (self->msg->response_body, SOUP_MEMORY_COPY, (gconstpointer) data, (gsize) data_length1);
	soup_server_unpause_message (self->priv->_server, self->msg);
}


static void rygel_http_response_real_end (RygelHTTPResponse* self, gboolean aborted, guint status) {
	GstElement* _tmp0_ = NULL;
	GstElement* _tmp1_;
	RygelHTTPGstSink* sink;
	SoupEncoding _tmp2_;
	SoupEncoding encoding;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = gst_bin_get_by_name ((GstBin*) self->priv->pipeline, RYGEL_HTTP_GST_SINK_NAME);
	_tmp1_ = _tmp0_;
	sink = RYGEL_IS_HTTP_GST_SINK (_tmp1_) ? ((RygelHTTPGstSink*) _tmp1_) : NULL;
	g_cancellable_cancel (sink->cancellable);
	gst_element_set_state ((GstElement*) self->priv->pipeline, GST_STATE_NULL);
	g_source_remove (self->priv->bus_watch_id);
	_tmp2_ = soup_message_headers_get_encoding (self->msg->response_headers);
	encoding = _tmp2_;
	if (!aborted) {
		_tmp3_ = encoding != SOUP_ENCODING_CONTENT_LENGTH;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		soup_message_body_complete (self->msg->response_body);
		soup_server_unpause_message (self->priv->_server, self->msg);
	}
	if (self->priv->run_continue != NULL) {
		self->priv->run_continue (self->priv->run_continue_target);
	}
	if (status != SOUP_STATUS_NONE) {
		soup_message_set_status (self->msg, status);
	}
	g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
	_gst_object_unref0 (sink);
}


void rygel_http_response_end (RygelHTTPResponse* self, gboolean aborted, guint status) {
	RYGEL_HTTP_RESPONSE_GET_CLASS (self)->end (self, aborted, status);
}


static void rygel_http_response_on_cancelled (RygelHTTPResponse* self, GCancellable* cancellable) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (cancellable != NULL);
	rygel_http_response_end (self, TRUE, (guint) SOUP_STATUS_CANCELLED);
}


static gpointer _gst_object_ref0 (gpointer self) {
	return self ? gst_object_ref (self) : NULL;
}


static void _rygel_http_response_src_pad_added_gst_element_pad_added (GstElement* _sender, GstPad* pad, gpointer self) {
	rygel_http_response_src_pad_added (self, _sender, pad);
}


static gboolean _rygel_http_response_bus_handler_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self) {
	gboolean result;
	result = rygel_http_response_bus_handler (self, bus, message);
	return result;
}


static void rygel_http_response_prepare_pipeline (RygelHTTPResponse* self, const gchar* name, GstElement* src, GError** error) {
	RygelHTTPGstSink* _tmp0_ = NULL;
	RygelHTTPGstSink* sink;
	GstPipeline* _tmp1_ = NULL;
	GstElement* _tmp2_;
	GstElement* _tmp3_;
	GstBus* _tmp9_ = NULL;
	GstBus* bus;
	guint _tmp10_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (src != NULL);
	_tmp0_ = rygel_http_gst_sink_new (self);
	sink = _tmp0_;
	_tmp1_ = (GstPipeline*) gst_pipeline_new (name);
	_gst_object_unref0 (self->priv->pipeline);
	self->priv->pipeline = _tmp1_;
	g_assert (self->priv->pipeline != NULL);
	_tmp2_ = _gst_object_ref0 (src);
	_tmp3_ = _gst_object_ref0 ((GstElement*) sink);
	gst_bin_add_many ((GstBin*) self->priv->pipeline, _tmp2_, _tmp3_, NULL);
	if (src->numpads == 0) {
		g_signal_connect_object (src, "pad-added", (GCallback) _rygel_http_response_src_pad_added_gst_element_pad_added, self, 0);
	} else {
		gboolean _tmp4_;
		_tmp4_ = gst_element_link (src, (GstElement*) sink);
		if (!_tmp4_) {
			const gchar* _tmp5_ = NULL;
			const gchar* _tmp6_ = NULL;
			const gchar* _tmp7_ = NULL;
			GError* _tmp8_ = NULL;
			_tmp5_ = _ ("Failed to link %s to %s");
			_tmp6_ = gst_object_get_name ((GstObject*) src);
			_tmp7_ = gst_object_get_name ((GstObject*) sink);
			_tmp8_ = g_error_new (RYGEL_GST_ERROR, RYGEL_GST_ERROR_LINK, _tmp5_, _tmp6_, _tmp7_);
			_inner_error_ = _tmp8_;
			g_propagate_error (error, _inner_error_);
			_gst_object_unref0 (sink);
			return;
		}
	}
	_tmp9_ = gst_pipeline_get_bus (self->priv->pipeline);
	bus = _tmp9_;
	_tmp10_ = gst_bus_add_watch_full (bus, G_PRIORITY_DEFAULT, _rygel_http_response_bus_handler_gst_bus_func, g_object_ref (self), g_object_unref);
	self->priv->bus_watch_id = _tmp10_;
	_gst_object_unref0 (bus);
	_gst_object_unref0 (sink);
}


static void rygel_http_response_src_pad_added (RygelHTTPResponse* self, GstElement* src, GstPad* src_pad) {
	GstCaps* _tmp0_ = NULL;
	GstCaps* caps;
	GstElement* _tmp1_ = NULL;
	GstElement* sink;
	GstPad* sink_pad = NULL;
	GstElement* _tmp2_ = NULL;
	GstElement* depay;
	GstPadLinkReturn _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (src != NULL);
	g_return_if_fail (src_pad != NULL);
	_tmp0_ = gst_pad_get_caps (src_pad);
	caps = _tmp0_;
	_tmp1_ = gst_bin_get_by_name ((GstBin*) self->priv->pipeline, RYGEL_HTTP_GST_SINK_NAME);
	sink = _tmp1_;
	_tmp2_ = rygel_gst_utils_get_rtp_depayloader (caps);
	depay = _tmp2_;
	if (depay != NULL) {
		GstElement* _tmp3_;
		gboolean _tmp4_;
		GstPad* _tmp8_ = NULL;
		_tmp3_ = _gst_object_ref0 (depay);
		gst_bin_add ((GstBin*) self->priv->pipeline, _tmp3_);
		_tmp4_ = gst_element_link (depay, sink);
		if (!_tmp4_) {
			const gchar* _tmp5_ = NULL;
			const gchar* _tmp6_ = NULL;
			const gchar* _tmp7_ = NULL;
			_tmp5_ = _ ("Failed to link %s to %s");
			_tmp6_ = gst_object_get_name ((GstObject*) depay);
			_tmp7_ = gst_object_get_name ((GstObject*) sink);
			g_critical (_tmp5_, _tmp6_, _tmp7_);
			rygel_http_response_end (self, FALSE, (guint) SOUP_STATUS_NONE);
			_gst_object_unref0 (depay);
			_gst_object_unref0 (sink_pad);
			_gst_object_unref0 (sink);
			_gst_caps_unref0 (caps);
			return;
		}
		_tmp8_ = gst_element_get_compatible_pad (depay, src_pad, caps);
		_gst_object_unref0 (sink_pad);
		sink_pad = _tmp8_;
	} else {
		GstPad* _tmp9_ = NULL;
		_tmp9_ = gst_element_get_compatible_pad (sink, src_pad, caps);
		_gst_object_unref0 (sink_pad);
		sink_pad = _tmp9_;
	}
	_tmp10_ = gst_pad_link (src_pad, sink_pad);
	if (_tmp10_ != GST_PAD_LINK_OK) {
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		_tmp11_ = _ ("Failed to link pad %s to %s");
		_tmp12_ = gst_object_get_name ((GstObject*) src_pad);
		_tmp13_ = gst_object_get_name ((GstObject*) sink_pad);
		g_critical (_tmp11_, _tmp12_, _tmp13_);
		rygel_http_response_end (self, FALSE, (guint) SOUP_STATUS_NONE);
		_gst_object_unref0 (depay);
		_gst_object_unref0 (sink_pad);
		_gst_object_unref0 (sink);
		_gst_caps_unref0 (caps);
		return;
	}
	if (depay != NULL) {
		gst_element_sync_state_with_parent (depay);
	}
	_gst_object_unref0 (depay);
	_gst_object_unref0 (sink_pad);
	_gst_object_unref0 (sink);
	_gst_caps_unref0 (caps);
}


static gboolean _lambda3_ (RygelHTTPResponse* self) {
	gboolean result = FALSE;
	GCancellable* _tmp0_ = NULL;
	gboolean _tmp1_;
	_tmp0_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
	_tmp1_ = g_cancellable_is_cancelled (_tmp0_);
	if (!_tmp1_) {
		rygel_http_response_end (self, FALSE, (guint) SOUP_STATUS_NONE);
	}
	result = FALSE;
	return result;
}


static gboolean __lambda3__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda3_ (self);
	return result;
}


static gboolean rygel_http_response_bus_handler (RygelHTTPResponse* self, GstBus* bus, GstMessage* message) {
	gboolean result = FALSE;
	gboolean ret;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (bus != NULL, FALSE);
	g_return_val_if_fail (message != NULL, FALSE);
	ret = TRUE;
	if (message->type == GST_MESSAGE_EOS) {
		ret = FALSE;
	} else {
		if (message->type == GST_MESSAGE_STATE_CHANGED) {
			gboolean _tmp0_ = FALSE;
			if (message->src != GST_OBJECT (self->priv->pipeline)) {
				result = TRUE;
				return result;
			}
			if (self->seek != NULL) {
				gint64 _tmp1_;
				_tmp1_ = rygel_http_seek_get_start (self->seek);
				_tmp0_ = _tmp1_ > 0;
			} else {
				_tmp0_ = FALSE;
			}
			if (_tmp0_) {
				GstState old_state = 0;
				GstState new_state = 0;
				GstState _tmp2_;
				GstState _tmp3_;
				gboolean _tmp4_ = FALSE;
				gst_message_parse_state_changed (message, &_tmp2_, &_tmp3_, NULL);
				old_state = _tmp2_;
				new_state = _tmp3_;
				if (old_state == GST_STATE_READY) {
					_tmp4_ = new_state == GST_STATE_PAUSED;
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					gboolean _tmp5_;
					_tmp5_ = rygel_http_response_perform_seek (self);
					if (_tmp5_) {
						gst_element_set_state ((GstElement*) self->priv->pipeline, GST_STATE_PLAYING);
					}
				}
			}
		} else {
			GError* err = NULL;
			gchar* err_msg = NULL;
			if (message->type == GST_MESSAGE_ERROR) {
				GError* _tmp6_ = NULL;
				gchar* _tmp7_ = NULL;
				const gchar* _tmp8_ = NULL;
				const gchar* _tmp9_ = NULL;
				gst_message_parse_error (message, &_tmp6_, &_tmp7_);
				_g_error_free0 (err);
				err = _tmp6_;
				_g_free0 (err_msg);
				err_msg = _tmp7_;
				_tmp8_ = _ ("Error from pipeline %s: %s");
				_tmp9_ = gst_object_get_name ((GstObject*) self->priv->pipeline);
				g_critical (_tmp8_, _tmp9_, err_msg);
				ret = FALSE;
			} else {
				if (message->type == GST_MESSAGE_WARNING) {
					GError* _tmp10_ = NULL;
					gchar* _tmp11_ = NULL;
					const gchar* _tmp12_ = NULL;
					const gchar* _tmp13_ = NULL;
					gst_message_parse_warning (message, &_tmp10_, &_tmp11_);
					_g_error_free0 (err);
					err = _tmp10_;
					_g_free0 (err_msg);
					err_msg = _tmp11_;
					_tmp12_ = _ ("Warning from pipeline %s: %s");
					_tmp13_ = gst_object_get_name ((GstObject*) self->priv->pipeline);
					g_warning (_tmp12_, _tmp13_, err_msg);
				}
			}
			_g_free0 (err_msg);
			_g_error_free0 (err);
		}
	}
	if (!ret) {
		gint _tmp14_;
		_tmp14_ = rygel_http_response_get_priority (self);
		g_idle_add_full (_tmp14_, __lambda3__gsource_func, g_object_ref (self), g_object_unref);
	}
	result = ret;
	return result;
}


static gboolean rygel_http_response_perform_seek (RygelHTTPResponse* self) {
	gboolean result = FALSE;
	GstSeekType stop_type;
	GstFormat format = 0;
	gint64 _tmp1_;
	gint64 _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	stop_type = GST_SEEK_TYPE_NONE;
	if (RYGEL_IS_HTTP_TIME_SEEK (self->seek)) {
		gint64 _tmp0_;
		format = GST_FORMAT_TIME;
		_tmp0_ = rygel_http_seek_get_stop (self->seek);
		if (_tmp0_ > 0) {
			stop_type = GST_SEEK_TYPE_SET;
		}
	} else {
		format = GST_FORMAT_BYTES;
	}
	_tmp1_ = rygel_http_seek_get_start (self->seek);
	_tmp2_ = rygel_http_seek_get_stop (self->seek);
	_tmp3_ = gst_element_seek ((GstElement*) self->priv->pipeline, 1.0, format, GST_SEEK_FLAG_FLUSH | GST_SEEK_FLAG_ACCURATE, GST_SEEK_TYPE_SET, _tmp1_, stop_type, _tmp2_);
	if (!_tmp3_) {
		const gchar* _tmp4_ = NULL;
		gint64 _tmp5_;
		_tmp4_ = _ ("Failed to seek to offset %lld");
		_tmp5_ = rygel_http_seek_get_start (self->seek);
		g_warning (_tmp4_, _tmp5_);
		rygel_http_response_end (self, FALSE, (guint) SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE);
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


SoupServer* rygel_http_response_get_server (RygelHTTPResponse* self) {
	SoupServer* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_server;
	return result;
}


static void rygel_http_response_set_server (RygelHTTPResponse* self, SoupServer* value) {
	SoupServer* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_server);
	self->priv->_server = _tmp0_;
	g_object_notify ((GObject *) self, "server");
}


static GCancellable* rygel_http_response_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelHTTPResponse* self;
	self = (RygelHTTPResponse*) base;
	result = self->priv->_cancellable;
	return result;
}


static void rygel_http_response_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelHTTPResponse* self;
	GCancellable* _tmp0_;
	self = (RygelHTTPResponse*) base;
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_cancellable);
	self->priv->_cancellable = _tmp0_;
	g_object_notify ((GObject *) self, "cancellable");
}


gint rygel_http_response_get_priority (RygelHTTPResponse* self) {
	gint result;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* mode;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, 0);
	if (self->priv->_priority != (-1)) {
		result = self->priv->_priority;
		return result;
	}
	_tmp0_ = soup_message_headers_get_one (self->msg->request_headers, "transferMode.dlna.org");
	_tmp1_ = g_strdup (_tmp0_);
	mode = _tmp1_;
	if (mode == NULL) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = g_strcmp0 (mode, "Interactive") == 0;
	}
	if (_tmp2_) {
		self->priv->_priority = G_PRIORITY_DEFAULT;
	} else {
		if (g_strcmp0 (mode, "Streaming") == 0) {
			self->priv->_priority = G_PRIORITY_HIGH;
		} else {
			if (g_strcmp0 (mode, "Background") == 0) {
				self->priv->_priority = G_PRIORITY_LOW;
			} else {
				self->priv->_priority = G_PRIORITY_DEFAULT;
			}
		}
	}
	result = self->priv->_priority;
	_g_free0 (mode);
	return result;
}


static void rygel_http_response_class_init (RygelHTTPResponseClass * klass) {
	rygel_http_response_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelHTTPResponsePrivate));
	RYGEL_HTTP_RESPONSE_CLASS (klass)->end = rygel_http_response_real_end;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_response_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_http_response_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_response_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_RESPONSE_SERVER, g_param_spec_object ("server", "server", "server", SOUP_TYPE_SERVER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_RESPONSE_CANCELLABLE, "cancellable");
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_RESPONSE_PRIORITY, g_param_spec_int ("priority", "priority", "priority", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void rygel_http_response_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
	rygel_http_response_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
	iface->run = (void (*)(RygelStateMachine*)) rygel_http_response_real_run;
	iface->run_finish = rygel_http_response_real_run_finish;
	iface->get_cancellable = rygel_http_response_real_get_cancellable;
	iface->set_cancellable = rygel_http_response_real_set_cancellable;
}


static void rygel_http_response_instance_init (RygelHTTPResponse * self) {
	self->priv = RYGEL_HTTP_RESPONSE_GET_PRIVATE (self);
	self->priv->_priority = -1;
}


static void rygel_http_response_finalize (GObject* obj) {
	RygelHTTPResponse * self;
	self = RYGEL_HTTP_RESPONSE (obj);
	_g_object_unref0 (self->priv->_server);
	_g_object_unref0 (self->msg);
	_g_object_unref0 (self->priv->_cancellable);
	_g_object_unref0 (self->seek);
	(self->priv->run_continue_target_destroy_notify == NULL) ? NULL : (self->priv->run_continue_target_destroy_notify (self->priv->run_continue_target), NULL);
	self->priv->run_continue = NULL;
	self->priv->run_continue_target = NULL;
	self->priv->run_continue_target_destroy_notify = NULL;
	_gst_object_unref0 (self->priv->pipeline);
	G_OBJECT_CLASS (rygel_http_response_parent_class)->finalize (obj);
}


GType rygel_http_response_get_type (void) {
	static volatile gsize rygel_http_response_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_response_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPResponseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_response_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPResponse), 0, (GInstanceInitFunc) rygel_http_response_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_http_response_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_http_response_type_id;
		rygel_http_response_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPResponse", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_http_response_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_http_response_type_id__volatile, rygel_http_response_type_id);
	}
	return rygel_http_response_type_id__volatile;
}


static void _vala_rygel_http_response_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPResponse * self;
	self = RYGEL_HTTP_RESPONSE (object);
	switch (property_id) {
		case RYGEL_HTTP_RESPONSE_SERVER:
		g_value_set_object (value, rygel_http_response_get_server (self));
		break;
		case RYGEL_HTTP_RESPONSE_CANCELLABLE:
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
		break;
		case RYGEL_HTTP_RESPONSE_PRIORITY:
		g_value_set_int (value, rygel_http_response_get_priority (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_http_response_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPResponse * self;
	self = RYGEL_HTTP_RESPONSE (object);
	switch (property_id) {
		case RYGEL_HTTP_RESPONSE_SERVER:
		rygel_http_response_set_server (self, g_value_get_object (value));
		break;
		case RYGEL_HTTP_RESPONSE_CANCELLABLE:
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



