/* rygel-import-resource.c generated by valac 0.12.0, the Vala compiler
 * generated from rygel-import-resource.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <libsoup/soup.h>
#include <libgupnp/gupnp.h>
#include <glib/gi18n-lib.h>
#include <libgupnp-av/gupnp-av.h>
#include <gee.h>


#define RYGEL_TYPE_TRANSFER_STATUS (rygel_transfer_status_get_type ())

#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_IMPORT_RESOURCE (rygel_import_resource_get_type ())
#define RYGEL_IMPORT_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_IMPORT_RESOURCE, RygelImportResource))
#define RYGEL_IMPORT_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_IMPORT_RESOURCE, RygelImportResourceClass))
#define RYGEL_IS_IMPORT_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_IMPORT_RESOURCE))
#define RYGEL_IS_IMPORT_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_IMPORT_RESOURCE))
#define RYGEL_IMPORT_RESOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_IMPORT_RESOURCE, RygelImportResourceClass))

typedef struct _RygelImportResource RygelImportResource;
typedef struct _RygelImportResourceClass RygelImportResourceClass;
typedef struct _RygelImportResourcePrivate RygelImportResourcePrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_CONTENT_DIRECTORY (rygel_content_directory_get_type ())
#define RYGEL_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectory))
#define RYGEL_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))
#define RYGEL_IS_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_IS_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_CONTENT_DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))

typedef struct _RygelContentDirectory RygelContentDirectory;
typedef struct _RygelContentDirectoryClass RygelContentDirectoryClass;
typedef struct _RygelContentDirectoryPrivate RygelContentDirectoryPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_ITEM_REMOVAL_QUEUE (rygel_item_removal_queue_get_type ())
#define RYGEL_ITEM_REMOVAL_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ITEM_REMOVAL_QUEUE, RygelItemRemovalQueue))
#define RYGEL_ITEM_REMOVAL_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ITEM_REMOVAL_QUEUE, RygelItemRemovalQueueClass))
#define RYGEL_IS_ITEM_REMOVAL_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ITEM_REMOVAL_QUEUE))
#define RYGEL_IS_ITEM_REMOVAL_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ITEM_REMOVAL_QUEUE))
#define RYGEL_ITEM_REMOVAL_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ITEM_REMOVAL_QUEUE, RygelItemRemovalQueueClass))

typedef struct _RygelItemRemovalQueue RygelItemRemovalQueue;
typedef struct _RygelItemRemovalQueueClass RygelItemRemovalQueueClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;
typedef struct _RygelImportResourceRunData RygelImportResourceRunData;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;
typedef struct _RygelHTTPItemURIPrivate RygelHTTPItemURIPrivate;

#define RYGEL_TYPE_WRITABLE_CONTAINER (rygel_writable_container_get_type ())
#define RYGEL_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainer))
#define RYGEL_IS_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_WRITABLE_CONTAINER))
#define RYGEL_WRITABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainerIface))

typedef struct _RygelWritableContainer RygelWritableContainer;
typedef struct _RygelWritableContainerIface RygelWritableContainerIface;
typedef struct _RygelImportResourceFetchItemData RygelImportResourceFetchItemData;

typedef enum  {
	RYGEL_TRANSFER_STATUS_COMPLETED,
	RYGEL_TRANSFER_STATUS_ERROR,
	RYGEL_TRANSFER_STATUS_IN_PROGRESS,
	RYGEL_TRANSFER_STATUS_STOPPED
} RygelTransferStatus;

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelImportResource {
	GObject parent_instance;
	RygelImportResourcePrivate * priv;
	gchar* source_uri;
	gchar* destination_uri;
	guint32 transfer_id;
	RygelTransferStatus status;
	gint64 bytes_copied;
	gint64 bytes_total;
};

struct _RygelImportResourceClass {
	GObjectClass parent_class;
};

struct _RygelImportResourcePrivate {
	RygelMediaItem* item;
	SoupSession* session;
	GCancellable* _cancellable;
	RygelHTTPServer* http_server;
	RygelMediaContainer* root_container;
	GUPnPServiceAction* action;
	GSourceFunc run_callback;
	gpointer run_callback_target;
	GDestroyNotify run_callback_target_destroy_notify;
	GFileOutputStream* output_stream;
};

struct _RygelContentDirectory {
	GUPnPService parent_instance;
	RygelContentDirectoryPrivate * priv;
	gchar* feature_list;
	RygelHTTPServer* http_server;
	RygelMediaContainer* root_container;
	GCancellable* cancellable;
	guint32 system_update_id;
};

struct _RygelContentDirectoryClass {
	GUPnPServiceClass parent_class;
};

typedef enum  {
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT = 701,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SORT_CRITERIA = 709,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_OBJECT = 711,
	RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA = 712,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT = 713,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_DESTINATION_RESOURCE = 718,
	RYGEL_CONTENT_DIRECTORY_ERROR_CANT_PROCESS = 720,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS = 402
} RygelContentDirectoryError;
#define RYGEL_CONTENT_DIRECTORY_ERROR rygel_content_directory_error_quark ()
struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* ref_id;
	gchar* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelImportResourceRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelImportResource* self;
	GError* _tmp0_;
	GError* _tmp1_;
	RygelMediaItem* _tmp2_;
	RygelMediaItem* _tmp3_;
	GError * _error_;
	const gchar* _tmp4_;
	gint code;
	RygelItemRemovalQueue* _tmp5_;
	RygelItemRemovalQueue* queue;
	gpointer _tmp6_;
	gchar* _tmp7_;
	GFile* _tmp8_;
	GFile* _tmp9_;
	GFile* source_file;
	GCancellable* _tmp10_;
	GFileOutputStream* _tmp11_;
	GFileOutputStream* _tmp12_;
	SoupMessage* _tmp13_;
	SoupMessage* message;
	SoupMessage* _tmp14_;
	GError * err;
	GCancellable* _tmp15_;
	GError * _inner_error_;
};

typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
struct _RygelHTTPItemURI {
	GObject parent_instance;
	RygelHTTPItemURIPrivate * priv;
	gchar* item_id;
	gint thumbnail_index;
	gint subtitle_index;
	gchar* transcode_target;
	RygelHTTPServer* http_server;
};

struct _RygelHTTPItemURIClass {
	GObjectClass parent_class;
};

struct _RygelWritableContainerIface {
	GTypeInterface parent_iface;
	void (*add_item) (RygelWritableContainer* self, RygelMediaItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_item_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*remove_item) (RygelWritableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_item_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	GeeArrayList* (*get_create_classes) (RygelWritableContainer* self);
	void (*set_create_classes) (RygelWritableContainer* self, GeeArrayList* value);
};

struct _RygelImportResourceFetchItemData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelImportResource* self;
	RygelMediaItem* result;
	RygelHTTPItemURI* _tmp0_;
	RygelHTTPItemURI* uri;
	RygelMediaObject* _tmp1_;
	RygelMediaObject* media_object;
	gchar* msg;
	gboolean _tmp2_;
	gboolean _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	RygelMediaObject* _tmp6_;
	gboolean _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gint _tmp10_;
	GError* _tmp11_;
	RygelMediaObject* _tmp12_;
	RygelMediaItem* _tmp13_;
	GError * _inner_error_;
};


static gpointer rygel_import_resource_parent_class = NULL;
static guint32 rygel_import_resource_last_transfer_id;
static guint32 rygel_import_resource_last_transfer_id = (guint32) 0;
static RygelStateMachineIface* rygel_import_resource_rygel_state_machine_parent_iface = NULL;

GType rygel_transfer_status_get_type (void) G_GNUC_CONST;
GType rygel_state_machine_get_type (void) G_GNUC_CONST;
GType rygel_import_resource_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
#define RYGEL_IMPORT_RESOURCE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_IMPORT_RESOURCE, RygelImportResourcePrivate))
enum  {
	RYGEL_IMPORT_RESOURCE_DUMMY_PROPERTY,
	RYGEL_IMPORT_RESOURCE_STATUS_AS_STRING,
	RYGEL_IMPORT_RESOURCE_CANCELLABLE
};
GType rygel_content_directory_get_type (void) G_GNUC_CONST;
RygelImportResource* rygel_import_resource_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelImportResource* rygel_import_resource_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
void rygel_state_machine_set_cancellable (RygelStateMachine* self, GCancellable* value);
static void _lambda8_ (RygelImportResource* self);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
static void __lambda8__g_cancellable_cancelled (GCancellable* _sender, gpointer self);
static void rygel_import_resource_real_run_data_free (gpointer _data);
static void rygel_import_resource_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_import_resource_real_run_co (RygelImportResourceRunData* data);
GQuark rygel_content_directory_error_quark (void);
static void rygel_import_resource_fetch_item (RygelImportResource* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static RygelMediaItem* rygel_import_resource_fetch_item_finish (RygelImportResource* self, GAsyncResult* _res_, GError** error);
static void rygel_import_resource_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GType rygel_item_removal_queue_get_type (void) G_GNUC_CONST;
RygelItemRemovalQueue* rygel_item_removal_queue_get_default (void);
gboolean rygel_item_removal_queue_dequeue (RygelItemRemovalQueue* self, RygelMediaItem* item);
static void rygel_import_resource_got_chunk_cb (RygelImportResource* self, SoupMessage* message, SoupBuffer* buffer);
static void _rygel_import_resource_got_chunk_cb_soup_message_got_chunk (SoupMessage* _sender, SoupBuffer* chunk, gpointer self);
static void rygel_import_resource_got_body_cb (RygelImportResource* self, SoupMessage* message);
static void _rygel_import_resource_got_body_cb_soup_message_got_body (SoupMessage* _sender, gpointer self);
static void rygel_import_resource_got_headers_cb (RygelImportResource* self, SoupMessage* message);
static void _rygel_import_resource_got_headers_cb_soup_message_got_headers (SoupMessage* _sender, gpointer self);
static void rygel_import_resource_finished_cb (RygelImportResource* self, SoupMessage* message);
static void _rygel_import_resource_finished_cb_soup_message_finished (SoupMessage* _sender, gpointer self);
void rygel_state_machine_run (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_state_machine_run_finish (RygelStateMachine* self, GAsyncResult* _res_);
static gboolean _rygel_import_resource_real_run_co_gsource_func (gpointer self);
void rygel_item_removal_queue_remove_now (RygelItemRemovalQueue* self, RygelMediaItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_item_removal_queue_remove_now_finish (RygelItemRemovalQueue* self, GAsyncResult* _res_);
static void rygel_import_resource_fetch_item_data_free (gpointer _data);
static gboolean rygel_import_resource_fetch_item_co (RygelImportResourceFetchItemData* data);
GQuark rygel_http_request_error_quark (void);
RygelHTTPItemURI* rygel_http_item_uri_new_from_string (const gchar* uri, RygelHTTPServer* http_server, GError** error);
RygelHTTPItemURI* rygel_http_item_uri_construct_from_string (GType object_type, const gchar* uri, RygelHTTPServer* http_server, GError** error);
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
static void rygel_import_resource_fetch_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GType rygel_writable_container_get_type (void) G_GNUC_CONST;
gboolean rygel_media_item_get_place_holder (RygelMediaItem* self);
const gchar* rygel_import_resource_get_status_as_string (RygelImportResource* self);
static void rygel_import_resource_finalize (GObject* obj);
static void _vala_rygel_import_resource_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_import_resource_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GType rygel_transfer_status_get_type (void) {
	static volatile gsize rygel_transfer_status_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_transfer_status_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_TRANSFER_STATUS_COMPLETED, "RYGEL_TRANSFER_STATUS_COMPLETED", "completed"}, {RYGEL_TRANSFER_STATUS_ERROR, "RYGEL_TRANSFER_STATUS_ERROR", "error"}, {RYGEL_TRANSFER_STATUS_IN_PROGRESS, "RYGEL_TRANSFER_STATUS_IN_PROGRESS", "in-progress"}, {RYGEL_TRANSFER_STATUS_STOPPED, "RYGEL_TRANSFER_STATUS_STOPPED", "stopped"}, {0, NULL, NULL}};
		GType rygel_transfer_status_type_id;
		rygel_transfer_status_type_id = g_enum_register_static ("RygelTransferStatus", values);
		g_once_init_leave (&rygel_transfer_status_type_id__volatile, rygel_transfer_status_type_id);
	}
	return rygel_transfer_status_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _lambda8_ (RygelImportResource* self) {
	GCancellable* _tmp0_ = NULL;
	_tmp0_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
	g_cancellable_cancel (_tmp0_);
}


static void __lambda8__g_cancellable_cancelled (GCancellable* _sender, gpointer self) {
	_lambda8_ (self);
}


RygelImportResource* rygel_import_resource_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action) {
	RygelImportResource * self = NULL;
	RygelMediaContainer* _tmp0_;
	RygelHTTPServer* _tmp1_;
	GCancellable* _tmp2_ = NULL;
	GCancellable* _tmp3_;
	GUPnPServiceAction* _tmp4_;
	SoupSessionAsync* _tmp5_ = NULL;
	g_return_val_if_fail (content_dir != NULL, NULL);
	g_return_val_if_fail (action != NULL, NULL);
	self = (RygelImportResource*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (content_dir->root_container);
	_g_object_unref0 (self->priv->root_container);
	self->priv->root_container = _tmp0_;
	_tmp1_ = _g_object_ref0 (content_dir->http_server);
	_g_object_unref0 (self->priv->http_server);
	self->priv->http_server = _tmp1_;
	_tmp2_ = g_cancellable_new ();
	_tmp3_ = _tmp2_;
	rygel_state_machine_set_cancellable ((RygelStateMachine*) self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = action;
	action = NULL;
	self->priv->action = _tmp4_;
	rygel_import_resource_last_transfer_id++;
	self->transfer_id = rygel_import_resource_last_transfer_id;
	self->bytes_copied = (gint64) 0;
	self->bytes_total = (gint64) 0;
	self->status = RYGEL_TRANSFER_STATUS_IN_PROGRESS;
	_tmp5_ = (SoupSessionAsync*) soup_session_async_new ();
	_g_object_unref0 (self->priv->session);
	self->priv->session = (SoupSession*) _tmp5_;
	g_signal_connect_object (content_dir->cancellable, "cancelled", (GCallback) __lambda8__g_cancellable_cancelled, self, 0);
	return self;
}


RygelImportResource* rygel_import_resource_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action) {
	return rygel_import_resource_construct (RYGEL_TYPE_IMPORT_RESOURCE, content_dir, action);
}


static void rygel_import_resource_real_run_data_free (gpointer _data) {
	RygelImportResourceRunData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (RygelImportResourceRunData, data);
}


static void rygel_import_resource_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelImportResource * self;
	RygelImportResourceRunData* _data_;
	self = (RygelImportResource*) base;
	_data_ = g_slice_new0 (RygelImportResourceRunData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_import_resource_real_run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_import_resource_real_run_data_free);
	_data_->self = _g_object_ref0 (self);
	rygel_import_resource_real_run_co (_data_);
}


static void rygel_import_resource_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelImportResourceRunData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_import_resource_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelImportResourceRunData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_import_resource_real_run_co (data);
}


static void _rygel_import_resource_got_chunk_cb_soup_message_got_chunk (SoupMessage* _sender, SoupBuffer* chunk, gpointer self) {
	rygel_import_resource_got_chunk_cb (self, _sender, chunk);
}


static void _rygel_import_resource_got_body_cb_soup_message_got_body (SoupMessage* _sender, gpointer self) {
	rygel_import_resource_got_body_cb (self, _sender);
}


static void _rygel_import_resource_got_headers_cb_soup_message_got_headers (SoupMessage* _sender, gpointer self) {
	rygel_import_resource_got_headers_cb (self, _sender);
}


static void _rygel_import_resource_finished_cb_soup_message_finished (SoupMessage* _sender, gpointer self) {
	rygel_import_resource_finished_cb (self, _sender);
}


static gboolean _rygel_import_resource_real_run_co_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_import_resource_real_run_co (self);
	return result;
}


static gboolean rygel_import_resource_real_run_co (RygelImportResourceRunData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	gupnp_service_action_get (data->self->priv->action, "SourceURI", G_TYPE_STRING, &data->self->source_uri, "DestinationURI", G_TYPE_STRING, &data->self->destination_uri, NULL);
	if (data->self->source_uri == NULL) {
		data->_tmp0_ = NULL;
		data->_tmp0_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS, "Must provide source URI");
		data->_inner_error_ = data->_tmp0_;
		goto __catch63_g_error;
	}
	if (data->self->destination_uri == NULL) {
		data->_tmp1_ = NULL;
		data->_tmp1_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_DESTINATION_RESOURCE, "Must provide destination URI");
		data->_inner_error_ = data->_tmp1_;
		goto __catch63_g_error;
	}
	gupnp_service_action_set (data->self->priv->action, "TransferID", G_TYPE_UINT, data->self->transfer_id, NULL);
	data->_state_ = 1;
	rygel_import_resource_fetch_item (data->self, rygel_import_resource_run_ready, data);
	return FALSE;
	_state_1:
	data->_tmp2_ = NULL;
	data->_tmp2_ = rygel_import_resource_fetch_item_finish (data->self, data->_res_, &data->_inner_error_);
	data->_tmp3_ = data->_tmp2_;
	if (data->_inner_error_ != NULL) {
		goto __catch63_g_error;
	}
	_g_object_unref0 (data->self->priv->item);
	data->self->priv->item = data->_tmp3_;
	goto __finally63;
	__catch63_g_error:
	{
		data->_error_ = data->_inner_error_;
		data->_inner_error_ = NULL;
		data->_tmp4_ = NULL;
		data->_tmp4_ = _ ("Failed to get original URI for '%s': %s");
		g_warning (data->_tmp4_, data->self->destination_uri, data->_error_->message);
		if (data->_error_->domain == RYGEL_CONTENT_DIRECTORY_ERROR) {
			data->code = data->_error_->code;
		} else {
			data->code = 719;
		}
		gupnp_service_action_return_error (data->self->priv->action, (guint) data->code, data->_error_->message);
		data->self->status = RYGEL_TRANSFER_STATUS_ERROR;
		g_signal_emit_by_name ((RygelStateMachine*) data->self, "completed");
		_g_error_free0 (data->_error_);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	__finally63:
	if (data->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	data->_tmp5_ = NULL;
	data->_tmp5_ = rygel_item_removal_queue_get_default ();
	data->queue = data->_tmp5_;
	rygel_item_removal_queue_dequeue (data->queue, data->self->priv->item);
	data->_tmp6_ = NULL;
	data->_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) ((RygelMediaObject*) data->self->priv->item)->uris, 0);
	data->_tmp7_ = (gchar*) data->_tmp6_;
	data->_tmp8_ = NULL;
	data->_tmp8_ = g_file_new_for_uri (data->_tmp7_);
	data->_tmp9_ = data->_tmp8_;
	_g_free0 (data->_tmp7_);
	data->source_file = data->_tmp9_;
	data->_tmp10_ = NULL;
	data->_tmp10_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self);
	data->_state_ = 2;
	g_file_replace_async (data->source_file, NULL, FALSE, G_FILE_CREATE_PRIVATE, G_PRIORITY_DEFAULT, data->_tmp10_, rygel_import_resource_run_ready, data);
	return FALSE;
	_state_2:
	data->_tmp11_ = NULL;
	data->_tmp11_ = g_file_replace_finish (data->source_file, data->_res_, &data->_inner_error_);
	data->_tmp12_ = data->_tmp11_;
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->source_file);
		goto __catch64_g_error;
	}
	_g_object_unref0 (data->self->priv->output_stream);
	data->self->priv->output_stream = data->_tmp12_;
	data->_tmp13_ = NULL;
	data->_tmp13_ = soup_message_new ("GET", data->self->source_uri);
	data->message = data->_tmp13_;
	g_signal_connect_object (data->message, "got-chunk", (GCallback) _rygel_import_resource_got_chunk_cb_soup_message_got_chunk, data->self, 0);
	g_signal_connect_object (data->message, "got-body", (GCallback) _rygel_import_resource_got_body_cb_soup_message_got_body, data->self, 0);
	g_signal_connect_object (data->message, "got-headers", (GCallback) _rygel_import_resource_got_headers_cb_soup_message_got_headers, data->self, 0);
	g_signal_connect_object (data->message, "finished", (GCallback) _rygel_import_resource_finished_cb_soup_message_finished, data->self, 0);
	(data->self->priv->run_callback_target_destroy_notify == NULL) ? NULL : (data->self->priv->run_callback_target_destroy_notify (data->self->priv->run_callback_target), NULL);
	data->self->priv->run_callback = NULL;
	data->self->priv->run_callback_target = NULL;
	data->self->priv->run_callback_target_destroy_notify = NULL;
	data->self->priv->run_callback = _rygel_import_resource_real_run_co_gsource_func;
	data->self->priv->run_callback_target = data;
	data->self->priv->run_callback_target_destroy_notify = NULL;
	data->_tmp14_ = _g_object_ref0 (data->message);
	soup_session_queue_message (data->self->priv->session, data->_tmp14_, NULL, NULL);
	data->_state_ = 3;
	return FALSE;
	_state_3:
	;
	_g_object_unref0 (data->message);
	_g_object_unref0 (data->source_file);
	goto __finally64;
	__catch64_g_error:
	{
		data->err = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_warning ("rygel-import-resource.vala:165: %s", data->err->message);
		data->self->status = RYGEL_TRANSFER_STATUS_ERROR;
		data->_tmp15_ = NULL;
		data->_tmp15_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self);
		data->_state_ = 4;
		rygel_item_removal_queue_remove_now (data->queue, data->self->priv->item, data->_tmp15_, rygel_import_resource_run_ready, data);
		return FALSE;
		_state_4:
		rygel_item_removal_queue_remove_now_finish (data->queue, data->_res_);
		_g_error_free0 (data->err);
	}
	__finally64:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->queue);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	g_signal_emit_by_name ((RygelStateMachine*) data->self, "completed");
	_g_object_unref0 (data->queue);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void rygel_import_resource_fetch_item_data_free (gpointer _data) {
	RygelImportResourceFetchItemData* data;
	data = _data;
	_g_object_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (RygelImportResourceFetchItemData, data);
}


static void rygel_import_resource_fetch_item (RygelImportResource* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelImportResourceFetchItemData* _data_;
	_data_ = g_slice_new0 (RygelImportResourceFetchItemData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_import_resource_fetch_item);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_import_resource_fetch_item_data_free);
	_data_->self = _g_object_ref0 (self);
	rygel_import_resource_fetch_item_co (_data_);
}


static RygelMediaItem* rygel_import_resource_fetch_item_finish (RygelImportResource* self, GAsyncResult* _res_, GError** error) {
	RygelMediaItem* result;
	RygelImportResourceFetchItemData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_import_resource_fetch_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelImportResourceFetchItemData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_import_resource_fetch_item_co (data);
}


static gboolean rygel_import_resource_fetch_item_co (RygelImportResourceFetchItemData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = rygel_http_item_uri_new_from_string (data->self->destination_uri, data->self->priv->http_server, &data->_inner_error_);
	data->uri = data->_tmp0_;
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_state_ = 1;
	rygel_media_container_find_object (data->self->priv->root_container, data->uri->item_id, NULL, rygel_import_resource_fetch_item_ready, data);
	return FALSE;
	_state_1:
	data->_tmp1_ = NULL;
	data->_tmp1_ = rygel_media_container_find_object_finish (data->self->priv->root_container, data->_res_, &data->_inner_error_);
	data->media_object = data->_tmp1_;
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_object_unref0 (data->uri);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->msg = NULL;
	if (data->media_object == NULL) {
		data->_tmp3_ = TRUE;
	} else {
		data->_tmp3_ = !RYGEL_IS_MEDIA_ITEM (data->media_object);
	}
	if (data->_tmp3_) {
		data->_tmp2_ = TRUE;
	} else {
		data->_tmp2_ = !RYGEL_IS_WRITABLE_CONTAINER (data->media_object->parent);
	}
	if (data->_tmp2_) {
		data->_tmp4_ = NULL;
		data->_tmp4_ = _ ("URI '%s' invalid for importing contents to");
		data->_tmp5_ = NULL;
		data->_tmp5_ = g_strdup_printf (data->_tmp4_, data->self->destination_uri);
		_g_free0 (data->msg);
		data->msg = data->_tmp5_;
	} else {
		data->_tmp6_ = data->media_object;
		data->_tmp7_ = rygel_media_item_get_place_holder (RYGEL_IS_MEDIA_ITEM (data->_tmp6_) ? ((RygelMediaItem*) data->_tmp6_) : NULL);
		if (!data->_tmp7_) {
			data->_tmp8_ = NULL;
			data->_tmp8_ = _ ("Pushing data to non-empty item '%s' not allowed");
			data->_tmp9_ = NULL;
			data->_tmp9_ = g_strdup_printf (data->_tmp8_, data->media_object->id);
			_g_free0 (data->msg);
			data->msg = data->_tmp9_;
		} else {
			data->_tmp10_ = gee_collection_get_size ((GeeCollection*) data->media_object->uris);
			if (data->_tmp10_ < 1) {
				g_assert_not_reached ();
			}
		}
	}
	if (data->msg != NULL) {
		data->_tmp11_ = NULL;
		data->_tmp11_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS, data->msg);
		data->_inner_error_ = data->_tmp11_;
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_free0 (data->msg);
		_g_object_unref0 (data->media_object);
		_g_object_unref0 (data->uri);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp12_ = data->media_object;
	data->_tmp13_ = _g_object_ref0 (RYGEL_IS_MEDIA_ITEM (data->_tmp12_) ? ((RygelMediaItem*) data->_tmp12_) : NULL);
	data->result = data->_tmp13_;
	_g_free0 (data->msg);
	_g_object_unref0 (data->media_object);
	_g_object_unref0 (data->uri);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_g_free0 (data->msg);
	_g_object_unref0 (data->media_object);
	_g_object_unref0 (data->uri);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void rygel_import_resource_got_headers_cb (RygelImportResource* self, SoupMessage* message) {
	gint64 _tmp0_;
	gboolean _tmp1_ = FALSE;
	guint _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = soup_message_headers_get_content_length (message->response_headers);
	self->bytes_total = _tmp0_;
	g_object_get (message, "status-code", &_tmp2_, NULL);
	if (_tmp2_ >= 200) {
		guint _tmp3_;
		g_object_get (message, "status-code", &_tmp3_, NULL);
		_tmp1_ = _tmp3_ <= 299;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gupnp_service_action_return (self->priv->action);
	} else {
		GCancellable* _tmp4_ = NULL;
		gpointer _tmp5_ = NULL;
		gchar* _tmp6_;
		GFile* _tmp7_ = NULL;
		GFile* _tmp8_;
		GFile* file;
		GCancellable* _tmp9_ = NULL;
		guint _tmp10_;
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		gchar* phrase;
		guint _tmp13_;
		self->status = RYGEL_TRANSFER_STATUS_ERROR;
		_tmp4_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
		g_output_stream_close ((GOutputStream*) self->priv->output_stream, _tmp4_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch65_g_error;
		}
		_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) ((RygelMediaObject*) self->priv->item)->uris, 0);
		_tmp6_ = (gchar*) _tmp5_;
		_tmp7_ = g_file_new_for_uri (_tmp6_);
		_tmp8_ = _tmp7_;
		_g_free0 (_tmp6_);
		file = _tmp8_;
		_tmp9_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
		g_file_delete (file, _tmp9_, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (file);
			goto __catch65_g_error;
		}
		_g_object_unref0 (file);
		goto __finally65;
		__catch65_g_error:
		{
			GError * _error_;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (_error_);
		}
		__finally65:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		g_object_get (message, "status-code", &_tmp10_, NULL);
		_tmp11_ = soup_status_get_phrase (_tmp10_);
		_tmp12_ = g_strdup (_tmp11_);
		phrase = _tmp12_;
		g_object_get (message, "status-code", &_tmp13_, NULL);
		if (_tmp13_ == 404) {
			gupnp_service_action_return_error (self->priv->action, (guint) 714, phrase);
		} else {
			gupnp_service_action_return_error (self->priv->action, (guint) 715, phrase);
		}
		_g_free0 (phrase);
	}
}


static void rygel_import_resource_got_chunk_cb (RygelImportResource* self, SoupMessage* message, SoupBuffer* buffer) {
	gsize bytes_written = 0UL;
	GCancellable* _tmp0_ = NULL;
	gsize _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	g_return_if_fail (buffer != NULL);
	self->bytes_copied = self->bytes_copied + ((gint64) buffer->length);
	_tmp0_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
	g_output_stream_write_all ((GOutputStream*) self->priv->output_stream, buffer->data, (gsize) ((gint) buffer->length), &_tmp1_, _tmp0_, &_inner_error_);
	bytes_written = _tmp1_;
	if (_inner_error_ != NULL) {
		goto __catch66_g_error;
	}
	goto __finally66;
	__catch66_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("rygel-import-resource.vala:230: %s", _error_->message);
		if (g_error_matches (_error_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
			self->status = RYGEL_TRANSFER_STATUS_STOPPED;
		} else {
			self->status = RYGEL_TRANSFER_STATUS_ERROR;
		}
		soup_session_cancel_message (self->priv->session, message, (guint) SOUP_STATUS_CANCELLED);
		_g_error_free0 (_error_);
	}
	__finally66:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void rygel_import_resource_got_body_cb (RygelImportResource* self, SoupMessage* message) {
	GCancellable* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	if (self->bytes_total == 0) {
		self->bytes_total = self->bytes_copied;
	} else {
		if (self->bytes_total != self->bytes_copied) {
			self->status = RYGEL_TRANSFER_STATUS_ERROR;
			return;
		}
	}
	_tmp0_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
	g_output_stream_close ((GOutputStream*) self->priv->output_stream, _tmp0_, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch67_g_error;
	}
	if (self->status == RYGEL_TRANSFER_STATUS_IN_PROGRESS) {
		self->status = RYGEL_TRANSFER_STATUS_COMPLETED;
	}
	goto __finally67;
	__catch67_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("rygel-import-resource.vala:256: %s", _error_->message);
		self->status = RYGEL_TRANSFER_STATUS_ERROR;
		_g_error_free0 (_error_);
	}
	__finally67:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void rygel_import_resource_finished_cb (RygelImportResource* self, SoupMessage* message) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	self->priv->run_callback (self->priv->run_callback_target);
}


const gchar* rygel_import_resource_get_status_as_string (RygelImportResource* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	switch (self->status) {
		case RYGEL_TRANSFER_STATUS_COMPLETED:
		{
			result = "COMPLETED";
			return result;
		}
		case RYGEL_TRANSFER_STATUS_ERROR:
		{
			result = "ERROR";
			return result;
		}
		case RYGEL_TRANSFER_STATUS_IN_PROGRESS:
		{
			result = "IN_PROGRESS";
			return result;
		}
		default:
		case RYGEL_TRANSFER_STATUS_STOPPED:
		{
			result = "STOPPED";
			return result;
		}
	}
}


static GCancellable* rygel_import_resource_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelImportResource* self;
	self = (RygelImportResource*) base;
	result = self->priv->_cancellable;
	return result;
}


static void rygel_import_resource_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelImportResource* self;
	GCancellable* _tmp0_;
	self = (RygelImportResource*) base;
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_cancellable);
	self->priv->_cancellable = _tmp0_;
	g_object_notify ((GObject *) self, "cancellable");
}


static void rygel_import_resource_class_init (RygelImportResourceClass * klass) {
	rygel_import_resource_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelImportResourcePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_import_resource_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_import_resource_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_import_resource_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_IMPORT_RESOURCE_STATUS_AS_STRING, g_param_spec_string ("status-as-string", "status-as-string", "status-as-string", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_IMPORT_RESOURCE_CANCELLABLE, "cancellable");
}


static void rygel_import_resource_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
	rygel_import_resource_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
	iface->run = (void (*)(RygelStateMachine*)) rygel_import_resource_real_run;
	iface->run_finish = rygel_import_resource_real_run_finish;
	iface->get_cancellable = rygel_import_resource_real_get_cancellable;
	iface->set_cancellable = rygel_import_resource_real_set_cancellable;
}


static void rygel_import_resource_instance_init (RygelImportResource * self) {
	self->priv = RYGEL_IMPORT_RESOURCE_GET_PRIVATE (self);
}


static void rygel_import_resource_finalize (GObject* obj) {
	RygelImportResource * self;
	self = RYGEL_IMPORT_RESOURCE (obj);
	_g_free0 (self->source_uri);
	_g_free0 (self->destination_uri);
	_g_object_unref0 (self->priv->item);
	_g_object_unref0 (self->priv->session);
	_g_object_unref0 (self->priv->_cancellable);
	_g_object_unref0 (self->priv->http_server);
	_g_object_unref0 (self->priv->root_container);
	(self->priv->run_callback_target_destroy_notify == NULL) ? NULL : (self->priv->run_callback_target_destroy_notify (self->priv->run_callback_target), NULL);
	self->priv->run_callback = NULL;
	self->priv->run_callback_target = NULL;
	self->priv->run_callback_target_destroy_notify = NULL;
	_g_object_unref0 (self->priv->output_stream);
	G_OBJECT_CLASS (rygel_import_resource_parent_class)->finalize (obj);
}


/**
 * Responsible for handling ImportResource action.
 */
GType rygel_import_resource_get_type (void) {
	static volatile gsize rygel_import_resource_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_import_resource_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelImportResourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_import_resource_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelImportResource), 0, (GInstanceInitFunc) rygel_import_resource_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_import_resource_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_import_resource_type_id;
		rygel_import_resource_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelImportResource", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_import_resource_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_import_resource_type_id__volatile, rygel_import_resource_type_id);
	}
	return rygel_import_resource_type_id__volatile;
}


static void _vala_rygel_import_resource_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelImportResource * self;
	self = RYGEL_IMPORT_RESOURCE (object);
	switch (property_id) {
		case RYGEL_IMPORT_RESOURCE_STATUS_AS_STRING:
		g_value_set_string (value, rygel_import_resource_get_status_as_string (self));
		break;
		case RYGEL_IMPORT_RESOURCE_CANCELLABLE:
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_import_resource_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelImportResource * self;
	self = RYGEL_IMPORT_RESOURCE (object);
	switch (property_id) {
		case RYGEL_IMPORT_RESOURCE_CANCELLABLE:
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



