/* rygel-media-object.c generated by valac 0.12.0, the Vala compiler
 * generated from rygel-media-object.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp-av/gupnp-av.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>


#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelMediaObjectGetWritableData RygelMediaObjectGetWritableData;
typedef struct _RygelMediaObjectGetWritablesData RygelMediaObjectGetWritablesData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelMediaObjectCheckWritableData RygelMediaObjectCheckWritableData;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* ref_id;
	gchar* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaObjectPrivate {
	RygelMediaContainer* _parent_ref;
	gchar* _title;
};

struct _RygelMediaObjectGetWritableData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaObject* self;
	GCancellable* cancellable;
	GFile* result;
	GeeArrayList* _tmp0_;
	GeeArrayList* _uri_list;
	gint _tmp1_;
	gint _uri_size;
	gint _uri_index;
	gpointer _tmp2_;
	gchar* uri;
	GFile* _tmp3_;
	GFile* file;
	gboolean _tmp4_;
	gboolean _tmp5_;
	GError * _inner_error_;
};

struct _RygelMediaObjectGetWritablesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaObject* self;
	GCancellable* cancellable;
	GeeArrayList* result;
	GeeArrayList* _tmp0_;
	GeeArrayList* writables;
	GeeArrayList* _tmp1_;
	GeeArrayList* _uri_list;
	gint _tmp2_;
	gint _uri_size;
	gint _uri_index;
	gpointer _tmp3_;
	gchar* uri;
	GFile* _tmp4_;
	GFile* file;
	gboolean _tmp5_;
	gboolean _tmp6_;
	GError * _inner_error_;
};

struct _RygelMediaObjectCheckWritableData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaObject* self;
	GFile* file;
	GCancellable* cancellable;
	gboolean result;
	gboolean _tmp0_;
	GFileInfo* _tmp1_;
	GFileInfo* info;
	gboolean _tmp2_;
	GError * _error_;
	GError * _inner_error_;
};


static gpointer rygel_media_object_parent_class = NULL;
static GRegex* rygel_media_object_real_name_regex;
static GRegex* rygel_media_object_real_name_regex = NULL;
static GRegex* rygel_media_object_user_name_regex;
static GRegex* rygel_media_object_user_name_regex = NULL;
static GRegex* rygel_media_object_host_name_regex;
static GRegex* rygel_media_object_host_name_regex = NULL;

GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_OBJECT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectPrivate))
enum  {
	RYGEL_MEDIA_OBJECT_DUMMY_PROPERTY,
	RYGEL_MEDIA_OBJECT_PARENT_REF,
	RYGEL_MEDIA_OBJECT_TITLE,
	RYGEL_MEDIA_OBJECT_OCM_FLAGS,
	RYGEL_MEDIA_OBJECT_RESTRICTED
};
static void rygel_media_object_get_writable_data_free (gpointer _data);
void rygel_media_object_get_writable (RygelMediaObject* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GFile* rygel_media_object_get_writable_finish (RygelMediaObject* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_media_object_get_writable_co (RygelMediaObjectGetWritableData* data);
static void rygel_media_object_check_writable (RygelMediaObject* self, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_media_object_check_writable_finish (RygelMediaObject* self, GAsyncResult* _res_, GError** error);
static void rygel_media_object_get_writable_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_media_object_get_writables_data_free (gpointer _data);
void rygel_media_object_get_writables (RygelMediaObject* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GeeArrayList* rygel_media_object_get_writables_finish (RygelMediaObject* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_media_object_get_writables_co (RygelMediaObjectGetWritablesData* data);
static void rygel_media_object_get_writables_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GUPnPDIDLLiteObject* rygel_media_object_serialize (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
static GUPnPDIDLLiteObject* rygel_media_object_real_serialize (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
gint rygel_media_object_compare_by_property (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
static gint rygel_media_object_real_compare_by_property (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
gint rygel_media_object_compare_string_props (RygelMediaObject* self, const gchar* prop1, const gchar* prop2);
const gchar* rygel_media_object_get_title (RygelMediaObject* self);
static void rygel_media_object_check_writable_data_free (gpointer _data);
static gboolean rygel_media_object_check_writable_co (RygelMediaObjectCheckWritableData* data);
static void rygel_media_object_check_writable_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
RygelMediaObject* rygel_media_object_construct (GType object_type);
RygelMediaContainer* rygel_media_object_get_parent_ref (RygelMediaObject* self);
void rygel_media_object_set_parent_ref (RygelMediaObject* self, RygelMediaContainer* value);
void rygel_media_object_set_title (RygelMediaObject* self, const gchar* value);
GUPnPOCMFlags rygel_media_object_get_ocm_flags (RygelMediaObject* self);
gboolean rygel_media_object_get_restricted (RygelMediaObject* self);
static GObject * rygel_media_object_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void rygel_media_object_finalize (GObject* obj);
static void _vala_rygel_media_object_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_media_object_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void rygel_media_object_get_writable_data_free (gpointer _data) {
	RygelMediaObjectGetWritableData* data;
	data = _data;
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (RygelMediaObjectGetWritableData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void rygel_media_object_get_writable (RygelMediaObject* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaObjectGetWritableData* _data_;
	_data_ = g_slice_new0 (RygelMediaObjectGetWritableData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_object_get_writable);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_object_get_writable_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_media_object_get_writable_co (_data_);
}


GFile* rygel_media_object_get_writable_finish (RygelMediaObject* self, GAsyncResult* _res_, GError** error) {
	GFile* result;
	RygelMediaObjectGetWritableData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
     * Fetches a File object for any writable URI available for this object.
     *
     * @param cancellable A GLib.Cancellable
     */
static void rygel_media_object_get_writable_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaObjectGetWritableData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_media_object_get_writable_co (data);
}


static gboolean rygel_media_object_get_writable_co (RygelMediaObjectGetWritableData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		data->_tmp0_ = _g_object_ref0 (data->self->uris);
		data->_uri_list = data->_tmp0_;
		data->_tmp1_ = gee_collection_get_size ((GeeCollection*) data->_uri_list);
		data->_uri_size = data->_tmp1_;
		data->_uri_index = -1;
		while (TRUE) {
			data->_uri_index = data->_uri_index + 1;
			if (!(data->_uri_index < data->_uri_size)) {
				break;
			}
			data->_tmp2_ = NULL;
			data->_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) data->_uri_list, data->_uri_index);
			data->uri = (gchar*) data->_tmp2_;
			data->_tmp3_ = NULL;
			data->_tmp3_ = g_file_new_for_uri (data->uri);
			data->file = data->_tmp3_;
			data->_state_ = 1;
			rygel_media_object_check_writable (data->self, data->file, data->cancellable, rygel_media_object_get_writable_ready, data);
			return FALSE;
			_state_1:
			data->_tmp4_ = rygel_media_object_check_writable_finish (data->self, data->_res_, &data->_inner_error_);
			data->_tmp5_ = data->_tmp4_;
			if (data->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				_g_object_unref0 (data->file);
				_g_free0 (data->uri);
				_g_object_unref0 (data->_uri_list);
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
			if (data->_tmp5_) {
				data->result = data->file;
				_g_free0 (data->uri);
				_g_object_unref0 (data->_uri_list);
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
			_g_object_unref0 (data->file);
			_g_free0 (data->uri);
		}
		_g_object_unref0 (data->_uri_list);
	}
	data->result = NULL;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void rygel_media_object_get_writables_data_free (gpointer _data) {
	RygelMediaObjectGetWritablesData* data;
	data = _data;
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (RygelMediaObjectGetWritablesData, data);
}


void rygel_media_object_get_writables (RygelMediaObject* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaObjectGetWritablesData* _data_;
	_data_ = g_slice_new0 (RygelMediaObjectGetWritablesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_object_get_writables);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_object_get_writables_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_media_object_get_writables_co (_data_);
}


GeeArrayList* rygel_media_object_get_writables_finish (RygelMediaObject* self, GAsyncResult* _res_, GError** error) {
	GeeArrayList* result;
	RygelMediaObjectGetWritablesData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
     * Fetches File objects for all writable URIs available for this object.
     *
     * @param cancellable A GLib.Cancellable
     */
static void rygel_media_object_get_writables_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaObjectGetWritablesData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_media_object_get_writables_co (data);
}


static gboolean rygel_media_object_get_writables_co (RygelMediaObjectGetWritablesData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = gee_array_list_new (G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	data->writables = data->_tmp0_;
	{
		data->_tmp1_ = _g_object_ref0 (data->self->uris);
		data->_uri_list = data->_tmp1_;
		data->_tmp2_ = gee_collection_get_size ((GeeCollection*) data->_uri_list);
		data->_uri_size = data->_tmp2_;
		data->_uri_index = -1;
		while (TRUE) {
			data->_uri_index = data->_uri_index + 1;
			if (!(data->_uri_index < data->_uri_size)) {
				break;
			}
			data->_tmp3_ = NULL;
			data->_tmp3_ = gee_abstract_list_get ((GeeAbstractList*) data->_uri_list, data->_uri_index);
			data->uri = (gchar*) data->_tmp3_;
			data->_tmp4_ = NULL;
			data->_tmp4_ = g_file_new_for_uri (data->uri);
			data->file = data->_tmp4_;
			data->_state_ = 1;
			rygel_media_object_check_writable (data->self, data->file, data->cancellable, rygel_media_object_get_writables_ready, data);
			return FALSE;
			_state_1:
			data->_tmp5_ = rygel_media_object_check_writable_finish (data->self, data->_res_, &data->_inner_error_);
			data->_tmp6_ = data->_tmp5_;
			if (data->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				_g_object_unref0 (data->file);
				_g_free0 (data->uri);
				_g_object_unref0 (data->_uri_list);
				_g_object_unref0 (data->writables);
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
			if (data->_tmp6_) {
				gee_abstract_collection_add ((GeeAbstractCollection*) data->writables, data->file);
			}
			_g_object_unref0 (data->file);
			_g_free0 (data->uri);
		}
		_g_object_unref0 (data->_uri_list);
	}
	data->result = data->writables;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_g_object_unref0 (data->writables);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static GUPnPDIDLLiteObject* rygel_media_object_real_serialize (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `rygel_media_object_serialize'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


GUPnPDIDLLiteObject* rygel_media_object_serialize (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error) {
	return RYGEL_MEDIA_OBJECT_GET_CLASS (self)->serialize (self, writer, http_server, error);
}


static gint rygel_media_object_real_compare_by_property (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property) {
	gint result = 0;
	const gchar* _tmp0_;
	GQuark _tmp1_;
	static GQuark _tmp1__label0 = 0;
	static GQuark _tmp1__label1 = 0;
	static GQuark _tmp1__label2 = 0;
	static GQuark _tmp1__label3 = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (media_object != NULL, 0);
	g_return_val_if_fail (property != NULL, 0);
	_tmp0_ = property;
	_tmp1_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp1_ == ((0 != _tmp1__label0) ? _tmp1__label0 : (_tmp1__label0 = g_quark_from_static_string ("@id")))) {
		switch (0) {
			default:
			{
				gint _tmp2_;
				_tmp2_ = rygel_media_object_compare_string_props (self, self->id, media_object->id);
				result = _tmp2_;
				return result;
			}
		}
	} else if (_tmp1_ == ((0 != _tmp1__label1) ? _tmp1__label1 : (_tmp1__label1 = g_quark_from_static_string ("@parentID")))) {
		switch (0) {
			default:
			{
				gint _tmp3_;
				_tmp3_ = rygel_media_object_compare_string_props (self, ((RygelMediaObject*) self->parent)->id, ((RygelMediaObject*) media_object->parent)->id);
				result = _tmp3_;
				return result;
			}
		}
	} else if (_tmp1_ == ((0 != _tmp1__label2) ? _tmp1__label2 : (_tmp1__label2 = g_quark_from_static_string ("dc:title")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp4_ = NULL;
				const gchar* _tmp5_ = NULL;
				gint _tmp6_;
				_tmp4_ = rygel_media_object_get_title (self);
				_tmp5_ = rygel_media_object_get_title (media_object);
				_tmp6_ = rygel_media_object_compare_string_props (self, _tmp4_, _tmp5_);
				result = _tmp6_;
				return result;
			}
		}
	} else if (_tmp1_ == ((0 != _tmp1__label3) ? _tmp1__label3 : (_tmp1__label3 = g_quark_from_static_string ("upnp:class")))) {
		switch (0) {
			default:
			{
				gint _tmp7_;
				_tmp7_ = rygel_media_object_compare_string_props (self, self->upnp_class, media_object->upnp_class);
				result = _tmp7_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = 0;
				return result;
			}
		}
	}
}


gint rygel_media_object_compare_by_property (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property) {
	return RYGEL_MEDIA_OBJECT_GET_CLASS (self)->compare_by_property (self, media_object, property);
}


gint rygel_media_object_compare_string_props (RygelMediaObject* self, const gchar* prop1, const gchar* prop2) {
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (prop1 != NULL, 0);
	g_return_val_if_fail (prop2 != NULL, 0);
	if (prop1 == NULL) {
		result = -1;
		return result;
	} else {
		if (prop2 == NULL) {
			result = 1;
			return result;
		} else {
			gint _tmp0_;
			_tmp0_ = g_utf8_collate (prop1, prop2);
			result = _tmp0_;
			return result;
		}
	}
}


static void rygel_media_object_check_writable_data_free (gpointer _data) {
	RygelMediaObjectCheckWritableData* data;
	data = _data;
	_g_object_unref0 (data->file);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->self);
	g_slice_free (RygelMediaObjectCheckWritableData, data);
}


static void rygel_media_object_check_writable (RygelMediaObject* self, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaObjectCheckWritableData* _data_;
	_data_ = g_slice_new0 (RygelMediaObjectCheckWritableData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_object_check_writable);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_object_check_writable_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->file = _g_object_ref0 (file);
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_media_object_check_writable_co (_data_);
}


static gboolean rygel_media_object_check_writable_finish (RygelMediaObject* self, GAsyncResult* _res_, GError** error) {
	gboolean result;
	RygelMediaObjectCheckWritableData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return FALSE;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void rygel_media_object_check_writable_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaObjectCheckWritableData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_media_object_check_writable_co (data);
}


static gboolean rygel_media_object_check_writable_co (RygelMediaObjectCheckWritableData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = g_file_is_native (data->file);
	if (!data->_tmp0_) {
		data->result = FALSE;
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_state_ = 1;
	g_file_query_info_async (data->file, G_FILE_ATTRIBUTE_ACCESS_CAN_WRITE, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, data->cancellable, rygel_media_object_check_writable_ready, data);
	return FALSE;
	_state_1:
	data->_tmp1_ = NULL;
	data->_tmp1_ = g_file_query_info_finish (data->file, data->_res_, &data->_inner_error_);
	data->info = data->_tmp1_;
	if (data->_inner_error_ != NULL) {
		if (g_error_matches (data->_inner_error_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
			goto __catch41_g_io_error_not_found;
		}
		goto __finally41;
	}
	data->_tmp2_ = g_file_info_get_attribute_boolean (data->info, G_FILE_ATTRIBUTE_ACCESS_CAN_WRITE);
	data->result = data->_tmp2_;
	_g_object_unref0 (data->info);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_g_object_unref0 (data->info);
	goto __finally41;
	__catch41_g_io_error_not_found:
	{
		data->_error_ = data->_inner_error_;
		data->_inner_error_ = NULL;
		data->result = TRUE;
		_g_error_free0 (data->_error_);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	__finally41:
	g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
	g_error_free (data->_inner_error_);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


RygelMediaObject* rygel_media_object_construct (GType object_type) {
	RygelMediaObject * self = NULL;
	self = (RygelMediaObject*) g_object_new (object_type, NULL);
	return self;
}


RygelMediaContainer* rygel_media_object_get_parent_ref (RygelMediaObject* self) {
	RygelMediaContainer* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_parent_ref;
	return result;
}


void rygel_media_object_set_parent_ref (RygelMediaObject* self, RygelMediaContainer* value) {
	RygelMediaContainer* _tmp0_;
	g_return_if_fail (self != NULL);
	self->parent = value;
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_parent_ref);
	self->priv->_parent_ref = _tmp0_;
	g_object_notify ((GObject *) self, "parent-ref");
}


const gchar* rygel_media_object_get_title (RygelMediaObject* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_title;
	return result;
}


void rygel_media_object_set_title (RygelMediaObject* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_get_real_name ();
	_tmp1_ = g_regex_replace_literal (rygel_media_object_real_name_regex, value, (gssize) (-1), 0, _tmp0_, 0, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch42_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (self->priv->_title);
	self->priv->_title = _tmp2_;
	_tmp3_ = g_get_user_name ();
	_tmp4_ = g_regex_replace_literal (rygel_media_object_user_name_regex, self->priv->_title, (gssize) (-1), 0, _tmp3_, 0, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch42_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (self->priv->_title);
	self->priv->_title = _tmp5_;
	_tmp6_ = g_get_host_name ();
	_tmp7_ = g_regex_replace_literal (rygel_media_object_host_name_regex, self->priv->_title, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
	_tmp8_ = _tmp7_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch42_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (self->priv->_title);
	self->priv->_title = _tmp8_;
	goto __finally42;
	__catch42_g_regex_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (err);
	}
	__finally42:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	g_object_notify ((GObject *) self, "title");
}


GUPnPOCMFlags rygel_media_object_get_ocm_flags (RygelMediaObject* self) {
	return RYGEL_MEDIA_OBJECT_GET_CLASS (self)->get_ocm_flags (self);
}


gboolean rygel_media_object_get_restricted (RygelMediaObject* self) {
	gboolean result;
	GUPnPOCMFlags _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = rygel_media_object_get_ocm_flags (self);
	result = _tmp0_ == GUPNP_OCM_FLAGS_NONE;
	return result;
}


static GObject * rygel_media_object_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	RygelMediaObject * self;
	GeeArrayList* _tmp0_ = NULL;
	parent_class = G_OBJECT_CLASS (rygel_media_object_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = RYGEL_MEDIA_OBJECT (obj);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	_g_object_unref0 (self->uris);
	self->uris = _tmp0_;
	return obj;
}


static void rygel_media_object_class_init (RygelMediaObjectClass * klass) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GRegex* _tmp2_ = NULL;
	GRegex* _tmp3_;
	GRegex* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	GRegex* _tmp7_ = NULL;
	GRegex* _tmp8_;
	GRegex* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	GRegex* _tmp12_ = NULL;
	GRegex* _tmp13_;
	GRegex* _tmp14_;
	GError * _inner_error_ = NULL;
	rygel_media_object_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaObjectPrivate));
	RYGEL_MEDIA_OBJECT_CLASS (klass)->serialize = rygel_media_object_real_serialize;
	RYGEL_MEDIA_OBJECT_CLASS (klass)->compare_by_property = rygel_media_object_real_compare_by_property;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_object_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_object_set_property;
	G_OBJECT_CLASS (klass)->constructor = rygel_media_object_constructor;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_object_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_PARENT_REF, g_param_spec_object ("parent-ref", "parent-ref", "parent-ref", RYGEL_TYPE_MEDIA_CONTAINER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_TITLE, g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_OCM_FLAGS, g_param_spec_flags ("ocm-flags", "ocm-flags", "ocm-flags", GUPNP_TYPE_OCM_FLAGS, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_RESTRICTED, g_param_spec_boolean ("restricted", "restricted", "restricted", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	_tmp0_ = g_regex_escape_string ("@REALNAME@", -1);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_regex_new (_tmp1_, 0, 0, &_inner_error_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	_tmp4_ = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch43_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	_g_regex_unref0 (rygel_media_object_real_name_regex);
	rygel_media_object_real_name_regex = _tmp4_;
	_tmp5_ = g_regex_escape_string ("@USERNAME@", -1);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_regex_new (_tmp6_, 0, 0, &_inner_error_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	_tmp9_ = _tmp8_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch43_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	_g_regex_unref0 (rygel_media_object_user_name_regex);
	rygel_media_object_user_name_regex = _tmp9_;
	_tmp10_ = g_regex_escape_string ("@HOSTNAME@", -1);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_regex_new (_tmp11_, 0, 0, &_inner_error_);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp11_);
	_tmp14_ = _tmp13_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch43_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	_g_regex_unref0 (rygel_media_object_host_name_regex);
	rygel_media_object_host_name_regex = _tmp14_;
	goto __finally43;
	__catch43_g_regex_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (err);
	}
	__finally43:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
}


static void rygel_media_object_instance_init (RygelMediaObject * self) {
	self->priv = RYGEL_MEDIA_OBJECT_GET_PRIVATE (self);
}


static void rygel_media_object_finalize (GObject* obj) {
	RygelMediaObject * self;
	self = RYGEL_MEDIA_OBJECT (obj);
	_g_free0 (self->id);
	_g_free0 (self->ref_id);
	_g_free0 (self->upnp_class);
	_g_object_unref0 (self->uris);
	_g_object_unref0 (self->priv->_parent_ref);
	_g_free0 (self->priv->_title);
	G_OBJECT_CLASS (rygel_media_object_parent_class)->finalize (obj);
}


/**
 * Represents a media object (container and item).
 */
GType rygel_media_object_get_type (void) {
	static volatile gsize rygel_media_object_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_object_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaObject), 0, (GInstanceInitFunc) rygel_media_object_instance_init, NULL };
		GType rygel_media_object_type_id;
		rygel_media_object_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaObject", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_media_object_type_id__volatile, rygel_media_object_type_id);
	}
	return rygel_media_object_type_id__volatile;
}


static void _vala_rygel_media_object_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMediaObject * self;
	self = RYGEL_MEDIA_OBJECT (object);
	switch (property_id) {
		case RYGEL_MEDIA_OBJECT_PARENT_REF:
		g_value_set_object (value, rygel_media_object_get_parent_ref (self));
		break;
		case RYGEL_MEDIA_OBJECT_TITLE:
		g_value_set_string (value, rygel_media_object_get_title (self));
		break;
		case RYGEL_MEDIA_OBJECT_RESTRICTED:
		g_value_set_boolean (value, rygel_media_object_get_restricted (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_media_object_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMediaObject * self;
	self = RYGEL_MEDIA_OBJECT (object);
	switch (property_id) {
		case RYGEL_MEDIA_OBJECT_PARENT_REF:
		rygel_media_object_set_parent_ref (self, g_value_get_object (value));
		break;
		case RYGEL_MEDIA_OBJECT_TITLE:
		rygel_media_object_set_title (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



