/* cairo-display.c generated by valac 0.36.1.17-97a62, the Vala compiler
 * generated from cairo-display.vala, do not modify */

/* This file is part of retro-gtk. License: GPL-3.0+.*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <float.h>
#include <math.h>
#include <cairo.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>


#define RETRO_TYPE_CAIRO_DISPLAY (retro_cairo_display_get_type ())
#define RETRO_CAIRO_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_CAIRO_DISPLAY, RetroCairoDisplay))
#define RETRO_CAIRO_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RETRO_TYPE_CAIRO_DISPLAY, RetroCairoDisplayClass))
#define RETRO_IS_CAIRO_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_CAIRO_DISPLAY))
#define RETRO_IS_CAIRO_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RETRO_TYPE_CAIRO_DISPLAY))
#define RETRO_CAIRO_DISPLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RETRO_TYPE_CAIRO_DISPLAY, RetroCairoDisplayClass))

typedef struct _RetroCairoDisplay RetroCairoDisplay;
typedef struct _RetroCairoDisplayClass RetroCairoDisplayClass;
typedef struct _RetroCairoDisplayPrivate RetroCairoDisplayPrivate;

#define RETRO_TYPE_CORE (retro_core_get_type ())
#define RETRO_CORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_CORE, RetroCore))
#define RETRO_CORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RETRO_TYPE_CORE, RetroCoreClass))
#define RETRO_IS_CORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_CORE))
#define RETRO_IS_CORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RETRO_TYPE_CORE))
#define RETRO_CORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RETRO_TYPE_CORE, RetroCoreClass))

typedef struct _RetroCore RetroCore;
typedef struct _RetroCoreClass RetroCoreClass;

#define RETRO_TYPE_VIDEO_FILTER (retro_video_filter_get_type ())
enum  {
	RETRO_CAIRO_DISPLAY_DUMMY_PROPERTY,
	RETRO_CAIRO_DISPLAY_PIXBUF,
	RETRO_CAIRO_DISPLAY_LAST_PROPERTY
};
static GParamSpec* retro_cairo_display_properties[RETRO_CAIRO_DISPLAY_LAST_PROPERTY];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RETRO_TYPE_PIXEL_FORMAT (retro_pixel_format_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))

struct _RetroCairoDisplay {
	GtkDrawingArea parent_instance;
	RetroCairoDisplayPrivate * priv;
};

struct _RetroCairoDisplayClass {
	GtkDrawingAreaClass parent_class;
};

typedef enum  {
	RETRO_VIDEO_FILTER_SMOOTH,
	RETRO_VIDEO_FILTER_SHARP
} RetroVideoFilter;

struct _RetroCairoDisplayPrivate {
	GdkPixbuf* _pixbuf;
	RetroCore* core;
	RetroVideoFilter filter;
	gulong on_video_output_id;
	gfloat aspect_ratio;
	gboolean show_surface;
};

typedef enum  {
	RETRO_PIXEL_FORMAT_XRGB1555,
	RETRO_PIXEL_FORMAT_XRGB8888,
	RETRO_PIXEL_FORMAT_RGB565,
	RETRO_PIXEL_FORMAT_UNKNOWN = -1
} RetroPixelFormat;


static gpointer retro_cairo_display_parent_class = NULL;

GType retro_cairo_display_get_type (void) G_GNUC_CONST;
GType retro_core_get_type (void) G_GNUC_CONST;
GType retro_video_filter_get_type (void) G_GNUC_CONST;
#define RETRO_CAIRO_DISPLAY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RETRO_TYPE_CAIRO_DISPLAY, RetroCairoDisplayPrivate))
#define RETRO_CAIRO_DISPLAY_Y_DPI 1000000.0f
GType retro_pixel_format_get_type (void) G_GNUC_CONST;
GdkPixbuf* gdk_pixbuf_new_from_video (guint8* data, guint width, guint height, gsize pitch, RetroPixelFormat pixel_format);
void retro_cairo_display_set_core (RetroCairoDisplay* self, RetroCore* core);
static void retro_cairo_display_on_video_output (RetroCairoDisplay* self, guint8* data, int data_length1, guint width, guint height, gsize pitch, RetroPixelFormat pixel_format, gfloat aspect_ratio);
static void _retro_cairo_display_on_video_output_retro_core_video_output (RetroCore* _sender, guint8* data, int data_length1, guint width, guint height, gsize pitch, RetroPixelFormat pixel_format, gfloat aspect_ratio, gpointer self);
void retro_cairo_display_set_filter (RetroCairoDisplay* self, RetroVideoFilter filter);
gboolean retro_cairo_display_get_coordinates_on_display (RetroCairoDisplay* self, gdouble widget_x, gdouble widget_y, gdouble* display_x, gdouble* display_y);
static void retro_cairo_display_get_video_box (RetroCairoDisplay* self, gdouble* width, gdouble* height, gdouble* x, gdouble* y);
void retro_cairo_display_set_pixbuf (RetroCairoDisplay* self, GdkPixbuf* value);
GdkPixbuf* retro_cairo_display_get_pixbuf (RetroCairoDisplay* self);
void retro_cairo_display_show_video (RetroCairoDisplay* self);
void retro_cairo_display_hide_video (RetroCairoDisplay* self);
static gboolean retro_cairo_display_real_draw (GtkWidget* base, cairo_t* cr);
static void retro_cairo_display_draw_background (RetroCairoDisplay* self, cairo_t* cr);
RetroCairoDisplay* retro_cairo_display_new (void);
RetroCairoDisplay* retro_cairo_display_construct (GType object_type);
static GObject * retro_cairo_display_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _gtk_widget_queue_draw_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void retro_cairo_display_finalize (GObject * obj);
static void _vala_retro_cairo_display_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_retro_cairo_display_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _retro_cairo_display_on_video_output_retro_core_video_output (RetroCore* _sender, guint8* data, int data_length1, guint width, guint height, gsize pitch, RetroPixelFormat pixel_format, gfloat aspect_ratio, gpointer self) {
	retro_cairo_display_on_video_output ((RetroCairoDisplay*) self, data, data_length1, width, height, pitch, pixel_format, aspect_ratio);
}


void retro_cairo_display_set_core (RetroCairoDisplay* self, RetroCore* core) {
	RetroCore* _tmp0_;
	RetroCore* _tmp3_;
	RetroCore* _tmp4_;
	RetroCore* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->core;
	if (_tmp0_ != NULL) {
		RetroCore* _tmp1_;
		gulong _tmp2_;
		_tmp1_ = self->priv->core;
		_tmp2_ = self->priv->on_video_output_id;
		g_signal_handler_disconnect ((GObject*) _tmp1_, _tmp2_);
	}
	_tmp3_ = core;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->priv->core);
	self->priv->core = _tmp4_;
	_tmp5_ = self->priv->core;
	if (_tmp5_ != NULL) {
		RetroCore* _tmp6_;
		gulong _tmp7_;
		_tmp6_ = core;
		_tmp7_ = g_signal_connect_object (_tmp6_, "video-output", (GCallback) _retro_cairo_display_on_video_output_retro_core_video_output, self, 0);
		self->priv->on_video_output_id = _tmp7_;
	}
}


void retro_cairo_display_set_filter (RetroCairoDisplay* self, RetroVideoFilter filter) {
	RetroVideoFilter _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = filter;
	self->priv->filter = _tmp0_;
	gtk_widget_queue_draw ((GtkWidget*) self);
}


gboolean retro_cairo_display_get_coordinates_on_display (RetroCairoDisplay* self, gdouble widget_x, gdouble widget_y, gdouble* display_x, gdouble* display_y) {
	gdouble _vala_display_x = 0.0;
	gdouble _vala_display_y = 0.0;
	gboolean result = FALSE;
	gdouble w = 0.0;
	gdouble h = 0.0;
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_;
	gdouble _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	gdouble _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	gboolean _tmp12_ = FALSE;
	gdouble _tmp13_;
	gdouble _tmp14_;
	g_return_val_if_fail (self != NULL, FALSE);
	retro_cairo_display_get_video_box (self, &_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
	w = _tmp0_;
	h = _tmp1_;
	x = _tmp2_;
	y = _tmp3_;
	_tmp4_ = widget_x;
	_tmp5_ = x;
	_tmp6_ = w;
	_tmp7_ = w;
	_vala_display_x = (((_tmp4_ - _tmp5_) * 2.0) - _tmp6_) / _tmp7_;
	_tmp8_ = widget_y;
	_tmp9_ = y;
	_tmp10_ = h;
	_tmp11_ = h;
	_vala_display_y = (((_tmp8_ - _tmp9_) * 2.0) - _tmp10_) / _tmp11_;
	_tmp13_ = _vala_display_x;
	_tmp14_ = _tmp13_;
	if (((-1.0) <= _tmp14_) && (_tmp14_ <= 1.0)) {
		gdouble _tmp15_;
		gdouble _tmp16_;
		_tmp15_ = _vala_display_y;
		_tmp16_ = _tmp15_;
		_tmp12_ = ((-1.0) <= _tmp16_) && (_tmp16_ <= 1.0);
	} else {
		_tmp12_ = FALSE;
	}
	result = _tmp12_;
	if (display_x) {
		*display_x = _vala_display_x;
	}
	if (display_y) {
		*display_y = _vala_display_y;
	}
	return result;
}


static void retro_cairo_display_on_video_output (RetroCairoDisplay* self, guint8* data, int data_length1, guint width, guint height, gsize pitch, RetroPixelFormat pixel_format, gfloat aspect_ratio) {
	gfloat _tmp0_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	guint _tmp2_;
	guint _tmp3_;
	gsize _tmp4_;
	RetroPixelFormat _tmp5_;
	GdkPixbuf* _tmp6_;
	GdkPixbuf* _tmp7_;
	gfloat x_dpi;
	gfloat _tmp8_;
	gchar* x_dpi_string;
	gchar* _tmp9_;
	gchar* y_dpi_string;
	gchar* _tmp10_;
	GdkPixbuf* _tmp11_;
	GdkPixbuf* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = aspect_ratio;
	self->priv->aspect_ratio = _tmp0_;
	_tmp1_ = data;
	_tmp1__length1 = data_length1;
	_tmp2_ = width;
	_tmp3_ = height;
	_tmp4_ = pitch;
	_tmp5_ = pixel_format;
	_tmp6_ = gdk_pixbuf_new_from_video (_tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_);
	_tmp7_ = _tmp6_;
	retro_cairo_display_set_pixbuf (self, _tmp7_);
	_g_object_unref0 (_tmp7_);
	_tmp8_ = aspect_ratio;
	x_dpi = _tmp8_ * RETRO_CAIRO_DISPLAY_Y_DPI;
	_tmp9_ = g_strdup_printf ("%g", x_dpi);
	x_dpi_string = _tmp9_;
	_tmp10_ = g_strdup_printf ("%g", RETRO_CAIRO_DISPLAY_Y_DPI);
	y_dpi_string = _tmp10_;
	_tmp11_ = self->priv->_pixbuf;
	gdk_pixbuf_set_option (_tmp11_, "x-dpi", x_dpi_string);
	_tmp12_ = self->priv->_pixbuf;
	gdk_pixbuf_set_option (_tmp12_, "y-dpi", y_dpi_string);
	_g_free0 (y_dpi_string);
	_g_free0 (x_dpi_string);
}


void retro_cairo_display_show_video (RetroCairoDisplay* self) {
	g_return_if_fail (self != NULL);
	self->priv->show_surface = TRUE;
	gtk_widget_queue_draw ((GtkWidget*) self);
}


void retro_cairo_display_hide_video (RetroCairoDisplay* self) {
	g_return_if_fail (self != NULL);
	self->priv->show_surface = FALSE;
	gtk_widget_queue_draw ((GtkWidget*) self);
}


static gpointer _cairo_pattern_reference0 (gpointer self) {
	return self ? cairo_pattern_reference (self) : NULL;
}


static gboolean retro_cairo_display_real_draw (GtkWidget* base, cairo_t* cr) {
	RetroCairoDisplay * self;
	gboolean result = FALSE;
	cairo_t* _tmp0_;
	gboolean _tmp1_;
	GdkPixbuf* to_draw;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* _tmp3_;
	GdkPixbuf* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	cairo_surface_t* surface;
	GdkPixbuf* _tmp21_;
	cairo_surface_t* _tmp22_;
	gdouble w = 0.0;
	gdouble h = 0.0;
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble _tmp23_ = 0.0;
	gdouble _tmp24_ = 0.0;
	gdouble _tmp25_ = 0.0;
	gdouble _tmp26_ = 0.0;
	gdouble xs;
	gdouble _tmp27_;
	GdkPixbuf* _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	gdouble ys;
	gdouble _tmp31_;
	GdkPixbuf* _tmp32_;
	gint _tmp33_;
	gint _tmp34_;
	cairo_t* _tmp35_;
	gdouble _tmp36_;
	gdouble _tmp37_;
	cairo_t* _tmp38_;
	cairo_surface_t* _tmp39_;
	gdouble _tmp40_;
	gdouble _tmp41_;
	gdouble _tmp42_;
	gdouble _tmp43_;
	cairo_pattern_t* source;
	cairo_t* _tmp44_;
	cairo_pattern_t* _tmp45_;
	cairo_pattern_t* _tmp46_;
	RetroVideoFilter _tmp47_;
	cairo_t* _tmp50_;
	self = (RetroCairoDisplay*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	_tmp0_ = cr;
	retro_cairo_display_draw_background (self, _tmp0_);
	_tmp1_ = self->priv->show_surface;
	if (!_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = self->priv->_pixbuf;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	to_draw = _tmp3_;
	_tmp4_ = to_draw;
	if (_tmp4_ == NULL) {
		result = FALSE;
		_g_object_unref0 (to_draw);
		return result;
	}
	_tmp5_ = gtk_widget_get_sensitive ((GtkWidget*) self);
	_tmp6_ = _tmp5_;
	if (!_tmp6_) {
		GdkPixbuf* desaturated;
		GdkPixbuf* _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_;
		GdkPixbuf* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		GdkPixbuf* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		GdkPixbuf* _tmp16_;
		GdkPixbuf* _tmp17_;
		GdkPixbuf* _tmp18_;
		GdkPixbuf* _tmp19_;
		GdkPixbuf* _tmp20_;
		_tmp7_ = to_draw;
		_tmp8_ = gdk_pixbuf_get_has_alpha (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = to_draw;
		_tmp11_ = gdk_pixbuf_get_width (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = to_draw;
		_tmp14_ = gdk_pixbuf_get_height (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = gdk_pixbuf_new (GDK_COLORSPACE_RGB, _tmp9_, 8, _tmp12_, _tmp15_);
		desaturated = _tmp16_;
		_tmp17_ = to_draw;
		_tmp18_ = desaturated;
		gdk_pixbuf_saturate_and_pixelate (_tmp17_, _tmp18_, 0.0f, FALSE);
		_tmp19_ = desaturated;
		_tmp20_ = _g_object_ref0 (_tmp19_);
		_g_object_unref0 (to_draw);
		to_draw = _tmp20_;
		_g_object_unref0 (desaturated);
	}
	_tmp21_ = to_draw;
	_tmp22_ = gdk_cairo_surface_create_from_pixbuf (_tmp21_, 1, NULL);
	surface = _tmp22_;
	retro_cairo_display_get_video_box (self, &_tmp23_, &_tmp24_, &_tmp25_, &_tmp26_);
	w = _tmp23_;
	h = _tmp24_;
	x = _tmp25_;
	y = _tmp26_;
	_tmp27_ = w;
	_tmp28_ = to_draw;
	_tmp29_ = gdk_pixbuf_get_width (_tmp28_);
	_tmp30_ = _tmp29_;
	xs = _tmp27_ / _tmp30_;
	_tmp31_ = h;
	_tmp32_ = to_draw;
	_tmp33_ = gdk_pixbuf_get_height (_tmp32_);
	_tmp34_ = _tmp33_;
	ys = _tmp31_ / _tmp34_;
	_tmp35_ = cr;
	_tmp36_ = xs;
	_tmp37_ = ys;
	cairo_scale (_tmp35_, _tmp36_, _tmp37_);
	_tmp38_ = cr;
	_tmp39_ = surface;
	_tmp40_ = x;
	_tmp41_ = xs;
	_tmp42_ = y;
	_tmp43_ = ys;
	cairo_set_source_surface (_tmp38_, _tmp39_, _tmp40_ / _tmp41_, _tmp42_ / _tmp43_);
	_tmp44_ = cr;
	_tmp45_ = cairo_get_source (_tmp44_);
	_tmp46_ = _cairo_pattern_reference0 (_tmp45_);
	source = _tmp46_;
	_tmp47_ = self->priv->filter;
	switch (_tmp47_) {
		case RETRO_VIDEO_FILTER_SHARP:
		{
			cairo_pattern_t* _tmp48_;
			_tmp48_ = source;
			cairo_pattern_set_filter (_tmp48_, CAIRO_FILTER_NEAREST);
			break;
		}
		default:
		case RETRO_VIDEO_FILTER_SMOOTH:
		{
			cairo_pattern_t* _tmp49_;
			_tmp49_ = source;
			cairo_pattern_set_filter (_tmp49_, CAIRO_FILTER_BILINEAR);
			break;
		}
	}
	_tmp50_ = cr;
	cairo_paint (_tmp50_);
	result = TRUE;
	_cairo_pattern_destroy0 (source);
	_cairo_surface_destroy0 (surface);
	_g_object_unref0 (to_draw);
	return result;
}


static void retro_cairo_display_draw_background (RetroCairoDisplay* self, cairo_t* cr) {
	cairo_t* _tmp0_;
	cairo_t* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = cr;
	cairo_set_source_rgb (_tmp0_, (gdouble) 0, (gdouble) 0, (gdouble) 0);
	_tmp1_ = cr;
	cairo_paint (_tmp1_);
}


static void retro_cairo_display_get_video_box (RetroCairoDisplay* self, gdouble* width, gdouble* height, gdouble* x, gdouble* y) {
	gdouble _vala_width = 0.0;
	gdouble _vala_height = 0.0;
	gdouble _vala_x = 0.0;
	gdouble _vala_y = 0.0;
	gdouble w;
	gint _tmp0_;
	gdouble h;
	gint _tmp1_;
	gdouble display_ratio;
	gfloat _tmp2_;
	gdouble allocated_ratio;
	gdouble _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp13_;
	gdouble _tmp14_;
	gdouble _tmp15_;
	gdouble _tmp16_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	w = (gdouble) _tmp0_;
	_tmp1_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	h = (gdouble) _tmp1_;
	_tmp2_ = self->priv->aspect_ratio;
	display_ratio = (gdouble) _tmp2_;
	_tmp3_ = w;
	_tmp4_ = h;
	allocated_ratio = _tmp3_ / _tmp4_;
	_tmp5_ = allocated_ratio;
	_tmp6_ = display_ratio;
	if (_tmp5_ > _tmp6_) {
		gdouble _tmp7_;
		gdouble _tmp8_;
		gdouble _tmp9_;
		_tmp7_ = h;
		_vala_height = _tmp7_;
		_tmp8_ = h;
		_tmp9_ = display_ratio;
		_vala_width = (gdouble) (_tmp8_ * _tmp9_);
	} else {
		gdouble _tmp10_;
		gdouble _tmp11_;
		gdouble _tmp12_;
		_tmp10_ = w;
		_vala_width = _tmp10_;
		_tmp11_ = w;
		_tmp12_ = display_ratio;
		_vala_height = (gdouble) (_tmp11_ / _tmp12_);
	}
	_tmp13_ = w;
	_tmp14_ = _vala_width;
	_vala_x = (_tmp13_ - _tmp14_) / 2;
	_tmp15_ = h;
	_tmp16_ = _vala_height;
	_vala_y = (_tmp15_ - _tmp16_) / 2;
	if (width) {
		*width = _vala_width;
	}
	if (height) {
		*height = _vala_height;
	}
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
}


RetroCairoDisplay* retro_cairo_display_construct (GType object_type) {
	RetroCairoDisplay * self = NULL;
	self = (RetroCairoDisplay*) g_object_new (object_type, NULL);
	return self;
}


RetroCairoDisplay* retro_cairo_display_new (void) {
	return retro_cairo_display_construct (RETRO_TYPE_CAIRO_DISPLAY);
}


GdkPixbuf* retro_cairo_display_get_pixbuf (RetroCairoDisplay* self) {
	GdkPixbuf* result;
	GdkPixbuf* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_pixbuf;
	result = _tmp0_;
	return result;
}


void retro_cairo_display_set_pixbuf (RetroCairoDisplay* self, GdkPixbuf* value) {
	g_return_if_fail (self != NULL);
	if (retro_cairo_display_get_pixbuf (self) != value) {
		GdkPixbuf* _tmp0_;
		GdkPixbuf* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_g_object_unref0 (self->priv->_pixbuf);
		self->priv->_pixbuf = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, retro_cairo_display_properties[RETRO_CAIRO_DISPLAY_PIXBUF]);
	}
}


static void _gtk_widget_queue_draw_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	gtk_widget_queue_draw ((GtkWidget*) self);
}


static GObject * retro_cairo_display_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	RetroCairoDisplay * self;
	parent_class = G_OBJECT_CLASS (retro_cairo_display_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RETRO_TYPE_CAIRO_DISPLAY, RetroCairoDisplay);
	self->priv->filter = RETRO_VIDEO_FILTER_SMOOTH;
	self->priv->show_surface = TRUE;
	g_signal_connect_object ((GObject*) self, "notify::sensitive", (GCallback) _gtk_widget_queue_draw_g_object_notify, (GtkWidget*) self, 0);
	g_signal_connect_object ((GObject*) self, "notify::pixbuf", (GCallback) _gtk_widget_queue_draw_g_object_notify, (GtkWidget*) self, 0);
	return obj;
}


static void retro_cairo_display_class_init (RetroCairoDisplayClass * klass) {
	retro_cairo_display_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RetroCairoDisplayPrivate));
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget *, cairo_t*)) retro_cairo_display_real_draw;
	G_OBJECT_CLASS (klass)->get_property = _vala_retro_cairo_display_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_retro_cairo_display_set_property;
	G_OBJECT_CLASS (klass)->constructor = retro_cairo_display_constructor;
	G_OBJECT_CLASS (klass)->finalize = retro_cairo_display_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_CAIRO_DISPLAY_PIXBUF, retro_cairo_display_properties[RETRO_CAIRO_DISPLAY_PIXBUF] = g_param_spec_object ("pixbuf", "pixbuf", "pixbuf", gdk_pixbuf_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void retro_cairo_display_instance_init (RetroCairoDisplay * self) {
	self->priv = RETRO_CAIRO_DISPLAY_GET_PRIVATE (self);
}


static void retro_cairo_display_finalize (GObject * obj) {
	RetroCairoDisplay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RETRO_TYPE_CAIRO_DISPLAY, RetroCairoDisplay);
	_g_object_unref0 (self->priv->_pixbuf);
	_g_object_unref0 (self->priv->core);
	G_OBJECT_CLASS (retro_cairo_display_parent_class)->finalize (obj);
}


GType retro_cairo_display_get_type (void) {
	static volatile gsize retro_cairo_display_type_id__volatile = 0;
	if (g_once_init_enter (&retro_cairo_display_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RetroCairoDisplayClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) retro_cairo_display_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RetroCairoDisplay), 0, (GInstanceInitFunc) retro_cairo_display_instance_init, NULL };
		GType retro_cairo_display_type_id;
		retro_cairo_display_type_id = g_type_register_static (gtk_drawing_area_get_type (), "RetroCairoDisplay", &g_define_type_info, 0);
		g_once_init_leave (&retro_cairo_display_type_id__volatile, retro_cairo_display_type_id);
	}
	return retro_cairo_display_type_id__volatile;
}


static void _vala_retro_cairo_display_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RetroCairoDisplay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RETRO_TYPE_CAIRO_DISPLAY, RetroCairoDisplay);
	switch (property_id) {
		case RETRO_CAIRO_DISPLAY_PIXBUF:
		g_value_set_object (value, retro_cairo_display_get_pixbuf (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_retro_cairo_display_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RetroCairoDisplay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RETRO_TYPE_CAIRO_DISPLAY, RetroCairoDisplay);
	switch (property_id) {
		case RETRO_CAIRO_DISPLAY_PIXBUF:
		retro_cairo_display_set_pixbuf (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



