/* device.c generated by valac 0.36.1.17-97a62, the Vala compiler
 * generated from device.vala, do not modify */

/* This file is part of retro-gtk. License: GPL-3.0+.*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define RETRO_TYPE_DEVICE_TYPE (retro_device_type_get_type ())

#define RETRO_TYPE_JOYPAD_ID (retro_joypad_id_get_type ())

#define RETRO_TYPE_ANALOG_INDEX (retro_analog_index_get_type ())

#define RETRO_TYPE_ANALOG_ID (retro_analog_id_get_type ())

#define RETRO_TYPE_MOUSE_ID (retro_mouse_id_get_type ())

#define RETRO_TYPE_LIGHTGUN_ID (retro_lightgun_id_get_type ())

#define RETRO_TYPE_POINTER_ID (retro_pointer_id_get_type ())

#define RETRO_TYPE_INPUT_DESCRIPTOR (retro_input_descriptor_get_type ())
typedef struct _RetroInputDescriptor RetroInputDescriptor;
#define _g_free0(var) (var = (g_free (var), NULL))

typedef enum  {
	RETRO_DEVICE_TYPE_TYPE_MASK = 0xff,
	RETRO_DEVICE_TYPE_NONE = 0,
	RETRO_DEVICE_TYPE_JOYPAD = 1,
	RETRO_DEVICE_TYPE_MOUSE = 2,
	RETRO_DEVICE_TYPE_KEYBOARD = 3,
	RETRO_DEVICE_TYPE_LIGHTGUN = 4,
	RETRO_DEVICE_TYPE_ANALOG = 5,
	RETRO_DEVICE_TYPE_POINTER = 6
} RetroDeviceType;

typedef enum  {
	RETRO_JOYPAD_ID_B,
	RETRO_JOYPAD_ID_Y,
	RETRO_JOYPAD_ID_SELECT,
	RETRO_JOYPAD_ID_START,
	RETRO_JOYPAD_ID_UP,
	RETRO_JOYPAD_ID_DOWN,
	RETRO_JOYPAD_ID_LEFT,
	RETRO_JOYPAD_ID_RIGHT,
	RETRO_JOYPAD_ID_A,
	RETRO_JOYPAD_ID_X,
	RETRO_JOYPAD_ID_L,
	RETRO_JOYPAD_ID_R,
	RETRO_JOYPAD_ID_L2,
	RETRO_JOYPAD_ID_R2,
	RETRO_JOYPAD_ID_L3,
	RETRO_JOYPAD_ID_R3,
	RETRO_JOYPAD_ID_COUNT
} RetroJoypadId;

typedef enum  {
	RETRO_ANALOG_INDEX_LEFT,
	RETRO_ANALOG_INDEX_RIGHT
} RetroAnalogIndex;

typedef enum  {
	RETRO_ANALOG_ID_X,
	RETRO_ANALOG_ID_Y
} RetroAnalogId;

typedef enum  {
	RETRO_MOUSE_ID_X,
	RETRO_MOUSE_ID_Y,
	RETRO_MOUSE_ID_LEFT,
	RETRO_MOUSE_ID_RIGHT,
	RETRO_MOUSE_ID_WHEELUP,
	RETRO_MOUSE_ID_WHEELDOWN,
	RETRO_MOUSE_ID_MIDDLE,
	RETRO_MOUSE_ID_HORIZ_WHEELUP,
	RETRO_MOUSE_ID_HORIZ_WHEELDOWN
} RetroMouseId;

typedef enum  {
	RETRO_LIGHTGUN_ID_X,
	RETRO_LIGHTGUN_ID_Y,
	RETRO_LIGHTGUN_ID_TRIGGER,
	RETRO_LIGHTGUN_ID_CURSOR,
	RETRO_LIGHTGUN_ID_TURBO,
	RETRO_LIGHTGUN_ID_PAUSE,
	RETRO_LIGHTGUN_ID_START
} RetroLightgunId;

typedef enum  {
	RETRO_POINTER_ID_X,
	RETRO_POINTER_ID_Y,
	RETRO_POINTER_ID_PRESSED
} RetroPointerId;

struct _RetroInputDescriptor {
	guint port;
	RetroDeviceType device;
	guint index;
	guint id;
	gchar* description;
};



GType retro_device_type_get_type (void) G_GNUC_CONST;
RetroDeviceType retro_device_type_get_basic_type (RetroDeviceType self);
GType retro_joypad_id_get_type (void) G_GNUC_CONST;
GType retro_analog_index_get_type (void) G_GNUC_CONST;
GType retro_analog_id_get_type (void) G_GNUC_CONST;
GType retro_mouse_id_get_type (void) G_GNUC_CONST;
GType retro_lightgun_id_get_type (void) G_GNUC_CONST;
GType retro_pointer_id_get_type (void) G_GNUC_CONST;
GType retro_input_descriptor_get_type (void) G_GNUC_CONST;
RetroInputDescriptor* retro_input_descriptor_dup (const RetroInputDescriptor* self);
void retro_input_descriptor_free (RetroInputDescriptor* self);
void retro_input_descriptor_copy (const RetroInputDescriptor* self, RetroInputDescriptor* dest);
void retro_input_descriptor_destroy (RetroInputDescriptor* self);


/**
 * Gets the basic type of a device type.
 *
 * Applies the type mask on a DeviceType to get its basic type.
 * If the device type is already basic, it will return the same type.
 *
 * E.g DeviceType.JOYPAD_MULTITAP.get_basic_type () returns
 * DeviceType.JOYPAD, and DeviceType.JOYPAD.get_basic_type () also
 * returns Type.JOYPAD.
 *
 * @return the basic type of a device type
 */
RetroDeviceType retro_device_type_get_basic_type (RetroDeviceType self) {
	RetroDeviceType result = 0;
	result = self & RETRO_DEVICE_TYPE_TYPE_MASK;
	return result;
}


/**
 * The device types.
 */
GType retro_device_type_get_type (void) {
	static volatile gsize retro_device_type_type_id__volatile = 0;
	if (g_once_init_enter (&retro_device_type_type_id__volatile)) {
		static const GEnumValue values[] = {{RETRO_DEVICE_TYPE_TYPE_MASK, "RETRO_DEVICE_TYPE_TYPE_MASK", "type-mask"}, {RETRO_DEVICE_TYPE_NONE, "RETRO_DEVICE_TYPE_NONE", "none"}, {RETRO_DEVICE_TYPE_JOYPAD, "RETRO_DEVICE_TYPE_JOYPAD", "joypad"}, {RETRO_DEVICE_TYPE_MOUSE, "RETRO_DEVICE_TYPE_MOUSE", "mouse"}, {RETRO_DEVICE_TYPE_KEYBOARD, "RETRO_DEVICE_TYPE_KEYBOARD", "keyboard"}, {RETRO_DEVICE_TYPE_LIGHTGUN, "RETRO_DEVICE_TYPE_LIGHTGUN", "lightgun"}, {RETRO_DEVICE_TYPE_ANALOG, "RETRO_DEVICE_TYPE_ANALOG", "analog"}, {RETRO_DEVICE_TYPE_POINTER, "RETRO_DEVICE_TYPE_POINTER", "pointer"}, {0, NULL, NULL}};
		GType retro_device_type_type_id;
		retro_device_type_type_id = g_enum_register_static ("RetroDeviceType", values);
		g_once_init_leave (&retro_device_type_type_id__volatile, retro_device_type_type_id);
	}
	return retro_device_type_type_id__volatile;
}


/**
 * The input types of a joypad.
 */
GType retro_joypad_id_get_type (void) {
	static volatile gsize retro_joypad_id_type_id__volatile = 0;
	if (g_once_init_enter (&retro_joypad_id_type_id__volatile)) {
		static const GEnumValue values[] = {{RETRO_JOYPAD_ID_B, "RETRO_JOYPAD_ID_B", "b"}, {RETRO_JOYPAD_ID_Y, "RETRO_JOYPAD_ID_Y", "y"}, {RETRO_JOYPAD_ID_SELECT, "RETRO_JOYPAD_ID_SELECT", "select"}, {RETRO_JOYPAD_ID_START, "RETRO_JOYPAD_ID_START", "start"}, {RETRO_JOYPAD_ID_UP, "RETRO_JOYPAD_ID_UP", "up"}, {RETRO_JOYPAD_ID_DOWN, "RETRO_JOYPAD_ID_DOWN", "down"}, {RETRO_JOYPAD_ID_LEFT, "RETRO_JOYPAD_ID_LEFT", "left"}, {RETRO_JOYPAD_ID_RIGHT, "RETRO_JOYPAD_ID_RIGHT", "right"}, {RETRO_JOYPAD_ID_A, "RETRO_JOYPAD_ID_A", "a"}, {RETRO_JOYPAD_ID_X, "RETRO_JOYPAD_ID_X", "x"}, {RETRO_JOYPAD_ID_L, "RETRO_JOYPAD_ID_L", "l"}, {RETRO_JOYPAD_ID_R, "RETRO_JOYPAD_ID_R", "r"}, {RETRO_JOYPAD_ID_L2, "RETRO_JOYPAD_ID_L2", "l2"}, {RETRO_JOYPAD_ID_R2, "RETRO_JOYPAD_ID_R2", "r2"}, {RETRO_JOYPAD_ID_L3, "RETRO_JOYPAD_ID_L3", "l3"}, {RETRO_JOYPAD_ID_R3, "RETRO_JOYPAD_ID_R3", "r3"}, {RETRO_JOYPAD_ID_COUNT, "RETRO_JOYPAD_ID_COUNT", "count"}, {0, NULL, NULL}};
		GType retro_joypad_id_type_id;
		retro_joypad_id_type_id = g_enum_register_static ("RetroJoypadId", values);
		g_once_init_leave (&retro_joypad_id_type_id__volatile, retro_joypad_id_type_id);
	}
	return retro_joypad_id_type_id__volatile;
}


/**
 * The analog sticks of an analog joypad.
 */
GType retro_analog_index_get_type (void) {
	static volatile gsize retro_analog_index_type_id__volatile = 0;
	if (g_once_init_enter (&retro_analog_index_type_id__volatile)) {
		static const GEnumValue values[] = {{RETRO_ANALOG_INDEX_LEFT, "RETRO_ANALOG_INDEX_LEFT", "left"}, {RETRO_ANALOG_INDEX_RIGHT, "RETRO_ANALOG_INDEX_RIGHT", "right"}, {0, NULL, NULL}};
		GType retro_analog_index_type_id;
		retro_analog_index_type_id = g_enum_register_static ("RetroAnalogIndex", values);
		g_once_init_leave (&retro_analog_index_type_id__volatile, retro_analog_index_type_id);
	}
	return retro_analog_index_type_id__volatile;
}


/**
 * The axes of an analog stick.
 */
GType retro_analog_id_get_type (void) {
	static volatile gsize retro_analog_id_type_id__volatile = 0;
	if (g_once_init_enter (&retro_analog_id_type_id__volatile)) {
		static const GEnumValue values[] = {{RETRO_ANALOG_ID_X, "RETRO_ANALOG_ID_X", "x"}, {RETRO_ANALOG_ID_Y, "RETRO_ANALOG_ID_Y", "y"}, {0, NULL, NULL}};
		GType retro_analog_id_type_id;
		retro_analog_id_type_id = g_enum_register_static ("RetroAnalogId", values);
		g_once_init_leave (&retro_analog_id_type_id__volatile, retro_analog_id_type_id);
	}
	return retro_analog_id_type_id__volatile;
}


/**
 * The input types of a mouse.
 */
GType retro_mouse_id_get_type (void) {
	static volatile gsize retro_mouse_id_type_id__volatile = 0;
	if (g_once_init_enter (&retro_mouse_id_type_id__volatile)) {
		static const GEnumValue values[] = {{RETRO_MOUSE_ID_X, "RETRO_MOUSE_ID_X", "x"}, {RETRO_MOUSE_ID_Y, "RETRO_MOUSE_ID_Y", "y"}, {RETRO_MOUSE_ID_LEFT, "RETRO_MOUSE_ID_LEFT", "left"}, {RETRO_MOUSE_ID_RIGHT, "RETRO_MOUSE_ID_RIGHT", "right"}, {RETRO_MOUSE_ID_WHEELUP, "RETRO_MOUSE_ID_WHEELUP", "wheelup"}, {RETRO_MOUSE_ID_WHEELDOWN, "RETRO_MOUSE_ID_WHEELDOWN", "wheeldown"}, {RETRO_MOUSE_ID_MIDDLE, "RETRO_MOUSE_ID_MIDDLE", "middle"}, {RETRO_MOUSE_ID_HORIZ_WHEELUP, "RETRO_MOUSE_ID_HORIZ_WHEELUP", "horiz-wheelup"}, {RETRO_MOUSE_ID_HORIZ_WHEELDOWN, "RETRO_MOUSE_ID_HORIZ_WHEELDOWN", "horiz-wheeldown"}, {0, NULL, NULL}};
		GType retro_mouse_id_type_id;
		retro_mouse_id_type_id = g_enum_register_static ("RetroMouseId", values);
		g_once_init_leave (&retro_mouse_id_type_id__volatile, retro_mouse_id_type_id);
	}
	return retro_mouse_id_type_id__volatile;
}


/**
 * The input types of a lightgun.
 */
GType retro_lightgun_id_get_type (void) {
	static volatile gsize retro_lightgun_id_type_id__volatile = 0;
	if (g_once_init_enter (&retro_lightgun_id_type_id__volatile)) {
		static const GEnumValue values[] = {{RETRO_LIGHTGUN_ID_X, "RETRO_LIGHTGUN_ID_X", "x"}, {RETRO_LIGHTGUN_ID_Y, "RETRO_LIGHTGUN_ID_Y", "y"}, {RETRO_LIGHTGUN_ID_TRIGGER, "RETRO_LIGHTGUN_ID_TRIGGER", "trigger"}, {RETRO_LIGHTGUN_ID_CURSOR, "RETRO_LIGHTGUN_ID_CURSOR", "cursor"}, {RETRO_LIGHTGUN_ID_TURBO, "RETRO_LIGHTGUN_ID_TURBO", "turbo"}, {RETRO_LIGHTGUN_ID_PAUSE, "RETRO_LIGHTGUN_ID_PAUSE", "pause"}, {RETRO_LIGHTGUN_ID_START, "RETRO_LIGHTGUN_ID_START", "start"}, {0, NULL, NULL}};
		GType retro_lightgun_id_type_id;
		retro_lightgun_id_type_id = g_enum_register_static ("RetroLightgunId", values);
		g_once_init_leave (&retro_lightgun_id_type_id__volatile, retro_lightgun_id_type_id);
	}
	return retro_lightgun_id_type_id__volatile;
}


/**
 * The input types of a pointer.
 */
GType retro_pointer_id_get_type (void) {
	static volatile gsize retro_pointer_id_type_id__volatile = 0;
	if (g_once_init_enter (&retro_pointer_id_type_id__volatile)) {
		static const GEnumValue values[] = {{RETRO_POINTER_ID_X, "RETRO_POINTER_ID_X", "x"}, {RETRO_POINTER_ID_Y, "RETRO_POINTER_ID_Y", "y"}, {RETRO_POINTER_ID_PRESSED, "RETRO_POINTER_ID_PRESSED", "pressed"}, {0, NULL, NULL}};
		GType retro_pointer_id_type_id;
		retro_pointer_id_type_id = g_enum_register_static ("RetroPointerId", values);
		g_once_init_leave (&retro_pointer_id_type_id__volatile, retro_pointer_id_type_id);
	}
	return retro_pointer_id_type_id__volatile;
}


void retro_input_descriptor_copy (const RetroInputDescriptor* self, RetroInputDescriptor* dest) {
	guint _tmp0_;
	RetroDeviceType _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	_tmp0_ = (*self).port;
	(*dest).port = _tmp0_;
	_tmp1_ = (*self).device;
	(*dest).device = _tmp1_;
	_tmp2_ = (*self).index;
	(*dest).index = _tmp2_;
	_tmp3_ = (*self).id;
	(*dest).id = _tmp3_;
	_tmp4_ = (*self).description;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 ((*dest).description);
	(*dest).description = _tmp5_;
}


void retro_input_descriptor_destroy (RetroInputDescriptor* self) {
	_g_free0 ((*self).description);
}


RetroInputDescriptor* retro_input_descriptor_dup (const RetroInputDescriptor* self) {
	RetroInputDescriptor* dup;
	dup = g_new0 (RetroInputDescriptor, 1);
	retro_input_descriptor_copy (self, dup);
	return dup;
}


void retro_input_descriptor_free (RetroInputDescriptor* self) {
	retro_input_descriptor_destroy (self);
	g_free (self);
}


GType retro_input_descriptor_get_type (void) {
	static volatile gsize retro_input_descriptor_type_id__volatile = 0;
	if (g_once_init_enter (&retro_input_descriptor_type_id__volatile)) {
		GType retro_input_descriptor_type_id;
		retro_input_descriptor_type_id = g_boxed_type_register_static ("RetroInputDescriptor", (GBoxedCopyFunc) retro_input_descriptor_dup, (GBoxedFreeFunc) retro_input_descriptor_free);
		g_once_init_leave (&retro_input_descriptor_type_id__volatile, retro_input_descriptor_type_id);
	}
	return retro_input_descriptor_type_id__volatile;
}



