/* core.c generated by valac 0.36.1.17-97a62, the Vala compiler
 * generated from core.vala, do not modify */

/* This file is part of retro-gtk. License: GPL-3.0+.*/

#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>


#define RETRO_TYPE_CORE (retro_core_get_type ())
#define RETRO_CORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_CORE, RetroCore))
#define RETRO_CORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RETRO_TYPE_CORE, RetroCoreClass))
#define RETRO_IS_CORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_CORE))
#define RETRO_IS_CORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RETRO_TYPE_CORE))
#define RETRO_CORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RETRO_TYPE_CORE, RetroCoreClass))

typedef struct _RetroCore RetroCore;
typedef struct _RetroCoreClass RetroCoreClass;
typedef struct _RetroCorePrivate RetroCorePrivate;

#define RETRO_TYPE_VARIABLES (retro_variables_get_type ())
#define RETRO_VARIABLES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_VARIABLES, RetroVariables))
#define RETRO_IS_VARIABLES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_VARIABLES))
#define RETRO_VARIABLES_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RETRO_TYPE_VARIABLES, RetroVariablesIface))

typedef struct _RetroVariables RetroVariables;
typedef struct _RetroVariablesIface RetroVariablesIface;

#define RETRO_TYPE_VARIABLE (retro_variable_get_type ())
typedef struct _RetroVariable RetroVariable;

#define RETRO_TYPE_INPUT (retro_input_get_type ())
#define RETRO_INPUT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_INPUT, RetroInput))
#define RETRO_IS_INPUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_INPUT))
#define RETRO_INPUT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RETRO_TYPE_INPUT, RetroInputIface))

typedef struct _RetroInput RetroInput;
typedef struct _RetroInputIface RetroInputIface;

#define RETRO_TYPE_DEVICE_TYPE (retro_device_type_get_type ())

#define RETRO_TYPE_INPUT_DESCRIPTOR (retro_input_descriptor_get_type ())
typedef struct _RetroInputDescriptor RetroInputDescriptor;

#define RETRO_TYPE_INPUT_DEVICE (retro_input_device_get_type ())
#define RETRO_INPUT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_INPUT_DEVICE, RetroInputDevice))
#define RETRO_IS_INPUT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_INPUT_DEVICE))
#define RETRO_INPUT_DEVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RETRO_TYPE_INPUT_DEVICE, RetroInputDeviceIface))

typedef struct _RetroInputDevice RetroInputDevice;
typedef struct _RetroInputDeviceIface RetroInputDeviceIface;

#define RETRO_TYPE_RUMBLE (retro_rumble_get_type ())
#define RETRO_RUMBLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_RUMBLE, RetroRumble))
#define RETRO_IS_RUMBLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_RUMBLE))
#define RETRO_RUMBLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RETRO_TYPE_RUMBLE, RetroRumbleIface))

typedef struct _RetroRumble RetroRumble;
typedef struct _RetroRumbleIface RetroRumbleIface;

#define RETRO_TYPE_RUMBLE_EFFECT (retro_rumble_effect_get_type ())
enum  {
	RETRO_CORE_DUMMY_PROPERTY,
	RETRO_CORE_API_VERSION,
	RETRO_CORE_FILE_NAME,
	RETRO_CORE_SYSTEM_DIRECTORY,
	RETRO_CORE_LIBRETRO_PATH,
	RETRO_CORE_CONTENT_DIRECTORY,
	RETRO_CORE_SAVE_DIRECTORY,
	RETRO_CORE_IS_INITIATED,
	RETRO_CORE_GAME_LOADED,
	RETRO_CORE_SUPPORT_NO_GAME,
	RETRO_CORE_FRAMES_PER_SECOND,
	RETRO_CORE_INPUT_INTERFACE,
	RETRO_CORE_RUMBLE_INTERFACE,
	RETRO_CORE_LAST_PROPERTY
};
static GParamSpec* retro_core_properties[RETRO_CORE_LAST_PROPERTY];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RETRO_TYPE_MEMORY_TYPE (retro_memory_type_get_type ())

#define RETRO_TYPE_PIXEL_FORMAT (retro_pixel_format_get_type ())
enum  {
	RETRO_CORE_VIDEO_OUTPUT_SIGNAL,
	RETRO_CORE_AUDIO_OUTPUT_SIGNAL,
	RETRO_CORE_LOG_SIGNAL,
	RETRO_CORE_SHUTDOWN_SIGNAL,
	RETRO_CORE_MESSAGE_SIGNAL,
	RETRO_CORE_LAST_SIGNAL
};
static guint retro_core_signals[RETRO_CORE_LAST_SIGNAL] = {0};

struct _RetroVariable {
	gchar* key;
	gchar* value;
};

struct _RetroVariablesIface {
	GTypeInterface parent_iface;
	gchar* (*get_variable) (RetroVariables* self, const gchar* key);
	void (*set_variable) (RetroVariables* self, RetroVariable* variables, int variables_length1);
	gboolean (*get_variable_update) (RetroVariables* self);
	RetroCore* (*get_core) (RetroVariables* self);
	void (*set_core) (RetroVariables* self, RetroCore* value);
};

struct _RetroCore {
	GObject parent_instance;
	RetroCorePrivate * priv;
	gdouble _frames_per_second;
	RetroVariables* variables_interface;
	void* environment_internal;
};

struct _RetroCoreClass {
	GObjectClass parent_class;
};

typedef enum  {
	RETRO_DEVICE_TYPE_TYPE_MASK = 0xff,
	RETRO_DEVICE_TYPE_NONE = 0,
	RETRO_DEVICE_TYPE_JOYPAD = 1,
	RETRO_DEVICE_TYPE_MOUSE = 2,
	RETRO_DEVICE_TYPE_KEYBOARD = 3,
	RETRO_DEVICE_TYPE_LIGHTGUN = 4,
	RETRO_DEVICE_TYPE_ANALOG = 5,
	RETRO_DEVICE_TYPE_POINTER = 6
} RetroDeviceType;

struct _RetroInputDescriptor {
	guint port;
	RetroDeviceType device;
	guint index;
	guint id;
	gchar* description;
};

struct _RetroInputDeviceIface {
	GTypeInterface parent_iface;
	void (*poll) (RetroInputDevice* self);
	gint16 (*get_input_state) (RetroInputDevice* self, RetroDeviceType device, guint index, guint id);
	RetroDeviceType (*get_device_type) (RetroInputDevice* self);
	guint64 (*get_device_capabilities) (RetroInputDevice* self);
};

typedef void (*RetroInputControllerCallback) (guint port, RetroInputDevice* device, void* user_data);
struct _RetroInputIface {
	GTypeInterface parent_iface;
	void (*poll) (RetroInput* self);
	gint16 (*get_state) (RetroInput* self, guint port, RetroDeviceType device, guint index, guint id);
	void (*set_descriptors) (RetroInput* self, RetroInputDescriptor* input_descriptors, int input_descriptors_length1);
	guint64 (*get_device_capabilities) (RetroInput* self);
	void (*foreach_controller) (RetroInput* self, RetroInputControllerCallback callback, void* callback_target);
};

typedef enum  {
	RETRO_RUMBLE_EFFECT_STRONG,
	RETRO_RUMBLE_EFFECT_WEAK
} RetroRumbleEffect;

struct _RetroRumbleIface {
	GTypeInterface parent_iface;
	gboolean (*set_rumble_state) (RetroRumble* self, guint port, RetroRumbleEffect effect, guint16 strength);
};

struct _RetroCorePrivate {
	gchar* _file_name;
	gchar* _system_directory;
	gchar* _libretro_path;
	gchar* _content_directory;
	gchar* _save_directory;
	gboolean _is_initiated;
	gboolean _game_loaded;
	gboolean _support_no_game;
	RetroInput* _input_interface;
	gulong input_controller_connected_id;
	gulong input_controller_disconnected_id;
	gulong input_key_event_id;
	RetroRumble* _rumble_interface;
};

typedef enum  {
	RETRO_MEMORY_TYPE_SAVE_RAM = 0,
	RETRO_MEMORY_TYPE_RTC = 1,
	RETRO_MEMORY_TYPE_SYSTEM_RAM = 2,
	RETRO_MEMORY_TYPE_VIDEO_RAM = 3
} RetroMemoryType;

typedef enum  {
	RETRO_PIXEL_FORMAT_XRGB1555,
	RETRO_PIXEL_FORMAT_XRGB8888,
	RETRO_PIXEL_FORMAT_RGB565,
	RETRO_PIXEL_FORMAT_UNKNOWN = -1
} RetroPixelFormat;


static gpointer retro_core_parent_class = NULL;

GType retro_core_get_type (void) G_GNUC_CONST;
GType retro_variable_get_type (void) G_GNUC_CONST;
RetroVariable* retro_variable_dup (const RetroVariable* self);
void retro_variable_free (RetroVariable* self);
void retro_variable_copy (const RetroVariable* self, RetroVariable* dest);
void retro_variable_destroy (RetroVariable* self);
GType retro_variables_get_type (void) G_GNUC_CONST;
GType retro_device_type_get_type (void) G_GNUC_CONST;
GType retro_input_descriptor_get_type (void) G_GNUC_CONST;
RetroInputDescriptor* retro_input_descriptor_dup (const RetroInputDescriptor* self);
void retro_input_descriptor_free (RetroInputDescriptor* self);
void retro_input_descriptor_copy (const RetroInputDescriptor* self, RetroInputDescriptor* dest);
void retro_input_descriptor_destroy (RetroInputDescriptor* self);
GType retro_input_device_get_type (void) G_GNUC_CONST;
GType retro_input_get_type (void) G_GNUC_CONST;
GType retro_rumble_effect_get_type (void) G_GNUC_CONST;
GType retro_rumble_get_type (void) G_GNUC_CONST;
#define RETRO_CORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RETRO_TYPE_CORE, RetroCorePrivate))
void retro_core_destructor (RetroCore* self);
void retro_core_push_cb_data (RetroCore* self);
void retro_core_pop_cb_data (void);
RetroCore* retro_core_get_cb_data (void);
guint retro_core_get_api_version_real (RetroCore* self);
RetroCore* retro_core_new (const gchar* file_name);
RetroCore* retro_core_construct (GType object_type, const gchar* file_name);
void retro_core_constructor (RetroCore* self, const gchar* file_name);
void retro_core_init (RetroCore* self, GError** error);
void retro_core_set_medias (RetroCore* self, gchar** uris);
void retro_core_set_current_media (RetroCore* self, guint media_index, GError** error);
void retro_core_set_controller_port_device (RetroCore* self, guint port, RetroDeviceType device);
void retro_core_reset (RetroCore* self);
void retro_core_run (RetroCore* self);
gboolean retro_core_supports_serialization (RetroCore* self);
guint8* retro_core_serialize_state (RetroCore* self, gsize* result_length1, GError** error);
void retro_core_deserialize_state (RetroCore* self, guint8* data, gsize data_length1, GError** error);
GType retro_memory_type_get_type (void) G_GNUC_CONST;
gsize retro_core_get_memory_size (RetroCore* self, RetroMemoryType id);
guint8* retro_core_get_memory (RetroCore* self, RetroMemoryType id, int* result_length1);
void retro_core_set_memory (RetroCore* self, RetroMemoryType id, guint8* data, int data_length1);
void retro_core_init_input (RetroCore* self);
void retro_core_on_input_controller_connected (RetroCore* self, guint port, RetroInputDevice* device);
void retro_core_on_input_controller_disconnected (RetroCore* self, guint port);
gboolean retro_core_on_key_event (RetroCore* self, GdkEventKey* event);
guint retro_core_get_api_version (RetroCore* self);
const gchar* retro_core_get_file_name (RetroCore* self);
void retro_core_set_file_name (RetroCore* self, const gchar* value);
const gchar* retro_core_get_system_directory (RetroCore* self);
void retro_core_set_system_directory (RetroCore* self, const gchar* value);
const gchar* retro_core_get_libretro_path (RetroCore* self);
void retro_core_set_libretro_path (RetroCore* self, const gchar* value);
const gchar* retro_core_get_content_directory (RetroCore* self);
void retro_core_set_content_directory (RetroCore* self, const gchar* value);
const gchar* retro_core_get_save_directory (RetroCore* self);
void retro_core_set_save_directory (RetroCore* self, const gchar* value);
gboolean retro_core_get_is_initiated (RetroCore* self);
void retro_core_set_is_initiated (RetroCore* self, gboolean value);
gboolean retro_core_get_game_loaded (RetroCore* self);
void retro_core_set_game_loaded (RetroCore* self, gboolean value);
gboolean retro_core_get_support_no_game (RetroCore* self);
void retro_core_set_support_no_game (RetroCore* self, gboolean value);
gdouble retro_core_get_frames_per_second (RetroCore* self);
RetroInput* retro_core_get_input_interface (RetroCore* self);
void retro_core_set_input_interface (RetroCore* self, RetroInput* value);
static void _retro_core_on_input_controller_connected_retro_input_controller_connected (RetroInput* _sender, guint port, RetroInputDevice* device, gpointer self);
static void _retro_core_on_input_controller_disconnected_retro_input_controller_disconnected (RetroInput* _sender, guint port, gpointer self);
static gboolean _retro_core_on_key_event_retro_input_key_event (RetroInput* _sender, GdkEventKey* event, gpointer self);
RetroRumble* retro_core_get_rumble_interface (RetroCore* self);
void retro_core_set_rumble_interface (RetroCore* self, RetroRumble* value);
GType retro_pixel_format_get_type (void) G_GNUC_CONST;
static void g_cclosure_user_marshal_VOID__POINTER_INT_UINT_UINT_ULONG_ENUM_FLOAT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__POINTER_INT_DOUBLE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__STRING_UINT_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_BOOLEAN__VOID (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_BOOLEAN__STRING_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void retro_core_finalize (GObject * obj);
static void _vala_retro_core_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_retro_core_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
 * Stores the current Core instance in a stack.
 *
 * Stores the current instance of Core in a thread local global stack.
 * It allows to know wich Core a callback is related to.
 *
 * Must be called before any call to a function from the module.
 */
/**
 * Removes the Core at the head of the stack.
 *
 * Must be called after any call to {@link push_cb_data()}.
 */
/**
 * Creates a Core from the file name of a Libretro implementation.
 *
 * The file must be a dynamically loadable shared object implementing the
 * same version of the Libretro API as Retro.
 *
 * @param file_name the file name of the Libretro implementation to load
 */
RetroCore* retro_core_construct (GType object_type, const gchar* file_name) {
	RetroCore * self = NULL;
	const gchar* _tmp0_;
	g_return_val_if_fail (file_name != NULL, NULL);
	self = (RetroCore*) g_object_new (object_type, NULL);
	_tmp0_ = file_name;
	retro_core_constructor (self, _tmp0_);
	return self;
}


RetroCore* retro_core_new (const gchar* file_name) {
	return retro_core_construct (RETRO_TYPE_CORE, file_name);
}


/**
 * Initializes the module.
 *
 * Must be called before loading a game and running the core.
 */
/**
 * Resets the current game.
 */
/**
 * Runs the game for one video frame.
 *
 * The callbacks must be set and the core must be initialized before
 * running the core.
 *
 * During {@link run}, the input_poll callback will be called
 * at least once.
 *
 * If a frame is not rendered for reasons where a game "dropped" a frame,
 * this still counts as a frame, and {@link run} will explicitly dupe a
 * frame if the can_dupe property of {@link video_interface} is set to true.
 * In this case, the video callback can take a null argument for data.
 */
/**
 * Gets the size of a region of memory.
 *
 * @param id the region of memory
 * @return the size of the region of memory
 */
/**
 * Gets a region of memory.
 *
 * @param id the region of memory
 * @return the region of memory
 */
/**
 * Sets a region of memory.
 *
 * @param id the region of memory
 * @param data the data to write in the memory region
 */
guint retro_core_get_api_version (RetroCore* self) {
	guint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = retro_core_get_api_version_real (self);
	result = _tmp0_;
	return result;
}


const gchar* retro_core_get_file_name (RetroCore* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_file_name;
	result = _tmp0_;
	return result;
}


void retro_core_set_file_name (RetroCore* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, retro_core_get_file_name (self)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_file_name);
		self->priv->_file_name = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, retro_core_properties[RETRO_CORE_FILE_NAME]);
	}
}


const gchar* retro_core_get_system_directory (RetroCore* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_system_directory;
	result = _tmp0_;
	return result;
}


void retro_core_set_system_directory (RetroCore* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, retro_core_get_system_directory (self)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_system_directory);
		self->priv->_system_directory = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, retro_core_properties[RETRO_CORE_SYSTEM_DIRECTORY]);
	}
}


const gchar* retro_core_get_libretro_path (RetroCore* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_libretro_path;
	result = _tmp0_;
	return result;
}


void retro_core_set_libretro_path (RetroCore* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, retro_core_get_libretro_path (self)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_libretro_path);
		self->priv->_libretro_path = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, retro_core_properties[RETRO_CORE_LIBRETRO_PATH]);
	}
}


const gchar* retro_core_get_content_directory (RetroCore* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_content_directory;
	result = _tmp0_;
	return result;
}


void retro_core_set_content_directory (RetroCore* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, retro_core_get_content_directory (self)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_content_directory);
		self->priv->_content_directory = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, retro_core_properties[RETRO_CORE_CONTENT_DIRECTORY]);
	}
}


const gchar* retro_core_get_save_directory (RetroCore* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_save_directory;
	result = _tmp0_;
	return result;
}


void retro_core_set_save_directory (RetroCore* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, retro_core_get_save_directory (self)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_save_directory);
		self->priv->_save_directory = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, retro_core_properties[RETRO_CORE_SAVE_DIRECTORY]);
	}
}


gboolean retro_core_get_is_initiated (RetroCore* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_initiated;
	result = _tmp0_;
	return result;
}


void retro_core_set_is_initiated (RetroCore* self, gboolean value) {
	g_return_if_fail (self != NULL);
	if (retro_core_get_is_initiated (self) != value) {
		gboolean _tmp0_;
		_tmp0_ = value;
		self->priv->_is_initiated = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, retro_core_properties[RETRO_CORE_IS_INITIATED]);
	}
}


gboolean retro_core_get_game_loaded (RetroCore* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_game_loaded;
	result = _tmp0_;
	return result;
}


void retro_core_set_game_loaded (RetroCore* self, gboolean value) {
	g_return_if_fail (self != NULL);
	if (retro_core_get_game_loaded (self) != value) {
		gboolean _tmp0_;
		_tmp0_ = value;
		self->priv->_game_loaded = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, retro_core_properties[RETRO_CORE_GAME_LOADED]);
	}
}


gboolean retro_core_get_support_no_game (RetroCore* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_support_no_game;
	result = _tmp0_;
	return result;
}


void retro_core_set_support_no_game (RetroCore* self, gboolean value) {
	g_return_if_fail (self != NULL);
	if (retro_core_get_support_no_game (self) != value) {
		gboolean _tmp0_;
		_tmp0_ = value;
		self->priv->_support_no_game = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, retro_core_properties[RETRO_CORE_SUPPORT_NO_GAME]);
	}
}


gdouble retro_core_get_frames_per_second (RetroCore* self) {
	gdouble result;
	gdouble _tmp0_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->_frames_per_second;
	result = _tmp0_;
	return result;
}


RetroInput* retro_core_get_input_interface (RetroCore* self) {
	RetroInput* result;
	RetroInput* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_input_interface;
	result = _tmp0_;
	return result;
}


static void _retro_core_on_input_controller_connected_retro_input_controller_connected (RetroInput* _sender, guint port, RetroInputDevice* device, gpointer self) {
	retro_core_on_input_controller_connected ((RetroCore*) self, port, device);
}


static void _retro_core_on_input_controller_disconnected_retro_input_controller_disconnected (RetroInput* _sender, guint port, gpointer self) {
	retro_core_on_input_controller_disconnected ((RetroCore*) self, port);
}


static gboolean _retro_core_on_key_event_retro_input_key_event (RetroInput* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = retro_core_on_key_event ((RetroCore*) self, event);
	return result;
}


void retro_core_set_input_interface (RetroCore* self, RetroInput* value) {
	RetroInput* _tmp0_;
	RetroInput* _tmp1_;
	RetroInput* _tmp2_;
	RetroInput* _tmp3_;
	RetroInput* _tmp4_;
	RetroInput* _tmp14_;
	RetroInput* _tmp15_;
	RetroInput* _tmp16_;
	RetroInput* _tmp17_;
	RetroInput* _tmp18_;
	RetroInput* _tmp19_;
	RetroInput* _tmp20_;
	RetroInput* _tmp21_;
	RetroInput* _tmp22_;
	gboolean _tmp23_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = retro_core_get_input_interface (self);
	_tmp2_ = _tmp1_;
	if (_tmp0_ == _tmp2_) {
		return;
	}
	_tmp3_ = retro_core_get_input_interface (self);
	_tmp4_ = _tmp3_;
	if (_tmp4_ != NULL) {
		RetroInput* _tmp5_;
		RetroInput* _tmp6_;
		gulong _tmp7_;
		RetroInput* _tmp8_;
		RetroInput* _tmp9_;
		gulong _tmp10_;
		RetroInput* _tmp11_;
		RetroInput* _tmp12_;
		gulong _tmp13_;
		_tmp5_ = retro_core_get_input_interface (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = self->priv->input_controller_connected_id;
		g_signal_handler_disconnect ((GObject*) _tmp6_, _tmp7_);
		_tmp8_ = retro_core_get_input_interface (self);
		_tmp9_ = _tmp8_;
		_tmp10_ = self->priv->input_controller_disconnected_id;
		g_signal_handler_disconnect ((GObject*) _tmp9_, _tmp10_);
		_tmp11_ = retro_core_get_input_interface (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = self->priv->input_key_event_id;
		g_signal_handler_disconnect ((GObject*) _tmp12_, _tmp13_);
	}
	_tmp14_ = value;
	self->priv->_input_interface = _tmp14_;
	_tmp15_ = retro_core_get_input_interface (self);
	_tmp16_ = _tmp15_;
	if (_tmp16_ == NULL) {
		return;
	}
	_tmp17_ = retro_core_get_input_interface (self);
	_tmp18_ = _tmp17_;
	g_signal_connect_object (_tmp18_, "controller-connected", (GCallback) _retro_core_on_input_controller_connected_retro_input_controller_connected, self, 0);
	_tmp19_ = retro_core_get_input_interface (self);
	_tmp20_ = _tmp19_;
	g_signal_connect_object (_tmp20_, "controller-disconnected", (GCallback) _retro_core_on_input_controller_disconnected_retro_input_controller_disconnected, self, 0);
	_tmp21_ = retro_core_get_input_interface (self);
	_tmp22_ = _tmp21_;
	g_signal_connect_object (_tmp22_, "key-event", (GCallback) _retro_core_on_key_event_retro_input_key_event, self, 0);
	_tmp23_ = self->priv->_is_initiated;
	if (_tmp23_) {
		retro_core_init_input (self);
	}
	g_object_notify_by_pspec ((GObject *) self, retro_core_properties[RETRO_CORE_INPUT_INTERFACE]);
}


RetroRumble* retro_core_get_rumble_interface (RetroCore* self) {
	RetroRumble* result;
	RetroRumble* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_rumble_interface;
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void retro_core_set_rumble_interface (RetroCore* self, RetroRumble* value) {
	g_return_if_fail (self != NULL);
	if (retro_core_get_rumble_interface (self) != value) {
		RetroRumble* _tmp0_;
		RetroRumble* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_g_object_unref0 (self->priv->_rumble_interface);
		self->priv->_rumble_interface = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, retro_core_properties[RETRO_CORE_RUMBLE_INTERFACE]);
	}
}


static void g_cclosure_user_marshal_VOID__POINTER_INT_UINT_UINT_ULONG_ENUM_FLOAT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__POINTER_INT_UINT_UINT_ULONG_ENUM_FLOAT) (gpointer data1, gpointer arg_1, gint arg_2, guint arg_3, guint arg_4, gsize arg_5, gint arg_6, gfloat arg_7, gpointer data2);
	register GMarshalFunc_VOID__POINTER_INT_UINT_UINT_ULONG_ENUM_FLOAT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 8);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__POINTER_INT_UINT_UINT_ULONG_ENUM_FLOAT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_pointer (param_values + 1), g_value_get_int (param_values + 2), g_value_get_uint (param_values + 3), g_value_get_uint (param_values + 4), g_value_get_ulong (param_values + 5), g_value_get_enum (param_values + 6), g_value_get_float (param_values + 7), data2);
}


static void g_cclosure_user_marshal_VOID__POINTER_INT_DOUBLE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__POINTER_INT_DOUBLE) (gpointer data1, gpointer arg_1, gint arg_2, gdouble arg_3, gpointer data2);
	register GMarshalFunc_VOID__POINTER_INT_DOUBLE callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__POINTER_INT_DOUBLE) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_pointer (param_values + 1), g_value_get_int (param_values + 2), g_value_get_double (param_values + 3), data2);
}


static void g_cclosure_user_marshal_VOID__STRING_UINT_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_UINT_STRING) (gpointer data1, const char* arg_1, gint arg_2, const char* arg_3, gpointer data2);
	register GMarshalFunc_VOID__STRING_UINT_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_UINT_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_uint (param_values + 2), g_value_get_string (param_values + 3), data2);
}


static void g_cclosure_user_marshal_BOOLEAN__VOID (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__VOID) (gpointer data1, gpointer data2);
	register GMarshalFunc_BOOLEAN__VOID callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 1);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_BOOLEAN__VOID) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, data2);
	g_value_set_boolean (return_value, v_return);
}


static void g_cclosure_user_marshal_BOOLEAN__STRING_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__STRING_UINT) (gpointer data1, const char* arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_BOOLEAN__STRING_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_BOOLEAN__STRING_UINT) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, g_value_get_string (param_values + 1), g_value_get_uint (param_values + 2), data2);
	g_value_set_boolean (return_value, v_return);
}


static void retro_core_class_init (RetroCoreClass * klass) {
	retro_core_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RetroCorePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_retro_core_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_retro_core_set_property;
	G_OBJECT_CLASS (klass)->finalize = retro_core_finalize;
	/**
	 * The version of Libretro used by the module.
	 *
	 * Can be compared with {@link API_VERSION} to validate ABI
	 * compatibility.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_CORE_API_VERSION, retro_core_properties[RETRO_CORE_API_VERSION] = g_param_spec_uint ("api-version", "api-version", "api-version", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * The file name of the module.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_CORE_FILE_NAME, retro_core_properties[RETRO_CORE_FILE_NAME] = g_param_spec_string ("file-name", "file-name", "file-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The directory the core will use to look for for additional data.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_CORE_SYSTEM_DIRECTORY, retro_core_properties[RETRO_CORE_SYSTEM_DIRECTORY] = g_param_spec_string ("system-directory", "system-directory", "system-directory", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The absolute path to the source module file.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_CORE_LIBRETRO_PATH, retro_core_properties[RETRO_CORE_LIBRETRO_PATH] = g_param_spec_string ("libretro-path", "libretro-path", "libretro-path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The directory the core will use to look for for additional assets.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_CORE_CONTENT_DIRECTORY, retro_core_properties[RETRO_CORE_CONTENT_DIRECTORY] = g_param_spec_string ("content-directory", "content-directory", "content-directory", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The directory the core will use to save user data.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_CORE_SAVE_DIRECTORY, retro_core_properties[RETRO_CORE_SAVE_DIRECTORY] = g_param_spec_string ("save-directory", "save-directory", "save-directory", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * Whether or not the a game is loaded.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_CORE_IS_INITIATED, retro_core_properties[RETRO_CORE_IS_INITIATED] = g_param_spec_boolean ("is-initiated", "is-initiated", "is-initiated", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * Whether or not the a game is loaded.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_CORE_GAME_LOADED, retro_core_properties[RETRO_CORE_GAME_LOADED] = g_param_spec_boolean ("game-loaded", "game-loaded", "game-loaded", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * Whether or not the core supports games.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_CORE_SUPPORT_NO_GAME, retro_core_properties[RETRO_CORE_SUPPORT_NO_GAME] = g_param_spec_boolean ("support-no-game", "support-no-game", "support-no-game", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_CORE_FRAMES_PER_SECOND, retro_core_properties[RETRO_CORE_FRAMES_PER_SECOND] = g_param_spec_double ("frames-per-second", "frames-per-second", "frames-per-second", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * The input interface.
	 *
	 * It must be set before {@link init} is called.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_CORE_INPUT_INTERFACE, retro_core_properties[RETRO_CORE_INPUT_INTERFACE] = g_param_spec_object ("input-interface", "input-interface", "input-interface", RETRO_TYPE_INPUT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	 * The rumble interface.
	 *
	 * Optional.
	 * If set, it must be set before {@link init} is called.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_CORE_RUMBLE_INTERFACE, retro_core_properties[RETRO_CORE_RUMBLE_INTERFACE] = g_param_spec_object ("rumble-interface", "rumble-interface", "rumble-interface", RETRO_TYPE_RUMBLE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	retro_core_signals[RETRO_CORE_VIDEO_OUTPUT_SIGNAL] = g_signal_new ("video_output", RETRO_TYPE_CORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__POINTER_INT_UINT_UINT_ULONG_ENUM_FLOAT, G_TYPE_NONE, 7, G_TYPE_POINTER, G_TYPE_INT, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_ULONG, RETRO_TYPE_PIXEL_FORMAT, G_TYPE_FLOAT);
	retro_core_signals[RETRO_CORE_AUDIO_OUTPUT_SIGNAL] = g_signal_new ("audio_output", RETRO_TYPE_CORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__POINTER_INT_DOUBLE, G_TYPE_NONE, 3, G_TYPE_POINTER, G_TYPE_INT, G_TYPE_DOUBLE);
	retro_core_signals[RETRO_CORE_LOG_SIGNAL] = g_signal_new ("log", RETRO_TYPE_CORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_UINT_STRING, G_TYPE_NONE, 3, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_STRING);
	/**
	 * Asks the frontend to shut down.
	 */
	retro_core_signals[RETRO_CORE_SHUTDOWN_SIGNAL] = g_signal_new ("shutdown", RETRO_TYPE_CORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__VOID, G_TYPE_BOOLEAN, 0);
	/**
	 * Asks the frontend to display a message for an amount of frames.
	 */
	retro_core_signals[RETRO_CORE_MESSAGE_SIGNAL] = g_signal_new ("message", RETRO_TYPE_CORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__STRING_UINT, G_TYPE_BOOLEAN, 2, G_TYPE_STRING, G_TYPE_UINT);
}


static void retro_core_instance_init (RetroCore * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	self->priv = RETRO_CORE_GET_PRIVATE (self);
	_tmp0_ = g_strdup (".");
	self->priv->_system_directory = _tmp0_;
	_tmp1_ = g_strdup (".");
	self->priv->_libretro_path = _tmp1_;
	_tmp2_ = g_strdup (".");
	self->priv->_content_directory = _tmp2_;
	_tmp3_ = g_strdup (".");
	self->priv->_save_directory = _tmp3_;
	self->priv->_is_initiated = FALSE;
	self->priv->_game_loaded = FALSE;
	self->priv->_support_no_game = FALSE;
}


static void retro_core_finalize (GObject * obj) {
	RetroCore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RETRO_TYPE_CORE, RetroCore);
	retro_core_destructor (self);
	_g_free0 (self->priv->_file_name);
	_g_free0 (self->priv->_system_directory);
	_g_free0 (self->priv->_libretro_path);
	_g_free0 (self->priv->_content_directory);
	_g_free0 (self->priv->_save_directory);
	_g_object_unref0 (self->priv->_rumble_interface);
	_g_object_unref0 (self->variables_interface);
	G_OBJECT_CLASS (retro_core_parent_class)->finalize (obj);
}


/**
 * Handles a Libretro module.
 */
GType retro_core_get_type (void) {
	static volatile gsize retro_core_type_id__volatile = 0;
	if (g_once_init_enter (&retro_core_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RetroCoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) retro_core_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RetroCore), 0, (GInstanceInitFunc) retro_core_instance_init, NULL };
		GType retro_core_type_id;
		retro_core_type_id = g_type_register_static (G_TYPE_OBJECT, "RetroCore", &g_define_type_info, 0);
		g_once_init_leave (&retro_core_type_id__volatile, retro_core_type_id);
	}
	return retro_core_type_id__volatile;
}


static void _vala_retro_core_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RetroCore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RETRO_TYPE_CORE, RetroCore);
	switch (property_id) {
		case RETRO_CORE_API_VERSION:
		g_value_set_uint (value, retro_core_get_api_version (self));
		break;
		case RETRO_CORE_FILE_NAME:
		g_value_set_string (value, retro_core_get_file_name (self));
		break;
		case RETRO_CORE_SYSTEM_DIRECTORY:
		g_value_set_string (value, retro_core_get_system_directory (self));
		break;
		case RETRO_CORE_LIBRETRO_PATH:
		g_value_set_string (value, retro_core_get_libretro_path (self));
		break;
		case RETRO_CORE_CONTENT_DIRECTORY:
		g_value_set_string (value, retro_core_get_content_directory (self));
		break;
		case RETRO_CORE_SAVE_DIRECTORY:
		g_value_set_string (value, retro_core_get_save_directory (self));
		break;
		case RETRO_CORE_IS_INITIATED:
		g_value_set_boolean (value, retro_core_get_is_initiated (self));
		break;
		case RETRO_CORE_GAME_LOADED:
		g_value_set_boolean (value, retro_core_get_game_loaded (self));
		break;
		case RETRO_CORE_SUPPORT_NO_GAME:
		g_value_set_boolean (value, retro_core_get_support_no_game (self));
		break;
		case RETRO_CORE_FRAMES_PER_SECOND:
		g_value_set_double (value, retro_core_get_frames_per_second (self));
		break;
		case RETRO_CORE_INPUT_INTERFACE:
		g_value_set_object (value, retro_core_get_input_interface (self));
		break;
		case RETRO_CORE_RUMBLE_INTERFACE:
		g_value_set_object (value, retro_core_get_rumble_interface (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_retro_core_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RetroCore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RETRO_TYPE_CORE, RetroCore);
	switch (property_id) {
		case RETRO_CORE_FILE_NAME:
		retro_core_set_file_name (self, g_value_get_string (value));
		break;
		case RETRO_CORE_SYSTEM_DIRECTORY:
		retro_core_set_system_directory (self, g_value_get_string (value));
		break;
		case RETRO_CORE_LIBRETRO_PATH:
		retro_core_set_libretro_path (self, g_value_get_string (value));
		break;
		case RETRO_CORE_CONTENT_DIRECTORY:
		retro_core_set_content_directory (self, g_value_get_string (value));
		break;
		case RETRO_CORE_SAVE_DIRECTORY:
		retro_core_set_save_directory (self, g_value_get_string (value));
		break;
		case RETRO_CORE_IS_INITIATED:
		retro_core_set_is_initiated (self, g_value_get_boolean (value));
		break;
		case RETRO_CORE_GAME_LOADED:
		retro_core_set_game_loaded (self, g_value_get_boolean (value));
		break;
		case RETRO_CORE_SUPPORT_NO_GAME:
		retro_core_set_support_no_game (self, g_value_get_boolean (value));
		break;
		case RETRO_CORE_INPUT_INTERFACE:
		retro_core_set_input_interface (self, g_value_get_object (value));
		break;
		case RETRO_CORE_RUMBLE_INTERFACE:
		retro_core_set_rumble_interface (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



