/* retro-gtk.h generated by valac 0.36.4, the Vala compiler, do not modify */


#ifndef __RETRO_GTK_H__
#define __RETRO_GTK_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

G_BEGIN_DECLS


#define RETRO_TYPE_PA_PLAYER (retro_pa_player_get_type ())
#define RETRO_PA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_PA_PLAYER, RetroPaPlayer))
#define RETRO_PA_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RETRO_TYPE_PA_PLAYER, RetroPaPlayerClass))
#define RETRO_IS_PA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_PA_PLAYER))
#define RETRO_IS_PA_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RETRO_TYPE_PA_PLAYER))
#define RETRO_PA_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RETRO_TYPE_PA_PLAYER, RetroPaPlayerClass))

typedef struct _RetroPaPlayer RetroPaPlayer;
typedef struct _RetroPaPlayerClass RetroPaPlayerClass;
typedef struct _RetroPaPlayerPrivate RetroPaPlayerPrivate;

#define RETRO_TYPE_CORE (retro_core_get_type ())
#define RETRO_CORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_CORE, RetroCore))
#define RETRO_CORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RETRO_TYPE_CORE, RetroCoreClass))
#define RETRO_IS_CORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_CORE))
#define RETRO_IS_CORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RETRO_TYPE_CORE))
#define RETRO_CORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RETRO_TYPE_CORE, RetroCoreClass))

typedef struct _RetroCore RetroCore;
typedef struct _RetroCoreClass RetroCoreClass;

#define RETRO_TYPE_DEVICE_TYPE (retro_device_type_get_type ())

#define RETRO_TYPE_JOYPAD_ID (retro_joypad_id_get_type ())

#define RETRO_TYPE_ANALOG_INDEX (retro_analog_index_get_type ())

#define RETRO_TYPE_ANALOG_ID (retro_analog_id_get_type ())

#define RETRO_TYPE_MOUSE_ID (retro_mouse_id_get_type ())

#define RETRO_TYPE_LIGHTGUN_ID (retro_lightgun_id_get_type ())

#define RETRO_TYPE_POINTER_ID (retro_pointer_id_get_type ())

#define RETRO_TYPE_INPUT_DESCRIPTOR (retro_input_descriptor_get_type ())
typedef struct _RetroInputDescriptor RetroInputDescriptor;

#define RETRO_TYPE_GAMEPAD_BUTTON_TYPE (retro_gamepad_button_type_get_type ())

#define RETRO_TYPE_GAMEPAD_CONFIGURATION (retro_gamepad_configuration_get_type ())
#define RETRO_GAMEPAD_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_GAMEPAD_CONFIGURATION, RetroGamepadConfiguration))
#define RETRO_GAMEPAD_CONFIGURATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RETRO_TYPE_GAMEPAD_CONFIGURATION, RetroGamepadConfigurationClass))
#define RETRO_IS_GAMEPAD_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_GAMEPAD_CONFIGURATION))
#define RETRO_IS_GAMEPAD_CONFIGURATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RETRO_TYPE_GAMEPAD_CONFIGURATION))
#define RETRO_GAMEPAD_CONFIGURATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RETRO_TYPE_GAMEPAD_CONFIGURATION, RetroGamepadConfigurationClass))

typedef struct _RetroGamepadConfiguration RetroGamepadConfiguration;
typedef struct _RetroGamepadConfigurationClass RetroGamepadConfigurationClass;
typedef struct _RetroGamepadConfigurationPrivate RetroGamepadConfigurationPrivate;

#define RETRO_TYPE_INPUT (retro_input_get_type ())
#define RETRO_INPUT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_INPUT, RetroInput))
#define RETRO_IS_INPUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_INPUT))
#define RETRO_INPUT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RETRO_TYPE_INPUT, RetroInputIface))

typedef struct _RetroInput RetroInput;
typedef struct _RetroInputIface RetroInputIface;

#define RETRO_TYPE_INPUT_DEVICE (retro_input_device_get_type ())
#define RETRO_INPUT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_INPUT_DEVICE, RetroInputDevice))
#define RETRO_IS_INPUT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_INPUT_DEVICE))
#define RETRO_INPUT_DEVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RETRO_TYPE_INPUT_DEVICE, RetroInputDeviceIface))

typedef struct _RetroInputDevice RetroInputDevice;
typedef struct _RetroInputDeviceIface RetroInputDeviceIface;

#define RETRO_TYPE_INPUT_DEVICE_MANAGER (retro_input_device_manager_get_type ())
#define RETRO_INPUT_DEVICE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_INPUT_DEVICE_MANAGER, RetroInputDeviceManager))
#define RETRO_INPUT_DEVICE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RETRO_TYPE_INPUT_DEVICE_MANAGER, RetroInputDeviceManagerClass))
#define RETRO_IS_INPUT_DEVICE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_INPUT_DEVICE_MANAGER))
#define RETRO_IS_INPUT_DEVICE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RETRO_TYPE_INPUT_DEVICE_MANAGER))
#define RETRO_INPUT_DEVICE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RETRO_TYPE_INPUT_DEVICE_MANAGER, RetroInputDeviceManagerClass))

typedef struct _RetroInputDeviceManager RetroInputDeviceManager;
typedef struct _RetroInputDeviceManagerClass RetroInputDeviceManagerClass;
typedef struct _RetroInputDeviceManagerPrivate RetroInputDeviceManagerPrivate;

#define RETRO_TYPE_KEYBOARD (retro_keyboard_get_type ())
#define RETRO_KEYBOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_KEYBOARD, RetroKeyboard))
#define RETRO_KEYBOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RETRO_TYPE_KEYBOARD, RetroKeyboardClass))
#define RETRO_IS_KEYBOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_KEYBOARD))
#define RETRO_IS_KEYBOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RETRO_TYPE_KEYBOARD))
#define RETRO_KEYBOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RETRO_TYPE_KEYBOARD, RetroKeyboardClass))

typedef struct _RetroKeyboard RetroKeyboard;
typedef struct _RetroKeyboardClass RetroKeyboardClass;

#define RETRO_TYPE_KEYBOARD_KEY (retro_keyboard_key_get_type ())

#define RETRO_TYPE_KEYBOARD_MODIFIER_KEY (retro_keyboard_modifier_key_get_type ())
typedef struct _RetroKeyboardPrivate RetroKeyboardPrivate;

#define RETRO_TYPE_KEYBOARD_STATE (retro_keyboard_state_get_type ())
#define RETRO_KEYBOARD_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_KEYBOARD_STATE, RetroKeyboardState))
#define RETRO_KEYBOARD_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RETRO_TYPE_KEYBOARD_STATE, RetroKeyboardStateClass))
#define RETRO_IS_KEYBOARD_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_KEYBOARD_STATE))
#define RETRO_IS_KEYBOARD_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RETRO_TYPE_KEYBOARD_STATE))
#define RETRO_KEYBOARD_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RETRO_TYPE_KEYBOARD_STATE, RetroKeyboardStateClass))

typedef struct _RetroKeyboardState RetroKeyboardState;
typedef struct _RetroKeyboardStateClass RetroKeyboardStateClass;
typedef struct _RetroKeyboardStatePrivate RetroKeyboardStatePrivate;

#define RETRO_TYPE_MOUSE (retro_mouse_get_type ())
#define RETRO_MOUSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_MOUSE, RetroMouse))
#define RETRO_MOUSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RETRO_TYPE_MOUSE, RetroMouseClass))
#define RETRO_IS_MOUSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_MOUSE))
#define RETRO_IS_MOUSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RETRO_TYPE_MOUSE))
#define RETRO_MOUSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RETRO_TYPE_MOUSE, RetroMouseClass))

typedef struct _RetroMouse RetroMouse;
typedef struct _RetroMouseClass RetroMouseClass;
typedef struct _RetroMousePrivate RetroMousePrivate;

#define RETRO_TYPE_VIRTUAL_GAMEPAD (retro_virtual_gamepad_get_type ())
#define RETRO_VIRTUAL_GAMEPAD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_VIRTUAL_GAMEPAD, RetroVirtualGamepad))
#define RETRO_VIRTUAL_GAMEPAD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RETRO_TYPE_VIRTUAL_GAMEPAD, RetroVirtualGamepadClass))
#define RETRO_IS_VIRTUAL_GAMEPAD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_VIRTUAL_GAMEPAD))
#define RETRO_IS_VIRTUAL_GAMEPAD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RETRO_TYPE_VIRTUAL_GAMEPAD))
#define RETRO_VIRTUAL_GAMEPAD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RETRO_TYPE_VIRTUAL_GAMEPAD, RetroVirtualGamepadClass))

typedef struct _RetroVirtualGamepad RetroVirtualGamepad;
typedef struct _RetroVirtualGamepadClass RetroVirtualGamepadClass;
typedef struct _RetroVirtualGamepadPrivate RetroVirtualGamepadPrivate;

#define RETRO_TYPE_MAIN_LOOP (retro_main_loop_get_type ())
#define RETRO_MAIN_LOOP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_MAIN_LOOP, RetroMainLoop))
#define RETRO_MAIN_LOOP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RETRO_TYPE_MAIN_LOOP, RetroMainLoopClass))
#define RETRO_IS_MAIN_LOOP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_MAIN_LOOP))
#define RETRO_IS_MAIN_LOOP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RETRO_TYPE_MAIN_LOOP))
#define RETRO_MAIN_LOOP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RETRO_TYPE_MAIN_LOOP, RetroMainLoopClass))

typedef struct _RetroMainLoop RetroMainLoop;
typedef struct _RetroMainLoopClass RetroMainLoopClass;
typedef struct _RetroMainLoopPrivate RetroMainLoopPrivate;
typedef struct _RetroCorePrivate RetroCorePrivate;

#define RETRO_TYPE_MODULE (retro_module_get_type ())
#define RETRO_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_MODULE, RetroModule))
#define RETRO_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RETRO_TYPE_MODULE, RetroModuleClass))
#define RETRO_IS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_MODULE))
#define RETRO_IS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RETRO_TYPE_MODULE))
#define RETRO_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RETRO_TYPE_MODULE, RetroModuleClass))

typedef struct _RetroModule RetroModule;
typedef struct _RetroModuleClass RetroModuleClass;

#define RETRO_TYPE_VARIABLES (retro_variables_get_type ())
#define RETRO_VARIABLES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_VARIABLES, RetroVariables))
#define RETRO_IS_VARIABLES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_VARIABLES))
#define RETRO_VARIABLES_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RETRO_TYPE_VARIABLES, RetroVariablesIface))

typedef struct _RetroVariables RetroVariables;
typedef struct _RetroVariablesIface RetroVariablesIface;

#define RETRO_TYPE_VARIABLE (retro_variable_get_type ())
typedef struct _RetroVariable RetroVariable;

#define RETRO_TYPE_MEMORY_TYPE (retro_memory_type_get_type ())

#define RETRO_TYPE_SYSTEM_INFO (retro_system_info_get_type ())
typedef struct _RetroSystemInfo RetroSystemInfo;

#define RETRO_TYPE_RUMBLE (retro_rumble_get_type ())
#define RETRO_RUMBLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_RUMBLE, RetroRumble))
#define RETRO_IS_RUMBLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_RUMBLE))
#define RETRO_RUMBLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RETRO_TYPE_RUMBLE, RetroRumbleIface))

typedef struct _RetroRumble RetroRumble;
typedef struct _RetroRumbleIface RetroRumbleIface;

#define RETRO_TYPE_RUMBLE_EFFECT (retro_rumble_effect_get_type ())

#define RETRO_TYPE_DISK_CONTROL (retro_disk_control_get_type ())
#define RETRO_DISK_CONTROL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_DISK_CONTROL, RetroDiskControl))
#define RETRO_DISK_CONTROL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RETRO_TYPE_DISK_CONTROL, RetroDiskControlClass))
#define RETRO_IS_DISK_CONTROL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_DISK_CONTROL))
#define RETRO_IS_DISK_CONTROL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RETRO_TYPE_DISK_CONTROL))
#define RETRO_DISK_CONTROL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RETRO_TYPE_DISK_CONTROL, RetroDiskControlClass))

typedef struct _RetroDiskControl RetroDiskControl;
typedef struct _RetroDiskControlClass RetroDiskControlClass;
typedef struct _RetroDiskControlPrivate RetroDiskControlPrivate;

#define RETRO_TYPE_GAME_INFO (retro_game_info_get_type ())
typedef struct _RetroGameInfo RetroGameInfo;

#define RETRO_TYPE_CORE_DESCRIPTOR (retro_core_descriptor_get_type ())
#define RETRO_CORE_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_CORE_DESCRIPTOR, RetroCoreDescriptor))
#define RETRO_CORE_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RETRO_TYPE_CORE_DESCRIPTOR, RetroCoreDescriptorClass))
#define RETRO_IS_CORE_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_CORE_DESCRIPTOR))
#define RETRO_IS_CORE_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RETRO_TYPE_CORE_DESCRIPTOR))
#define RETRO_CORE_DESCRIPTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RETRO_TYPE_CORE_DESCRIPTOR, RetroCoreDescriptorClass))

typedef struct _RetroCoreDescriptor RetroCoreDescriptor;
typedef struct _RetroCoreDescriptorClass RetroCoreDescriptorClass;
typedef struct _RetroCoreDescriptorPrivate RetroCoreDescriptorPrivate;

#define RETRO_CORE_DESCRIPTOR_TYPE_PLATFORM (retro_core_descriptor_platform_get_type ())
#define RETRO_CORE_DESCRIPTOR_PLATFORM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_CORE_DESCRIPTOR_TYPE_PLATFORM, RetroCoreDescriptorPlatform))
#define RETRO_CORE_DESCRIPTOR_PLATFORM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RETRO_CORE_DESCRIPTOR_TYPE_PLATFORM, RetroCoreDescriptorPlatformClass))
#define RETRO_CORE_DESCRIPTOR_IS_PLATFORM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_CORE_DESCRIPTOR_TYPE_PLATFORM))
#define RETRO_CORE_DESCRIPTOR_IS_PLATFORM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RETRO_CORE_DESCRIPTOR_TYPE_PLATFORM))
#define RETRO_CORE_DESCRIPTOR_PLATFORM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RETRO_CORE_DESCRIPTOR_TYPE_PLATFORM, RetroCoreDescriptorPlatformClass))

typedef struct _RetroCoreDescriptorPlatform RetroCoreDescriptorPlatform;
typedef struct _RetroCoreDescriptorPlatformClass RetroCoreDescriptorPlatformClass;
typedef struct _RetroCoreDescriptorPlatformPrivate RetroCoreDescriptorPlatformPrivate;

#define RETRO_TYPE_CORE_VIEW (retro_core_view_get_type ())
#define RETRO_CORE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_CORE_VIEW, RetroCoreView))
#define RETRO_CORE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RETRO_TYPE_CORE_VIEW, RetroCoreViewClass))
#define RETRO_IS_CORE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_CORE_VIEW))
#define RETRO_IS_CORE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RETRO_TYPE_CORE_VIEW))
#define RETRO_CORE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RETRO_TYPE_CORE_VIEW, RetroCoreViewClass))

typedef struct _RetroCoreView RetroCoreView;
typedef struct _RetroCoreViewClass RetroCoreViewClass;
typedef struct _RetroCoreViewPrivate RetroCoreViewPrivate;

#define RETRO_TYPE_MODULE_QUERY (retro_module_query_get_type ())
#define RETRO_MODULE_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_MODULE_QUERY, RetroModuleQuery))
#define RETRO_MODULE_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RETRO_TYPE_MODULE_QUERY, RetroModuleQueryClass))
#define RETRO_IS_MODULE_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_MODULE_QUERY))
#define RETRO_IS_MODULE_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RETRO_TYPE_MODULE_QUERY))
#define RETRO_MODULE_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RETRO_TYPE_MODULE_QUERY, RetroModuleQueryClass))

typedef struct _RetroModuleQuery RetroModuleQuery;
typedef struct _RetroModuleQueryClass RetroModuleQueryClass;
typedef struct _RetroModuleQueryPrivate RetroModuleQueryPrivate;

#define RETRO_TYPE_MODULE_ITERATOR (retro_module_iterator_get_type ())
#define RETRO_MODULE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_MODULE_ITERATOR, RetroModuleIterator))
#define RETRO_MODULE_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RETRO_TYPE_MODULE_ITERATOR, RetroModuleIteratorClass))
#define RETRO_IS_MODULE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_MODULE_ITERATOR))
#define RETRO_IS_MODULE_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RETRO_TYPE_MODULE_ITERATOR))
#define RETRO_MODULE_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RETRO_TYPE_MODULE_ITERATOR, RetroModuleIteratorClass))

typedef struct _RetroModuleIterator RetroModuleIterator;
typedef struct _RetroModuleIteratorClass RetroModuleIteratorClass;
typedef struct _RetroModuleIteratorPrivate RetroModuleIteratorPrivate;

#define RETRO_TYPE_PIXEL_FORMAT (retro_pixel_format_get_type ())

#define RETRO_TYPE_CAIRO_DISPLAY (retro_cairo_display_get_type ())
#define RETRO_CAIRO_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_CAIRO_DISPLAY, RetroCairoDisplay))
#define RETRO_CAIRO_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RETRO_TYPE_CAIRO_DISPLAY, RetroCairoDisplayClass))
#define RETRO_IS_CAIRO_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_CAIRO_DISPLAY))
#define RETRO_IS_CAIRO_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RETRO_TYPE_CAIRO_DISPLAY))
#define RETRO_CAIRO_DISPLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RETRO_TYPE_CAIRO_DISPLAY, RetroCairoDisplayClass))

typedef struct _RetroCairoDisplay RetroCairoDisplay;
typedef struct _RetroCairoDisplayClass RetroCairoDisplayClass;
typedef struct _RetroCairoDisplayPrivate RetroCairoDisplayPrivate;

#define RETRO_TYPE_VIDEO_FILTER (retro_video_filter_get_type ())

struct _RetroPaPlayer {
	GObject parent_instance;
	RetroPaPlayerPrivate * priv;
};

struct _RetroPaPlayerClass {
	GObjectClass parent_class;
};

typedef enum  {
	RETRO_DEVICE_TYPE_TYPE_MASK = 0xff,
	RETRO_DEVICE_TYPE_NONE = 0,
	RETRO_DEVICE_TYPE_JOYPAD = 1,
	RETRO_DEVICE_TYPE_MOUSE = 2,
	RETRO_DEVICE_TYPE_KEYBOARD = 3,
	RETRO_DEVICE_TYPE_LIGHTGUN = 4,
	RETRO_DEVICE_TYPE_ANALOG = 5,
	RETRO_DEVICE_TYPE_POINTER = 6
} RetroDeviceType;

typedef enum  {
	RETRO_JOYPAD_ID_B,
	RETRO_JOYPAD_ID_Y,
	RETRO_JOYPAD_ID_SELECT,
	RETRO_JOYPAD_ID_START,
	RETRO_JOYPAD_ID_UP,
	RETRO_JOYPAD_ID_DOWN,
	RETRO_JOYPAD_ID_LEFT,
	RETRO_JOYPAD_ID_RIGHT,
	RETRO_JOYPAD_ID_A,
	RETRO_JOYPAD_ID_X,
	RETRO_JOYPAD_ID_L,
	RETRO_JOYPAD_ID_R,
	RETRO_JOYPAD_ID_L2,
	RETRO_JOYPAD_ID_R2,
	RETRO_JOYPAD_ID_L3,
	RETRO_JOYPAD_ID_R3
} RetroJoypadId;

typedef enum  {
	RETRO_ANALOG_INDEX_LEFT,
	RETRO_ANALOG_INDEX_RIGHT
} RetroAnalogIndex;

typedef enum  {
	RETRO_ANALOG_ID_X,
	RETRO_ANALOG_ID_Y
} RetroAnalogId;

typedef enum  {
	RETRO_MOUSE_ID_X,
	RETRO_MOUSE_ID_Y,
	RETRO_MOUSE_ID_LEFT,
	RETRO_MOUSE_ID_RIGHT,
	RETRO_MOUSE_ID_WHEELUP,
	RETRO_MOUSE_ID_WHEELDOWN,
	RETRO_MOUSE_ID_MIDDLE,
	RETRO_MOUSE_ID_HORIZ_WHEELUP,
	RETRO_MOUSE_ID_HORIZ_WHEELDOWN
} RetroMouseId;

typedef enum  {
	RETRO_LIGHTGUN_ID_X,
	RETRO_LIGHTGUN_ID_Y,
	RETRO_LIGHTGUN_ID_TRIGGER,
	RETRO_LIGHTGUN_ID_CURSOR,
	RETRO_LIGHTGUN_ID_TURBO,
	RETRO_LIGHTGUN_ID_PAUSE,
	RETRO_LIGHTGUN_ID_START
} RetroLightgunId;

typedef enum  {
	RETRO_POINTER_ID_X,
	RETRO_POINTER_ID_Y,
	RETRO_POINTER_ID_PRESSED
} RetroPointerId;

struct _RetroInputDescriptor {
	guint port;
	RetroDeviceType device;
	guint index;
	guint id;
	gchar* description;
};

typedef enum  {
	RETRO_GAMEPAD_BUTTON_TYPE_ACTION_DOWN,
	RETRO_GAMEPAD_BUTTON_TYPE_ACTION_LEFT,
	RETRO_GAMEPAD_BUTTON_TYPE_SELECT,
	RETRO_GAMEPAD_BUTTON_TYPE_START,
	RETRO_GAMEPAD_BUTTON_TYPE_DIRECTION_UP,
	RETRO_GAMEPAD_BUTTON_TYPE_DIRECTION_DOWN,
	RETRO_GAMEPAD_BUTTON_TYPE_DIRECTION_LEFT,
	RETRO_GAMEPAD_BUTTON_TYPE_DIRECTION_RIGHT,
	RETRO_GAMEPAD_BUTTON_TYPE_ACTION_RIGHT,
	RETRO_GAMEPAD_BUTTON_TYPE_ACTION_UP,
	RETRO_GAMEPAD_BUTTON_TYPE_SHOULDER_L,
	RETRO_GAMEPAD_BUTTON_TYPE_SHOULDER_R,
	RETRO_GAMEPAD_BUTTON_TYPE_SHOULDER_L2,
	RETRO_GAMEPAD_BUTTON_TYPE_SHOULDER_R2,
	RETRO_GAMEPAD_BUTTON_TYPE_STICK_L,
	RETRO_GAMEPAD_BUTTON_TYPE_STICK_R,
	RETRO_GAMEPAD_BUTTON_TYPE_HOME
} RetroGamepadButtonType;

struct _RetroGamepadConfiguration {
	GObject parent_instance;
	RetroGamepadConfigurationPrivate * priv;
};

struct _RetroGamepadConfigurationClass {
	GObjectClass parent_class;
};

struct _RetroInputDeviceIface {
	GTypeInterface parent_iface;
	void (*poll) (RetroInputDevice* self);
	gint16 (*get_input_state) (RetroInputDevice* self, RetroDeviceType device, guint index, guint id);
	RetroDeviceType (*get_device_type) (RetroInputDevice* self);
	guint64 (*get_device_capabilities) (RetroInputDevice* self);
};

typedef void (*RetroInputControllerCallback) (guint port, RetroInputDevice* device, void* user_data);
struct _RetroInputIface {
	GTypeInterface parent_iface;
	void (*poll) (RetroInput* self);
	gint16 (*get_state) (RetroInput* self, guint port, RetroDeviceType device, guint index, guint id);
	void (*set_descriptors) (RetroInput* self, RetroInputDescriptor* input_descriptors, int input_descriptors_length1);
	guint64 (*get_device_capabilities) (RetroInput* self);
	void (*foreach_controller) (RetroInput* self, RetroInputControllerCallback callback, void* callback_target);
};

struct _RetroInputDeviceManager {
	GObject parent_instance;
	RetroInputDeviceManagerPrivate * priv;
};

struct _RetroInputDeviceManagerClass {
	GObjectClass parent_class;
};

typedef enum  {
	RETRO_KEYBOARD_KEY_UNKNOWN = 0,
	RETRO_KEYBOARD_KEY_FIRST = 0,
	RETRO_KEYBOARD_KEY_BACKSPACE = 8,
	RETRO_KEYBOARD_KEY_TAB = 9,
	RETRO_KEYBOARD_KEY_CLEAR = 12,
	RETRO_KEYBOARD_KEY_RETURN = 13,
	RETRO_KEYBOARD_KEY_PAUSE = 19,
	RETRO_KEYBOARD_KEY_ESCAPE = 27,
	RETRO_KEYBOARD_KEY_SPACE = 32,
	RETRO_KEYBOARD_KEY_EXCLAIM = 33,
	RETRO_KEYBOARD_KEY_QUOTEDBL = 34,
	RETRO_KEYBOARD_KEY_HASH = 35,
	RETRO_KEYBOARD_KEY_DOLLAR = 36,
	RETRO_KEYBOARD_KEY_AMPERSAND = 38,
	RETRO_KEYBOARD_KEY_QUOTE = 39,
	RETRO_KEYBOARD_KEY_LEFTPAREN = 40,
	RETRO_KEYBOARD_KEY_RIGHTPAREN = 41,
	RETRO_KEYBOARD_KEY_ASTERISK = 42,
	RETRO_KEYBOARD_KEY_PLUS = 43,
	RETRO_KEYBOARD_KEY_COMMA = 44,
	RETRO_KEYBOARD_KEY_MINUS = 45,
	RETRO_KEYBOARD_KEY_PERIOD = 46,
	RETRO_KEYBOARD_KEY_SLASH = 47,
	RETRO_KEYBOARD_KEY_ZERO = 48,
	RETRO_KEYBOARD_KEY_ONE = 49,
	RETRO_KEYBOARD_KEY_TWO = 50,
	RETRO_KEYBOARD_KEY_THREE = 51,
	RETRO_KEYBOARD_KEY_FOUR = 52,
	RETRO_KEYBOARD_KEY_FINE = 53,
	RETRO_KEYBOARD_KEY_SIX = 54,
	RETRO_KEYBOARD_KEY_SEVEN = 55,
	RETRO_KEYBOARD_KEY_HEIGHT = 56,
	RETRO_KEYBOARD_KEY_NINE = 57,
	RETRO_KEYBOARD_KEY_COLON = 58,
	RETRO_KEYBOARD_KEY_SEMICOLON = 59,
	RETRO_KEYBOARD_KEY_LESS = 60,
	RETRO_KEYBOARD_KEY_EQUALS = 61,
	RETRO_KEYBOARD_KEY_GREATER = 62,
	RETRO_KEYBOARD_KEY_QUESTION = 63,
	RETRO_KEYBOARD_KEY_AT = 64,
	RETRO_KEYBOARD_KEY_LEFTBRACKET = 91,
	RETRO_KEYBOARD_KEY_BACKSLASH = 92,
	RETRO_KEYBOARD_KEY_RIGHTBRACKET = 93,
	RETRO_KEYBOARD_KEY_CARET = 94,
	RETRO_KEYBOARD_KEY_UNDERSCORE = 95,
	RETRO_KEYBOARD_KEY_BACKQUOTE = 96,
	RETRO_KEYBOARD_KEY_a = 97,
	RETRO_KEYBOARD_KEY_b = 98,
	RETRO_KEYBOARD_KEY_c = 99,
	RETRO_KEYBOARD_KEY_d = 100,
	RETRO_KEYBOARD_KEY_e = 101,
	RETRO_KEYBOARD_KEY_f = 102,
	RETRO_KEYBOARD_KEY_g = 103,
	RETRO_KEYBOARD_KEY_h = 104,
	RETRO_KEYBOARD_KEY_i = 105,
	RETRO_KEYBOARD_KEY_j = 106,
	RETRO_KEYBOARD_KEY_k = 107,
	RETRO_KEYBOARD_KEY_l = 108,
	RETRO_KEYBOARD_KEY_m = 109,
	RETRO_KEYBOARD_KEY_n = 110,
	RETRO_KEYBOARD_KEY_o = 111,
	RETRO_KEYBOARD_KEY_p = 112,
	RETRO_KEYBOARD_KEY_q = 113,
	RETRO_KEYBOARD_KEY_r = 114,
	RETRO_KEYBOARD_KEY_s = 115,
	RETRO_KEYBOARD_KEY_t = 116,
	RETRO_KEYBOARD_KEY_u = 117,
	RETRO_KEYBOARD_KEY_v = 118,
	RETRO_KEYBOARD_KEY_w = 119,
	RETRO_KEYBOARD_KEY_x = 120,
	RETRO_KEYBOARD_KEY_y = 121,
	RETRO_KEYBOARD_KEY_z = 122,
	RETRO_KEYBOARD_KEY_DELETE = 127,
	RETRO_KEYBOARD_KEY_KP0 = 256,
	RETRO_KEYBOARD_KEY_KP1 = 257,
	RETRO_KEYBOARD_KEY_KP2 = 258,
	RETRO_KEYBOARD_KEY_KP3 = 259,
	RETRO_KEYBOARD_KEY_KP4 = 260,
	RETRO_KEYBOARD_KEY_KP5 = 261,
	RETRO_KEYBOARD_KEY_KP6 = 262,
	RETRO_KEYBOARD_KEY_KP7 = 263,
	RETRO_KEYBOARD_KEY_KP8 = 264,
	RETRO_KEYBOARD_KEY_KP9 = 265,
	RETRO_KEYBOARD_KEY_KP_PERIOD = 266,
	RETRO_KEYBOARD_KEY_KP_DIVIDE = 267,
	RETRO_KEYBOARD_KEY_KP_MULTIPLY = 268,
	RETRO_KEYBOARD_KEY_KP_MINUS = 269,
	RETRO_KEYBOARD_KEY_KP_PLUS = 270,
	RETRO_KEYBOARD_KEY_KP_ENTER = 271,
	RETRO_KEYBOARD_KEY_KP_EQUALS = 272,
	RETRO_KEYBOARD_KEY_UP = 273,
	RETRO_KEYBOARD_KEY_DOWN = 274,
	RETRO_KEYBOARD_KEY_RIGHT = 275,
	RETRO_KEYBOARD_KEY_LEFT = 276,
	RETRO_KEYBOARD_KEY_INSERT = 277,
	RETRO_KEYBOARD_KEY_HOME = 278,
	RETRO_KEYBOARD_KEY_END = 279,
	RETRO_KEYBOARD_KEY_PAGEUP = 280,
	RETRO_KEYBOARD_KEY_PAGEDOWN = 281,
	RETRO_KEYBOARD_KEY_F1 = 282,
	RETRO_KEYBOARD_KEY_F2 = 283,
	RETRO_KEYBOARD_KEY_F3 = 284,
	RETRO_KEYBOARD_KEY_F4 = 285,
	RETRO_KEYBOARD_KEY_F5 = 286,
	RETRO_KEYBOARD_KEY_F6 = 287,
	RETRO_KEYBOARD_KEY_F7 = 288,
	RETRO_KEYBOARD_KEY_F8 = 289,
	RETRO_KEYBOARD_KEY_F9 = 290,
	RETRO_KEYBOARD_KEY_F10 = 291,
	RETRO_KEYBOARD_KEY_F11 = 292,
	RETRO_KEYBOARD_KEY_F12 = 293,
	RETRO_KEYBOARD_KEY_F13 = 294,
	RETRO_KEYBOARD_KEY_F14 = 295,
	RETRO_KEYBOARD_KEY_F15 = 296,
	RETRO_KEYBOARD_KEY_NUMLOCK = 300,
	RETRO_KEYBOARD_KEY_CAPSLOCK = 301,
	RETRO_KEYBOARD_KEY_SCROLLOCK = 302,
	RETRO_KEYBOARD_KEY_RSHIFT = 303,
	RETRO_KEYBOARD_KEY_LSHIFT = 304,
	RETRO_KEYBOARD_KEY_RCTRL = 305,
	RETRO_KEYBOARD_KEY_LCTRL = 306,
	RETRO_KEYBOARD_KEY_RALT = 307,
	RETRO_KEYBOARD_KEY_LALT = 308,
	RETRO_KEYBOARD_KEY_RMETA = 309,
	RETRO_KEYBOARD_KEY_LMETA = 310,
	RETRO_KEYBOARD_KEY_LSUPER = 311,
	RETRO_KEYBOARD_KEY_RSUPER = 312,
	RETRO_KEYBOARD_KEY_MODE = 313,
	RETRO_KEYBOARD_KEY_COMPOSE = 314,
	RETRO_KEYBOARD_KEY_HELP = 315,
	RETRO_KEYBOARD_KEY_PRINT = 316,
	RETRO_KEYBOARD_KEY_SYSREQ = 317,
	RETRO_KEYBOARD_KEY_BREAK = 318,
	RETRO_KEYBOARD_KEY_MENU = 319,
	RETRO_KEYBOARD_KEY_POWER = 320,
	RETRO_KEYBOARD_KEY_EURO = 321,
	RETRO_KEYBOARD_KEY_UNDO = 322,
	RETRO_KEYBOARD_KEY_LAST
} RetroKeyboardKey;

typedef enum  {
	RETRO_KEYBOARD_MODIFIER_KEY_NONE = 0x0000,
	RETRO_KEYBOARD_MODIFIER_KEY_SHIFT = 0x01,
	RETRO_KEYBOARD_MODIFIER_KEY_CTRL = 0x02,
	RETRO_KEYBOARD_MODIFIER_KEY_ALT = 0x04,
	RETRO_KEYBOARD_MODIFIER_KEY_META = 0x08,
	RETRO_KEYBOARD_MODIFIER_KEY_NUMLOCK = 0x10,
	RETRO_KEYBOARD_MODIFIER_KEY_CAPSLOCK = 0x20,
	RETRO_KEYBOARD_MODIFIER_KEY_SCROLLOCK = 0x40
} RetroKeyboardModifierKey;

struct _RetroKeyboard {
	GObject parent_instance;
	RetroKeyboardPrivate * priv;
};

struct _RetroKeyboardClass {
	GObjectClass parent_class;
};

struct _RetroKeyboardState {
	GObject parent_instance;
	RetroKeyboardStatePrivate * priv;
};

struct _RetroKeyboardStateClass {
	GObjectClass parent_class;
};

struct _RetroMouse {
	GObject parent_instance;
	RetroMousePrivate * priv;
};

struct _RetroMouseClass {
	GObjectClass parent_class;
};

struct _RetroVirtualGamepad {
	GObject parent_instance;
	RetroVirtualGamepadPrivate * priv;
};

struct _RetroVirtualGamepadClass {
	GObjectClass parent_class;
};

struct _RetroMainLoop {
	GObject parent_instance;
	RetroMainLoopPrivate * priv;
};

struct _RetroMainLoopClass {
	GObjectClass parent_class;
};

struct _RetroVariable {
	gchar* key;
	gchar* value;
};

struct _RetroVariablesIface {
	GTypeInterface parent_iface;
	gchar* (*get_variable) (RetroVariables* self, const gchar* key);
	void (*set_variable) (RetroVariables* self, RetroVariable* variables, int variables_length1);
	gboolean (*get_variable_update) (RetroVariables* self);
	RetroCore* (*get_core) (RetroVariables* self);
	void (*set_core) (RetroVariables* self, RetroCore* value);
};

struct _RetroCore {
	GObject parent_instance;
	RetroCorePrivate * priv;
	gdouble _frames_per_second;
	RetroModule* module;
	RetroVariables* variables_interface;
	void* environment_internal;
};

struct _RetroCoreClass {
	GObjectClass parent_class;
	void (*init) (RetroCore* self);
};

typedef enum  {
	RETRO_MEMORY_TYPE_TYPE_MASK = 0xff,
	RETRO_MEMORY_TYPE_SAVE_RAM = 0,
	RETRO_MEMORY_TYPE_RTC = 1,
	RETRO_MEMORY_TYPE_SYSTEM_RAM = 2,
	RETRO_MEMORY_TYPE_VIDEO_RAM = 3,
	RETRO_MEMORY_TYPE_SNES_BSX_RAM = (1 << 8) | RETRO_MEMORY_TYPE_SAVE_RAM,
	RETRO_MEMORY_TYPE_SNES_BSX_PRAM = (2 << 8) | RETRO_MEMORY_TYPE_SAVE_RAM,
	RETRO_MEMORY_TYPE_SNES_SUFAMI_TURBO_A_RAM = (3 << 8) | RETRO_MEMORY_TYPE_SAVE_RAM,
	RETRO_MEMORY_TYPE_SNES_SUFAMI_TURBO_B_RAM = (4 << 8) | RETRO_MEMORY_TYPE_SAVE_RAM,
	RETRO_MEMORY_TYPE_SNES_GAME_BOY_RAM = (5 << 8) | RETRO_MEMORY_TYPE_SAVE_RAM,
	RETRO_MEMORY_TYPE_SNES_GAME_BOY_RTC = (6 << 8) | RETRO_MEMORY_TYPE_RTC
} RetroMemoryType;

struct _RetroSystemInfo {
	gchar* library_name;
	gchar* library_version;
	gchar* valid_extensions;
	gboolean need_fullpath;
	gboolean block_extract;
};

typedef enum  {
	RETRO_RUMBLE_EFFECT_STRONG,
	RETRO_RUMBLE_EFFECT_WEAK
} RetroRumbleEffect;

struct _RetroRumbleIface {
	GTypeInterface parent_iface;
	gboolean (*set_rumble_state) (RetroRumble* self, guint port, RetroRumbleEffect effect, guint16 strength);
};

typedef enum  {
	RETRO_CORE_ERROR_COULDNT_SERIALIZE,
	RETRO_CORE_ERROR_COULDNT_DESERIALIZE,
	RETRO_CORE_ERROR_SERIALIZATION_NOT_SUPPORTED
} RetroCoreError;
#define RETRO_CORE_ERROR retro_core_error_quark ()
struct _RetroDiskControl {
	GObject parent_instance;
	RetroDiskControlPrivate * priv;
};

struct _RetroDiskControlClass {
	GObjectClass parent_class;
};

typedef enum  {
	RETRO_CB_ERROR_NO_CORE,
	RETRO_CB_ERROR_NO_CALLBACK
} RetroCbError;
#define RETRO_CB_ERROR retro_cb_error_quark ()
struct _RetroGameInfo {
	gchar* path;
	guint8* data;
	gint data_length1;
	gchar* meta;
};

struct _RetroCoreDescriptor {
	GObject parent_instance;
	RetroCoreDescriptorPrivate * priv;
};

struct _RetroCoreDescriptorClass {
	GObjectClass parent_class;
};

typedef enum  {
	RETRO_CORE_DESCRIPTOR_ERROR_REQUIRED_GROUP_NOT_FOUND,
	RETRO_CORE_DESCRIPTOR_ERROR_REQUIRED_KEY_NOT_FOUND,
	RETRO_CORE_DESCRIPTOR_ERROR_FIRMWARE_NOT_FOUND
} RetroCoreDescriptorError;
#define RETRO_CORE_DESCRIPTOR_ERROR retro_core_descriptor_error_quark ()
struct _RetroCoreDescriptorPlatform {
	GObject parent_instance;
	RetroCoreDescriptorPlatformPrivate * priv;
};

struct _RetroCoreDescriptorPlatformClass {
	GObjectClass parent_class;
};

struct _RetroCoreView {
	GtkEventBox parent_instance;
	RetroCoreViewPrivate * priv;
};

struct _RetroCoreViewClass {
	GtkEventBoxClass parent_class;
};

struct _RetroModuleQuery {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RetroModuleQueryPrivate * priv;
};

struct _RetroModuleQueryClass {
	GTypeClass parent_class;
	void (*finalize) (RetroModuleQuery *self);
};

struct _RetroModuleIterator {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RetroModuleIteratorPrivate * priv;
};

struct _RetroModuleIteratorClass {
	GTypeClass parent_class;
	void (*finalize) (RetroModuleIterator *self);
};

typedef enum  {
	RETRO_PIXEL_FORMAT_XRGB1555,
	RETRO_PIXEL_FORMAT_XRGB8888,
	RETRO_PIXEL_FORMAT_RGB565,
	RETRO_PIXEL_FORMAT_UNKNOWN = -1
} RetroPixelFormat;

struct _RetroCairoDisplay {
	GtkDrawingArea parent_instance;
	RetroCairoDisplayPrivate * priv;
};

struct _RetroCairoDisplayClass {
	GtkDrawingAreaClass parent_class;
};

typedef enum  {
	RETRO_VIDEO_FILTER_SMOOTH,
	RETRO_VIDEO_FILTER_SHARP
} RetroVideoFilter;


GType retro_pa_player_get_type (void) G_GNUC_CONST;
GType retro_core_get_type (void) G_GNUC_CONST;
void retro_pa_player_set_core (RetroPaPlayer* self, RetroCore* core);
RetroPaPlayer* retro_pa_player_new (void);
RetroPaPlayer* retro_pa_player_construct (GType object_type);
GType retro_device_type_get_type (void) G_GNUC_CONST;
RetroDeviceType retro_device_type_get_basic_type (RetroDeviceType self);
GType retro_joypad_id_get_type (void) G_GNUC_CONST;
GType retro_analog_index_get_type (void) G_GNUC_CONST;
GType retro_analog_id_get_type (void) G_GNUC_CONST;
GType retro_mouse_id_get_type (void) G_GNUC_CONST;
GType retro_lightgun_id_get_type (void) G_GNUC_CONST;
GType retro_pointer_id_get_type (void) G_GNUC_CONST;
GType retro_input_descriptor_get_type (void) G_GNUC_CONST;
RetroInputDescriptor* retro_input_descriptor_dup (const RetroInputDescriptor* self);
void retro_input_descriptor_free (RetroInputDescriptor* self);
void retro_input_descriptor_copy (const RetroInputDescriptor* self, RetroInputDescriptor* dest);
void retro_input_descriptor_destroy (RetroInputDescriptor* self);
gsize retro_gamepad_button_type_size (void);
GType retro_gamepad_button_type_get_type (void) G_GNUC_CONST;
GType retro_gamepad_configuration_get_type (void) G_GNUC_CONST;
void retro_gamepad_configuration_set_to_default (RetroGamepadConfiguration* self);
void retro_gamepad_configuration_set_button_key (RetroGamepadConfiguration* self, RetroGamepadButtonType button, guint16 key);
guint16 retro_gamepad_configuration_get_button_key (RetroGamepadConfiguration* self, RetroGamepadButtonType button);
RetroGamepadConfiguration* retro_gamepad_configuration_new (void);
RetroGamepadConfiguration* retro_gamepad_configuration_construct (GType object_type);
GType retro_input_device_get_type (void) G_GNUC_CONST;
GType retro_input_get_type (void) G_GNUC_CONST;
void retro_input_poll (RetroInput* self);
gint16 retro_input_get_state (RetroInput* self, guint port, RetroDeviceType device, guint index, guint id);
void retro_input_set_descriptors (RetroInput* self, RetroInputDescriptor* input_descriptors, int input_descriptors_length1);
guint64 retro_input_get_device_capabilities (RetroInput* self);
void retro_input_foreach_controller (RetroInput* self, RetroInputControllerCallback callback, void* callback_target);
void retro_input_device_poll (RetroInputDevice* self);
gint16 retro_input_device_get_input_state (RetroInputDevice* self, RetroDeviceType device, guint index, guint id);
RetroDeviceType retro_input_device_get_device_type (RetroInputDevice* self);
guint64 retro_input_device_get_device_capabilities (RetroInputDevice* self);
GType retro_input_device_manager_get_type (void) G_GNUC_CONST;
void retro_input_device_manager_set_controller_device (RetroInputDeviceManager* self, guint port, RetroInputDevice* device);
GType retro_keyboard_get_type (void) G_GNUC_CONST;
void retro_input_device_manager_set_keyboard (RetroInputDeviceManager* self, RetroKeyboard* keyboard);
void retro_input_device_manager_remove_controller_device (RetroInputDeviceManager* self, guint port);
RetroInputDeviceManager* retro_input_device_manager_new (void);
RetroInputDeviceManager* retro_input_device_manager_construct (GType object_type);
GType retro_keyboard_key_get_type (void) G_GNUC_CONST;
GType retro_keyboard_modifier_key_get_type (void) G_GNUC_CONST;
RetroKeyboard* retro_keyboard_new (GtkWidget* widget);
RetroKeyboard* retro_keyboard_construct (GType object_type, GtkWidget* widget);
GtkWidget* retro_keyboard_get_widget (RetroKeyboard* self);
GType retro_keyboard_state_get_type (void) G_GNUC_CONST;
RetroKeyboardState* retro_keyboard_state_new (GtkWidget* widget);
RetroKeyboardState* retro_keyboard_state_construct (GType object_type, GtkWidget* widget);
gboolean retro_keyboard_state_get_key_state (RetroKeyboardState* self, guint16 hardware_keycode);
GtkWidget* retro_keyboard_state_get_widget (RetroKeyboardState* self);
GType retro_mouse_get_type (void) G_GNUC_CONST;
RetroMouse* retro_mouse_new (GtkWidget* widget);
RetroMouse* retro_mouse_construct (GType object_type, GtkWidget* widget);
gboolean retro_mouse_get_button_state (RetroMouse* self, guint button);
GtkWidget* retro_mouse_get_widget (RetroMouse* self);
gboolean retro_mouse_get_parse (RetroMouse* self);
void retro_mouse_set_parse (RetroMouse* self, gboolean value);
GType retro_virtual_gamepad_get_type (void) G_GNUC_CONST;
RetroVirtualGamepad* retro_virtual_gamepad_new (GtkWidget* widget);
RetroVirtualGamepad* retro_virtual_gamepad_construct (GType object_type, GtkWidget* widget);
RetroVirtualGamepad* retro_virtual_gamepad_new_with_configuration (GtkWidget* widget, RetroGamepadConfiguration* configuration);
RetroVirtualGamepad* retro_virtual_gamepad_construct_with_configuration (GType object_type, GtkWidget* widget, RetroGamepadConfiguration* configuration);
gboolean retro_virtual_gamepad_get_button_pressed (RetroVirtualGamepad* self, RetroGamepadButtonType button);
GtkWidget* retro_virtual_gamepad_get_widget (RetroVirtualGamepad* self);
RetroGamepadConfiguration* retro_virtual_gamepad_get_configuration (RetroVirtualGamepad* self);
void retro_virtual_gamepad_set_configuration (RetroVirtualGamepad* self, RetroGamepadConfiguration* value);
GType retro_main_loop_get_type (void) G_GNUC_CONST;
RetroMainLoop* retro_main_loop_new (RetroCore* core);
RetroMainLoop* retro_main_loop_construct (GType object_type, RetroCore* core);
void retro_main_loop_start (RetroMainLoop* self);
void retro_main_loop_reset (RetroMainLoop* self);
void retro_main_loop_stop (RetroMainLoop* self);
RetroCore* retro_main_loop_get_core (RetroMainLoop* self);
void retro_main_loop_set_core (RetroMainLoop* self, RetroCore* value);
gdouble retro_main_loop_get_speed_rate (RetroMainLoop* self);
void retro_main_loop_set_speed_rate (RetroMainLoop* self, gdouble value);
GType retro_module_get_type (void) G_GNUC_CONST;
GType retro_variable_get_type (void) G_GNUC_CONST;
RetroVariable* retro_variable_dup (const RetroVariable* self);
void retro_variable_free (RetroVariable* self);
void retro_variable_copy (const RetroVariable* self, RetroVariable* dest);
void retro_variable_destroy (RetroVariable* self);
GType retro_variables_get_type (void) G_GNUC_CONST;
RetroCore* retro_core_new (const gchar* file_name);
RetroCore* retro_core_construct (GType object_type, const gchar* file_name);
void retro_core_set_medias (RetroCore* self, gchar** uris);
void retro_core_set_current_media (RetroCore* self, guint media_index, GError** error);
void retro_core_set_controller_port_device (RetroCore* self, guint port, RetroDeviceType device);
void retro_core_reset (RetroCore* self);
void retro_core_run (RetroCore* self);
gboolean retro_core_supports_serialization (RetroCore* self);
guint8* retro_core_serialize_state (RetroCore* self, gsize* result_length1, GError** error);
void retro_core_deserialize_state (RetroCore* self, guint8* data, gsize data_length1, GError** error);
GType retro_memory_type_get_type (void) G_GNUC_CONST;
gsize retro_core_get_memory_size (RetroCore* self, RetroMemoryType id);
guint8* retro_core_get_memory (RetroCore* self, RetroMemoryType id, int* result_length1);
void retro_core_set_memory (RetroCore* self, RetroMemoryType id, guint8* data, int data_length1);
guint retro_core_get_api_version (RetroCore* self);
GType retro_system_info_get_type (void) G_GNUC_CONST;
RetroSystemInfo* retro_system_info_dup (const RetroSystemInfo* self);
void retro_system_info_free (RetroSystemInfo* self);
void retro_system_info_copy (const RetroSystemInfo* self, RetroSystemInfo* dest);
void retro_system_info_destroy (RetroSystemInfo* self);
void retro_core_get_system_info (RetroCore* self, RetroSystemInfo * result);
const gchar* retro_core_get_file_name (RetroCore* self);
const gchar* retro_core_get_system_directory (RetroCore* self);
void retro_core_set_system_directory (RetroCore* self, const gchar* value);
const gchar* retro_core_get_libretro_path (RetroCore* self);
void retro_core_set_libretro_path (RetroCore* self, const gchar* value);
const gchar* retro_core_get_content_directory (RetroCore* self);
void retro_core_set_content_directory (RetroCore* self, const gchar* value);
const gchar* retro_core_get_save_directory (RetroCore* self);
void retro_core_set_save_directory (RetroCore* self, const gchar* value);
gboolean retro_core_get_is_initiated (RetroCore* self);
gboolean retro_core_get_game_loaded (RetroCore* self);
gboolean retro_core_get_support_no_game (RetroCore* self);
gdouble retro_core_get_frames_per_second (RetroCore* self);
RetroInput* retro_core_get_input_interface (RetroCore* self);
void retro_core_set_input_interface (RetroCore* self, RetroInput* value);
GType retro_rumble_effect_get_type (void) G_GNUC_CONST;
GType retro_rumble_get_type (void) G_GNUC_CONST;
RetroRumble* retro_core_get_rumble_interface (RetroCore* self);
void retro_core_set_rumble_interface (RetroCore* self, RetroRumble* value);
GQuark retro_core_error_quark (void);
GType retro_disk_control_get_type (void) G_GNUC_CONST;
GQuark retro_cb_error_quark (void);
gboolean retro_disk_control_set_eject_state (RetroDiskControl* self, gboolean ejected, GError** error);
gboolean retro_disk_control_get_eject_state (RetroDiskControl* self, GError** error);
gboolean retro_disk_control_set_image_index (RetroDiskControl* self, guint image_index, GError** error);
guint retro_disk_control_get_image_index (RetroDiskControl* self, GError** error);
guint retro_disk_control_get_num_images (RetroDiskControl* self, GError** error);
GType retro_game_info_get_type (void) G_GNUC_CONST;
RetroGameInfo* retro_game_info_dup (const RetroGameInfo* self);
void retro_game_info_free (RetroGameInfo* self);
void retro_game_info_copy (const RetroGameInfo* self, RetroGameInfo* dest);
void retro_game_info_destroy (RetroGameInfo* self);
gboolean retro_disk_control_replace_image_index (RetroDiskControl* self, guint index, RetroGameInfo* info, GError** error);
gboolean retro_disk_control_remove_image_index (RetroDiskControl* self, guint index, GError** error);
gboolean retro_disk_control_add_image_index (RetroDiskControl* self, GError** error);
void retro_game_info_init (RetroGameInfo *self, const gchar* file_name);
void retro_game_info_init_with_data (RetroGameInfo *self, const gchar* file_name, GError** error);
RetroMemoryType retro_memory_type_get_basic_type (RetroMemoryType self);
#define RETRO_API_VERSION ((guint) 1)
RetroSystemInfo* retro_get_system_info (const gchar* module_name);
void retro_g_log (RetroCore* core, const gchar* log_domain, GLogLevelFlags log_level, const gchar* message);
GType retro_core_descriptor_get_type (void) G_GNUC_CONST;
GQuark retro_core_descriptor_error_quark (void);
RetroCoreDescriptor* retro_core_descriptor_new (const gchar* filename, GError** error);
RetroCoreDescriptor* retro_core_descriptor_construct (GType object_type, const gchar* filename, GError** error);
gboolean retro_core_descriptor_has_icon (RetroCoreDescriptor* self, GError** error);
gchar* retro_core_descriptor_get_uri (RetroCoreDescriptor* self);
gchar* retro_core_descriptor_get_id (RetroCoreDescriptor* self);
gboolean retro_core_descriptor_get_is_game (RetroCoreDescriptor* self, GError** error);
gboolean retro_core_descriptor_get_is_emulator (RetroCoreDescriptor* self, GError** error);
gchar* retro_core_descriptor_get_name (RetroCoreDescriptor* self, GError** error);
GIcon* retro_core_descriptor_get_icon (RetroCoreDescriptor* self, GError** error);
gchar* retro_core_descriptor_get_module (RetroCoreDescriptor* self, GError** error);
GFile* retro_core_descriptor_get_module_file (RetroCoreDescriptor* self, GError** error);
gboolean retro_core_descriptor_has_platform (RetroCoreDescriptor* self, const gchar* platform);
gboolean retro_core_descriptor_has_firmwares (RetroCoreDescriptor* self, const gchar* platform, GError** error);
gboolean retro_core_descriptor_has_firmware_md5 (RetroCoreDescriptor* self, const gchar* firmware, GError** error);
gboolean retro_core_descriptor_has_firmware_sha512 (RetroCoreDescriptor* self, const gchar* firmware, GError** error);
gchar** retro_core_descriptor_get_mime_type (RetroCoreDescriptor* self, const gchar* platform, int* result_length1, GError** error);
gchar** retro_core_descriptor_get_firmwares (RetroCoreDescriptor* self, const gchar* platform, int* result_length1, GError** error);
gchar* retro_core_descriptor_get_firmware_path (RetroCoreDescriptor* self, const gchar* firmware, GError** error);
gchar* retro_core_descriptor_get_firmware_md5 (RetroCoreDescriptor* self, const gchar* firmware, GError** error);
gchar* retro_core_descriptor_get_firmware_sha512 (RetroCoreDescriptor* self, const gchar* firmware, GError** error);
gboolean retro_core_descriptor_get_is_firmware_mandatory (RetroCoreDescriptor* self, const gchar* firmware, GError** error);
gboolean retro_core_descriptor_get_platform_supports_mime_types (RetroCoreDescriptor* self, const gchar* platform, gchar** mime_types, int mime_types_length1, GError** error);
GType retro_core_descriptor_platform_get_type (void) G_GNUC_CONST;
GType retro_core_view_get_type (void) G_GNUC_CONST;
void retro_core_view_set_core (RetroCoreView* self, RetroCore* core);
RetroCoreView* retro_core_view_new (void);
RetroCoreView* retro_core_view_construct (GType object_type);
gpointer retro_module_query_ref (gpointer instance);
void retro_module_query_unref (gpointer instance);
GParamSpec* retro_param_spec_module_query (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void retro_value_set_module_query (GValue* value, gpointer v_object);
void retro_value_take_module_query (GValue* value, gpointer v_object);
gpointer retro_value_get_module_query (const GValue* value);
GType retro_module_query_get_type (void) G_GNUC_CONST;
RetroModuleQuery* retro_module_query_new (gboolean recursive);
RetroModuleQuery* retro_module_query_construct (GType object_type, gboolean recursive);
gpointer retro_module_iterator_ref (gpointer instance);
void retro_module_iterator_unref (gpointer instance);
GParamSpec* retro_param_spec_module_iterator (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void retro_value_set_module_iterator (GValue* value, gpointer v_object);
void retro_value_take_module_iterator (GValue* value, gpointer v_object);
gpointer retro_value_get_module_iterator (const GValue* value);
GType retro_module_iterator_get_type (void) G_GNUC_CONST;
RetroModuleIterator* retro_module_query_iterator (RetroModuleQuery* self);
RetroCoreDescriptor* retro_module_iterator_get (RetroModuleIterator* self);
gboolean retro_module_iterator_next (RetroModuleIterator* self);
gboolean retro_rumble_set_rumble_state (RetroRumble* self, guint port, RetroRumbleEffect effect, guint16 strength);
GType retro_pixel_format_get_type (void) G_GNUC_CONST;
GType retro_cairo_display_get_type (void) G_GNUC_CONST;
void retro_cairo_display_set_core (RetroCairoDisplay* self, RetroCore* core);
GType retro_video_filter_get_type (void) G_GNUC_CONST;
void retro_cairo_display_set_filter (RetroCairoDisplay* self, RetroVideoFilter filter);
void retro_cairo_display_show_video (RetroCairoDisplay* self);
void retro_cairo_display_hide_video (RetroCairoDisplay* self);
RetroCairoDisplay* retro_cairo_display_new (void);
RetroCairoDisplay* retro_cairo_display_construct (GType object_type);
GdkPixbuf* retro_cairo_display_get_pixbuf (RetroCairoDisplay* self);
void retro_cairo_display_set_pixbuf (RetroCairoDisplay* self, GdkPixbuf* value);
RetroVideoFilter retro_video_filter_from_string (const gchar* filter);


G_END_DECLS

#endif
