/* input.c generated by valac 0.36.4, the Vala compiler
 * generated from input.vala, do not modify */

/* This file is part of retro-gtk. License: GPLv3*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define RETRO_TYPE_INPUT (retro_input_get_type ())
#define RETRO_INPUT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_INPUT, RetroInput))
#define RETRO_IS_INPUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_INPUT))
#define RETRO_INPUT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RETRO_TYPE_INPUT, RetroInputIface))

typedef struct _RetroInput RetroInput;
typedef struct _RetroInputIface RetroInputIface;

#define RETRO_TYPE_DEVICE_TYPE (retro_device_type_get_type ())

#define RETRO_TYPE_INPUT_DESCRIPTOR (retro_input_descriptor_get_type ())
typedef struct _RetroInputDescriptor RetroInputDescriptor;

#define RETRO_TYPE_INPUT_DEVICE (retro_input_device_get_type ())
#define RETRO_INPUT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_INPUT_DEVICE, RetroInputDevice))
#define RETRO_IS_INPUT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_INPUT_DEVICE))
#define RETRO_INPUT_DEVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RETRO_TYPE_INPUT_DEVICE, RetroInputDeviceIface))

typedef struct _RetroInputDevice RetroInputDevice;
typedef struct _RetroInputDeviceIface RetroInputDeviceIface;

#define RETRO_TYPE_KEYBOARD_KEY (retro_keyboard_key_get_type ())

#define RETRO_TYPE_KEYBOARD_MODIFIER_KEY (retro_keyboard_modifier_key_get_type ())
enum  {
	RETRO_INPUT_CONTROLLER_CONNECTED_SIGNAL,
	RETRO_INPUT_CONTROLLER_DISCONNECTED_SIGNAL,
	RETRO_INPUT_KEY_EVENT_SIGNAL,
	RETRO_INPUT_LAST_SIGNAL
};
static guint retro_input_signals[RETRO_INPUT_LAST_SIGNAL] = {0};

typedef enum  {
	RETRO_DEVICE_TYPE_TYPE_MASK = 0xff,
	RETRO_DEVICE_TYPE_NONE = 0,
	RETRO_DEVICE_TYPE_JOYPAD = 1,
	RETRO_DEVICE_TYPE_MOUSE = 2,
	RETRO_DEVICE_TYPE_KEYBOARD = 3,
	RETRO_DEVICE_TYPE_LIGHTGUN = 4,
	RETRO_DEVICE_TYPE_ANALOG = 5,
	RETRO_DEVICE_TYPE_POINTER = 6
} RetroDeviceType;

struct _RetroInputDescriptor {
	guint port;
	RetroDeviceType device;
	guint index;
	guint id;
	gchar* description;
};

struct _RetroInputDeviceIface {
	GTypeInterface parent_iface;
	void (*poll) (RetroInputDevice* self);
	gint16 (*get_input_state) (RetroInputDevice* self, RetroDeviceType device, guint index, guint id);
	RetroDeviceType (*get_device_type) (RetroInputDevice* self);
	guint64 (*get_device_capabilities) (RetroInputDevice* self);
};

typedef void (*RetroInputControllerCallback) (guint port, RetroInputDevice* device, void* user_data);
struct _RetroInputIface {
	GTypeInterface parent_iface;
	void (*poll) (RetroInput* self);
	gint16 (*get_state) (RetroInput* self, guint port, RetroDeviceType device, guint index, guint id);
	void (*set_descriptors) (RetroInput* self, RetroInputDescriptor* input_descriptors, int input_descriptors_length1);
	guint64 (*get_device_capabilities) (RetroInput* self);
	void (*foreach_controller) (RetroInput* self, RetroInputControllerCallback callback, void* callback_target);
};

typedef enum  {
	RETRO_KEYBOARD_KEY_UNKNOWN = 0,
	RETRO_KEYBOARD_KEY_FIRST = 0,
	RETRO_KEYBOARD_KEY_BACKSPACE = 8,
	RETRO_KEYBOARD_KEY_TAB = 9,
	RETRO_KEYBOARD_KEY_CLEAR = 12,
	RETRO_KEYBOARD_KEY_RETURN = 13,
	RETRO_KEYBOARD_KEY_PAUSE = 19,
	RETRO_KEYBOARD_KEY_ESCAPE = 27,
	RETRO_KEYBOARD_KEY_SPACE = 32,
	RETRO_KEYBOARD_KEY_EXCLAIM = 33,
	RETRO_KEYBOARD_KEY_QUOTEDBL = 34,
	RETRO_KEYBOARD_KEY_HASH = 35,
	RETRO_KEYBOARD_KEY_DOLLAR = 36,
	RETRO_KEYBOARD_KEY_AMPERSAND = 38,
	RETRO_KEYBOARD_KEY_QUOTE = 39,
	RETRO_KEYBOARD_KEY_LEFTPAREN = 40,
	RETRO_KEYBOARD_KEY_RIGHTPAREN = 41,
	RETRO_KEYBOARD_KEY_ASTERISK = 42,
	RETRO_KEYBOARD_KEY_PLUS = 43,
	RETRO_KEYBOARD_KEY_COMMA = 44,
	RETRO_KEYBOARD_KEY_MINUS = 45,
	RETRO_KEYBOARD_KEY_PERIOD = 46,
	RETRO_KEYBOARD_KEY_SLASH = 47,
	RETRO_KEYBOARD_KEY_ZERO = 48,
	RETRO_KEYBOARD_KEY_ONE = 49,
	RETRO_KEYBOARD_KEY_TWO = 50,
	RETRO_KEYBOARD_KEY_THREE = 51,
	RETRO_KEYBOARD_KEY_FOUR = 52,
	RETRO_KEYBOARD_KEY_FINE = 53,
	RETRO_KEYBOARD_KEY_SIX = 54,
	RETRO_KEYBOARD_KEY_SEVEN = 55,
	RETRO_KEYBOARD_KEY_HEIGHT = 56,
	RETRO_KEYBOARD_KEY_NINE = 57,
	RETRO_KEYBOARD_KEY_COLON = 58,
	RETRO_KEYBOARD_KEY_SEMICOLON = 59,
	RETRO_KEYBOARD_KEY_LESS = 60,
	RETRO_KEYBOARD_KEY_EQUALS = 61,
	RETRO_KEYBOARD_KEY_GREATER = 62,
	RETRO_KEYBOARD_KEY_QUESTION = 63,
	RETRO_KEYBOARD_KEY_AT = 64,
	RETRO_KEYBOARD_KEY_LEFTBRACKET = 91,
	RETRO_KEYBOARD_KEY_BACKSLASH = 92,
	RETRO_KEYBOARD_KEY_RIGHTBRACKET = 93,
	RETRO_KEYBOARD_KEY_CARET = 94,
	RETRO_KEYBOARD_KEY_UNDERSCORE = 95,
	RETRO_KEYBOARD_KEY_BACKQUOTE = 96,
	RETRO_KEYBOARD_KEY_a = 97,
	RETRO_KEYBOARD_KEY_b = 98,
	RETRO_KEYBOARD_KEY_c = 99,
	RETRO_KEYBOARD_KEY_d = 100,
	RETRO_KEYBOARD_KEY_e = 101,
	RETRO_KEYBOARD_KEY_f = 102,
	RETRO_KEYBOARD_KEY_g = 103,
	RETRO_KEYBOARD_KEY_h = 104,
	RETRO_KEYBOARD_KEY_i = 105,
	RETRO_KEYBOARD_KEY_j = 106,
	RETRO_KEYBOARD_KEY_k = 107,
	RETRO_KEYBOARD_KEY_l = 108,
	RETRO_KEYBOARD_KEY_m = 109,
	RETRO_KEYBOARD_KEY_n = 110,
	RETRO_KEYBOARD_KEY_o = 111,
	RETRO_KEYBOARD_KEY_p = 112,
	RETRO_KEYBOARD_KEY_q = 113,
	RETRO_KEYBOARD_KEY_r = 114,
	RETRO_KEYBOARD_KEY_s = 115,
	RETRO_KEYBOARD_KEY_t = 116,
	RETRO_KEYBOARD_KEY_u = 117,
	RETRO_KEYBOARD_KEY_v = 118,
	RETRO_KEYBOARD_KEY_w = 119,
	RETRO_KEYBOARD_KEY_x = 120,
	RETRO_KEYBOARD_KEY_y = 121,
	RETRO_KEYBOARD_KEY_z = 122,
	RETRO_KEYBOARD_KEY_DELETE = 127,
	RETRO_KEYBOARD_KEY_KP0 = 256,
	RETRO_KEYBOARD_KEY_KP1 = 257,
	RETRO_KEYBOARD_KEY_KP2 = 258,
	RETRO_KEYBOARD_KEY_KP3 = 259,
	RETRO_KEYBOARD_KEY_KP4 = 260,
	RETRO_KEYBOARD_KEY_KP5 = 261,
	RETRO_KEYBOARD_KEY_KP6 = 262,
	RETRO_KEYBOARD_KEY_KP7 = 263,
	RETRO_KEYBOARD_KEY_KP8 = 264,
	RETRO_KEYBOARD_KEY_KP9 = 265,
	RETRO_KEYBOARD_KEY_KP_PERIOD = 266,
	RETRO_KEYBOARD_KEY_KP_DIVIDE = 267,
	RETRO_KEYBOARD_KEY_KP_MULTIPLY = 268,
	RETRO_KEYBOARD_KEY_KP_MINUS = 269,
	RETRO_KEYBOARD_KEY_KP_PLUS = 270,
	RETRO_KEYBOARD_KEY_KP_ENTER = 271,
	RETRO_KEYBOARD_KEY_KP_EQUALS = 272,
	RETRO_KEYBOARD_KEY_UP = 273,
	RETRO_KEYBOARD_KEY_DOWN = 274,
	RETRO_KEYBOARD_KEY_RIGHT = 275,
	RETRO_KEYBOARD_KEY_LEFT = 276,
	RETRO_KEYBOARD_KEY_INSERT = 277,
	RETRO_KEYBOARD_KEY_HOME = 278,
	RETRO_KEYBOARD_KEY_END = 279,
	RETRO_KEYBOARD_KEY_PAGEUP = 280,
	RETRO_KEYBOARD_KEY_PAGEDOWN = 281,
	RETRO_KEYBOARD_KEY_F1 = 282,
	RETRO_KEYBOARD_KEY_F2 = 283,
	RETRO_KEYBOARD_KEY_F3 = 284,
	RETRO_KEYBOARD_KEY_F4 = 285,
	RETRO_KEYBOARD_KEY_F5 = 286,
	RETRO_KEYBOARD_KEY_F6 = 287,
	RETRO_KEYBOARD_KEY_F7 = 288,
	RETRO_KEYBOARD_KEY_F8 = 289,
	RETRO_KEYBOARD_KEY_F9 = 290,
	RETRO_KEYBOARD_KEY_F10 = 291,
	RETRO_KEYBOARD_KEY_F11 = 292,
	RETRO_KEYBOARD_KEY_F12 = 293,
	RETRO_KEYBOARD_KEY_F13 = 294,
	RETRO_KEYBOARD_KEY_F14 = 295,
	RETRO_KEYBOARD_KEY_F15 = 296,
	RETRO_KEYBOARD_KEY_NUMLOCK = 300,
	RETRO_KEYBOARD_KEY_CAPSLOCK = 301,
	RETRO_KEYBOARD_KEY_SCROLLOCK = 302,
	RETRO_KEYBOARD_KEY_RSHIFT = 303,
	RETRO_KEYBOARD_KEY_LSHIFT = 304,
	RETRO_KEYBOARD_KEY_RCTRL = 305,
	RETRO_KEYBOARD_KEY_LCTRL = 306,
	RETRO_KEYBOARD_KEY_RALT = 307,
	RETRO_KEYBOARD_KEY_LALT = 308,
	RETRO_KEYBOARD_KEY_RMETA = 309,
	RETRO_KEYBOARD_KEY_LMETA = 310,
	RETRO_KEYBOARD_KEY_LSUPER = 311,
	RETRO_KEYBOARD_KEY_RSUPER = 312,
	RETRO_KEYBOARD_KEY_MODE = 313,
	RETRO_KEYBOARD_KEY_COMPOSE = 314,
	RETRO_KEYBOARD_KEY_HELP = 315,
	RETRO_KEYBOARD_KEY_PRINT = 316,
	RETRO_KEYBOARD_KEY_SYSREQ = 317,
	RETRO_KEYBOARD_KEY_BREAK = 318,
	RETRO_KEYBOARD_KEY_MENU = 319,
	RETRO_KEYBOARD_KEY_POWER = 320,
	RETRO_KEYBOARD_KEY_EURO = 321,
	RETRO_KEYBOARD_KEY_UNDO = 322,
	RETRO_KEYBOARD_KEY_LAST
} RetroKeyboardKey;

typedef enum  {
	RETRO_KEYBOARD_MODIFIER_KEY_NONE = 0x0000,
	RETRO_KEYBOARD_MODIFIER_KEY_SHIFT = 0x01,
	RETRO_KEYBOARD_MODIFIER_KEY_CTRL = 0x02,
	RETRO_KEYBOARD_MODIFIER_KEY_ALT = 0x04,
	RETRO_KEYBOARD_MODIFIER_KEY_META = 0x08,
	RETRO_KEYBOARD_MODIFIER_KEY_NUMLOCK = 0x10,
	RETRO_KEYBOARD_MODIFIER_KEY_CAPSLOCK = 0x20,
	RETRO_KEYBOARD_MODIFIER_KEY_SCROLLOCK = 0x40
} RetroKeyboardModifierKey;



GType retro_device_type_get_type (void) G_GNUC_CONST;
GType retro_input_descriptor_get_type (void) G_GNUC_CONST;
RetroInputDescriptor* retro_input_descriptor_dup (const RetroInputDescriptor* self);
void retro_input_descriptor_free (RetroInputDescriptor* self);
void retro_input_descriptor_copy (const RetroInputDescriptor* self, RetroInputDescriptor* dest);
void retro_input_descriptor_destroy (RetroInputDescriptor* self);
GType retro_input_device_get_type (void) G_GNUC_CONST;
GType retro_input_get_type (void) G_GNUC_CONST;
void retro_input_poll (RetroInput* self);
gint16 retro_input_get_state (RetroInput* self, guint port, RetroDeviceType device, guint index, guint id);
void retro_input_set_descriptors (RetroInput* self, RetroInputDescriptor* input_descriptors, int input_descriptors_length1);
guint64 retro_input_get_device_capabilities (RetroInput* self);
void retro_input_foreach_controller (RetroInput* self, RetroInputControllerCallback callback, void* callback_target);
static void g_cclosure_user_marshal_VOID__UINT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
GType retro_keyboard_key_get_type (void) G_GNUC_CONST;
GType retro_keyboard_modifier_key_get_type (void) G_GNUC_CONST;
static void g_cclosure_user_marshal_VOID__BOOLEAN_ENUM_UINT_FLAGS (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);


/**
 * Asks the frontend to poll inputs.
 */
void retro_input_poll (RetroInput* self) {
	g_return_if_fail (self != NULL);
	RETRO_INPUT_GET_INTERFACE (self)->poll (self);
}


/**
 * Gets the state of a specific input.
 *
 * @param port the port of the controller to check the input state from
 * @param device the type of the device to check the input state from
 * @param index the index of given input (left or right stick)
 * @param id the specific input to get (button or axis)
 * @return the value of the given state
 */
gint16 retro_input_get_state (RetroInput* self, guint port, RetroDeviceType device, guint index, guint id) {
	g_return_val_if_fail (self != NULL, 0);
	return RETRO_INPUT_GET_INTERFACE (self)->get_state (self, port, device, index, id);
}


/**
 * Sets how the {@link core} handles the inputs in a human-readable way.
 *
 * @param input_descriptors the descriptors of the inputs used by the
 * {@link core}
 */
void retro_input_set_descriptors (RetroInput* self, RetroInputDescriptor* input_descriptors, int input_descriptors_length1) {
	g_return_if_fail (self != NULL);
	RETRO_INPUT_GET_INTERFACE (self)->set_descriptors (self, input_descriptors, input_descriptors_length1);
}


/**
 * Gets the flags of the devices implemented by the frontend.
 *
 * @return flags of the devices implemented by the frontend
 */
guint64 retro_input_get_device_capabilities (RetroInput* self) {
	g_return_val_if_fail (self != NULL, 0ULL);
	return RETRO_INPUT_GET_INTERFACE (self)->get_device_capabilities (self);
}


void retro_input_foreach_controller (RetroInput* self, RetroInputControllerCallback callback, void* callback_target) {
	g_return_if_fail (self != NULL);
	RETRO_INPUT_GET_INTERFACE (self)->foreach_controller (self, callback, callback_target);
}


static void g_cclosure_user_marshal_VOID__UINT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_OBJECT) (gpointer data1, guint arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_object (param_values + 2), data2);
}


static void g_cclosure_user_marshal_VOID__BOOLEAN_ENUM_UINT_FLAGS (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOOLEAN_ENUM_UINT_FLAGS) (gpointer data1, gboolean arg_1, gint arg_2, guint32 arg_3, gint arg_4, gpointer data2);
	register GMarshalFunc_VOID__BOOLEAN_ENUM_UINT_FLAGS callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 5);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOOLEAN_ENUM_UINT_FLAGS) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boolean (param_values + 1), g_value_get_enum (param_values + 2), g_value_get_uint (param_values + 3), g_value_get_flags (param_values + 4), data2);
}


static void retro_input_base_init (RetroInputIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		retro_input_signals[RETRO_INPUT_CONTROLLER_CONNECTED_SIGNAL] = g_signal_new ("controller_connected", RETRO_TYPE_INPUT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_OBJECT, G_TYPE_NONE, 2, G_TYPE_UINT, RETRO_TYPE_INPUT_DEVICE);
		retro_input_signals[RETRO_INPUT_CONTROLLER_DISCONNECTED_SIGNAL] = g_signal_new ("controller_disconnected", RETRO_TYPE_INPUT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
		/**
		 * Warns of keyboard events.
		 *
		 * @param down whether the key has been pressed or released
		 * @param keycode the core of the key
		 * @param character the character of the key
		 * @param key_modifiers the modifier key which are held
		 */
		retro_input_signals[RETRO_INPUT_KEY_EVENT_SIGNAL] = g_signal_new ("key_event", RETRO_TYPE_INPUT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOOLEAN_ENUM_UINT_FLAGS, G_TYPE_NONE, 4, G_TYPE_BOOLEAN, RETRO_TYPE_KEYBOARD_KEY, G_TYPE_UINT, RETRO_TYPE_KEYBOARD_MODIFIER_KEY);
	}
}


/**
 * An interface to render a {@link Core}'s inputs.
 */
GType retro_input_get_type (void) {
	static volatile gsize retro_input_type_id__volatile = 0;
	if (g_once_init_enter (&retro_input_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RetroInputIface), (GBaseInitFunc) retro_input_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType retro_input_type_id;
		retro_input_type_id = g_type_register_static (G_TYPE_INTERFACE, "RetroInput", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (retro_input_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&retro_input_type_id__volatile, retro_input_type_id);
	}
	return retro_input_type_id__volatile;
}



