/* game-info.c generated by valac 0.36.4, the Vala compiler
 * generated from game-info.vala, do not modify */

/* This file is part of retro-gtk. License: GPLv3*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>


#define RETRO_TYPE_GAME_INFO (retro_game_info_get_type ())
typedef struct _RetroGameInfo RetroGameInfo;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _RetroGameInfo {
	gchar* path;
	guint8* data;
	gint data_length1;
	gchar* meta;
};



GType retro_game_info_get_type (void) G_GNUC_CONST;
RetroGameInfo* retro_game_info_dup (const RetroGameInfo* self);
void retro_game_info_free (RetroGameInfo* self);
void retro_game_info_copy (const RetroGameInfo* self, RetroGameInfo* dest);
void retro_game_info_destroy (RetroGameInfo* self);
void retro_game_info_init (RetroGameInfo *self, const gchar* file_name);
void retro_game_info_init_with_data (RetroGameInfo *self, const gchar* file_name, GError** error);
static guint8* _vala_array_dup1 (guint8* self, int length);


/**
 * Sets from a game file name.
 *
 * Use this constructor if the {@link Core} needs a full path to the
 * game and not its data.
 *
 * @param file_name the game to store information from
 */
void retro_game_info_init (RetroGameInfo *self, const gchar* file_name) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	guint8* _tmp2_;
	g_return_if_fail (file_name != NULL);
	memset (self, 0, sizeof (RetroGameInfo));
	_tmp0_ = file_name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*self).path);
	(*self).path = _tmp1_;
	_tmp2_ = g_new0 (guint8, 0);
	(*self).data = (g_free ((*self).data), NULL);
	(*self).data = _tmp2_;
	(*self).data_length1 = 0;
}


/**
 * Sets from a game file name.
 *
 * Use this constructor if the {@link Core} needs the data of the
 * game.
 *
 * @param file_name the game to store information from
 * @throws FileError the file can't be read
 */
void retro_game_info_init_with_data (RetroGameInfo *self, const gchar* file_name, GError** error) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	guint8* _tmp3_ = NULL;
	size_t _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (file_name != NULL);
	memset (self, 0, sizeof (RetroGameInfo));
	_tmp0_ = file_name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*self).path);
	(*self).path = _tmp1_;
	_tmp2_ = file_name;
	g_file_get_contents (_tmp2_, (gchar**) (&_tmp3_), &_tmp4_, &_inner_error_);
	(*self).data = (g_free ((*self).data), NULL);
	(*self).data = _tmp3_;
	(*self).data_length1 = _tmp4_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == G_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static guint8* _vala_array_dup1 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


void retro_game_info_copy (const RetroGameInfo* self, RetroGameInfo* dest) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	guint8* _tmp3_;
	gint _tmp3__length1;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	_tmp0_ = (*self).path;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).path);
	(*dest).path = _tmp1_;
	_tmp2_ = (*self).data;
	_tmp2__length1 = (gint) (*self).data_length1;
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup1 (_tmp2_, _tmp2__length1) : ((gpointer) _tmp2_);
	_tmp3__length1 = _tmp2__length1;
	(*dest).data = (g_free ((*dest).data), NULL);
	(*dest).data = _tmp3_;
	(*dest).data_length1 = _tmp3__length1;
	_tmp4_ = (*self).meta;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 ((*dest).meta);
	(*dest).meta = _tmp5_;
}


void retro_game_info_destroy (RetroGameInfo* self) {
	_g_free0 ((*self).path);
	(*self).data = (g_free ((*self).data), NULL);
	_g_free0 ((*self).meta);
}


RetroGameInfo* retro_game_info_dup (const RetroGameInfo* self) {
	RetroGameInfo* dup;
	dup = g_new0 (RetroGameInfo, 1);
	retro_game_info_copy (self, dup);
	return dup;
}


void retro_game_info_free (RetroGameInfo* self) {
	retro_game_info_destroy (self);
	g_free (self);
}


GType retro_game_info_get_type (void) {
	static volatile gsize retro_game_info_type_id__volatile = 0;
	if (g_once_init_enter (&retro_game_info_type_id__volatile)) {
		GType retro_game_info_type_id;
		retro_game_info_type_id = g_boxed_type_register_static ("RetroGameInfo", (GBoxedCopyFunc) retro_game_info_dup, (GBoxedFreeFunc) retro_game_info_free);
		g_once_init_leave (&retro_game_info_type_id__volatile, retro_game_info_type_id);
	}
	return retro_game_info_type_id__volatile;
}



