/* retro-core-descriptor.c generated by valac 0.35.5, the Vala compiler
 * generated from retro-core-descriptor.vala, do not modify */

/* This file is part of retro-gtk. License: GPLv3*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define RETRO_TYPE_CORE_DESCRIPTOR (retro_core_descriptor_get_type ())
#define RETRO_CORE_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_CORE_DESCRIPTOR, RetroCoreDescriptor))
#define RETRO_CORE_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RETRO_TYPE_CORE_DESCRIPTOR, RetroCoreDescriptorClass))
#define RETRO_IS_CORE_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_CORE_DESCRIPTOR))
#define RETRO_IS_CORE_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RETRO_TYPE_CORE_DESCRIPTOR))
#define RETRO_CORE_DESCRIPTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RETRO_TYPE_CORE_DESCRIPTOR, RetroCoreDescriptorClass))

typedef struct _RetroCoreDescriptor RetroCoreDescriptor;
typedef struct _RetroCoreDescriptorClass RetroCoreDescriptorClass;
typedef struct _RetroCoreDescriptorPrivate RetroCoreDescriptorPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RETRO_CORE_DESCRIPTOR_TYPE_PLATFORM (retro_core_descriptor_platform_get_type ())
#define RETRO_CORE_DESCRIPTOR_PLATFORM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_CORE_DESCRIPTOR_TYPE_PLATFORM, RetroCoreDescriptorPlatform))
#define RETRO_CORE_DESCRIPTOR_PLATFORM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RETRO_CORE_DESCRIPTOR_TYPE_PLATFORM, RetroCoreDescriptorPlatformClass))
#define RETRO_CORE_DESCRIPTOR_IS_PLATFORM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_CORE_DESCRIPTOR_TYPE_PLATFORM))
#define RETRO_CORE_DESCRIPTOR_IS_PLATFORM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RETRO_CORE_DESCRIPTOR_TYPE_PLATFORM))
#define RETRO_CORE_DESCRIPTOR_PLATFORM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RETRO_CORE_DESCRIPTOR_TYPE_PLATFORM, RetroCoreDescriptorPlatformClass))

typedef struct _RetroCoreDescriptorPlatform RetroCoreDescriptorPlatform;
typedef struct _RetroCoreDescriptorPlatformClass RetroCoreDescriptorPlatformClass;
typedef struct _RetroCoreDescriptorPlatformPrivate RetroCoreDescriptorPlatformPrivate;

struct _RetroCoreDescriptor {
	GObject parent_instance;
	RetroCoreDescriptorPrivate * priv;
};

struct _RetroCoreDescriptorClass {
	GObjectClass parent_class;
};

struct _RetroCoreDescriptorPrivate {
	gchar* filename;
	GKeyFile* key_file;
};

typedef enum  {
	RETRO_CORE_DESCRIPTOR_ERROR_REQUIRED_GROUP_NOT_FOUND,
	RETRO_CORE_DESCRIPTOR_ERROR_REQUIRED_KEY_NOT_FOUND,
	RETRO_CORE_DESCRIPTOR_ERROR_FIRMWARE_NOT_FOUND
} RetroCoreDescriptorError;
#define RETRO_CORE_DESCRIPTOR_ERROR retro_core_descriptor_error_quark ()
struct _RetroCoreDescriptorPlatform {
	GObject parent_instance;
	RetroCoreDescriptorPlatformPrivate * priv;
};

struct _RetroCoreDescriptorPlatformClass {
	GObjectClass parent_class;
};

struct _RetroCoreDescriptorPlatformPrivate {
	GKeyFile* key_file;
	gchar* group;
};


static gpointer retro_core_descriptor_parent_class = NULL;
static gpointer retro_core_descriptor_platform_parent_class = NULL;

GType retro_core_descriptor_get_type (void) G_GNUC_CONST;
#define RETRO_CORE_DESCRIPTOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RETRO_TYPE_CORE_DESCRIPTOR, RetroCoreDescriptorPrivate))
enum  {
	RETRO_CORE_DESCRIPTOR_DUMMY_PROPERTY
};
#define RETRO_CORE_DESCRIPTOR_LIBRETRO_GROUP "Libretro"
#define RETRO_CORE_DESCRIPTOR_PLATFORM_GROUP_PREFIX "Platform:"
#define RETRO_CORE_DESCRIPTOR_FIRMWARE_GROUP_PREFIX "Firmware:"
#define RETRO_CORE_DESCRIPTOR_TYPE_KEY "Type"
#define RETRO_CORE_DESCRIPTOR_NAME_KEY "Name"
#define RETRO_CORE_DESCRIPTOR_ICON_KEY "Icon"
#define RETRO_CORE_DESCRIPTOR_MODULE_KEY "Module"
#define RETRO_CORE_DESCRIPTOR_LIBRETRO_VERSION_KEY "LibretroVersion"
#define RETRO_CORE_DESCRIPTOR_PLATFORM_MIME_TYPE_KEY "MimeType"
#define RETRO_CORE_DESCRIPTOR_PLATFORM_FIRMWARES_KEY "Firmwares"
#define RETRO_CORE_DESCRIPTOR_FIRMWARE_PATH_KEY "Path"
#define RETRO_CORE_DESCRIPTOR_FIRMWARE_MD5_KEY "MD5"
#define RETRO_CORE_DESCRIPTOR_FIRMWARE_SHA512_KEY "SHA-512"
#define RETRO_CORE_DESCRIPTOR_FIRMWARE_MANDATORY_KEY "Mandatory"
#define RETRO_CORE_DESCRIPTOR_TYPE_GAME "Game"
#define RETRO_CORE_DESCRIPTOR_TYPE_EMULATOR "Emulator"
GQuark retro_core_descriptor_error_quark (void);
RetroCoreDescriptor* retro_core_descriptor_new (const gchar* filename, GError** error);
RetroCoreDescriptor* retro_core_descriptor_construct (GType object_type, const gchar* filename, GError** error);
static void retro_core_descriptor_check_libretro_group (RetroCoreDescriptor* self, GError** error);
static void retro_core_descriptor_check_platform_group (RetroCoreDescriptor* self, const gchar* group, GError** error);
static void retro_core_descriptor_check_firmware_group (RetroCoreDescriptor* self, const gchar* group, GError** error);
gboolean retro_core_descriptor_has_icon (RetroCoreDescriptor* self, GError** error);
gchar* retro_core_descriptor_get_id (RetroCoreDescriptor* self);
gboolean retro_core_descriptor_get_is_game (RetroCoreDescriptor* self, GError** error);
gboolean retro_core_descriptor_get_is_emulator (RetroCoreDescriptor* self, GError** error);
gchar* retro_core_descriptor_get_name (RetroCoreDescriptor* self, GError** error);
GIcon* retro_core_descriptor_get_icon (RetroCoreDescriptor* self, GError** error);
gchar* retro_core_descriptor_get_module (RetroCoreDescriptor* self, GError** error);
GFile* retro_core_descriptor_get_module_file (RetroCoreDescriptor* self, GError** error);
gboolean retro_core_descriptor_has_platform (RetroCoreDescriptor* self, const gchar* platform);
gboolean retro_core_descriptor_has_firmwares (RetroCoreDescriptor* self, const gchar* platform, GError** error);
gboolean retro_core_descriptor_has_firmware_md5 (RetroCoreDescriptor* self, const gchar* firmware, GError** error);
gboolean retro_core_descriptor_has_firmware_sha512 (RetroCoreDescriptor* self, const gchar* firmware, GError** error);
gchar** retro_core_descriptor_get_mime_type (RetroCoreDescriptor* self, const gchar* platform, int* result_length1, GError** error);
gchar** retro_core_descriptor_get_firmwares (RetroCoreDescriptor* self, const gchar* platform, int* result_length1, GError** error);
gchar* retro_core_descriptor_get_firmware_path (RetroCoreDescriptor* self, const gchar* firmware, GError** error);
gchar* retro_core_descriptor_get_firmware_md5 (RetroCoreDescriptor* self, const gchar* firmware, GError** error);
gchar* retro_core_descriptor_get_firmware_sha512 (RetroCoreDescriptor* self, const gchar* firmware, GError** error);
gboolean retro_core_descriptor_get_is_firmware_mandatory (RetroCoreDescriptor* self, const gchar* firmware, GError** error);
gboolean retro_core_descriptor_get_platform_supports_mime_types (RetroCoreDescriptor* self, const gchar* platform, gchar** mime_types, int mime_types_length1, GError** error);
static gboolean _vala_string_array_contains (gchar* * stack, int stack_length, gchar* needle);
static void retro_core_descriptor_check_has_required_key (RetroCoreDescriptor* self, const gchar* group, const gchar* key, GError** error);
GType retro_core_descriptor_platform_get_type (void) G_GNUC_CONST;
#define RETRO_CORE_DESCRIPTOR_PLATFORM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RETRO_CORE_DESCRIPTOR_TYPE_PLATFORM, RetroCoreDescriptorPlatformPrivate))
enum  {
	RETRO_CORE_DESCRIPTOR_PLATFORM_DUMMY_PROPERTY
};
static RetroCoreDescriptorPlatform* retro_core_descriptor_platform_new (GKeyFile* key_file, const gchar* platform);
static RetroCoreDescriptorPlatform* retro_core_descriptor_platform_construct (GType object_type, GKeyFile* key_file, const gchar* platform);
static void retro_core_descriptor_platform_finalize (GObject * obj);
static void retro_core_descriptor_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


RetroCoreDescriptor* retro_core_descriptor_construct (GType object_type, const gchar* filename, GError** error) {
	RetroCoreDescriptor * self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GKeyFile* _tmp2_;
	GKeyFile* _tmp3_;
	const gchar* _tmp4_;
	GKeyFile* _tmp5_;
	gsize _tmp6_;
	gchar** _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (filename != NULL, NULL);
	self = (RetroCoreDescriptor*) g_object_new (object_type, NULL);
	_tmp0_ = filename;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->filename);
	self->priv->filename = _tmp1_;
	_tmp2_ = g_key_file_new ();
	_g_key_file_unref0 (self->priv->key_file);
	self->priv->key_file = _tmp2_;
	_tmp3_ = self->priv->key_file;
	_tmp4_ = filename;
	g_key_file_load_from_file (_tmp3_, _tmp4_, G_KEY_FILE_NONE, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (((_inner_error_->domain == RETRO_CORE_DESCRIPTOR_ERROR) || (_inner_error_->domain == G_KEY_FILE_ERROR)) || (_inner_error_->domain == G_FILE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	retro_core_descriptor_check_libretro_group (self, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (((_inner_error_->domain == RETRO_CORE_DESCRIPTOR_ERROR) || (_inner_error_->domain == G_KEY_FILE_ERROR)) || (_inner_error_->domain == G_FILE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp5_ = self->priv->key_file;
	_tmp7_ = g_key_file_get_groups (_tmp5_, &_tmp6_);
	{
		gchar** group_collection = NULL;
		gint group_collection_length1 = 0;
		gint _group_collection_size_ = 0;
		gint group_it = 0;
		group_collection = _tmp7_;
		group_collection_length1 = _tmp6_;
		for (group_it = 0; group_it < _tmp6_; group_it = group_it + 1) {
			gchar* _tmp8_;
			gchar* group = NULL;
			_tmp8_ = g_strdup (group_collection[group_it]);
			group = _tmp8_;
			{
				const gchar* _tmp9_;
				gboolean _tmp10_;
				_tmp9_ = group;
				_tmp10_ = g_str_has_prefix (_tmp9_, RETRO_CORE_DESCRIPTOR_PLATFORM_GROUP_PREFIX);
				if (_tmp10_) {
					const gchar* _tmp11_;
					_tmp11_ = group;
					retro_core_descriptor_check_platform_group (self, _tmp11_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (((_inner_error_->domain == RETRO_CORE_DESCRIPTOR_ERROR) || (_inner_error_->domain == G_KEY_FILE_ERROR)) || (_inner_error_->domain == G_FILE_ERROR)) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (group);
							group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
							_g_object_unref0 (self);
							return NULL;
						} else {
							_g_free0 (group);
							group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
				} else {
					const gchar* _tmp12_;
					gboolean _tmp13_;
					_tmp12_ = group;
					_tmp13_ = g_str_has_prefix (_tmp12_, RETRO_CORE_DESCRIPTOR_FIRMWARE_GROUP_PREFIX);
					if (_tmp13_) {
						const gchar* _tmp14_;
						_tmp14_ = group;
						retro_core_descriptor_check_firmware_group (self, _tmp14_, &_inner_error_);
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							if (((_inner_error_->domain == RETRO_CORE_DESCRIPTOR_ERROR) || (_inner_error_->domain == G_KEY_FILE_ERROR)) || (_inner_error_->domain == G_FILE_ERROR)) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (group);
								group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
								_g_object_unref0 (self);
								return NULL;
							} else {
								_g_free0 (group);
								group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
					}
				}
				_g_free0 (group);
			}
		}
		group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	return self;
}


RetroCoreDescriptor* retro_core_descriptor_new (const gchar* filename, GError** error) {
	return retro_core_descriptor_construct (RETRO_TYPE_CORE_DESCRIPTOR, filename, error);
}


gboolean retro_core_descriptor_has_icon (RetroCoreDescriptor* self, GError** error) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	GKeyFile* _tmp1_;
	gboolean _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->key_file;
	_tmp2_ = g_key_file_has_key (_tmp1_, RETRO_CORE_DESCRIPTOR_LIBRETRO_GROUP, RETRO_CORE_DESCRIPTOR_ICON_KEY, &_inner_error_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			gboolean _tmp3_ = FALSE;
			g_propagate_error (error, _inner_error_);
			return _tmp3_;
		} else {
			gboolean _tmp4_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp4_;
		}
	}
	result = _tmp0_;
	return result;
}


gchar* retro_core_descriptor_get_id (RetroCoreDescriptor* self) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->filename;
	_tmp1_ = g_path_get_basename (_tmp0_);
	result = _tmp1_;
	return result;
}


gboolean retro_core_descriptor_get_is_game (RetroCoreDescriptor* self, GError** error) {
	gboolean result = FALSE;
	gchar* _tmp0_;
	GKeyFile* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->key_file;
	_tmp2_ = g_key_file_get_string (_tmp1_, RETRO_CORE_DESCRIPTOR_LIBRETRO_GROUP, RETRO_CORE_DESCRIPTOR_TYPE_KEY, &_inner_error_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			gboolean _tmp3_ = FALSE;
			g_propagate_error (error, _inner_error_);
			return _tmp3_;
		} else {
			gboolean _tmp4_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp4_;
		}
	}
	_tmp5_ = _tmp0_;
	_tmp0_ = NULL;
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strcmp0 (_tmp6_, RETRO_CORE_DESCRIPTOR_TYPE_GAME) == 0;
	_g_free0 (_tmp6_);
	result = _tmp7_;
	_g_free0 (_tmp0_);
	return result;
}


gboolean retro_core_descriptor_get_is_emulator (RetroCoreDescriptor* self, GError** error) {
	gboolean result = FALSE;
	gchar* _tmp0_;
	GKeyFile* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->key_file;
	_tmp2_ = g_key_file_get_string (_tmp1_, RETRO_CORE_DESCRIPTOR_LIBRETRO_GROUP, RETRO_CORE_DESCRIPTOR_TYPE_KEY, &_inner_error_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			gboolean _tmp3_ = FALSE;
			g_propagate_error (error, _inner_error_);
			return _tmp3_;
		} else {
			gboolean _tmp4_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp4_;
		}
	}
	_tmp5_ = _tmp0_;
	_tmp0_ = NULL;
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strcmp0 (_tmp6_, RETRO_CORE_DESCRIPTOR_TYPE_EMULATOR) == 0;
	_g_free0 (_tmp6_);
	result = _tmp7_;
	_g_free0 (_tmp0_);
	return result;
}


gchar* retro_core_descriptor_get_name (RetroCoreDescriptor* self, GError** error) {
	gchar* result = NULL;
	gchar* _tmp0_;
	GKeyFile* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->key_file;
	_tmp2_ = g_key_file_get_string (_tmp1_, RETRO_CORE_DESCRIPTOR_LIBRETRO_GROUP, RETRO_CORE_DESCRIPTOR_NAME_KEY, &_inner_error_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp3_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp3_;
	_g_free0 (_tmp0_);
	return result;
}


GIcon* retro_core_descriptor_get_icon (RetroCoreDescriptor* self, GError** error) {
	GIcon* result = NULL;
	gchar* icon_name;
	GKeyFile* _tmp0_;
	gchar* _tmp1_;
	GThemedIcon* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->key_file;
	_tmp1_ = g_key_file_get_string (_tmp0_, RETRO_CORE_DESCRIPTOR_LIBRETRO_GROUP, RETRO_CORE_DESCRIPTOR_ICON_KEY, &_inner_error_);
	icon_name = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp2_ = (GThemedIcon*) g_themed_icon_new (icon_name);
	result = (GIcon*) _tmp2_;
	_g_free0 (icon_name);
	return result;
}


gchar* retro_core_descriptor_get_module (RetroCoreDescriptor* self, GError** error) {
	gchar* result = NULL;
	gchar* _tmp0_;
	GKeyFile* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->key_file;
	_tmp2_ = g_key_file_get_string (_tmp1_, RETRO_CORE_DESCRIPTOR_LIBRETRO_GROUP, RETRO_CORE_DESCRIPTOR_MODULE_KEY, &_inner_error_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp3_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp3_;
	_g_free0 (_tmp0_);
	return result;
}


GFile* retro_core_descriptor_get_module_file (RetroCoreDescriptor* self, GError** error) {
	GFile* result = NULL;
	GFile* file;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GFile* dir;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	gchar* module;
	gchar* _tmp5_;
	GFile* module_file;
	GFile* _tmp6_;
	const gchar* _tmp7_;
	GFile* _tmp8_;
	GFile* _tmp9_;
	gboolean _tmp10_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->filename;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	file = _tmp1_;
	_tmp2_ = file;
	_tmp3_ = g_file_get_parent (_tmp2_);
	dir = _tmp3_;
	_tmp4_ = dir;
	if (_tmp4_ == NULL) {
		result = NULL;
		_g_object_unref0 (dir);
		_g_object_unref0 (file);
		return result;
	}
	_tmp5_ = retro_core_descriptor_get_module (self, &_inner_error_);
	module = _tmp5_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (dir);
			_g_object_unref0 (file);
			return NULL;
		} else {
			_g_object_unref0 (dir);
			_g_object_unref0 (file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp6_ = dir;
	_tmp7_ = module;
	_tmp8_ = g_file_get_child (_tmp6_, _tmp7_);
	module_file = _tmp8_;
	_tmp9_ = module_file;
	_tmp10_ = g_file_query_exists (_tmp9_, NULL);
	if (!_tmp10_) {
		result = NULL;
		_g_object_unref0 (module_file);
		_g_free0 (module);
		_g_object_unref0 (dir);
		_g_object_unref0 (file);
		return result;
	}
	result = module_file;
	_g_free0 (module);
	_g_object_unref0 (dir);
	_g_object_unref0 (file);
	return result;
}


gboolean retro_core_descriptor_has_platform (RetroCoreDescriptor* self, const gchar* platform) {
	gboolean result = FALSE;
	GKeyFile* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (platform != NULL, FALSE);
	_tmp0_ = self->priv->key_file;
	_tmp1_ = platform;
	_tmp2_ = g_strconcat (RETRO_CORE_DESCRIPTOR_PLATFORM_GROUP_PREFIX, _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_key_file_has_group (_tmp0_, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	result = _tmp5_;
	return result;
}


gboolean retro_core_descriptor_has_firmwares (RetroCoreDescriptor* self, const gchar* platform, GError** error) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	GKeyFile* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (platform != NULL, FALSE);
	_tmp1_ = self->priv->key_file;
	_tmp2_ = platform;
	_tmp3_ = g_strconcat (RETRO_CORE_DESCRIPTOR_PLATFORM_GROUP_PREFIX, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_key_file_has_key (_tmp1_, _tmp4_, RETRO_CORE_DESCRIPTOR_PLATFORM_FIRMWARES_KEY, &_inner_error_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_tmp0_ = _tmp6_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			gboolean _tmp7_ = FALSE;
			g_propagate_error (error, _inner_error_);
			return _tmp7_;
		} else {
			gboolean _tmp8_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp8_;
		}
	}
	result = _tmp0_;
	return result;
}


gboolean retro_core_descriptor_has_firmware_md5 (RetroCoreDescriptor* self, const gchar* firmware, GError** error) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	GKeyFile* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (firmware != NULL, FALSE);
	_tmp1_ = self->priv->key_file;
	_tmp2_ = firmware;
	_tmp3_ = g_strconcat (RETRO_CORE_DESCRIPTOR_FIRMWARE_GROUP_PREFIX, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_key_file_has_key (_tmp1_, _tmp4_, RETRO_CORE_DESCRIPTOR_FIRMWARE_MD5_KEY, &_inner_error_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_tmp0_ = _tmp6_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			gboolean _tmp7_ = FALSE;
			g_propagate_error (error, _inner_error_);
			return _tmp7_;
		} else {
			gboolean _tmp8_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp8_;
		}
	}
	result = _tmp0_;
	return result;
}


gboolean retro_core_descriptor_has_firmware_sha512 (RetroCoreDescriptor* self, const gchar* firmware, GError** error) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	GKeyFile* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (firmware != NULL, FALSE);
	_tmp1_ = self->priv->key_file;
	_tmp2_ = firmware;
	_tmp3_ = g_strconcat (RETRO_CORE_DESCRIPTOR_FIRMWARE_GROUP_PREFIX, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_key_file_has_key (_tmp1_, _tmp4_, RETRO_CORE_DESCRIPTOR_FIRMWARE_SHA512_KEY, &_inner_error_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_tmp0_ = _tmp6_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			gboolean _tmp7_ = FALSE;
			g_propagate_error (error, _inner_error_);
			return _tmp7_;
		} else {
			gboolean _tmp8_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp8_;
		}
	}
	result = _tmp0_;
	return result;
}


gchar** retro_core_descriptor_get_mime_type (RetroCoreDescriptor* self, const gchar* platform, int* result_length1, GError** error) {
	gchar** result = NULL;
	gchar** _tmp0_;
	GKeyFile* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gsize _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gint _tmp0__length1;
	gint __tmp0__size_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gchar** _tmp9_;
	gint _tmp9__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (platform != NULL, NULL);
	_tmp1_ = self->priv->key_file;
	_tmp2_ = platform;
	_tmp3_ = g_strconcat (RETRO_CORE_DESCRIPTOR_PLATFORM_GROUP_PREFIX, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp6_ = g_key_file_get_string_list (_tmp1_, _tmp4_, RETRO_CORE_DESCRIPTOR_PLATFORM_MIME_TYPE_KEY, &_tmp5_, &_inner_error_);
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp5_;
	_g_free0 (_tmp4_);
	_tmp0_ = _tmp7_;
	_tmp0__length1 = _tmp7__length1;
	__tmp0__size_ = _tmp0__length1;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp8_ = _tmp0_;
	_tmp8__length1 = _tmp0__length1;
	_tmp0_ = NULL;
	_tmp0__length1 = 0;
	_tmp9_ = _tmp8_;
	_tmp9__length1 = _tmp8__length1;
	if (result_length1) {
		*result_length1 = _tmp9__length1;
	}
	result = _tmp9_;
	_tmp0_ = (_vala_array_free (_tmp0_, _tmp0__length1, (GDestroyNotify) g_free), NULL);
	return result;
}


gchar** retro_core_descriptor_get_firmwares (RetroCoreDescriptor* self, const gchar* platform, int* result_length1, GError** error) {
	gchar** result = NULL;
	gchar** _tmp0_;
	GKeyFile* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gsize _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gint _tmp0__length1;
	gint __tmp0__size_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gchar** _tmp9_;
	gint _tmp9__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (platform != NULL, NULL);
	_tmp1_ = self->priv->key_file;
	_tmp2_ = platform;
	_tmp3_ = g_strconcat (RETRO_CORE_DESCRIPTOR_PLATFORM_GROUP_PREFIX, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp6_ = g_key_file_get_string_list (_tmp1_, _tmp4_, RETRO_CORE_DESCRIPTOR_PLATFORM_FIRMWARES_KEY, &_tmp5_, &_inner_error_);
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp5_;
	_g_free0 (_tmp4_);
	_tmp0_ = _tmp7_;
	_tmp0__length1 = _tmp7__length1;
	__tmp0__size_ = _tmp0__length1;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp8_ = _tmp0_;
	_tmp8__length1 = _tmp0__length1;
	_tmp0_ = NULL;
	_tmp0__length1 = 0;
	_tmp9_ = _tmp8_;
	_tmp9__length1 = _tmp8__length1;
	if (result_length1) {
		*result_length1 = _tmp9__length1;
	}
	result = _tmp9_;
	_tmp0_ = (_vala_array_free (_tmp0_, _tmp0__length1, (GDestroyNotify) g_free), NULL);
	return result;
}


gchar* retro_core_descriptor_get_firmware_path (RetroCoreDescriptor* self, const gchar* firmware, GError** error) {
	gchar* result = NULL;
	gchar* _tmp0_;
	GKeyFile* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (firmware != NULL, NULL);
	_tmp1_ = self->priv->key_file;
	_tmp2_ = firmware;
	_tmp3_ = g_strconcat (RETRO_CORE_DESCRIPTOR_FIRMWARE_GROUP_PREFIX, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_key_file_get_string (_tmp1_, _tmp4_, RETRO_CORE_DESCRIPTOR_FIRMWARE_PATH_KEY, &_inner_error_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_tmp0_ = _tmp6_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp7_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp7_;
	_g_free0 (_tmp0_);
	return result;
}


gchar* retro_core_descriptor_get_firmware_md5 (RetroCoreDescriptor* self, const gchar* firmware, GError** error) {
	gchar* result = NULL;
	gchar* _tmp0_;
	GKeyFile* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (firmware != NULL, NULL);
	_tmp1_ = self->priv->key_file;
	_tmp2_ = firmware;
	_tmp3_ = g_strconcat (RETRO_CORE_DESCRIPTOR_FIRMWARE_GROUP_PREFIX, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_key_file_get_string (_tmp1_, _tmp4_, RETRO_CORE_DESCRIPTOR_FIRMWARE_MD5_KEY, &_inner_error_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_tmp0_ = _tmp6_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp7_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp7_;
	_g_free0 (_tmp0_);
	return result;
}


gchar* retro_core_descriptor_get_firmware_sha512 (RetroCoreDescriptor* self, const gchar* firmware, GError** error) {
	gchar* result = NULL;
	gchar* _tmp0_;
	GKeyFile* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (firmware != NULL, NULL);
	_tmp1_ = self->priv->key_file;
	_tmp2_ = firmware;
	_tmp3_ = g_strconcat (RETRO_CORE_DESCRIPTOR_FIRMWARE_GROUP_PREFIX, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_key_file_get_string (_tmp1_, _tmp4_, RETRO_CORE_DESCRIPTOR_FIRMWARE_SHA512_KEY, &_inner_error_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_tmp0_ = _tmp6_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp7_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp7_;
	_g_free0 (_tmp0_);
	return result;
}


gboolean retro_core_descriptor_get_is_firmware_mandatory (RetroCoreDescriptor* self, const gchar* firmware, GError** error) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	GKeyFile* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (firmware != NULL, FALSE);
	_tmp1_ = self->priv->key_file;
	_tmp2_ = firmware;
	_tmp3_ = g_strconcat (RETRO_CORE_DESCRIPTOR_FIRMWARE_GROUP_PREFIX, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_key_file_get_boolean (_tmp1_, _tmp4_, RETRO_CORE_DESCRIPTOR_FIRMWARE_MANDATORY_KEY, &_inner_error_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_tmp0_ = _tmp6_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			gboolean _tmp7_ = FALSE;
			g_propagate_error (error, _inner_error_);
			return _tmp7_;
		} else {
			gboolean _tmp8_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp8_;
		}
	}
	result = _tmp0_;
	return result;
}


static gboolean _vala_string_array_contains (gchar* * stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


gboolean retro_core_descriptor_get_platform_supports_mime_types (RetroCoreDescriptor* self, const gchar* platform, gchar** mime_types, int mime_types_length1, GError** error) {
	gboolean result = FALSE;
	gchar** supported_mime_types;
	const gchar* _tmp0_;
	gint _tmp1_;
	gchar** _tmp2_;
	gint supported_mime_types_length1;
	gint _supported_mime_types_size_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (platform != NULL, FALSE);
	_tmp0_ = platform;
	_tmp2_ = retro_core_descriptor_get_mime_type (self, _tmp0_, &_tmp1_, &_inner_error_);
	supported_mime_types = _tmp2_;
	supported_mime_types_length1 = _tmp1_;
	_supported_mime_types_size_ = supported_mime_types_length1;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			gboolean _tmp3_ = FALSE;
			g_propagate_error (error, _inner_error_);
			return _tmp3_;
		} else {
			gboolean _tmp4_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp4_;
		}
	}
	_tmp5_ = mime_types;
	_tmp5__length1 = mime_types_length1;
	{
		gchar** mime_type_collection = NULL;
		gint mime_type_collection_length1 = 0;
		gint _mime_type_collection_size_ = 0;
		gint mime_type_it = 0;
		mime_type_collection = _tmp5_;
		mime_type_collection_length1 = _tmp5__length1;
		for (mime_type_it = 0; mime_type_it < _tmp5__length1; mime_type_it = mime_type_it + 1) {
			gchar* _tmp6_;
			gchar* mime_type = NULL;
			_tmp6_ = g_strdup (mime_type_collection[mime_type_it]);
			mime_type = _tmp6_;
			{
				const gchar* _tmp7_;
				_tmp7_ = mime_type;
				if (!_vala_string_array_contains (supported_mime_types, supported_mime_types_length1, _tmp7_)) {
					result = FALSE;
					_g_free0 (mime_type);
					supported_mime_types = (_vala_array_free (supported_mime_types, supported_mime_types_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
				_g_free0 (mime_type);
			}
		}
	}
	result = TRUE;
	supported_mime_types = (_vala_array_free (supported_mime_types, supported_mime_types_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void retro_core_descriptor_check_libretro_group (RetroCoreDescriptor* self, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	retro_core_descriptor_check_has_required_key (self, RETRO_CORE_DESCRIPTOR_LIBRETRO_GROUP, RETRO_CORE_DESCRIPTOR_TYPE_KEY, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == RETRO_CORE_DESCRIPTOR_ERROR) || (_inner_error_->domain == G_KEY_FILE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	retro_core_descriptor_check_has_required_key (self, RETRO_CORE_DESCRIPTOR_LIBRETRO_GROUP, RETRO_CORE_DESCRIPTOR_NAME_KEY, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == RETRO_CORE_DESCRIPTOR_ERROR) || (_inner_error_->domain == G_KEY_FILE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	retro_core_descriptor_check_has_required_key (self, RETRO_CORE_DESCRIPTOR_LIBRETRO_GROUP, RETRO_CORE_DESCRIPTOR_MODULE_KEY, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == RETRO_CORE_DESCRIPTOR_ERROR) || (_inner_error_->domain == G_KEY_FILE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	retro_core_descriptor_check_has_required_key (self, RETRO_CORE_DESCRIPTOR_LIBRETRO_GROUP, RETRO_CORE_DESCRIPTOR_LIBRETRO_VERSION_KEY, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == RETRO_CORE_DESCRIPTOR_ERROR) || (_inner_error_->domain == G_KEY_FILE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void retro_core_descriptor_check_platform_group (RetroCoreDescriptor* self, const gchar* group, GError** error) {
	const gchar* _tmp0_;
	gboolean _tmp1_;
	GKeyFile* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	_tmp0_ = group;
	retro_core_descriptor_check_has_required_key (self, _tmp0_, RETRO_CORE_DESCRIPTOR_PLATFORM_MIME_TYPE_KEY, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == RETRO_CORE_DESCRIPTOR_ERROR) || (_inner_error_->domain == G_KEY_FILE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp2_ = self->priv->key_file;
	_tmp3_ = group;
	_tmp4_ = g_key_file_has_key (_tmp2_, _tmp3_, RETRO_CORE_DESCRIPTOR_PLATFORM_FIRMWARES_KEY, &_inner_error_);
	_tmp1_ = _tmp4_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == RETRO_CORE_DESCRIPTOR_ERROR) || (_inner_error_->domain == G_KEY_FILE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (_tmp1_) {
		gchar** _tmp5_;
		GKeyFile* _tmp6_;
		const gchar* _tmp7_;
		gsize _tmp8_;
		gchar** _tmp9_;
		gint _tmp5__length1;
		gint __tmp5__size_;
		gchar** _tmp10_;
		gint _tmp10__length1;
		_tmp6_ = self->priv->key_file;
		_tmp7_ = group;
		_tmp9_ = g_key_file_get_string_list (_tmp6_, _tmp7_, RETRO_CORE_DESCRIPTOR_PLATFORM_FIRMWARES_KEY, &_tmp8_, &_inner_error_);
		_tmp5_ = _tmp9_;
		_tmp5__length1 = _tmp8_;
		__tmp5__size_ = _tmp5__length1;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if ((_inner_error_->domain == RETRO_CORE_DESCRIPTOR_ERROR) || (_inner_error_->domain == G_KEY_FILE_ERROR)) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp10_ = _tmp5_;
		_tmp10__length1 = _tmp5__length1;
		_tmp5_ = NULL;
		_tmp5__length1 = 0;
		{
			gchar** firmware_collection = NULL;
			gint firmware_collection_length1 = 0;
			gint _firmware_collection_size_ = 0;
			gint firmware_it = 0;
			firmware_collection = _tmp10_;
			firmware_collection_length1 = _tmp10__length1;
			for (firmware_it = 0; firmware_it < _tmp10__length1; firmware_it = firmware_it + 1) {
				gchar* _tmp11_;
				gchar* firmware = NULL;
				_tmp11_ = g_strdup (firmware_collection[firmware_it]);
				firmware = _tmp11_;
				{
					GKeyFile* _tmp12_;
					const gchar* _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					gboolean _tmp16_;
					gboolean _tmp17_;
					_tmp12_ = self->priv->key_file;
					_tmp13_ = firmware;
					_tmp14_ = g_strconcat (RETRO_CORE_DESCRIPTOR_FIRMWARE_GROUP_PREFIX, _tmp13_, NULL);
					_tmp15_ = _tmp14_;
					_tmp16_ = g_key_file_has_group (_tmp12_, _tmp15_);
					_tmp17_ = !_tmp16_;
					_g_free0 (_tmp15_);
					if (_tmp17_) {
						const gchar* _tmp18_;
						const gchar* _tmp19_;
						gchar* _tmp20_;
						gchar* _tmp21_;
						const gchar* _tmp22_;
						GError* _tmp23_;
						GError* _tmp24_;
						_tmp18_ = self->priv->filename;
						_tmp19_ = firmware;
						_tmp20_ = g_strconcat (RETRO_CORE_DESCRIPTOR_FIRMWARE_GROUP_PREFIX, _tmp19_, NULL);
						_tmp21_ = _tmp20_;
						_tmp22_ = group;
						_tmp23_ = g_error_new (RETRO_CORE_DESCRIPTOR_ERROR, RETRO_CORE_DESCRIPTOR_ERROR_FIRMWARE_NOT_FOUND, "%s isn't a valid Libretro core descriptor: [%s] mentioned in [%s] not " \
"found.", _tmp18_, _tmp21_, _tmp22_);
						_tmp24_ = _tmp23_;
						_g_free0 (_tmp21_);
						_inner_error_ = _tmp24_;
						if ((_inner_error_->domain == RETRO_CORE_DESCRIPTOR_ERROR) || (_inner_error_->domain == G_KEY_FILE_ERROR)) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (firmware);
							firmware_collection = (_vala_array_free (firmware_collection, firmware_collection_length1, (GDestroyNotify) g_free), NULL);
							_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
							return;
						} else {
							_g_free0 (firmware);
							firmware_collection = (_vala_array_free (firmware_collection, firmware_collection_length1, (GDestroyNotify) g_free), NULL);
							_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					_g_free0 (firmware);
				}
			}
			firmware_collection = (_vala_array_free (firmware_collection, firmware_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
	}
}


static void retro_core_descriptor_check_firmware_group (RetroCoreDescriptor* self, const gchar* group, GError** error) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	_tmp0_ = group;
	retro_core_descriptor_check_has_required_key (self, _tmp0_, RETRO_CORE_DESCRIPTOR_FIRMWARE_PATH_KEY, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == RETRO_CORE_DESCRIPTOR_ERROR) || (_inner_error_->domain == G_KEY_FILE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp1_ = group;
	retro_core_descriptor_check_has_required_key (self, _tmp1_, RETRO_CORE_DESCRIPTOR_FIRMWARE_MANDATORY_KEY, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == RETRO_CORE_DESCRIPTOR_ERROR) || (_inner_error_->domain == G_KEY_FILE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void retro_core_descriptor_check_has_required_key (RetroCoreDescriptor* self, const gchar* group, const gchar* key, GError** error) {
	gboolean _tmp0_;
	GKeyFile* _tmp1_;
	gboolean _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	g_return_if_fail (key != NULL);
	_tmp1_ = self->priv->key_file;
	_tmp2_ = g_key_file_has_key (_tmp1_, RETRO_CORE_DESCRIPTOR_LIBRETRO_GROUP, RETRO_CORE_DESCRIPTOR_TYPE_KEY, &_inner_error_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == RETRO_CORE_DESCRIPTOR_ERROR) || (_inner_error_->domain == G_KEY_FILE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (!_tmp0_) {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		GError* _tmp6_;
		_tmp3_ = self->priv->filename;
		_tmp4_ = key;
		_tmp5_ = group;
		_tmp6_ = g_error_new (RETRO_CORE_DESCRIPTOR_ERROR, RETRO_CORE_DESCRIPTOR_ERROR_REQUIRED_KEY_NOT_FOUND, "%s isn't a valid Libretro core descriptor: required key %s not found i" \
"n group [%s].", _tmp3_, _tmp4_, _tmp5_);
		_inner_error_ = _tmp6_;
		if ((_inner_error_->domain == RETRO_CORE_DESCRIPTOR_ERROR) || (_inner_error_->domain == G_KEY_FILE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static gpointer _g_key_file_ref0 (gpointer self) {
	return self ? g_key_file_ref (self) : NULL;
}


static RetroCoreDescriptorPlatform* retro_core_descriptor_platform_construct (GType object_type, GKeyFile* key_file, const gchar* platform) {
	RetroCoreDescriptorPlatform * self = NULL;
	GKeyFile* _tmp0_;
	GKeyFile* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (key_file != NULL, NULL);
	g_return_val_if_fail (platform != NULL, NULL);
	self = (RetroCoreDescriptorPlatform*) g_object_new (object_type, NULL);
	_tmp0_ = key_file;
	_tmp1_ = _g_key_file_ref0 (_tmp0_);
	_g_key_file_unref0 (self->priv->key_file);
	self->priv->key_file = _tmp1_;
	_tmp2_ = platform;
	_tmp3_ = g_strconcat (RETRO_CORE_DESCRIPTOR_PLATFORM_GROUP_PREFIX, _tmp2_, NULL);
	_g_free0 (self->priv->group);
	self->priv->group = _tmp3_;
	return self;
}


static RetroCoreDescriptorPlatform* retro_core_descriptor_platform_new (GKeyFile* key_file, const gchar* platform) {
	return retro_core_descriptor_platform_construct (RETRO_CORE_DESCRIPTOR_TYPE_PLATFORM, key_file, platform);
}


static void retro_core_descriptor_platform_class_init (RetroCoreDescriptorPlatformClass * klass) {
	retro_core_descriptor_platform_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RetroCoreDescriptorPlatformPrivate));
	G_OBJECT_CLASS (klass)->finalize = retro_core_descriptor_platform_finalize;
}


static void retro_core_descriptor_platform_instance_init (RetroCoreDescriptorPlatform * self) {
	self->priv = RETRO_CORE_DESCRIPTOR_PLATFORM_GET_PRIVATE (self);
}


static void retro_core_descriptor_platform_finalize (GObject * obj) {
	RetroCoreDescriptorPlatform * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RETRO_CORE_DESCRIPTOR_TYPE_PLATFORM, RetroCoreDescriptorPlatform);
	_g_key_file_unref0 (self->priv->key_file);
	_g_free0 (self->priv->group);
	G_OBJECT_CLASS (retro_core_descriptor_platform_parent_class)->finalize (obj);
}


GType retro_core_descriptor_platform_get_type (void) {
	static volatile gsize retro_core_descriptor_platform_type_id__volatile = 0;
	if (g_once_init_enter (&retro_core_descriptor_platform_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RetroCoreDescriptorPlatformClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) retro_core_descriptor_platform_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RetroCoreDescriptorPlatform), 0, (GInstanceInitFunc) retro_core_descriptor_platform_instance_init, NULL };
		GType retro_core_descriptor_platform_type_id;
		retro_core_descriptor_platform_type_id = g_type_register_static (G_TYPE_OBJECT, "RetroCoreDescriptorPlatform", &g_define_type_info, 0);
		g_once_init_leave (&retro_core_descriptor_platform_type_id__volatile, retro_core_descriptor_platform_type_id);
	}
	return retro_core_descriptor_platform_type_id__volatile;
}


static void retro_core_descriptor_class_init (RetroCoreDescriptorClass * klass) {
	retro_core_descriptor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RetroCoreDescriptorPrivate));
	G_OBJECT_CLASS (klass)->finalize = retro_core_descriptor_finalize;
}


static void retro_core_descriptor_instance_init (RetroCoreDescriptor * self) {
	self->priv = RETRO_CORE_DESCRIPTOR_GET_PRIVATE (self);
}


static void retro_core_descriptor_finalize (GObject * obj) {
	RetroCoreDescriptor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RETRO_TYPE_CORE_DESCRIPTOR, RetroCoreDescriptor);
	_g_free0 (self->priv->filename);
	_g_key_file_unref0 (self->priv->key_file);
	G_OBJECT_CLASS (retro_core_descriptor_parent_class)->finalize (obj);
}


GType retro_core_descriptor_get_type (void) {
	static volatile gsize retro_core_descriptor_type_id__volatile = 0;
	if (g_once_init_enter (&retro_core_descriptor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RetroCoreDescriptorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) retro_core_descriptor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RetroCoreDescriptor), 0, (GInstanceInitFunc) retro_core_descriptor_instance_init, NULL };
		GType retro_core_descriptor_type_id;
		retro_core_descriptor_type_id = g_type_register_static (G_TYPE_OBJECT, "RetroCoreDescriptor", &g_define_type_info, 0);
		g_once_init_leave (&retro_core_descriptor_type_id__volatile, retro_core_descriptor_type_id);
	}
	return retro_core_descriptor_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



