/* disk-controller.c generated by valac 0.35.5, the Vala compiler
 * generated from disk-controller.vala, do not modify */

/* This file is part of retro-gtk. License: GPLv3*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define RETRO_TYPE_DISK_CONTROL (retro_disk_control_get_type ())
#define RETRO_DISK_CONTROL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_DISK_CONTROL, RetroDiskControl))
#define RETRO_DISK_CONTROL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RETRO_TYPE_DISK_CONTROL, RetroDiskControlClass))
#define RETRO_IS_DISK_CONTROL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_DISK_CONTROL))
#define RETRO_IS_DISK_CONTROL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RETRO_TYPE_DISK_CONTROL))
#define RETRO_DISK_CONTROL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RETRO_TYPE_DISK_CONTROL, RetroDiskControlClass))

typedef struct _RetroDiskControl RetroDiskControl;
typedef struct _RetroDiskControlClass RetroDiskControlClass;
typedef struct _RetroDiskControlPrivate RetroDiskControlPrivate;

#define RETRO_TYPE_CORE (retro_core_get_type ())
#define RETRO_CORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_CORE, RetroCore))
#define RETRO_CORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RETRO_TYPE_CORE, RetroCoreClass))
#define RETRO_IS_CORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_CORE))
#define RETRO_IS_CORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RETRO_TYPE_CORE))
#define RETRO_CORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RETRO_TYPE_CORE, RetroCoreClass))

typedef struct _RetroCore RetroCore;
typedef struct _RetroCoreClass RetroCoreClass;

#define RETRO_TYPE_DISK_CONTROL_CALLBACK (retro_disk_control_callback_get_type ())

#define RETRO_TYPE_GAME_INFO (retro_game_info_get_type ())
typedef struct _RetroGameInfo RetroGameInfo;
typedef struct _RetroDiskControlCallback RetroDiskControlCallback;

struct _RetroDiskControl {
	GObject parent_instance;
	RetroDiskControlPrivate * priv;
};

struct _RetroDiskControlClass {
	GObjectClass parent_class;
};

typedef gboolean (*RetroDiskControlCallbackSetEjectState) (gboolean ejected);
typedef gboolean (*RetroDiskControlCallbackGetEjectState) ();
typedef guint (*RetroDiskControlCallbackGetImageIndex) ();
typedef gboolean (*RetroDiskControlCallbackSetImageIndex) (guint index);
typedef guint (*RetroDiskControlCallbackGetNumImages) ();
struct _RetroGameInfo {
	gchar* path;
	guint8* data;
	gint data_length1;
	gchar* meta;
};

typedef gboolean (*RetroDiskControlCallbackReplaceImageIndex) (guint index, RetroGameInfo* info);
typedef gboolean (*RetroDiskControlCallbackAddImageIndex) ();
struct _RetroDiskControlCallback {
	RetroDiskControlCallbackSetEjectState set_eject_state;
	RetroDiskControlCallbackGetEjectState get_eject_state;
	RetroDiskControlCallbackGetImageIndex get_image_index;
	RetroDiskControlCallbackSetImageIndex set_image_index;
	RetroDiskControlCallbackGetNumImages get_num_images;
	RetroDiskControlCallbackReplaceImageIndex replace_image_index;
	RetroDiskControlCallbackAddImageIndex add_image_index;
};

struct _RetroDiskControlPrivate {
	RetroCore* core;
	RetroDiskControlCallback callback_struct;
};

typedef enum  {
	RETRO_CB_ERROR_NO_CORE,
	RETRO_CB_ERROR_NO_CALLBACK
} RetroCbError;
#define RETRO_CB_ERROR retro_cb_error_quark ()

static gpointer retro_disk_control_parent_class = NULL;

GType retro_disk_control_get_type (void) G_GNUC_CONST;
GType retro_core_get_type (void) G_GNUC_CONST;
GType retro_disk_control_callback_get_type (void) G_GNUC_CONST;
GType retro_game_info_get_type (void) G_GNUC_CONST;
RetroGameInfo* retro_game_info_dup (const RetroGameInfo* self);
void retro_game_info_free (RetroGameInfo* self);
void retro_game_info_copy (const RetroGameInfo* self, RetroGameInfo* dest);
void retro_game_info_destroy (RetroGameInfo* self);
RetroDiskControlCallback* retro_disk_control_callback_dup (const RetroDiskControlCallback* self);
void retro_disk_control_callback_free (RetroDiskControlCallback* self);
#define RETRO_DISK_CONTROL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RETRO_TYPE_DISK_CONTROL, RetroDiskControlPrivate))
enum  {
	RETRO_DISK_CONTROL_DUMMY_PROPERTY
};
RetroDiskControl* retro_disk_control_new (RetroCore* core, RetroDiskControlCallback* callback_struct);
RetroDiskControl* retro_disk_control_construct (GType object_type, RetroCore* core, RetroDiskControlCallback* callback_struct);
GQuark retro_cb_error_quark (void);
gboolean retro_disk_control_set_eject_state (RetroDiskControl* self, gboolean ejected, GError** error);
void retro_core_push_cb_data (RetroCore* self);
void retro_core_pop_cb_data (void);
gboolean retro_disk_control_get_eject_state (RetroDiskControl* self, GError** error);
gboolean retro_disk_control_set_image_index (RetroDiskControl* self, guint image_index, GError** error);
guint retro_disk_control_get_image_index (RetroDiskControl* self, GError** error);
guint retro_disk_control_get_num_images (RetroDiskControl* self, GError** error);
gboolean retro_disk_control_replace_image_index (RetroDiskControl* self, guint index, RetroGameInfo* info, GError** error);
gboolean retro_disk_control_remove_image_index (RetroDiskControl* self, guint index, GError** error);
gboolean retro_disk_control_add_image_index (RetroDiskControl* self, GError** error);
static void retro_disk_control_finalize (GObject * obj);


RetroDiskControl* retro_disk_control_construct (GType object_type, RetroCore* core, RetroDiskControlCallback* callback_struct) {
	RetroDiskControl * self = NULL;
	RetroCore* _tmp0_;
	RetroDiskControlCallback _tmp1_;
	g_return_val_if_fail (core != NULL, NULL);
	g_return_val_if_fail (callback_struct != NULL, NULL);
	self = (RetroDiskControl*) g_object_new (object_type, NULL);
	_tmp0_ = core;
	self->priv->core = _tmp0_;
	_tmp1_ = *callback_struct;
	self->priv->callback_struct = _tmp1_;
	return self;
}


RetroDiskControl* retro_disk_control_new (RetroCore* core, RetroDiskControlCallback* callback_struct) {
	return retro_disk_control_construct (RETRO_TYPE_DISK_CONTROL, core, callback_struct);
}


/**
 * Sets the current eject state.
 *
 * When set to true, ejects the virtual disk tray.
 * When set to false, closes the virtual disk tray.
 *
 * When ejected, the disk image index can be set.
 *
 * The default state is "closed".
 *
 * @param ejected the desired eject state
 * @return //true// on successfully changed eject state, //false// otherwise
 * @throws CbError the core or its callback couldn't be found
 */
gboolean retro_disk_control_set_eject_state (RetroDiskControl* self, gboolean ejected, GError** error) {
	gboolean result = FALSE;
	RetroCore* _tmp0_;
	RetroDiskControlCallback _tmp4_;
	RetroDiskControlCallbackSetEjectState _tmp5_;
	RetroCore* _tmp9_;
	gboolean _result_;
	RetroDiskControlCallback _tmp10_;
	RetroDiskControlCallbackSetEjectState _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->core;
	if (_tmp0_ == NULL) {
		GError* _tmp1_;
		_tmp1_ = g_error_new_literal (RETRO_CB_ERROR, RETRO_CB_ERROR_NO_CORE, "DiskControl has no core");
		_inner_error_ = _tmp1_;
		if (_inner_error_->domain == RETRO_CB_ERROR) {
			gboolean _tmp2_ = FALSE;
			g_propagate_error (error, _inner_error_);
			return _tmp2_;
		} else {
			gboolean _tmp3_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp3_;
		}
	}
	_tmp4_ = self->priv->callback_struct;
	_tmp5_ = _tmp4_.set_eject_state;
	if (_tmp5_ == NULL) {
		GError* _tmp6_;
		_tmp6_ = g_error_new_literal (RETRO_CB_ERROR, RETRO_CB_ERROR_NO_CALLBACK, "DiskControl has no callback for this operation");
		_inner_error_ = _tmp6_;
		if (_inner_error_->domain == RETRO_CB_ERROR) {
			gboolean _tmp7_ = FALSE;
			g_propagate_error (error, _inner_error_);
			return _tmp7_;
		} else {
			gboolean _tmp8_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp8_;
		}
	}
	_tmp9_ = self->priv->core;
	retro_core_push_cb_data (_tmp9_);
	_tmp10_ = self->priv->callback_struct;
	_tmp11_ = _tmp10_.set_eject_state;
	_tmp12_ = ejected;
	_tmp13_ = _tmp11_ (_tmp12_);
	_result_ = _tmp13_;
	retro_core_pop_cb_data ();
	result = _result_;
	return result;
}


/**
 * Gets the current eject state.
 *
 * See {@link set_eject_state} for more informations.
 *
 * @return the current eject state
 * @throws CbError the core or its callback couldn't be found
 */
gboolean retro_disk_control_get_eject_state (RetroDiskControl* self, GError** error) {
	gboolean result = FALSE;
	RetroCore* _tmp0_;
	RetroDiskControlCallback _tmp4_;
	RetroDiskControlCallbackGetEjectState _tmp5_;
	RetroCore* _tmp9_;
	gboolean _result_;
	RetroDiskControlCallback _tmp10_;
	RetroDiskControlCallbackGetEjectState _tmp11_;
	gboolean _tmp12_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->core;
	if (_tmp0_ == NULL) {
		GError* _tmp1_;
		_tmp1_ = g_error_new_literal (RETRO_CB_ERROR, RETRO_CB_ERROR_NO_CORE, "DiskControl has no core");
		_inner_error_ = _tmp1_;
		if (_inner_error_->domain == RETRO_CB_ERROR) {
			gboolean _tmp2_ = FALSE;
			g_propagate_error (error, _inner_error_);
			return _tmp2_;
		} else {
			gboolean _tmp3_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp3_;
		}
	}
	_tmp4_ = self->priv->callback_struct;
	_tmp5_ = _tmp4_.get_eject_state;
	if (_tmp5_ == NULL) {
		GError* _tmp6_;
		_tmp6_ = g_error_new_literal (RETRO_CB_ERROR, RETRO_CB_ERROR_NO_CALLBACK, "DiskControl has no callback for this operation");
		_inner_error_ = _tmp6_;
		if (_inner_error_->domain == RETRO_CB_ERROR) {
			gboolean _tmp7_ = FALSE;
			g_propagate_error (error, _inner_error_);
			return _tmp7_;
		} else {
			gboolean _tmp8_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp8_;
		}
	}
	_tmp9_ = self->priv->core;
	retro_core_push_cb_data (_tmp9_);
	_tmp10_ = self->priv->callback_struct;
	_tmp11_ = _tmp10_.get_eject_state;
	_tmp12_ = _tmp11_ ();
	_result_ = _tmp12_;
	retro_core_pop_cb_data ();
	result = _result_;
	return result;
}


/**
 * Sets the current disk index.
 *
 * Can only be set when the disk drive is ejected.
 *
 * If the value is >= to the total number of images,
 * no disk is currently inserted.
 *
 * @param image_index the desired image index
 * @return //true// on successfully changed image index, //false// otherwise
 * @throws CbError the core or its callback couldn't be found
 */
gboolean retro_disk_control_set_image_index (RetroDiskControl* self, guint image_index, GError** error) {
	gboolean result = FALSE;
	RetroCore* _tmp0_;
	RetroDiskControlCallback _tmp4_;
	RetroDiskControlCallbackSetImageIndex _tmp5_;
	RetroCore* _tmp9_;
	gboolean _result_;
	RetroDiskControlCallback _tmp10_;
	RetroDiskControlCallbackSetImageIndex _tmp11_;
	guint _tmp12_;
	gboolean _tmp13_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->core;
	if (_tmp0_ == NULL) {
		GError* _tmp1_;
		_tmp1_ = g_error_new_literal (RETRO_CB_ERROR, RETRO_CB_ERROR_NO_CORE, "DiskControl has no core");
		_inner_error_ = _tmp1_;
		if (_inner_error_->domain == RETRO_CB_ERROR) {
			gboolean _tmp2_ = FALSE;
			g_propagate_error (error, _inner_error_);
			return _tmp2_;
		} else {
			gboolean _tmp3_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp3_;
		}
	}
	_tmp4_ = self->priv->callback_struct;
	_tmp5_ = _tmp4_.set_image_index;
	if (_tmp5_ == NULL) {
		GError* _tmp6_;
		_tmp6_ = g_error_new_literal (RETRO_CB_ERROR, RETRO_CB_ERROR_NO_CALLBACK, "DiskControl has no callback for this operation");
		_inner_error_ = _tmp6_;
		if (_inner_error_->domain == RETRO_CB_ERROR) {
			gboolean _tmp7_ = FALSE;
			g_propagate_error (error, _inner_error_);
			return _tmp7_;
		} else {
			gboolean _tmp8_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp8_;
		}
	}
	_tmp9_ = self->priv->core;
	retro_core_push_cb_data (_tmp9_);
	_tmp10_ = self->priv->callback_struct;
	_tmp11_ = _tmp10_.set_image_index;
	_tmp12_ = image_index;
	_tmp13_ = _tmp11_ (_tmp12_);
	_result_ = _tmp13_;
	retro_core_pop_cb_data ();
	result = _result_;
	return result;
}


/**
 * Gets the current disk index.
 *
 * @return the current image index
 * @throws CbError the core or its callback couldn't be found
 */
guint retro_disk_control_get_image_index (RetroDiskControl* self, GError** error) {
	guint result = 0U;
	RetroCore* _tmp0_;
	RetroDiskControlCallback _tmp4_;
	RetroDiskControlCallbackGetImageIndex _tmp5_;
	RetroCore* _tmp9_;
	guint _result_;
	RetroDiskControlCallback _tmp10_;
	RetroDiskControlCallbackGetImageIndex _tmp11_;
	guint _tmp12_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->core;
	if (_tmp0_ == NULL) {
		GError* _tmp1_;
		_tmp1_ = g_error_new_literal (RETRO_CB_ERROR, RETRO_CB_ERROR_NO_CORE, "DiskControl has no core");
		_inner_error_ = _tmp1_;
		if (_inner_error_->domain == RETRO_CB_ERROR) {
			guint _tmp2_ = 0U;
			g_propagate_error (error, _inner_error_);
			return _tmp2_;
		} else {
			guint _tmp3_ = 0U;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp3_;
		}
	}
	_tmp4_ = self->priv->callback_struct;
	_tmp5_ = _tmp4_.get_image_index;
	if (_tmp5_ == NULL) {
		GError* _tmp6_;
		_tmp6_ = g_error_new_literal (RETRO_CB_ERROR, RETRO_CB_ERROR_NO_CALLBACK, "DiskControl has no callback for this operation");
		_inner_error_ = _tmp6_;
		if (_inner_error_->domain == RETRO_CB_ERROR) {
			guint _tmp7_ = 0U;
			g_propagate_error (error, _inner_error_);
			return _tmp7_;
		} else {
			guint _tmp8_ = 0U;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp8_;
		}
	}
	_tmp9_ = self->priv->core;
	retro_core_push_cb_data (_tmp9_);
	_tmp10_ = self->priv->callback_struct;
	_tmp11_ = _tmp10_.get_image_index;
	_tmp12_ = _tmp11_ ();
	_result_ = _tmp12_;
	retro_core_pop_cb_data ();
	result = _result_;
	return result;
}


/**
 * Gets the total number of images which are available to use.
 *
 * @return total number of images available to use
 * @throws CbError the core or its callback couldn't be found
 */
guint retro_disk_control_get_num_images (RetroDiskControl* self, GError** error) {
	guint result = 0U;
	RetroCore* _tmp0_;
	RetroDiskControlCallback _tmp4_;
	RetroDiskControlCallbackGetNumImages _tmp5_;
	RetroCore* _tmp9_;
	guint _result_;
	RetroDiskControlCallback _tmp10_;
	RetroDiskControlCallbackGetNumImages _tmp11_;
	guint _tmp12_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->core;
	if (_tmp0_ == NULL) {
		GError* _tmp1_;
		_tmp1_ = g_error_new_literal (RETRO_CB_ERROR, RETRO_CB_ERROR_NO_CORE, "DiskControl has no core");
		_inner_error_ = _tmp1_;
		if (_inner_error_->domain == RETRO_CB_ERROR) {
			guint _tmp2_ = 0U;
			g_propagate_error (error, _inner_error_);
			return _tmp2_;
		} else {
			guint _tmp3_ = 0U;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp3_;
		}
	}
	_tmp4_ = self->priv->callback_struct;
	_tmp5_ = _tmp4_.get_num_images;
	if (_tmp5_ == NULL) {
		GError* _tmp6_;
		_tmp6_ = g_error_new_literal (RETRO_CB_ERROR, RETRO_CB_ERROR_NO_CALLBACK, "DiskControl has no callback for this operation");
		_inner_error_ = _tmp6_;
		if (_inner_error_->domain == RETRO_CB_ERROR) {
			guint _tmp7_ = 0U;
			g_propagate_error (error, _inner_error_);
			return _tmp7_;
		} else {
			guint _tmp8_ = 0U;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp8_;
		}
	}
	_tmp9_ = self->priv->core;
	retro_core_push_cb_data (_tmp9_);
	_tmp10_ = self->priv->callback_struct;
	_tmp11_ = _tmp10_.get_num_images;
	_tmp12_ = _tmp11_ ();
	_result_ = _tmp12_;
	retro_core_pop_cb_data ();
	result = _result_;
	return result;
}


/**
 * Replaces the disk image associated with index.
 *
 * Virtual disk tray must be ejected when calling this.
 *
 * Arguments to pass in info have same requirements as
 * {@link Core.load_game}.
 *
 * @param index index of the disk image to replace
 * @param info information on the disk image to use
 * @return //true// on successfully replaced image, //false// otherwise
 * @throws CbError the core or its callback couldn't be found
 */
gboolean retro_disk_control_replace_image_index (RetroDiskControl* self, guint index, RetroGameInfo* info, GError** error) {
	gboolean result = FALSE;
	RetroCore* _tmp0_;
	RetroDiskControlCallback _tmp4_;
	RetroDiskControlCallbackReplaceImageIndex _tmp5_;
	RetroCore* _tmp9_;
	gboolean _result_;
	RetroDiskControlCallback _tmp10_;
	RetroDiskControlCallbackReplaceImageIndex _tmp11_;
	guint _tmp12_;
	RetroGameInfo _tmp13_;
	gboolean _tmp14_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (info != NULL, FALSE);
	_tmp0_ = self->priv->core;
	if (_tmp0_ == NULL) {
		GError* _tmp1_;
		_tmp1_ = g_error_new_literal (RETRO_CB_ERROR, RETRO_CB_ERROR_NO_CORE, "DiskControl has no core");
		_inner_error_ = _tmp1_;
		if (_inner_error_->domain == RETRO_CB_ERROR) {
			gboolean _tmp2_ = FALSE;
			g_propagate_error (error, _inner_error_);
			return _tmp2_;
		} else {
			gboolean _tmp3_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp3_;
		}
	}
	_tmp4_ = self->priv->callback_struct;
	_tmp5_ = _tmp4_.replace_image_index;
	if (_tmp5_ == NULL) {
		GError* _tmp6_;
		_tmp6_ = g_error_new_literal (RETRO_CB_ERROR, RETRO_CB_ERROR_NO_CALLBACK, "DiskControl has no callback for this operation");
		_inner_error_ = _tmp6_;
		if (_inner_error_->domain == RETRO_CB_ERROR) {
			gboolean _tmp7_ = FALSE;
			g_propagate_error (error, _inner_error_);
			return _tmp7_;
		} else {
			gboolean _tmp8_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp8_;
		}
	}
	_tmp9_ = self->priv->core;
	retro_core_push_cb_data (_tmp9_);
	_tmp10_ = self->priv->callback_struct;
	_tmp11_ = _tmp10_.replace_image_index;
	_tmp12_ = index;
	_tmp13_ = *info;
	_tmp14_ = _tmp11_ (_tmp12_, &_tmp13_);
	_result_ = _tmp14_;
	retro_core_pop_cb_data ();
	result = _result_;
	return result;
}


/**
 * Removes the disk image associated with index.
 *
 * Virtual disk tray must be ejected when calling this.
 *
 * It will remove the disk image from the internal list.
 * As a result, the current image index can change.
 *
 * E.g. remove_image_index (1), and previous
 * image index was 4 before.
 * Index 1 will be removed, and the new index is 3.
 *
 * @param index index of the disk image to remove
 * @return //true// on successfully removed index, //false// otherwise
 * @throws CbError the core or its callback couldn't be found
 */
gboolean retro_disk_control_remove_image_index (RetroDiskControl* self, guint index, GError** error) {
	gboolean result = FALSE;
	RetroCore* _tmp0_;
	RetroDiskControlCallback _tmp4_;
	RetroDiskControlCallbackReplaceImageIndex _tmp5_;
	guint i;
	guint _tmp9_;
	RetroCore* _tmp12_;
	gboolean _result_;
	RetroDiskControlCallback _tmp13_;
	RetroDiskControlCallbackReplaceImageIndex _tmp14_;
	guint _tmp15_;
	gboolean _tmp16_;
	guint _tmp17_;
	guint _tmp18_;
	guint _tmp21_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->core;
	if (_tmp0_ == NULL) {
		GError* _tmp1_;
		_tmp1_ = g_error_new_literal (RETRO_CB_ERROR, RETRO_CB_ERROR_NO_CORE, "DiskControl has no core");
		_inner_error_ = _tmp1_;
		if (_inner_error_->domain == RETRO_CB_ERROR) {
			gboolean _tmp2_ = FALSE;
			g_propagate_error (error, _inner_error_);
			return _tmp2_;
		} else {
			gboolean _tmp3_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp3_;
		}
	}
	_tmp4_ = self->priv->callback_struct;
	_tmp5_ = _tmp4_.replace_image_index;
	if (_tmp5_ == NULL) {
		GError* _tmp6_;
		_tmp6_ = g_error_new_literal (RETRO_CB_ERROR, RETRO_CB_ERROR_NO_CALLBACK, "DiskControl has no callback for this operation");
		_inner_error_ = _tmp6_;
		if (_inner_error_->domain == RETRO_CB_ERROR) {
			gboolean _tmp7_ = FALSE;
			g_propagate_error (error, _inner_error_);
			return _tmp7_;
		} else {
			gboolean _tmp8_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp8_;
		}
	}
	_tmp9_ = retro_disk_control_get_image_index (self, &_inner_error_);
	i = _tmp9_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == RETRO_CB_ERROR) {
			gboolean _tmp10_ = FALSE;
			g_propagate_error (error, _inner_error_);
			return _tmp10_;
		} else {
			gboolean _tmp11_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp11_;
		}
	}
	_tmp12_ = self->priv->core;
	retro_core_push_cb_data (_tmp12_);
	_tmp13_ = self->priv->callback_struct;
	_tmp14_ = _tmp13_.replace_image_index;
	_tmp15_ = index;
	_tmp16_ = _tmp14_ (_tmp15_, NULL);
	_result_ = _tmp16_;
	retro_core_pop_cb_data ();
	_tmp18_ = retro_disk_control_get_image_index (self, &_inner_error_);
	_tmp17_ = _tmp18_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == RETRO_CB_ERROR) {
			gboolean _tmp19_ = FALSE;
			g_propagate_error (error, _inner_error_);
			return _tmp19_;
		} else {
			gboolean _tmp20_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp20_;
		}
	}
	_tmp21_ = i;
	if (_tmp21_ != _tmp17_) {
		g_object_notify ((GObject*) self, "image-index");
	}
	result = _result_;
	return result;
}


/**
 * Adds a new valid index to the internal disk lit.
 *
 * This will increment subsequent return values from {@link get_num_images}
 * by 1.
 * This image index cannot be used until a disk image has been set with
 * {@link replace_image_index}.
 *
 * @return //true// on successfully added index, //false// otherwise
 * @throws CbError the core or its callback couldn't be found
 */
gboolean retro_disk_control_add_image_index (RetroDiskControl* self, GError** error) {
	gboolean result = FALSE;
	RetroCore* _tmp0_;
	RetroDiskControlCallback _tmp4_;
	RetroDiskControlCallbackAddImageIndex _tmp5_;
	RetroCore* _tmp9_;
	gboolean _result_;
	RetroDiskControlCallback _tmp10_;
	RetroDiskControlCallbackAddImageIndex _tmp11_;
	gboolean _tmp12_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->core;
	if (_tmp0_ == NULL) {
		GError* _tmp1_;
		_tmp1_ = g_error_new_literal (RETRO_CB_ERROR, RETRO_CB_ERROR_NO_CORE, "DiskControl has no core");
		_inner_error_ = _tmp1_;
		if (_inner_error_->domain == RETRO_CB_ERROR) {
			gboolean _tmp2_ = FALSE;
			g_propagate_error (error, _inner_error_);
			return _tmp2_;
		} else {
			gboolean _tmp3_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp3_;
		}
	}
	_tmp4_ = self->priv->callback_struct;
	_tmp5_ = _tmp4_.add_image_index;
	if (_tmp5_ == NULL) {
		GError* _tmp6_;
		_tmp6_ = g_error_new_literal (RETRO_CB_ERROR, RETRO_CB_ERROR_NO_CALLBACK, "DiskControl has no callback for this operation");
		_inner_error_ = _tmp6_;
		if (_inner_error_->domain == RETRO_CB_ERROR) {
			gboolean _tmp7_ = FALSE;
			g_propagate_error (error, _inner_error_);
			return _tmp7_;
		} else {
			gboolean _tmp8_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp8_;
		}
	}
	_tmp9_ = self->priv->core;
	retro_core_push_cb_data (_tmp9_);
	_tmp10_ = self->priv->callback_struct;
	_tmp11_ = _tmp10_.add_image_index;
	_tmp12_ = _tmp11_ ();
	_result_ = _tmp12_;
	retro_core_pop_cb_data ();
	result = _result_;
	return result;
}


static void retro_disk_control_class_init (RetroDiskControlClass * klass) {
	retro_disk_control_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RetroDiskControlPrivate));
	G_OBJECT_CLASS (klass)->finalize = retro_disk_control_finalize;
}


static void retro_disk_control_instance_init (RetroDiskControl * self) {
	self->priv = RETRO_DISK_CONTROL_GET_PRIVATE (self);
}


static void retro_disk_control_finalize (GObject * obj) {
	RetroDiskControl * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RETRO_TYPE_DISK_CONTROL, RetroDiskControl);
	G_OBJECT_CLASS (retro_disk_control_parent_class)->finalize (obj);
}


/**
 * Handles a virtual disk drive.
 *
 * It si used by a {@link Core} which can swap out multiple disk images at
 * runtime.
 *
 * If the {@link Core} can do this automatically, it should strive to do so.
 * However, there are cases where the user must manually do so.
 *
 * To swap a disk image:
 *
 *  * eject the disk image by setting the eject state to true;
 *  * set the image index to the one you want to use.
 *  * insert the disk again by setting the eject state to false.
 */
GType retro_disk_control_get_type (void) {
	static volatile gsize retro_disk_control_type_id__volatile = 0;
	if (g_once_init_enter (&retro_disk_control_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RetroDiskControlClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) retro_disk_control_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RetroDiskControl), 0, (GInstanceInitFunc) retro_disk_control_instance_init, NULL };
		GType retro_disk_control_type_id;
		retro_disk_control_type_id = g_type_register_static (G_TYPE_OBJECT, "RetroDiskControl", &g_define_type_info, 0);
		g_once_init_leave (&retro_disk_control_type_id__volatile, retro_disk_control_type_id);
	}
	return retro_disk_control_type_id__volatile;
}


RetroDiskControlCallback* retro_disk_control_callback_dup (const RetroDiskControlCallback* self) {
	RetroDiskControlCallback* dup;
	dup = g_new0 (RetroDiskControlCallback, 1);
	memcpy (dup, self, sizeof (RetroDiskControlCallback));
	return dup;
}


void retro_disk_control_callback_free (RetroDiskControlCallback* self) {
	g_free (self);
}


GType retro_disk_control_callback_get_type (void) {
	static volatile gsize retro_disk_control_callback_type_id__volatile = 0;
	if (g_once_init_enter (&retro_disk_control_callback_type_id__volatile)) {
		GType retro_disk_control_callback_type_id;
		retro_disk_control_callback_type_id = g_boxed_type_register_static ("RetroDiskControlCallback", (GBoxedCopyFunc) retro_disk_control_callback_dup, (GBoxedFreeFunc) retro_disk_control_callback_free);
		g_once_init_leave (&retro_disk_control_callback_type_id__volatile, retro_disk_control_callback_type_id);
	}
	return retro_disk_control_callback_type_id__volatile;
}



