/* core.c generated by valac 0.35.5, the Vala compiler
 * generated from core.vala, do not modify */

/* This file is part of retro-gtk. License: GPLv3*/

#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gio/gio.h>


#define RETRO_TYPE_CORE (retro_core_get_type ())
#define RETRO_CORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_CORE, RetroCore))
#define RETRO_CORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RETRO_TYPE_CORE, RetroCoreClass))
#define RETRO_IS_CORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_CORE))
#define RETRO_IS_CORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RETRO_TYPE_CORE))
#define RETRO_CORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RETRO_TYPE_CORE, RetroCoreClass))

typedef struct _RetroCore RetroCore;
typedef struct _RetroCoreClass RetroCoreClass;
typedef struct _RetroCorePrivate RetroCorePrivate;

#define RETRO_TYPE_MODULE (retro_module_get_type ())
#define RETRO_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_MODULE, RetroModule))
#define RETRO_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RETRO_TYPE_MODULE, RetroModuleClass))
#define RETRO_IS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_MODULE))
#define RETRO_IS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RETRO_TYPE_MODULE))
#define RETRO_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RETRO_TYPE_MODULE, RetroModuleClass))

typedef struct _RetroModule RetroModule;
typedef struct _RetroModuleClass RetroModuleClass;

#define RETRO_TYPE_VARIABLES (retro_variables_get_type ())
#define RETRO_VARIABLES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_VARIABLES, RetroVariables))
#define RETRO_IS_VARIABLES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_VARIABLES))
#define RETRO_VARIABLES_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RETRO_TYPE_VARIABLES, RetroVariablesIface))

typedef struct _RetroVariables RetroVariables;
typedef struct _RetroVariablesIface RetroVariablesIface;

#define RETRO_TYPE_VARIABLE (retro_variable_get_type ())
typedef struct _RetroVariable RetroVariable;

#define RETRO_TYPE_PIXEL_FORMAT (retro_pixel_format_get_type ())

#define RETRO_TYPE_ROTATION (retro_rotation_get_type ())

#define RETRO_TYPE_DISK_CONTROL (retro_disk_control_get_type ())
#define RETRO_DISK_CONTROL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_DISK_CONTROL, RetroDiskControl))
#define RETRO_DISK_CONTROL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RETRO_TYPE_DISK_CONTROL, RetroDiskControlClass))
#define RETRO_IS_DISK_CONTROL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_DISK_CONTROL))
#define RETRO_IS_DISK_CONTROL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RETRO_TYPE_DISK_CONTROL))
#define RETRO_DISK_CONTROL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RETRO_TYPE_DISK_CONTROL, RetroDiskControlClass))

typedef struct _RetroDiskControl RetroDiskControl;
typedef struct _RetroDiskControlClass RetroDiskControlClass;

#define RETRO_TYPE_INPUT (retro_input_get_type ())
#define RETRO_INPUT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_INPUT, RetroInput))
#define RETRO_IS_INPUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_INPUT))
#define RETRO_INPUT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RETRO_TYPE_INPUT, RetroInputIface))

typedef struct _RetroInput RetroInput;
typedef struct _RetroInputIface RetroInputIface;

#define RETRO_TYPE_DEVICE_TYPE (retro_device_type_get_type ())

#define RETRO_TYPE_INPUT_DESCRIPTOR (retro_input_descriptor_get_type ())
typedef struct _RetroInputDescriptor RetroInputDescriptor;

#define RETRO_TYPE_INPUT_DEVICE (retro_input_device_get_type ())
#define RETRO_INPUT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_INPUT_DEVICE, RetroInputDevice))
#define RETRO_IS_INPUT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_INPUT_DEVICE))
#define RETRO_INPUT_DEVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RETRO_TYPE_INPUT_DEVICE, RetroInputDeviceIface))

typedef struct _RetroInputDevice RetroInputDevice;
typedef struct _RetroInputDeviceIface RetroInputDeviceIface;

#define RETRO_TYPE_RUMBLE (retro_rumble_get_type ())
#define RETRO_RUMBLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_RUMBLE, RetroRumble))
#define RETRO_IS_RUMBLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_RUMBLE))
#define RETRO_RUMBLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RETRO_TYPE_RUMBLE, RetroRumbleIface))

typedef struct _RetroRumble RetroRumble;
typedef struct _RetroRumbleIface RetroRumbleIface;

#define RETRO_TYPE_RUMBLE_EFFECT (retro_rumble_effect_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RETRO_TYPE_GAME_INFO (retro_game_info_get_type ())
typedef struct _RetroGameInfo RetroGameInfo;

#define RETRO_TYPE_SYSTEM_AV_INFO (retro_system_av_info_get_type ())

#define RETRO_TYPE_GAME_GEOMETRY (retro_game_geometry_get_type ())
typedef struct _RetroGameGeometry RetroGameGeometry;

#define RETRO_TYPE_SYSTEM_TIMING (retro_system_timing_get_type ())
typedef struct _RetroSystemTiming RetroSystemTiming;
typedef struct _RetroSystemAvInfo RetroSystemAvInfo;

#define RETRO_TYPE_MEMORY_TYPE (retro_memory_type_get_type ())

#define RETRO_TYPE_KEYBOARD_KEY (retro_keyboard_key_get_type ())

#define RETRO_TYPE_KEYBOARD_MODIFIER_KEY (retro_keyboard_modifier_key_get_type ())

#define RETRO_TYPE_SYSTEM_INFO (retro_system_info_get_type ())
typedef struct _RetroSystemInfo RetroSystemInfo;

#define RETRO_TYPE_OPTIONS (retro_options_get_type ())
#define RETRO_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_OPTIONS, RetroOptions))
#define RETRO_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RETRO_TYPE_OPTIONS, RetroOptionsClass))
#define RETRO_IS_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_OPTIONS))
#define RETRO_IS_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RETRO_TYPE_OPTIONS))
#define RETRO_OPTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RETRO_TYPE_OPTIONS, RetroOptionsClass))

typedef struct _RetroOptions RetroOptions;
typedef struct _RetroOptionsClass RetroOptionsClass;
enum  {
	RETRO_CORE_VIDEO_OUTPUT_SIGNAL,
	RETRO_CORE_AUDIO_OUTPUT_SIGNAL,
	RETRO_CORE_SHUTDOWN_SIGNAL,
	RETRO_CORE_MESSAGE_SIGNAL,
	RETRO_CORE_INIT_SIGNAL,
	RETRO_CORE_LAST_SIGNAL
};
static guint retro_core_signals[RETRO_CORE_LAST_SIGNAL] = {0};

struct _RetroVariable {
	gchar* key;
	gchar* value;
};

struct _RetroVariablesIface {
	GTypeInterface parent_iface;
	gchar* (*get_variable) (RetroVariables* self, const gchar* key);
	void (*set_variable) (RetroVariables* self, RetroVariable* variables, int variables_length1);
	gboolean (*get_variable_update) (RetroVariables* self);
	RetroCore* (*get_core) (RetroVariables* self);
	void (*set_core) (RetroVariables* self, RetroCore* value);
};

typedef enum  {
	RETRO_PIXEL_FORMAT_XRGB1555,
	RETRO_PIXEL_FORMAT_XRGB8888,
	RETRO_PIXEL_FORMAT_RGB565,
	RETRO_PIXEL_FORMAT_UNKNOWN = -1
} RetroPixelFormat;

typedef enum  {
	RETRO_ROTATION_NONE,
	RETRO_ROTATION_COUNTERCLOCKWISE,
	RETRO_ROTATION_UPSIDEDOWN,
	RETRO_ROTATION_CLOCKWISE
} RetroRotation;

struct _RetroCore {
	GObject parent_instance;
	RetroCorePrivate * priv;
	gdouble _frames_per_second;
	RetroModule* module;
	RetroVariables* variables_interface;
	gfloat aspect_ratio;
	gboolean overscan;
	RetroPixelFormat pixel_format;
	RetroRotation rotation;
	gdouble sample_rate;
};

struct _RetroCoreClass {
	GObjectClass parent_class;
	void (*init) (RetroCore* self);
};

typedef enum  {
	RETRO_DEVICE_TYPE_TYPE_MASK = 0xff,
	RETRO_DEVICE_TYPE_NONE = 0,
	RETRO_DEVICE_TYPE_JOYPAD = 1,
	RETRO_DEVICE_TYPE_MOUSE = 2,
	RETRO_DEVICE_TYPE_KEYBOARD = 3,
	RETRO_DEVICE_TYPE_LIGHTGUN = 4,
	RETRO_DEVICE_TYPE_ANALOG = 5,
	RETRO_DEVICE_TYPE_POINTER = 6
} RetroDeviceType;

struct _RetroInputDescriptor {
	guint port;
	RetroDeviceType device;
	guint index;
	guint id;
	gchar* description;
};

struct _RetroInputDeviceIface {
	GTypeInterface parent_iface;
	void (*poll) (RetroInputDevice* self);
	gint16 (*get_input_state) (RetroInputDevice* self, RetroDeviceType device, guint index, guint id);
	RetroDeviceType (*get_device_type) (RetroInputDevice* self);
	guint64 (*get_device_capabilities) (RetroInputDevice* self);
};

typedef void (*RetroInputControllerCallback) (guint port, RetroInputDevice* device, void* user_data);
struct _RetroInputIface {
	GTypeInterface parent_iface;
	void (*poll) (RetroInput* self);
	gint16 (*get_state) (RetroInput* self, guint port, RetroDeviceType device, guint index, guint id);
	void (*set_descriptors) (RetroInput* self, RetroInputDescriptor* input_descriptors, int input_descriptors_length1);
	guint64 (*get_device_capabilities) (RetroInput* self);
	void (*foreach_controller) (RetroInput* self, RetroInputControllerCallback callback, void* callback_target);
};

typedef enum  {
	RETRO_RUMBLE_EFFECT_STRONG,
	RETRO_RUMBLE_EFFECT_WEAK
} RetroRumbleEffect;

struct _RetroRumbleIface {
	GTypeInterface parent_iface;
	gboolean (*set_rumble_state) (RetroRumble* self, guint port, RetroRumbleEffect effect, guint16 strength);
};

struct _RetroCorePrivate {
	gchar* _file_name;
	gchar* _system_directory;
	gchar* _libretro_path;
	gchar* _content_directory;
	gchar* _save_directory;
	gboolean _is_initiated;
	gboolean _game_loaded;
	gboolean _support_no_game;
	RetroDiskControl* _disk_control_interface;
	RetroInput* _input_interface;
	gulong input_controller_connected_id;
	gulong input_controller_disconnected_id;
	gulong input_key_event_id;
	RetroRumble* _rumble_interface;
};

typedef void (*RetroUnloadGame) ();
typedef void (*RetroDeinit) ();
typedef void (*RetroSetControllerPortDevice) (guint port, RetroDeviceType device);
typedef void (*RetroReset) ();
typedef void (*RetroRun) ();
struct _RetroGameInfo {
	gchar* path;
	guint8* data;
	gint data_length1;
	gchar* meta;
};

typedef gboolean (*RetroLoadGame) (RetroGameInfo* game);
struct _RetroGameGeometry {
	guint base_width;
	guint base_height;
	guint max_width;
	guint max_height;
	gfloat aspect_ratio;
};

struct _RetroSystemTiming {
	gdouble fps;
	gdouble sample_rate;
};

struct _RetroSystemAvInfo {
	RetroGameGeometry geometry;
	RetroSystemTiming timing;
};

typedef void (*RetroGetSystemAvInfo) (RetroSystemAvInfo* info);
typedef enum  {
	RETRO_MEMORY_TYPE_TYPE_MASK = 0xff,
	RETRO_MEMORY_TYPE_SAVE_RAM = 0,
	RETRO_MEMORY_TYPE_RTC = 1,
	RETRO_MEMORY_TYPE_SYSTEM_RAM = 2,
	RETRO_MEMORY_TYPE_VIDEO_RAM = 3,
	RETRO_MEMORY_TYPE_SNES_BSX_RAM = (1 << 8) | RETRO_MEMORY_TYPE_SAVE_RAM,
	RETRO_MEMORY_TYPE_SNES_BSX_PRAM = (2 << 8) | RETRO_MEMORY_TYPE_SAVE_RAM,
	RETRO_MEMORY_TYPE_SNES_SUFAMI_TURBO_A_RAM = (3 << 8) | RETRO_MEMORY_TYPE_SAVE_RAM,
	RETRO_MEMORY_TYPE_SNES_SUFAMI_TURBO_B_RAM = (4 << 8) | RETRO_MEMORY_TYPE_SAVE_RAM,
	RETRO_MEMORY_TYPE_SNES_GAME_BOY_RAM = (5 << 8) | RETRO_MEMORY_TYPE_SAVE_RAM,
	RETRO_MEMORY_TYPE_SNES_GAME_BOY_RTC = (6 << 8) | RETRO_MEMORY_TYPE_RTC
} RetroMemoryType;

typedef gsize (*RetroGetMemorySize) (RetroMemoryType id);
typedef enum  {
	RETRO_KEYBOARD_KEY_UNKNOWN = 0,
	RETRO_KEYBOARD_KEY_FIRST = 0,
	RETRO_KEYBOARD_KEY_BACKSPACE = 8,
	RETRO_KEYBOARD_KEY_TAB = 9,
	RETRO_KEYBOARD_KEY_CLEAR = 12,
	RETRO_KEYBOARD_KEY_RETURN = 13,
	RETRO_KEYBOARD_KEY_PAUSE = 19,
	RETRO_KEYBOARD_KEY_ESCAPE = 27,
	RETRO_KEYBOARD_KEY_SPACE = 32,
	RETRO_KEYBOARD_KEY_EXCLAIM = 33,
	RETRO_KEYBOARD_KEY_QUOTEDBL = 34,
	RETRO_KEYBOARD_KEY_HASH = 35,
	RETRO_KEYBOARD_KEY_DOLLAR = 36,
	RETRO_KEYBOARD_KEY_AMPERSAND = 38,
	RETRO_KEYBOARD_KEY_QUOTE = 39,
	RETRO_KEYBOARD_KEY_LEFTPAREN = 40,
	RETRO_KEYBOARD_KEY_RIGHTPAREN = 41,
	RETRO_KEYBOARD_KEY_ASTERISK = 42,
	RETRO_KEYBOARD_KEY_PLUS = 43,
	RETRO_KEYBOARD_KEY_COMMA = 44,
	RETRO_KEYBOARD_KEY_MINUS = 45,
	RETRO_KEYBOARD_KEY_PERIOD = 46,
	RETRO_KEYBOARD_KEY_SLASH = 47,
	RETRO_KEYBOARD_KEY_ZERO = 48,
	RETRO_KEYBOARD_KEY_ONE = 49,
	RETRO_KEYBOARD_KEY_TWO = 50,
	RETRO_KEYBOARD_KEY_THREE = 51,
	RETRO_KEYBOARD_KEY_FOUR = 52,
	RETRO_KEYBOARD_KEY_FINE = 53,
	RETRO_KEYBOARD_KEY_SIX = 54,
	RETRO_KEYBOARD_KEY_SEVEN = 55,
	RETRO_KEYBOARD_KEY_HEIGHT = 56,
	RETRO_KEYBOARD_KEY_NINE = 57,
	RETRO_KEYBOARD_KEY_COLON = 58,
	RETRO_KEYBOARD_KEY_SEMICOLON = 59,
	RETRO_KEYBOARD_KEY_LESS = 60,
	RETRO_KEYBOARD_KEY_EQUALS = 61,
	RETRO_KEYBOARD_KEY_GREATER = 62,
	RETRO_KEYBOARD_KEY_QUESTION = 63,
	RETRO_KEYBOARD_KEY_AT = 64,
	RETRO_KEYBOARD_KEY_LEFTBRACKET = 91,
	RETRO_KEYBOARD_KEY_BACKSLASH = 92,
	RETRO_KEYBOARD_KEY_RIGHTBRACKET = 93,
	RETRO_KEYBOARD_KEY_CARET = 94,
	RETRO_KEYBOARD_KEY_UNDERSCORE = 95,
	RETRO_KEYBOARD_KEY_BACKQUOTE = 96,
	RETRO_KEYBOARD_KEY_a = 97,
	RETRO_KEYBOARD_KEY_b = 98,
	RETRO_KEYBOARD_KEY_c = 99,
	RETRO_KEYBOARD_KEY_d = 100,
	RETRO_KEYBOARD_KEY_e = 101,
	RETRO_KEYBOARD_KEY_f = 102,
	RETRO_KEYBOARD_KEY_g = 103,
	RETRO_KEYBOARD_KEY_h = 104,
	RETRO_KEYBOARD_KEY_i = 105,
	RETRO_KEYBOARD_KEY_j = 106,
	RETRO_KEYBOARD_KEY_k = 107,
	RETRO_KEYBOARD_KEY_l = 108,
	RETRO_KEYBOARD_KEY_m = 109,
	RETRO_KEYBOARD_KEY_n = 110,
	RETRO_KEYBOARD_KEY_o = 111,
	RETRO_KEYBOARD_KEY_p = 112,
	RETRO_KEYBOARD_KEY_q = 113,
	RETRO_KEYBOARD_KEY_r = 114,
	RETRO_KEYBOARD_KEY_s = 115,
	RETRO_KEYBOARD_KEY_t = 116,
	RETRO_KEYBOARD_KEY_u = 117,
	RETRO_KEYBOARD_KEY_v = 118,
	RETRO_KEYBOARD_KEY_w = 119,
	RETRO_KEYBOARD_KEY_x = 120,
	RETRO_KEYBOARD_KEY_y = 121,
	RETRO_KEYBOARD_KEY_z = 122,
	RETRO_KEYBOARD_KEY_DELETE = 127,
	RETRO_KEYBOARD_KEY_KP0 = 256,
	RETRO_KEYBOARD_KEY_KP1 = 257,
	RETRO_KEYBOARD_KEY_KP2 = 258,
	RETRO_KEYBOARD_KEY_KP3 = 259,
	RETRO_KEYBOARD_KEY_KP4 = 260,
	RETRO_KEYBOARD_KEY_KP5 = 261,
	RETRO_KEYBOARD_KEY_KP6 = 262,
	RETRO_KEYBOARD_KEY_KP7 = 263,
	RETRO_KEYBOARD_KEY_KP8 = 264,
	RETRO_KEYBOARD_KEY_KP9 = 265,
	RETRO_KEYBOARD_KEY_KP_PERIOD = 266,
	RETRO_KEYBOARD_KEY_KP_DIVIDE = 267,
	RETRO_KEYBOARD_KEY_KP_MULTIPLY = 268,
	RETRO_KEYBOARD_KEY_KP_MINUS = 269,
	RETRO_KEYBOARD_KEY_KP_PLUS = 270,
	RETRO_KEYBOARD_KEY_KP_ENTER = 271,
	RETRO_KEYBOARD_KEY_KP_EQUALS = 272,
	RETRO_KEYBOARD_KEY_UP = 273,
	RETRO_KEYBOARD_KEY_DOWN = 274,
	RETRO_KEYBOARD_KEY_RIGHT = 275,
	RETRO_KEYBOARD_KEY_LEFT = 276,
	RETRO_KEYBOARD_KEY_INSERT = 277,
	RETRO_KEYBOARD_KEY_HOME = 278,
	RETRO_KEYBOARD_KEY_END = 279,
	RETRO_KEYBOARD_KEY_PAGEUP = 280,
	RETRO_KEYBOARD_KEY_PAGEDOWN = 281,
	RETRO_KEYBOARD_KEY_F1 = 282,
	RETRO_KEYBOARD_KEY_F2 = 283,
	RETRO_KEYBOARD_KEY_F3 = 284,
	RETRO_KEYBOARD_KEY_F4 = 285,
	RETRO_KEYBOARD_KEY_F5 = 286,
	RETRO_KEYBOARD_KEY_F6 = 287,
	RETRO_KEYBOARD_KEY_F7 = 288,
	RETRO_KEYBOARD_KEY_F8 = 289,
	RETRO_KEYBOARD_KEY_F9 = 290,
	RETRO_KEYBOARD_KEY_F10 = 291,
	RETRO_KEYBOARD_KEY_F11 = 292,
	RETRO_KEYBOARD_KEY_F12 = 293,
	RETRO_KEYBOARD_KEY_F13 = 294,
	RETRO_KEYBOARD_KEY_F14 = 295,
	RETRO_KEYBOARD_KEY_F15 = 296,
	RETRO_KEYBOARD_KEY_NUMLOCK = 300,
	RETRO_KEYBOARD_KEY_CAPSLOCK = 301,
	RETRO_KEYBOARD_KEY_SCROLLOCK = 302,
	RETRO_KEYBOARD_KEY_RSHIFT = 303,
	RETRO_KEYBOARD_KEY_LSHIFT = 304,
	RETRO_KEYBOARD_KEY_RCTRL = 305,
	RETRO_KEYBOARD_KEY_LCTRL = 306,
	RETRO_KEYBOARD_KEY_RALT = 307,
	RETRO_KEYBOARD_KEY_LALT = 308,
	RETRO_KEYBOARD_KEY_RMETA = 309,
	RETRO_KEYBOARD_KEY_LMETA = 310,
	RETRO_KEYBOARD_KEY_LSUPER = 311,
	RETRO_KEYBOARD_KEY_RSUPER = 312,
	RETRO_KEYBOARD_KEY_MODE = 313,
	RETRO_KEYBOARD_KEY_COMPOSE = 314,
	RETRO_KEYBOARD_KEY_HELP = 315,
	RETRO_KEYBOARD_KEY_PRINT = 316,
	RETRO_KEYBOARD_KEY_SYSREQ = 317,
	RETRO_KEYBOARD_KEY_BREAK = 318,
	RETRO_KEYBOARD_KEY_MENU = 319,
	RETRO_KEYBOARD_KEY_POWER = 320,
	RETRO_KEYBOARD_KEY_EURO = 321,
	RETRO_KEYBOARD_KEY_UNDO = 322,
	RETRO_KEYBOARD_KEY_LAST
} RetroKeyboardKey;

typedef enum  {
	RETRO_KEYBOARD_MODIFIER_KEY_NONE = 0x0000,
	RETRO_KEYBOARD_MODIFIER_KEY_SHIFT = 0x01,
	RETRO_KEYBOARD_MODIFIER_KEY_CTRL = 0x02,
	RETRO_KEYBOARD_MODIFIER_KEY_ALT = 0x04,
	RETRO_KEYBOARD_MODIFIER_KEY_META = 0x08,
	RETRO_KEYBOARD_MODIFIER_KEY_NUMLOCK = 0x10,
	RETRO_KEYBOARD_MODIFIER_KEY_CAPSLOCK = 0x20,
	RETRO_KEYBOARD_MODIFIER_KEY_SCROLLOCK = 0x40
} RetroKeyboardModifierKey;

typedef guint (*RetroApiVersion) ();
struct _RetroSystemInfo {
	gchar* library_name;
	gchar* library_version;
	gchar* valid_extensions;
	gboolean need_fullpath;
	gboolean block_extract;
};

typedef void (*RetroGetSystemInfo) (RetroSystemInfo* info);
typedef void (*RetroInit) ();

static gpointer retro_core_parent_class = NULL;
static GRecMutex retro_core_r_mutex;
static GRecMutex retro_core_r_mutex = {0};
static GRecMutex retro_core_w_mutex;
static GRecMutex retro_core_w_mutex = {0};
static RetroCore** retro_core_objects;
static gint retro_core_objects_length1;
static RetroCore** retro_core_objects = NULL;
static gint retro_core_objects_length1 = 0;
static gint _retro_core_objects_size_ = 0;
static gint retro_core_i;
static gint retro_core_i = 0;

GType retro_core_get_type (void) G_GNUC_CONST;
GType retro_module_get_type (void) G_GNUC_CONST;
GType retro_variable_get_type (void) G_GNUC_CONST;
RetroVariable* retro_variable_dup (const RetroVariable* self);
void retro_variable_free (RetroVariable* self);
void retro_variable_copy (const RetroVariable* self, RetroVariable* dest);
void retro_variable_destroy (RetroVariable* self);
GType retro_variables_get_type (void) G_GNUC_CONST;
GType retro_pixel_format_get_type (void) G_GNUC_CONST;
GType retro_rotation_get_type (void) G_GNUC_CONST;
GType retro_disk_control_get_type (void) G_GNUC_CONST;
GType retro_device_type_get_type (void) G_GNUC_CONST;
GType retro_input_descriptor_get_type (void) G_GNUC_CONST;
RetroInputDescriptor* retro_input_descriptor_dup (const RetroInputDescriptor* self);
void retro_input_descriptor_free (RetroInputDescriptor* self);
void retro_input_descriptor_copy (const RetroInputDescriptor* self, RetroInputDescriptor* dest);
void retro_input_descriptor_destroy (RetroInputDescriptor* self);
GType retro_input_device_get_type (void) G_GNUC_CONST;
GType retro_input_get_type (void) G_GNUC_CONST;
GType retro_rumble_effect_get_type (void) G_GNUC_CONST;
GType retro_rumble_get_type (void) G_GNUC_CONST;
#define RETRO_CORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RETRO_TYPE_CORE, RetroCorePrivate))
enum  {
	RETRO_CORE_DUMMY_PROPERTY,
	RETRO_CORE_API_VERSION,
	RETRO_CORE_SYSTEM_INFO,
	RETRO_CORE_FILE_NAME,
	RETRO_CORE_SYSTEM_DIRECTORY,
	RETRO_CORE_LIBRETRO_PATH,
	RETRO_CORE_CONTENT_DIRECTORY,
	RETRO_CORE_SAVE_DIRECTORY,
	RETRO_CORE_IS_INITIATED,
	RETRO_CORE_GAME_LOADED,
	RETRO_CORE_SUPPORT_NO_GAME,
	RETRO_CORE_FRAMES_PER_SECOND,
	RETRO_CORE_DISK_CONTROL_INTERFACE,
	RETRO_CORE_INPUT_INTERFACE,
	RETRO_CORE_RUMBLE_INTERFACE
};
void retro_core_push_cb_data (RetroCore* self);
gboolean retro_core_get_game_loaded (RetroCore* self);
RetroUnloadGame retro_module_get_unload_game (RetroModule* self);
RetroDeinit retro_module_get_deinit (RetroModule* self);
void retro_core_pop_cb_data (void);
RetroCore* retro_core_get_cb_data (void);
void retro_core_set_environment_interface (RetroCore* self);
void retro_core_set_callbacks (RetroCore* self);
RetroCore* retro_core_new (const gchar* file_name);
RetroCore* retro_core_construct (GType object_type, const gchar* file_name);
void retro_core_set_controller_port_device (RetroCore* self, guint port, RetroDeviceType device);
RetroSetControllerPortDevice retro_module_get_set_controller_port_device (RetroModule* self);
void retro_core_reset (RetroCore* self);
RetroReset retro_module_get_reset (RetroModule* self);
void retro_core_run (RetroCore* self);
RetroRun retro_module_get_run (RetroModule* self);
gboolean retro_core_supports_serialization (RetroCore* self);
guint8* retro_core_serialize_state (RetroCore* self, gsize* result_length1, GError** error);
void retro_core_deserialize_state (RetroCore* self, guint8* data, gsize data_length1, GError** error);
GType retro_game_info_get_type (void) G_GNUC_CONST;
RetroGameInfo* retro_game_info_dup (const RetroGameInfo* self);
void retro_game_info_free (RetroGameInfo* self);
void retro_game_info_copy (const RetroGameInfo* self, RetroGameInfo* dest);
void retro_game_info_destroy (RetroGameInfo* self);
gboolean retro_core_load_game (RetroCore* self, RetroGameInfo* game);
RetroLoadGame retro_module_get_load_game (RetroModule* self);
static void retro_core_set_game_loaded (RetroCore* self, gboolean value);
GType retro_system_av_info_get_type (void) G_GNUC_CONST;
GType retro_game_geometry_get_type (void) G_GNUC_CONST;
RetroGameGeometry* retro_game_geometry_dup (const RetroGameGeometry* self);
void retro_game_geometry_free (RetroGameGeometry* self);
GType retro_system_timing_get_type (void) G_GNUC_CONST;
RetroSystemTiming* retro_system_timing_dup (const RetroSystemTiming* self);
void retro_system_timing_free (RetroSystemTiming* self);
RetroSystemAvInfo* retro_system_av_info_dup (const RetroSystemAvInfo* self);
void retro_system_av_info_free (RetroSystemAvInfo* self);
RetroGetSystemAvInfo retro_module_get_get_system_av_info (RetroModule* self);
void retro_core_set_system_av_info (RetroCore* self, RetroSystemAvInfo* system_av_info);
gboolean retro_core_prepare (RetroCore* self);
GType retro_memory_type_get_type (void) G_GNUC_CONST;
gsize retro_core_get_memory_size (RetroCore* self, RetroMemoryType id);
RetroGetMemorySize retro_module_get_get_memory_size (RetroModule* self);
guint8* retro_core_get_memory (RetroCore* self, RetroMemoryType id, int* result_length1);
void retro_core_set_memory (RetroCore* self, RetroMemoryType id, guint8* data, int data_length1);
static void retro_core_init_input (RetroCore* self);
RetroInput* retro_core_get_input_interface (RetroCore* self);
void retro_input_foreach_controller (RetroInput* self, RetroInputControllerCallback callback, void* callback_target);
static void retro_core_init_controller_device (RetroCore* self, guint port, RetroInputDevice* device);
static void _retro_core_init_controller_device_retro_input_controller_callback (guint port, RetroInputDevice* device, gpointer self);
RetroDeviceType retro_input_device_get_device_type (RetroInputDevice* self);
static void retro_core_on_input_controller_connected (RetroCore* self, guint port, RetroInputDevice* device);
gboolean retro_core_get_is_initiated (RetroCore* self);
static void retro_core_on_input_controller_disconnected (RetroCore* self, guint port);
GType retro_keyboard_key_get_type (void) G_GNUC_CONST;
GType retro_keyboard_modifier_key_get_type (void) G_GNUC_CONST;
static void retro_core_on_input_key_event (RetroCore* self, gboolean down, RetroKeyboardKey keycode, guint32 character, RetroKeyboardModifierKey key_modifiers);
guint retro_core_get_api_version (RetroCore* self);
RetroApiVersion retro_module_get_api_version (RetroModule* self);
GType retro_system_info_get_type (void) G_GNUC_CONST;
RetroSystemInfo* retro_system_info_dup (const RetroSystemInfo* self);
void retro_system_info_free (RetroSystemInfo* self);
void retro_system_info_copy (const RetroSystemInfo* self, RetroSystemInfo* dest);
void retro_system_info_destroy (RetroSystemInfo* self);
void retro_core_get_system_info (RetroCore* self, RetroSystemInfo * result);
RetroGetSystemInfo retro_module_get_get_system_info (RetroModule* self);
const gchar* retro_core_get_file_name (RetroCore* self);
static void retro_core_set_file_name (RetroCore* self, const gchar* value);
const gchar* retro_core_get_system_directory (RetroCore* self);
void retro_core_set_system_directory (RetroCore* self, const gchar* value);
const gchar* retro_core_get_libretro_path (RetroCore* self);
void retro_core_set_libretro_path (RetroCore* self, const gchar* value);
const gchar* retro_core_get_content_directory (RetroCore* self);
void retro_core_set_content_directory (RetroCore* self, const gchar* value);
const gchar* retro_core_get_save_directory (RetroCore* self);
void retro_core_set_save_directory (RetroCore* self, const gchar* value);
static void retro_core_set_is_initiated (RetroCore* self, gboolean value);
gboolean retro_core_get_support_no_game (RetroCore* self);
void retro_core_set_support_no_game (RetroCore* self, gboolean value);
gdouble retro_core_get_frames_per_second (RetroCore* self);
RetroDiskControl* retro_core_get_disk_control_interface (RetroCore* self);
void retro_core_set_disk_control_interface (RetroCore* self, RetroDiskControl* value);
void retro_core_set_input_interface (RetroCore* self, RetroInput* value);
static void _retro_core_on_input_controller_connected_retro_input_controller_connected (RetroInput* _sender, guint port, RetroInputDevice* device, gpointer self);
static void _retro_core_on_input_controller_disconnected_retro_input_controller_disconnected (RetroInput* _sender, guint port, gpointer self);
static void _retro_core_on_input_key_event_retro_input_key_event (RetroInput* _sender, gboolean down, RetroKeyboardKey keycode, guint32 character, RetroKeyboardModifierKey key_modifiers, gpointer self);
RetroRumble* retro_core_get_rumble_interface (RetroCore* self);
void retro_core_set_rumble_interface (RetroCore* self, RetroRumble* value);
static void g_cclosure_user_marshal_VOID__POINTER_INT_UINT_UINT_ULONG_ENUM_FLOAT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__POINTER_INT_DOUBLE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_BOOLEAN__VOID (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_BOOLEAN__STRING_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void retro_core_real_init (RetroCore* self);
RetroInit retro_module_get_init (RetroModule* self);
static GObject * retro_core_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
RetroModule* retro_module_new (const gchar* file_name);
RetroModule* retro_module_construct (GType object_type, const gchar* file_name);
RetroOptions* retro_options_new (void);
RetroOptions* retro_options_construct (GType object_type);
GType retro_options_get_type (void) G_GNUC_CONST;
static void retro_core_finalize (GObject * obj);
static void _vala_retro_core_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_retro_core_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
 * Stores the current Core instance in a stack.
 *
 * Stores the current instance of Core in a thread local global stack.
 * It allows to know wich Core a callback is related to.
 *
 * Must be called before any call to a function from the module.
 */
void retro_core_push_cb_data (RetroCore* self) {
	gint _tmp0_;
	RetroCore** _tmp1_;
	gint _tmp1__length1;
	RetroCore** _tmp3_;
	gint _tmp3__length1;
	gint _tmp4_;
	RetroCore* _tmp5_;
	gint _tmp6_;
	g_return_if_fail (self != NULL);
	g_rec_mutex_lock (&retro_core_w_mutex);
	g_rec_mutex_lock (&retro_core_r_mutex);
	_tmp0_ = retro_core_i;
	_tmp1_ = retro_core_objects;
	_tmp1__length1 = retro_core_objects_length1;
	if (_tmp0_ == _tmp1__length1) {
		FILE* _tmp2_;
		_tmp2_ = stderr;
		fprintf (_tmp2_, "Error: Callback data stack overflow.\n");
		g_rec_mutex_unlock (&retro_core_r_mutex);
		g_assert_not_reached ();
	}
	_tmp3_ = retro_core_objects;
	_tmp3__length1 = retro_core_objects_length1;
	_tmp4_ = retro_core_i;
	_tmp3_[_tmp4_] = self;
	_tmp5_ = _tmp3_[_tmp4_];
	_tmp6_ = retro_core_i;
	retro_core_i = _tmp6_ + 1;
	g_rec_mutex_unlock (&retro_core_r_mutex);
}


/**
 * Removes the Core at the head of the stack.
 *
 * Must be called after any call to {@link push_cb_data()}.
 */
void retro_core_pop_cb_data (void) {
	gint _tmp0_;
	gint _tmp2_;
	RetroCore** _tmp3_;
	gint _tmp3__length1;
	gint _tmp4_;
	RetroCore* _tmp5_;
	g_rec_mutex_lock (&retro_core_r_mutex);
	_tmp0_ = retro_core_i;
	if (_tmp0_ == 0) {
		FILE* _tmp1_;
		_tmp1_ = stderr;
		fprintf (_tmp1_, "Error: Callback data stack underflow.\n");
		g_rec_mutex_unlock (&retro_core_r_mutex);
		g_rec_mutex_unlock (&retro_core_w_mutex);
		g_assert_not_reached ();
	}
	_tmp2_ = retro_core_i;
	retro_core_i = _tmp2_ - 1;
	_tmp3_ = retro_core_objects;
	_tmp3__length1 = retro_core_objects_length1;
	_tmp4_ = retro_core_i;
	_tmp3_[_tmp4_] = NULL;
	_tmp5_ = _tmp3_[_tmp4_];
	g_rec_mutex_unlock (&retro_core_r_mutex);
	g_rec_mutex_unlock (&retro_core_w_mutex);
}


RetroCore* retro_core_get_cb_data (void) {
	RetroCore* result = NULL;
	gint _tmp0_;
	RetroCore* _result_;
	RetroCore** _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_;
	RetroCore* _tmp4_;
	g_rec_mutex_lock (&retro_core_r_mutex);
	_tmp0_ = retro_core_i;
	if (_tmp0_ == 0) {
		FILE* _tmp1_;
		_tmp1_ = stderr;
		fprintf (_tmp1_, "Error: Callback data segmentation fault.\n");
		g_rec_mutex_unlock (&retro_core_r_mutex);
		g_assert_not_reached ();
	}
	_tmp2_ = retro_core_objects;
	_tmp2__length1 = retro_core_objects_length1;
	_tmp3_ = retro_core_i;
	_tmp4_ = _tmp2_[_tmp3_ - 1];
	_result_ = _tmp4_;
	g_rec_mutex_unlock (&retro_core_r_mutex);
	result = _result_;
	return result;
}


/**
 * Creates a Core from the file name of a Libretro implementation.
 *
 * The file must be a dynamically loadable shared object implementing the
 * same version of the Libretro API as Retro.
 *
 * @param file_name the file name of the Libretro implementation to load
 */
RetroCore* retro_core_construct (GType object_type, const gchar* file_name) {
	RetroCore * self = NULL;
	const gchar* _tmp0_;
	g_return_val_if_fail (file_name != NULL, NULL);
	_tmp0_ = file_name;
	self = (RetroCore*) g_object_new (object_type, "file-name", _tmp0_, NULL);
	return self;
}


RetroCore* retro_core_new (const gchar* file_name) {
	return retro_core_construct (RETRO_TYPE_CORE, file_name);
}


/**
 * Sets device to be used for player 'port'.
 *
 * @param port the port on wich to connect a device
 * @param device the type of the device connected
 */
void retro_core_set_controller_port_device (RetroCore* self, guint port, RetroDeviceType device) {
	RetroModule* _tmp0_;
	RetroSetControllerPortDevice _tmp1_;
	RetroSetControllerPortDevice _tmp2_;
	guint _tmp3_;
	RetroDeviceType _tmp4_;
	g_return_if_fail (self != NULL);
	retro_core_push_cb_data (self);
	_tmp0_ = self->module;
	_tmp1_ = retro_module_get_set_controller_port_device (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = port;
	_tmp4_ = device;
	_tmp2_ (_tmp3_, _tmp4_);
	retro_core_pop_cb_data ();
}


/**
 * Resets the current game.
 */
void retro_core_reset (RetroCore* self) {
	RetroModule* _tmp0_;
	RetroReset _tmp1_;
	RetroReset _tmp2_;
	g_return_if_fail (self != NULL);
	retro_core_push_cb_data (self);
	_tmp0_ = self->module;
	_tmp1_ = retro_module_get_reset (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp2_ ();
	retro_core_pop_cb_data ();
}


/**
 * Runs the game for one video frame.
 *
 * The callbacks must be set and the core must be initialized before
 * running the core.
 *
 * During {@link run}, the input_poll callback will be called
 * at least once.
 *
 * If a frame is not rendered for reasons where a game "dropped" a frame,
 * this still counts as a frame, and {@link run} will explicitly dupe a
 * frame if the can_dupe property of {@link video_interface} is set to true.
 * In this case, the video callback can take a null argument for data.
 */
void retro_core_run (RetroCore* self) {
	RetroModule* _tmp0_;
	RetroRun _tmp1_;
	RetroRun _tmp2_;
	g_return_if_fail (self != NULL);
	retro_core_push_cb_data (self);
	_tmp0_ = self->module;
	_tmp1_ = retro_module_get_run (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp2_ ();
	retro_core_pop_cb_data ();
}


/**
 * Load. a game.
 *
 * @param game information to load the game
 * @return false if the loading failed, true otherwise
 */
gboolean retro_core_load_game (RetroCore* self, RetroGameInfo* game) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	RetroModule* _tmp4_;
	RetroLoadGame _tmp5_;
	RetroLoadGame _tmp6_;
	RetroGameInfo _tmp7_;
	gboolean _tmp8_;
	RetroSystemAvInfo info = {0};
	RetroModule* _tmp9_;
	RetroGetSystemAvInfo _tmp10_;
	RetroGetSystemAvInfo _tmp11_;
	RetroSystemAvInfo _tmp12_ = {0};
	RetroSystemAvInfo _tmp13_;
	gboolean _tmp14_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (game != NULL, FALSE);
	_tmp0_ = self->priv->_game_loaded;
	if (_tmp0_) {
		RetroModule* _tmp1_;
		RetroUnloadGame _tmp2_;
		RetroUnloadGame _tmp3_;
		retro_core_push_cb_data (self);
		_tmp1_ = self->module;
		_tmp2_ = retro_module_get_unload_game (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp3_ ();
		retro_core_pop_cb_data ();
	}
	retro_core_push_cb_data (self);
	_tmp4_ = self->module;
	_tmp5_ = retro_module_get_load_game (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = *game;
	_tmp8_ = _tmp6_ (&_tmp7_);
	retro_core_set_game_loaded (self, _tmp8_);
	_tmp9_ = self->module;
	_tmp10_ = retro_module_get_get_system_av_info (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp11_ (&_tmp12_);
	info = _tmp12_;
	_tmp13_ = info;
	retro_core_set_system_av_info (self, &_tmp13_);
	retro_core_pop_cb_data ();
	_tmp14_ = self->priv->_game_loaded;
	result = _tmp14_;
	return result;
}


/**
 * Prepare the standalone core.
 *
 * This should be used instead of load_game() for standalone cores.
 *
 * @return false if the preparation failed, true otherwise
 */
gboolean retro_core_prepare (RetroCore* self) {
	gboolean result = FALSE;
	RetroModule* _tmp0_;
	RetroLoadGame _tmp1_;
	RetroLoadGame _tmp2_;
	gboolean _tmp3_;
	RetroSystemAvInfo info = {0};
	RetroModule* _tmp4_;
	RetroGetSystemAvInfo _tmp5_;
	RetroGetSystemAvInfo _tmp6_;
	RetroSystemAvInfo _tmp7_ = {0};
	RetroSystemAvInfo _tmp8_;
	gboolean _tmp9_;
	g_return_val_if_fail (self != NULL, FALSE);
	retro_core_push_cb_data (self);
	_tmp0_ = self->module;
	_tmp1_ = retro_module_get_load_game (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_ (NULL);
	retro_core_set_game_loaded (self, _tmp3_);
	_tmp4_ = self->module;
	_tmp5_ = retro_module_get_get_system_av_info (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp6_ (&_tmp7_);
	info = _tmp7_;
	_tmp8_ = info;
	retro_core_set_system_av_info (self, &_tmp8_);
	retro_core_pop_cb_data ();
	_tmp9_ = self->priv->_game_loaded;
	result = _tmp9_;
	return result;
}


/**
 * Gets the size of a region of memory.
 *
 * @param id the region of memory
 * @return the size of the region of memory
 */
gsize retro_core_get_memory_size (RetroCore* self, RetroMemoryType id) {
	gsize result = 0UL;
	gsize _result_;
	RetroModule* _tmp0_;
	RetroGetMemorySize _tmp1_;
	RetroGetMemorySize _tmp2_;
	RetroMemoryType _tmp3_;
	gsize _tmp4_;
	g_return_val_if_fail (self != NULL, 0UL);
	retro_core_push_cb_data (self);
	_tmp0_ = self->module;
	_tmp1_ = retro_module_get_get_memory_size (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = id;
	_tmp4_ = _tmp2_ (_tmp3_);
	_result_ = _tmp4_;
	retro_core_pop_cb_data ();
	result = _result_;
	return result;
}


/**
 * Gets a region of memory.
 *
 * @param id the region of memory
 * @return the region of memory
 */
/**
 * Sets a region of memory.
 *
 * @param id the region of memory
 * @param data the data to write in the memory region
 */
static void _retro_core_init_controller_device_retro_input_controller_callback (guint port, RetroInputDevice* device, gpointer self) {
	retro_core_init_controller_device ((RetroCore*) self, port, device);
}


static void retro_core_init_input (RetroCore* self) {
	RetroInput* _tmp0_;
	RetroInput* _tmp1_;
	RetroInput* _tmp2_;
	RetroInput* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = retro_core_get_input_interface (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = retro_core_get_input_interface (self);
	_tmp3_ = _tmp2_;
	retro_input_foreach_controller (_tmp3_, _retro_core_init_controller_device_retro_input_controller_callback, self);
}


static void retro_core_init_controller_device (RetroCore* self, guint port, RetroInputDevice* device) {
	RetroDeviceType device_type;
	RetroInputDevice* _tmp0_;
	RetroDeviceType _tmp1_;
	guint _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	_tmp0_ = device;
	_tmp1_ = retro_input_device_get_device_type (_tmp0_);
	device_type = _tmp1_;
	_tmp2_ = port;
	retro_core_set_controller_port_device (self, _tmp2_, device_type);
}


static void retro_core_on_input_controller_connected (RetroCore* self, guint port, RetroInputDevice* device) {
	gboolean _tmp0_;
	RetroDeviceType device_type;
	RetroInputDevice* _tmp1_;
	RetroDeviceType _tmp2_;
	guint _tmp3_;
	RetroDeviceType _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	_tmp0_ = self->priv->_is_initiated;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = device;
	_tmp2_ = retro_input_device_get_device_type (_tmp1_);
	device_type = _tmp2_;
	_tmp3_ = port;
	_tmp4_ = device_type;
	retro_core_set_controller_port_device (self, _tmp3_, _tmp4_);
}


static void retro_core_on_input_controller_disconnected (RetroCore* self, guint port) {
	gboolean _tmp0_;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_is_initiated;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = port;
	retro_core_set_controller_port_device (self, _tmp1_, RETRO_DEVICE_TYPE_NONE);
}


static void retro_core_on_input_key_event (RetroCore* self, gboolean down, RetroKeyboardKey keycode, guint32 character, RetroKeyboardModifierKey key_modifiers) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_is_initiated;
	if (!_tmp0_) {
		return;
	}
}


guint retro_core_get_api_version (RetroCore* self) {
	guint result;
	guint _result_;
	RetroModule* _tmp0_;
	RetroApiVersion _tmp1_;
	RetroApiVersion _tmp2_;
	guint _tmp3_;
	g_return_val_if_fail (self != NULL, 0U);
	retro_core_push_cb_data (self);
	_tmp0_ = self->module;
	_tmp1_ = retro_module_get_api_version (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_ ();
	_result_ = _tmp3_;
	retro_core_pop_cb_data ();
	result = _result_;
	return result;
}


void retro_core_get_system_info (RetroCore* self, RetroSystemInfo * result) {
	RetroSystemInfo info = {0};
	RetroModule* _tmp0_;
	RetroGetSystemInfo _tmp1_;
	RetroGetSystemInfo _tmp2_;
	RetroSystemInfo _tmp3_ = {0};
	RetroSystemInfo _tmp4_;
	g_return_if_fail (self != NULL);
	retro_core_push_cb_data (self);
	_tmp0_ = self->module;
	_tmp1_ = retro_module_get_get_system_info (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp2_ (&_tmp3_);
	info = _tmp3_;
	retro_core_pop_cb_data ();
	_tmp4_ = info;
	*result = _tmp4_;
	return;
}


const gchar* retro_core_get_file_name (RetroCore* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_file_name;
	result = _tmp0_;
	return result;
}


static void retro_core_set_file_name (RetroCore* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, retro_core_get_file_name (self)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_file_name);
		self->priv->_file_name = _tmp1_;
		g_object_notify ((GObject *) self, "file-name");
	}
}


const gchar* retro_core_get_system_directory (RetroCore* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_system_directory;
	result = _tmp0_;
	return result;
}


void retro_core_set_system_directory (RetroCore* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, retro_core_get_system_directory (self)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_system_directory);
		self->priv->_system_directory = _tmp1_;
		g_object_notify ((GObject *) self, "system-directory");
	}
}


const gchar* retro_core_get_libretro_path (RetroCore* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_libretro_path;
	result = _tmp0_;
	return result;
}


void retro_core_set_libretro_path (RetroCore* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, retro_core_get_libretro_path (self)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_libretro_path);
		self->priv->_libretro_path = _tmp1_;
		g_object_notify ((GObject *) self, "libretro-path");
	}
}


const gchar* retro_core_get_content_directory (RetroCore* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_content_directory;
	result = _tmp0_;
	return result;
}


void retro_core_set_content_directory (RetroCore* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, retro_core_get_content_directory (self)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_content_directory);
		self->priv->_content_directory = _tmp1_;
		g_object_notify ((GObject *) self, "content-directory");
	}
}


const gchar* retro_core_get_save_directory (RetroCore* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_save_directory;
	result = _tmp0_;
	return result;
}


void retro_core_set_save_directory (RetroCore* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, retro_core_get_save_directory (self)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_save_directory);
		self->priv->_save_directory = _tmp1_;
		g_object_notify ((GObject *) self, "save-directory");
	}
}


gboolean retro_core_get_is_initiated (RetroCore* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_initiated;
	result = _tmp0_;
	return result;
}


static void retro_core_set_is_initiated (RetroCore* self, gboolean value) {
	g_return_if_fail (self != NULL);
	if (retro_core_get_is_initiated (self) != value) {
		gboolean _tmp0_;
		_tmp0_ = value;
		self->priv->_is_initiated = _tmp0_;
		g_object_notify ((GObject *) self, "is-initiated");
	}
}


gboolean retro_core_get_game_loaded (RetroCore* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_game_loaded;
	result = _tmp0_;
	return result;
}


static void retro_core_set_game_loaded (RetroCore* self, gboolean value) {
	g_return_if_fail (self != NULL);
	if (retro_core_get_game_loaded (self) != value) {
		gboolean _tmp0_;
		_tmp0_ = value;
		self->priv->_game_loaded = _tmp0_;
		g_object_notify ((GObject *) self, "game-loaded");
	}
}


gboolean retro_core_get_support_no_game (RetroCore* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_support_no_game;
	result = _tmp0_;
	return result;
}


void retro_core_set_support_no_game (RetroCore* self, gboolean value) {
	g_return_if_fail (self != NULL);
	if (retro_core_get_support_no_game (self) != value) {
		gboolean _tmp0_;
		_tmp0_ = value;
		self->priv->_support_no_game = _tmp0_;
		g_object_notify ((GObject *) self, "support-no-game");
	}
}


gdouble retro_core_get_frames_per_second (RetroCore* self) {
	gdouble result;
	gdouble _tmp0_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->_frames_per_second;
	result = _tmp0_;
	return result;
}


RetroDiskControl* retro_core_get_disk_control_interface (RetroCore* self) {
	RetroDiskControl* result;
	RetroDiskControl* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_disk_control_interface;
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void retro_core_set_disk_control_interface (RetroCore* self, RetroDiskControl* value) {
	g_return_if_fail (self != NULL);
	if (retro_core_get_disk_control_interface (self) != value) {
		RetroDiskControl* _tmp0_;
		RetroDiskControl* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_g_object_unref0 (self->priv->_disk_control_interface);
		self->priv->_disk_control_interface = _tmp1_;
		g_object_notify ((GObject *) self, "disk-control-interface");
	}
}


RetroInput* retro_core_get_input_interface (RetroCore* self) {
	RetroInput* result;
	RetroInput* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_input_interface;
	result = _tmp0_;
	return result;
}


static void _retro_core_on_input_controller_connected_retro_input_controller_connected (RetroInput* _sender, guint port, RetroInputDevice* device, gpointer self) {
	retro_core_on_input_controller_connected ((RetroCore*) self, port, device);
}


static void _retro_core_on_input_controller_disconnected_retro_input_controller_disconnected (RetroInput* _sender, guint port, gpointer self) {
	retro_core_on_input_controller_disconnected ((RetroCore*) self, port);
}


static void _retro_core_on_input_key_event_retro_input_key_event (RetroInput* _sender, gboolean down, RetroKeyboardKey keycode, guint32 character, RetroKeyboardModifierKey key_modifiers, gpointer self) {
	retro_core_on_input_key_event ((RetroCore*) self, down, keycode, character, key_modifiers);
}


void retro_core_set_input_interface (RetroCore* self, RetroInput* value) {
	g_return_if_fail (self != NULL);
	if (retro_core_get_input_interface (self) != value) {
		RetroInput* _tmp0_;
		RetroInput* _tmp1_;
		RetroInput* _tmp2_;
		RetroInput* _tmp3_;
		RetroInput* _tmp4_;
		RetroInput* _tmp14_;
		RetroInput* _tmp15_;
		RetroInput* _tmp16_;
		RetroInput* _tmp17_;
		RetroInput* _tmp18_;
		RetroInput* _tmp19_;
		RetroInput* _tmp20_;
		RetroInput* _tmp21_;
		RetroInput* _tmp22_;
		gboolean _tmp23_;
		_tmp0_ = value;
		_tmp1_ = retro_core_get_input_interface (self);
		_tmp2_ = _tmp1_;
		if (_tmp0_ == _tmp2_) {
			return;
		}
		_tmp3_ = retro_core_get_input_interface (self);
		_tmp4_ = _tmp3_;
		if (_tmp4_ != NULL) {
			RetroInput* _tmp5_;
			RetroInput* _tmp6_;
			gulong _tmp7_;
			RetroInput* _tmp8_;
			RetroInput* _tmp9_;
			gulong _tmp10_;
			RetroInput* _tmp11_;
			RetroInput* _tmp12_;
			gulong _tmp13_;
			_tmp5_ = retro_core_get_input_interface (self);
			_tmp6_ = _tmp5_;
			_tmp7_ = self->priv->input_controller_connected_id;
			g_signal_handler_disconnect ((GObject*) _tmp6_, _tmp7_);
			_tmp8_ = retro_core_get_input_interface (self);
			_tmp9_ = _tmp8_;
			_tmp10_ = self->priv->input_controller_disconnected_id;
			g_signal_handler_disconnect ((GObject*) _tmp9_, _tmp10_);
			_tmp11_ = retro_core_get_input_interface (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = self->priv->input_key_event_id;
			g_signal_handler_disconnect ((GObject*) _tmp12_, _tmp13_);
		}
		_tmp14_ = value;
		self->priv->_input_interface = _tmp14_;
		_tmp15_ = retro_core_get_input_interface (self);
		_tmp16_ = _tmp15_;
		if (_tmp16_ == NULL) {
			return;
		}
		_tmp17_ = retro_core_get_input_interface (self);
		_tmp18_ = _tmp17_;
		g_signal_connect_object (_tmp18_, "controller-connected", (GCallback) _retro_core_on_input_controller_connected_retro_input_controller_connected, self, 0);
		_tmp19_ = retro_core_get_input_interface (self);
		_tmp20_ = _tmp19_;
		g_signal_connect_object (_tmp20_, "controller-disconnected", (GCallback) _retro_core_on_input_controller_disconnected_retro_input_controller_disconnected, self, 0);
		_tmp21_ = retro_core_get_input_interface (self);
		_tmp22_ = _tmp21_;
		g_signal_connect_object (_tmp22_, "key-event", (GCallback) _retro_core_on_input_key_event_retro_input_key_event, self, 0);
		_tmp23_ = self->priv->_is_initiated;
		if (_tmp23_) {
			retro_core_init_input (self);
		}
		g_object_notify ((GObject *) self, "input-interface");
	}
}


RetroRumble* retro_core_get_rumble_interface (RetroCore* self) {
	RetroRumble* result;
	RetroRumble* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_rumble_interface;
	result = _tmp0_;
	return result;
}


void retro_core_set_rumble_interface (RetroCore* self, RetroRumble* value) {
	g_return_if_fail (self != NULL);
	if (retro_core_get_rumble_interface (self) != value) {
		RetroRumble* _tmp0_;
		RetroRumble* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_g_object_unref0 (self->priv->_rumble_interface);
		self->priv->_rumble_interface = _tmp1_;
		g_object_notify ((GObject *) self, "rumble-interface");
	}
}


static void g_cclosure_user_marshal_VOID__POINTER_INT_UINT_UINT_ULONG_ENUM_FLOAT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__POINTER_INT_UINT_UINT_ULONG_ENUM_FLOAT) (gpointer data1, gpointer arg_1, gint arg_2, guint arg_3, guint arg_4, gsize arg_5, gint arg_6, gfloat arg_7, gpointer data2);
	register GMarshalFunc_VOID__POINTER_INT_UINT_UINT_ULONG_ENUM_FLOAT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 8);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__POINTER_INT_UINT_UINT_ULONG_ENUM_FLOAT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_pointer (param_values + 1), g_value_get_int (param_values + 2), g_value_get_uint (param_values + 3), g_value_get_uint (param_values + 4), g_value_get_ulong (param_values + 5), g_value_get_enum (param_values + 6), g_value_get_float (param_values + 7), data2);
}


static void g_cclosure_user_marshal_VOID__POINTER_INT_DOUBLE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__POINTER_INT_DOUBLE) (gpointer data1, gpointer arg_1, gint arg_2, gdouble arg_3, gpointer data2);
	register GMarshalFunc_VOID__POINTER_INT_DOUBLE callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__POINTER_INT_DOUBLE) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_pointer (param_values + 1), g_value_get_int (param_values + 2), g_value_get_double (param_values + 3), data2);
}


static void g_cclosure_user_marshal_BOOLEAN__VOID (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__VOID) (gpointer data1, gpointer data2);
	register GMarshalFunc_BOOLEAN__VOID callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 1);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_BOOLEAN__VOID) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, data2);
	g_value_set_boolean (return_value, v_return);
}


static void g_cclosure_user_marshal_BOOLEAN__STRING_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__STRING_UINT) (gpointer data1, const char* arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_BOOLEAN__STRING_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_BOOLEAN__STRING_UINT) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, g_value_get_string (param_values + 1), g_value_get_uint (param_values + 2), data2);
	g_value_set_boolean (return_value, v_return);
}


static void retro_core_real_init (RetroCore* self) {
	RetroModule* _tmp0_;
	RetroInit _tmp1_;
	RetroInit _tmp2_;
	retro_core_set_environment_interface (self);
	retro_core_push_cb_data (self);
	_tmp0_ = self->module;
	_tmp1_ = retro_module_get_init (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp2_ ();
	retro_core_pop_cb_data ();
	retro_core_init_input (self);
	retro_core_set_is_initiated (self, TRUE);
}


static GObject * retro_core_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	RetroCore * self;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	RetroModule* _tmp8_;
	RetroOptions* _tmp9_;
	parent_class = G_OBJECT_CLASS (retro_core_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RETRO_TYPE_CORE, RetroCore);
	_tmp0_ = self->priv->_file_name;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_file_resolve_relative_path (_tmp2_, "");
	_tmp4_ = _tmp3_;
	_tmp5_ = g_file_get_path (_tmp4_);
	_tmp6_ = _tmp5_;
	retro_core_set_libretro_path (self, _tmp6_);
	_g_free0 (_tmp6_);
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
	_tmp7_ = self->priv->_libretro_path;
	_tmp8_ = retro_module_new (_tmp7_);
	_g_object_unref0 (self->module);
	self->module = _tmp8_;
	retro_core_set_callbacks (self);
	_tmp9_ = retro_options_new ();
	_g_object_unref0 (self->variables_interface);
	self->variables_interface = (RetroVariables*) _tmp9_;
	return obj;
}


static void retro_core_class_init (RetroCoreClass * klass) {
	RetroCore** _tmp0_;
	retro_core_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RetroCorePrivate));
	((RetroCoreClass *) klass)->init = retro_core_real_init;
	G_OBJECT_CLASS (klass)->get_property = _vala_retro_core_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_retro_core_set_property;
	G_OBJECT_CLASS (klass)->constructor = retro_core_constructor;
	G_OBJECT_CLASS (klass)->finalize = retro_core_finalize;
	/**
	 * The version of Libretro used by the module.
	 *
	 * Can be compared with {@link API_VERSION} to validate ABI
	 * compatibility.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_CORE_API_VERSION, g_param_spec_uint ("api-version", "api-version", "api-version", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * The system informations.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_CORE_SYSTEM_INFO, g_param_spec_boxed ("system-info", "system-info", "system-info", RETRO_TYPE_SYSTEM_INFO, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * The file name of the module.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_CORE_FILE_NAME, g_param_spec_string ("file-name", "file-name", "file-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	 * The directory the core will use to look for for additional data.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_CORE_SYSTEM_DIRECTORY, g_param_spec_string ("system-directory", "system-directory", "system-directory", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The absolute path to the source module file.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_CORE_LIBRETRO_PATH, g_param_spec_string ("libretro-path", "libretro-path", "libretro-path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The directory the core will use to look for for additional assets.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_CORE_CONTENT_DIRECTORY, g_param_spec_string ("content-directory", "content-directory", "content-directory", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The directory the core will use to save user data.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_CORE_SAVE_DIRECTORY, g_param_spec_string ("save-directory", "save-directory", "save-directory", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * Whether or not the a game is loaded.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_CORE_IS_INITIATED, g_param_spec_boolean ("is-initiated", "is-initiated", "is-initiated", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * Whether or not the a game is loaded.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_CORE_GAME_LOADED, g_param_spec_boolean ("game-loaded", "game-loaded", "game-loaded", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * Whether or not the core supports games.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_CORE_SUPPORT_NO_GAME, g_param_spec_boolean ("support-no-game", "support-no-game", "support-no-game", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_CORE_FRAMES_PER_SECOND, g_param_spec_double ("frames-per-second", "frames-per-second", "frames-per-second", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * The disk controlling interface.
	 *
	 * The Core can set it to let the frontend insert and eject disks images.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_CORE_DISK_CONTROL_INTERFACE, g_param_spec_object ("disk-control-interface", "disk-control-interface", "disk-control-interface", RETRO_TYPE_DISK_CONTROL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The input interface.
	 *
	 * It must be set before {@link init} is called.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_CORE_INPUT_INTERFACE, g_param_spec_object ("input-interface", "input-interface", "input-interface", RETRO_TYPE_INPUT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	 * The rumble interface.
	 *
	 * Optional.
	 * If set, it must be set before {@link init} is called.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_CORE_RUMBLE_INTERFACE, g_param_spec_object ("rumble-interface", "rumble-interface", "rumble-interface", RETRO_TYPE_RUMBLE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	retro_core_signals[RETRO_CORE_VIDEO_OUTPUT_SIGNAL] = g_signal_new ("video_output", RETRO_TYPE_CORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__POINTER_INT_UINT_UINT_ULONG_ENUM_FLOAT, G_TYPE_NONE, 7, G_TYPE_POINTER, G_TYPE_INT, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_ULONG, RETRO_TYPE_PIXEL_FORMAT, G_TYPE_FLOAT);
	retro_core_signals[RETRO_CORE_AUDIO_OUTPUT_SIGNAL] = g_signal_new ("audio_output", RETRO_TYPE_CORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__POINTER_INT_DOUBLE, G_TYPE_NONE, 3, G_TYPE_POINTER, G_TYPE_INT, G_TYPE_DOUBLE);
	/**
	 * Asks the frontend to shut down.
	 */
	retro_core_signals[RETRO_CORE_SHUTDOWN_SIGNAL] = g_signal_new ("shutdown", RETRO_TYPE_CORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__VOID, G_TYPE_BOOLEAN, 0);
	/**
	 * Asks the frontend to display a message for an amount of frames.
	 */
	retro_core_signals[RETRO_CORE_MESSAGE_SIGNAL] = g_signal_new ("message", RETRO_TYPE_CORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__STRING_UINT, G_TYPE_BOOLEAN, 2, G_TYPE_STRING, G_TYPE_UINT);
	/**
	 * Initializes the module.
	 *
	 * Must be called before loading a game and running the core.
	 */
	retro_core_signals[RETRO_CORE_INIT_SIGNAL] = g_signal_new ("init", RETRO_TYPE_CORE, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (RetroCoreClass, init), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_rec_mutex_init (&retro_core_r_mutex);
	retro_core_r_mutex = retro_core_r_mutex;
	g_rec_mutex_init (&retro_core_w_mutex);
	retro_core_w_mutex = retro_core_w_mutex;
	_tmp0_ = g_new0 (RetroCore*, 32 + 1);
	retro_core_objects = _tmp0_;
	retro_core_objects_length1 = 32;
}


static void retro_core_instance_init (RetroCore * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	self->priv = RETRO_CORE_GET_PRIVATE (self);
	_tmp0_ = g_strdup (".");
	self->priv->_system_directory = _tmp0_;
	_tmp1_ = g_strdup (".");
	self->priv->_libretro_path = _tmp1_;
	_tmp2_ = g_strdup (".");
	self->priv->_content_directory = _tmp2_;
	_tmp3_ = g_strdup (".");
	self->priv->_save_directory = _tmp3_;
	self->priv->_is_initiated = FALSE;
	self->priv->_game_loaded = FALSE;
	self->priv->_support_no_game = FALSE;
}


static void retro_core_finalize (GObject * obj) {
	RetroCore * self;
	gboolean _tmp0_;
	RetroModule* _tmp4_;
	RetroDeinit _tmp5_;
	RetroDeinit _tmp6_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RETRO_TYPE_CORE, RetroCore);
	retro_core_push_cb_data (self);
	_tmp0_ = self->priv->_game_loaded;
	if (_tmp0_) {
		RetroModule* _tmp1_;
		RetroUnloadGame _tmp2_;
		RetroUnloadGame _tmp3_;
		_tmp1_ = self->module;
		_tmp2_ = retro_module_get_unload_game (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp3_ ();
	}
	_tmp4_ = self->module;
	_tmp5_ = retro_module_get_deinit (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp6_ ();
	retro_core_pop_cb_data ();
	_g_free0 (self->priv->_file_name);
	_g_free0 (self->priv->_system_directory);
	_g_free0 (self->priv->_libretro_path);
	_g_free0 (self->priv->_content_directory);
	_g_free0 (self->priv->_save_directory);
	_g_object_unref0 (self->priv->_disk_control_interface);
	_g_object_unref0 (self->priv->_rumble_interface);
	_g_object_unref0 (self->module);
	_g_object_unref0 (self->variables_interface);
	G_OBJECT_CLASS (retro_core_parent_class)->finalize (obj);
}


/**
 * Handles a Libretro module.
 */
GType retro_core_get_type (void) {
	static volatile gsize retro_core_type_id__volatile = 0;
	if (g_once_init_enter (&retro_core_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RetroCoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) retro_core_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RetroCore), 0, (GInstanceInitFunc) retro_core_instance_init, NULL };
		GType retro_core_type_id;
		retro_core_type_id = g_type_register_static (G_TYPE_OBJECT, "RetroCore", &g_define_type_info, 0);
		g_once_init_leave (&retro_core_type_id__volatile, retro_core_type_id);
	}
	return retro_core_type_id__volatile;
}


static void _vala_retro_core_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RetroCore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RETRO_TYPE_CORE, RetroCore);
	switch (property_id) {
		case RETRO_CORE_API_VERSION:
		g_value_set_uint (value, retro_core_get_api_version (self));
		break;
		case RETRO_CORE_SYSTEM_INFO:
		{
			RetroSystemInfo boxed;
			retro_core_get_system_info (self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		case RETRO_CORE_FILE_NAME:
		g_value_set_string (value, retro_core_get_file_name (self));
		break;
		case RETRO_CORE_SYSTEM_DIRECTORY:
		g_value_set_string (value, retro_core_get_system_directory (self));
		break;
		case RETRO_CORE_LIBRETRO_PATH:
		g_value_set_string (value, retro_core_get_libretro_path (self));
		break;
		case RETRO_CORE_CONTENT_DIRECTORY:
		g_value_set_string (value, retro_core_get_content_directory (self));
		break;
		case RETRO_CORE_SAVE_DIRECTORY:
		g_value_set_string (value, retro_core_get_save_directory (self));
		break;
		case RETRO_CORE_IS_INITIATED:
		g_value_set_boolean (value, retro_core_get_is_initiated (self));
		break;
		case RETRO_CORE_GAME_LOADED:
		g_value_set_boolean (value, retro_core_get_game_loaded (self));
		break;
		case RETRO_CORE_SUPPORT_NO_GAME:
		g_value_set_boolean (value, retro_core_get_support_no_game (self));
		break;
		case RETRO_CORE_FRAMES_PER_SECOND:
		g_value_set_double (value, retro_core_get_frames_per_second (self));
		break;
		case RETRO_CORE_DISK_CONTROL_INTERFACE:
		g_value_set_object (value, retro_core_get_disk_control_interface (self));
		break;
		case RETRO_CORE_INPUT_INTERFACE:
		g_value_set_object (value, retro_core_get_input_interface (self));
		break;
		case RETRO_CORE_RUMBLE_INTERFACE:
		g_value_set_object (value, retro_core_get_rumble_interface (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_retro_core_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RetroCore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RETRO_TYPE_CORE, RetroCore);
	switch (property_id) {
		case RETRO_CORE_FILE_NAME:
		retro_core_set_file_name (self, g_value_get_string (value));
		break;
		case RETRO_CORE_SYSTEM_DIRECTORY:
		retro_core_set_system_directory (self, g_value_get_string (value));
		break;
		case RETRO_CORE_LIBRETRO_PATH:
		retro_core_set_libretro_path (self, g_value_get_string (value));
		break;
		case RETRO_CORE_CONTENT_DIRECTORY:
		retro_core_set_content_directory (self, g_value_get_string (value));
		break;
		case RETRO_CORE_SAVE_DIRECTORY:
		retro_core_set_save_directory (self, g_value_get_string (value));
		break;
		case RETRO_CORE_IS_INITIATED:
		retro_core_set_is_initiated (self, g_value_get_boolean (value));
		break;
		case RETRO_CORE_GAME_LOADED:
		retro_core_set_game_loaded (self, g_value_get_boolean (value));
		break;
		case RETRO_CORE_SUPPORT_NO_GAME:
		retro_core_set_support_no_game (self, g_value_get_boolean (value));
		break;
		case RETRO_CORE_DISK_CONTROL_INTERFACE:
		retro_core_set_disk_control_interface (self, g_value_get_object (value));
		break;
		case RETRO_CORE_INPUT_INTERFACE:
		retro_core_set_input_interface (self, g_value_get_object (value));
		break;
		case RETRO_CORE_RUMBLE_INTERFACE:
		retro_core_set_rumble_interface (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



