// $Id: tuner.cc,v 1.13 2001/11/06 17:45:39 cactus Exp $
//
// RadioActive Copyright (C) 1999 RDI Gerg <cactus@cactus.rulez.org>
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2
// (included in the RadioActive distribution in doc/GPL) as published by
// the Free Software Foundation.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

#include "tuner.h"
#include <math.h>

Tuner::Tuner(double min, double max):
    tuner_data(min, min, max, 0.5, 5)
{
    set_adjustment(tuner_data);
    set_digits(2);

    tuner_data.value_changed.connect (slot (this, &Tuner::tuner_changed));
}

void Tuner::tuner_changed()
{
    double curr_value = tuner_data.get_value();
    double curr_value_int = rint((curr_value * 20));
    double rounded_value = (curr_value_int / 20);
    if (rounded_value != curr_value)
	tuner_data.set_value(rounded_value);
    else
	freq_changed (rounded_value);
}

void Tuner::set_freq (double value)
{
    tuner_data.set_value(value);
}
