// $Id: file.h,v 1.11 2001/11/06 17:45:39 cactus Exp $ -*- c++ -*-

// RadioActive Copyright (C) 1999-2000 RDI Gerg <cactus@cactus.rulez.org>
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2
// (included in the RadioActive distribution in doc/GPL) as published by
// the Free Software Foundation.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

#ifndef RADIO_file
#define RADIO_file

#include <vector>
#include <fstream>
#include <string>
#include "radioactive.h"

namespace arg /* Keep this in sync with common/file.cc */
{
    extern std::string devfile;
    extern float tune_step;
    extern double freq;
    extern int volume;
    extern int last_button;
    extern bool console;
    extern bool mute_exit;
    extern bool mute;

    extern int progbutton_row, progbutton_col;

    extern int pos_x, pos_y;
    extern bool save_pos;
}

const char* rc_file (const std::string &filename);

SpeedButtonData load_button_values (int num);
void save_button_values (const SpeedButtonData &values);

void read_config ();
void save_config ();

#endif
