/* -*- mode: C; c-basic-offset: 4 -*- */
#ifndef PYORBIT_PRIVATE_H
#define PYORBIT_PRIVATE_H

#ifdef PYORBIT_H
#  error "don't include pyorbit.h and pyorbit-private.h together"
#endif

#define _INSIDE_PYORBIT_
#include "pyorbit.h"
#undef _INSIDE_PYORBIT_

void      pyorbit_register_stub(CORBA_TypeCode tc, PyObject *stub);
CORBA_TypeCode pyorbit_lookup_typecode(const gchar *repo_id);
PyObject *pyorbit_get_stub(CORBA_TypeCode tc);
PyObject *pyorbit_get_stub_from_repo_id(const gchar *repo_id);
PyObject *pyorbit_get_stub_from_objref(CORBA_Object objref);

void      pyorbit_generate_typecode_stubs(CORBA_TypeCode tc);
void      pyorbit_generate_iinterface_stubs(ORBit_IInterface *iface);

extern PyTypeObject PyCORBA_Method_Type;
extern PyTypeObject PyCORBA_BoundMethod_Type;
void      pyorbit_add_imethods_to_stub(PyObject *stub,
				       ORBit_IMethods *imethods);

gboolean  pyorbit_marshal_any(CORBA_any *any, PyObject *value);
PyObject *pyorbit_demarshal_any(CORBA_any *any);

extern PyObject *pyorbit_exception;
extern PyObject *pyorbit_system_exception;
extern PyObject *pyorbit_user_exception;

gboolean  pyorbit_check_ex(CORBA_Environment *ev);
void      pyorbit_register_exceptions(PyObject *corbamod);

extern PyTypeObject PyCORBA_UnionMember_Type;
void      pyorbit_add_union_members_to_stub(PyObject *stub, CORBA_TypeCode tc);


#endif
