# This file is part of pybliographer
# 
# Copyright (C) 1998-2004 Frederic GOBRY
# Email : gobry@pybliographer.org
# 	   
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2 
# of the License, or (at your option) any later version.
#   
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details. 
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
# 
# 


""" This module is a formatter for HTML output """


from Pyblio import Formatter, Autoload
import string


class HTML (Formatter.Formatter):

    coding = 'HTML'
    
    def write (self, text, style = None):
        if   style == 'bold':
            self.out.write ('<b>%s</b>' % text)
        elif style == 'italic' or style == 'slanted':
            self.out.write ('<i>%s</i>' % text)
        elif style == 'emph':
            self.out.write ('<em>%s</em>' % text)
        else:
            self.out.write (text)

    def start_group (self, id, table = None):
        self.out.write ('<dl>\n')
        return
    
    def end_group (self):
        self.out.write ('</dl>\n')
        self.out.write ('<p align="right"><small>')
        self.out.write ('Generated by Pybliographer')
        self.out.write ('</small></p>\n')
        return

    def start (self, key, entry):
        if key is None: key = self.next_key ()
        
        self.out.write ('<dt>[%s]<dd>' % key)
        return

    def separator (self):
        self.out.write (" ")
        return

    
Autoload.register ('output', 'HTML', HTML)

