# This file is part of pybliographer
# 
# Copyright (C) 1998 Frederic GOBRY
# Email : gobry@idiap.ch
# 	   
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2 
# of the License, or (at your option) any later version.
#   
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details. 
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
# 
# $Id: alpha.py,v 1.1 1999/09/24 07:20:16 gobry Exp $

import string

from Pyblio import recode

def author_desc (group, coding, initials = 0):
    """ Create a nice string describing a group of authors. """
    
    l = len (group)
            
    fulltext = ""
    
    for i in range (0, l):
        (honorific, first, last, lineage) = group [i].format (coding)

        if initials:
            first = group [i].initials (coding)

        text = ""
        
        if first:   text = first + " "
        if last:    text = text + last
        if lineage: text = text + ", " + lineage

        if text:
            if i < l - 2:
                text = text + ", "
            elif i == l - 2:
                text = text + " and "

        fulltext = fulltext + text
        
    return fulltext


def generate_key (database, fmt):
    """ Generate an alphabetical key for each entry """

    rc = recode.recode (fmt.coding)
    
    def generate_one_key (entry, fmt, table, rc = rc):
        
        if entry.has_key ('author'):
            
            aut = entry ['author']
	        
            if len (aut) > 1:
                key = ''
                for a in aut:
                    honorific, first, last, lineage = a.format (fmt.coding)
                    key = key + string.join (map (lambda x:
                                                  x [0], string.split (last, ' ')), '')
                    if len (key) >= 3:
                        key = key + '+'
                        break
            else:
                honorific, first, last, lineage = aut [0].format (fmt.coding)
                parts = string.split (last, ' ')
	            
                if len (parts) == 1:
                    key = parts [0][0:3]
                else:
                    key = string.join (map (lambda x: x [0], parts), '')
	
        else:
            key = rc (entry.name [0:3])
	
        if entry.has_key ('year'):
            key = key + entry ['year'].format (fmt.coding) [0] [2:]
	
        if table.has_key (key) or table.has_key (key + 'a'):
	
            if table.has_key (key):
                # rename the old entry
                new = key + 'a'
	        
                table [new] = table [key]
                del table [key]
	
            base = key
            suff = ord ('b')
            key  = base + chr (suff)
	        
            while table.has_key (key):
                suff = suff + 1
                key  = base + chr (suff)
	            
        return key


    # generate output keys
    key_table = {}

    def test_key (entry, fmt, key_table = key_table,
                  generate_one_key = generate_one_key):
        key = generate_one_key (entry, fmt, key_table)
        key_table [key] = entry.name
        return

    database.foreach (test_key, fmt)

    reverse_table = {}
    
    for k in key_table.keys ():
        reverse_table [key_table [k]] = k
        
    return reverse_table



def sort_database (database):
    """ Sor a database alphabetically """
    
    # sort keys...
    key_list = database.keys ()

    def sort_method (a, b, database = database):
        ea = database [a]
        eb = database [b]

        def fieldtest (ea, eb, field):
            if not ea.has_key (field): return  1
            if not eb.has_key (field): return -1
            
            return cmp (ea [field], eb [field])

        r = fieldtest (ea, eb, 'author')
        if r: return r
        
        r = fieldtest (ea, eb, 'year')
        if r: return r

        return 0

    key_list.sort (sort_method)

    return key_list
