/*
 This file is part of pybliographer
 
 Copyright (C) 1998-1999 Frederic GOBRY
 Email : gobry@idiap.ch
 	   
 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2 
 of the License, or (at your option) any later version.
   
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details. 
 
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 
 $Id: testparser.c,v 1.10 1999/07/16 13:26:58 gobry Exp $
*/

#include "bibtex.h"

void print_all (gpointer key,
		gpointer data,
		gpointer user)
{
    BibtexField * field = (BibtexField *) data;
    gchar * tmp;
    int i;
    BibtexAuthor * auth;
    GHashTable * dico = (GHashTable *) user;

    bibtex_field_parse (field, dico);

    printf ("\tfield `%s': [%d]\t", (gchar *) key, field->loss);

    switch (field->type) {
    case BIBTEX_AUTHOR:
	printf ("%s", field->text);

	for (i = 0; i < field->field.author->len; i++) {
	    
	    auth = (BibtexAuthor *) & g_array_index (field->field.author,
						     BibtexAuthor, i);

	    printf ("\n\t  %s", auth->last);
	    if (auth->lineage) {
		printf (" (%s)", auth->lineage);
	    }
	    if (auth->first) {
		printf (", %s", auth->first);
	    }
	}
	printf ("\n");
	break;

    default:
	printf ("%s\n", field->text);
    }
}

main (int argc, char * argv [])
{
    BibtexEntry * entry;
    BibtexFile * file;
    char * tmp;
  
    bibtex_set_default_handler ();

    file = bibtex_open (argv [1]);

    if (file == NULL) {
	printf ("cant open file\n");
	exit (0);
    }

    file->debug = argc - 2;

    while (entry = bibtex_next_entry (file)) {

	if (entry->type && entry->name)
	    printf ("(%s) [%s] %d\n",entry->type, entry->name,
		    bibtex_current_offset (file));

	g_hash_table_foreach (entry->table, print_all, file->table);
	bibtex_entry_destroy (entry, TRUE);

	printf ("\n");
    }

    if (file->eof) 
	printf ("at end of file\n");
    else {
	printf ("at error\n");
    }

    bibtex_close (file);

    g_mem_profile ();
}
