# This file is part of pybliographer
# 
# Copyright (C) 1998 Frederic GOBRY
# Email : gobry@idiap.ch
# 	   
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2 
# of the License, or (at your option) any later version.
#   
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details. 
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
# 
# $Id: Open.py,v 1.9 1999/07/30 12:32:13 gobry Exp $


from types import *
import Pyblio.Base, Pyblio.Help
from Pyblio import Autoload

import urlparse, urllib, traceback, os, sys, tempfile


# ----- Generic opening -----

OpeningMethods = {}
ListedMethods = []

def register (name, opener, printer):
	""
	if OpeningMethods.has_key (name):
		return
	
	OpeningMethods[name] = opener, printer
	ListedMethods.append (name)


Pyblio.Help.register ('bibopen', """
Syntax: database = bibopen (source)

bibopen  tries several  method  to open  `source'  as a  bibliographic
entry. `source'  can be  a simple file  or even  an URL. FTP  and HTTP
files are automatically fetched. One can even create a specific method
for client/server access for example.

One can apply the following commands on the output of bibopen :

 - database.keys () : lists the available entries
 - database ['key'] : returns a given entry
 - del database ['key'] : removes an entry from the file
 - database.where (...) : searches the base (see also `searching')
""")


def get (entity):
	if OpeningMethods.has_key (entity):
		return OpeningMethods [entity]

	return None, None


def bibopen (entity, how = None):
	"Generic function to open a bibliographic database"

	def simple_try (url, how):
		base = None

		if how == None:
			for method in ListedMethods:
				opener = get (method) [0]
				if opener:
					base = opener (url, 1)
					if base: break
		else:
			opener = get (how) [0]
			if opener:
				base = opener (url, 0)
			else:
				raise IOError, \
				      "method `%s' provides no opener" % how
		return base
	
	# Consider the reference as an URL
	url = list (urlparse.urlparse (entity))

	if url [0] == '':
		# Consider we handle a local file
		url [0] = 'file'
		url [2] = os.path.expanduser (url [2])

	# eventually load a new module
	Autoload.check (url)
	
	base = simple_try (url, how)
	
	# If one don't know how to retrieve a remote file, do it
	if base == None and (url [0] == 'http' or url [0] == 'ftp'):
		file, header = urllib.urlretrieve (entity)

		url = ['file', '', file, '', '', '']

		base = simple_try (url, how)
		
	if base == None:
		raise IOError, "don't know how to open `" + entity + "'"
    
	return base


Pyblio.Help.register ('bibwrite', """
Syntax: bibwrite (entity, output, how)

This function sends an entry description to the specified output
(stdout by default), formatted as specified by the third argument. By
default, this formatting is the same as the one used by `more'
""")


def bibwrite (entity, out = None, how = None):
	""" """

	# default output
	out = out or sys.stdout
	
	def simplewrite (entry, output = sys.stdout):
		""" Print an entry as simple text """
		output.write (str (entry) + "\n")

	
	if how == None:
		writer = simplewrite
	else:
		writer = get (how) [1]

	entity.foreach (writer, out)
	
