# Site configuration

from basics import *
import pyb
import string

# Les champs utilisables
pyb.FieldsOrder = [
    "CrossRef",	"Key", "Author", "Address_1", "Address_2",		
    "Title", "SpecificTitle", "Journal", "Special", "Type", 		
    "BookTitle", "Subject", "Ownership",				
    "Series", "Editor", "Edition", "Volume", "Number", "Chapter",	
    "Pages", "School", "Organization", "Location",	"Dates",		
    "Institution", "Publisher", "Address", "Format", "Month", 	
    "Year", "NoSeries", "ConfPlace", "ConfDate", "Cote",		
    "IEEECN", "LoCN", "ISBN", "ISSN", "Note", "Language",		
    "HowPublished", "To_Appear",	"From", "Received", "Owner",	
    "KeyWords", "Abstract", "Remarks", "IPDmembership",		
    "IPDascii", "IPDpostScript", "IPDhtml", "IPDxref", "IPDinAR",	
    "IPDpriority" 
    ]

for f in pyb.FieldsOrder:
    pyb.KnownFields [f] = string.lower (f)

# Les types d'entrees
Types  = [
    "Article",
    "Book",
    "Booklet",
    "InBook",
    "InCollection",
    "InProceedings",
    "Manual",
    "MastersThesis",
    "Misc",
    "PhdThesis",
    "Proceedings",
    "TechReport",
    "Unpublished",
    ]


for f in Types:
    pyb.KnownTypes [string.lower (f)] = f



print "... using BibTeX extension"
import pybibtex
