/* Generated by GOB (v1.0.10) on Sun Jul  8 03:39:30 2001
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */


#line 1 "pong-option-menu.gob"

/* PonG: option menu
 * Author: George Lebl
 * (c) 2000 Eazel, Inc.
 * (c) 2001 George Lebl
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#line 31 "pong-option-menu.c"
#define GOB_VERSION_MAJOR 1
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 10

#include <string.h> /* memset() */


#line 27 "pong-option-menu.gob"

#include "config.h"
#include <gnome.h>
#include <gconf/gconf-value.h>

#include "pong-i18n.h"

#include "pongpane.h"
#include "pongutil.h"

#include "pong-option-menu.h"
#include "pong-option-menu-private.h"

static void free_menu_item (MenuItem *item);
static void item_activated (GtkWidget *w, gpointer data);


#line 57 "pong-option-menu.c"
/* self casting macros */
#define SELF(x) PONG_OPTION_MENU(x)
#define SELF_CONST(x) PONG_OPTION_MENU_CONST(x)
#define IS_SELF(x) PONG_IS_OPTION_MENU(x)
#define TYPE_SELF PONG_TYPE_OPTION_MENU
#define SELF_CLASS(x) PONG_OPTION_MENU_CLASS(x)

#define SELF_GET_CLASS(x) PONG_OPTION_MENU_GET_CLASS(x)

/* self typedefs */
typedef PongOptionMenu Self;
typedef PongOptionMenuClass SelfClass;

/* GTK_CLASS_TYPE for 1.2<->1.3/2.0 GTK+ compatibility */
#ifndef GTK_CLASS_TYPE
#define GTK_CLASS_TYPE(x) (GTK_OBJECT_CLASS(x)->type)
#endif /* GTK_CLASS_TYPE */

/* here are local prototypes */
static void ___object_set_arg (GtkObject *object, GtkArg *arg, guint arg_id);
static void ___object_get_arg (GtkObject *object, GtkArg *arg, guint arg_id);
static void pong_option_menu_class_init (PongOptionMenuClass * klass) G_GNUC_UNUSED;
static void pong_option_menu_init (PongOptionMenu * self) G_GNUC_UNUSED;
static void pong_option_menu_changed (PongOptionMenu * self) G_GNUC_UNUSED;
static char * pong_option_menu_get_cur_value (PongOptionMenu * self) G_GNUC_UNUSED;
static void pong_option_menu_activate_item (PongOptionMenu * self, MenuItem * item) G_GNUC_UNUSED;
static void pong_option_menu_activate_first (PongOptionMenu * self) G_GNUC_UNUSED;
static gboolean pong_option_menu_get_value (GtkWidget * w, const char * specifier, PongType type, GConfValue ** value) G_GNUC_UNUSED;
static void pong_option_menu_whack_arbitrary (PongOptionMenu * self, MenuItem * cur) G_GNUC_UNUSED;
static void pong_option_menu_add_arbitrary (PongOptionMenu * self, GConfValue * value) G_GNUC_UNUSED;
static gboolean pong_option_menu_set_value (GtkWidget * w, const char * specifier, GConfValue * value) G_GNUC_UNUSED;
static void pong_option_menu_add_options (GtkWidget * w, GList * pong_options) G_GNUC_UNUSED;

enum {
	CHANGED_SIGNAL,
	LAST_SIGNAL
};

enum {
	ARG_0,
	ARG_ALLOW_ARBITRARY
};

static guint object_signals[LAST_SIGNAL] = {0};

/* pointer to the class of our parent */
static GtkOptionMenuClass *parent_class = NULL;

GtkType
pong_option_menu_get_type (void)
{
	static GtkType type = 0;

	if (type == 0) {
		static const GtkTypeInfo info = {
			"PongOptionMenu",
			sizeof (PongOptionMenu),
			sizeof (PongOptionMenuClass),
			(GtkClassInitFunc) pong_option_menu_class_init,
			(GtkObjectInitFunc) pong_option_menu_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL
		};

		type = gtk_type_unique (gtk_option_menu_get_type(), &info);
	}

	return type;
}

/* Short form macros */
#if defined(__GNUC__) && !defined(__STRICT_ANSI__)
#define new() pong_option_menu_new()
#define new_with_options(args...) pong_option_menu_new_with_options(args)
#define changed(args...) pong_option_menu_changed(args)
#define get_cur_value(args...) pong_option_menu_get_cur_value(args)
#define activate_item(args...) pong_option_menu_activate_item(args)
#define activate_first(args...) pong_option_menu_activate_first(args)
#define get_value(args...) pong_option_menu_get_value(args)
#define whack_arbitrary(args...) pong_option_menu_whack_arbitrary(args)
#define add_arbitrary(args...) pong_option_menu_add_arbitrary(args)
#define set_value(args...) pong_option_menu_set_value(args)
#define add_options(args...) pong_option_menu_add_options(args)
#endif /* __GNUC__ && !__STRICT_ANSI__ */

/* Short form pointers */
static GtkWidget * (* const new) (void) = pong_option_menu_new;
static GtkWidget * (* const new_with_options) (GList * pong_options) = pong_option_menu_new_with_options;
static void (* const changed) (PongOptionMenu * self) = pong_option_menu_changed;
static char * (* const get_cur_value) (PongOptionMenu * self) = pong_option_menu_get_cur_value;
static void (* const activate_item) (PongOptionMenu * self, MenuItem * item) = pong_option_menu_activate_item;
static void (* const activate_first) (PongOptionMenu * self) = pong_option_menu_activate_first;
static gboolean (* const get_value) (GtkWidget * w, const char * specifier, PongType type, GConfValue ** value) = pong_option_menu_get_value;
static void (* const whack_arbitrary) (PongOptionMenu * self, MenuItem * cur) = pong_option_menu_whack_arbitrary;
static void (* const add_arbitrary) (PongOptionMenu * self, GConfValue * value) = pong_option_menu_add_arbitrary;
static gboolean (* const set_value) (GtkWidget * w, const char * specifier, GConfValue * value) = pong_option_menu_set_value;
static void (* const add_options) (GtkWidget * w, GList * pong_options) = pong_option_menu_add_options;

/* a macro for creating a new object of our type */
#define GET_NEW ((PongOptionMenu *)gtk_type_new(pong_option_menu_get_type()))


static void
___destroy(GtkObject *obj_self)
{
#define __GOB_FUNCTION__ "Pong:Option:Menu::destroy"
	PongOptionMenu *self = PONG_OPTION_MENU (obj_self);
	if(GTK_OBJECT_CLASS(parent_class)->destroy) \
		(* GTK_OBJECT_CLASS(parent_class)->destroy)(obj_self);
#define VAR (self->_priv->menu_items)
	{
#line 57 "pong-option-menu.gob"
	
			g_list_foreach (VAR, (GFunc)free_menu_item, NULL);
			g_list_free (VAR);
		}
#line 175 "pong-option-menu.c"
	memset(&VAR, 0, sizeof(VAR));
#undef VAR
	return;
	self = NULL;
}
#undef __GOB_FUNCTION__


#ifdef G_OBJECT_CLASS
static void
___finalize(GObject *obj_self)
#else /* !G_OBJECT_CLASS */
static void
___finalize(GtkObject *obj_self)
#endif /* G_OBJECT_CLASS */
{
#define __GOB_FUNCTION__ "Pong:Option:Menu::finalize"
	PongOptionMenu *self = PONG_OPTION_MENU (obj_self);
	gpointer priv = self->_priv;
#ifdef G_OBJECT_CLASS
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#else /* !G_OBJECT_CLASS */
	if(GTK_OBJECT_CLASS(parent_class)->finalize) \
		(* GTK_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#endif /* G_OBJECT_CLASS */
	g_free(priv);
}
#undef __GOB_FUNCTION__

#line 67 "pong-option-menu.gob"
static void 
pong_option_menu_class_init (PongOptionMenuClass * klass)
#line 209 "pong-option-menu.c"
{
#define __GOB_FUNCTION__ "Pong:Option:Menu::class_init"
	GtkObjectClass *gtk_object_class = (GtkObjectClass*) klass;
#ifdef G_OBJECT_CLASS
	GObjectClass *g_object_class = (GObjectClass*) klass;
#endif /* G_OBJECT_CLASS */

	parent_class = gtk_type_class (gtk_option_menu_get_type ());

	object_signals[CHANGED_SIGNAL] =
		gtk_signal_new ("changed",
			(GtkSignalRunType)(GTK_RUN_LAST),
			GTK_CLASS_TYPE(gtk_object_class),
			GTK_SIGNAL_OFFSET (PongOptionMenuClass, changed),
			gtk_signal_default_marshaller,
			GTK_TYPE_NONE, 0);
	gtk_object_class_add_signals (gtk_object_class,
		object_signals, LAST_SIGNAL);


	klass->changed = NULL;
	gtk_object_class->destroy = ___destroy;
#ifdef G_OBJECT_CLASS
	g_object_class->finalize = ___finalize;
#else /* !G_OBJECT_CLASS */
	gtk_object_class->finalize = ___finalize;
#endif /* G_OBJECT_CLASS */

	gtk_object_add_arg_type("PongOptionMenu::allow_arbitrary",
		GTK_TYPE_BOOL,
		GTK_ARG_READWRITE,
		ARG_ALLOW_ARBITRARY);

	gtk_object_class->get_arg = ___object_get_arg;
	gtk_object_class->set_arg = ___object_set_arg;
 {
#line 68 "pong-option-menu.gob"

		PongWidgetInterface *iface;

		iface = pong_widget_interface_add (GTK_OBJECT_CLASS (klass));
		iface->changed_signal = "changed";
		iface->get_value = get_value;
		iface->set_value = set_value;
		iface->add_options = add_options;
	
#line 256 "pong-option-menu.c"
 }
	return;
	klass = NULL;
	gtk_object_class = NULL;
#ifdef G_OBJECT_CLASS
	g_object_class = NULL;
#endif /* G_OBJECT_CLASS */
}
#undef __GOB_FUNCTION__
#line 78 "pong-option-menu.gob"
static void 
pong_option_menu_init (PongOptionMenu * self)
#line 269 "pong-option-menu.c"
{
#define __GOB_FUNCTION__ "Pong:Option:Menu::init"
	self->_priv = g_new0 (PongOptionMenuPrivate, 1);
#line 45 "pong-option-menu.gob"
	self->_priv->menu_items = NULL;
#line 275 "pong-option-menu.c"
#line 57 "pong-option-menu.gob"
	self->_priv->allow_arbitrary = FALSE;
#line 278 "pong-option-menu.c"
#line 57 "pong-option-menu.gob"
	self->_priv->arbit_item = NULL;
#line 281 "pong-option-menu.c"
 {
#line 79 "pong-option-menu.gob"

		add_options ((GtkWidget *)self, NULL);
	
#line 287 "pong-option-menu.c"
 }
	return;
	self = NULL;
}
#undef __GOB_FUNCTION__

static void
___object_set_arg (GtkObject *object,
	GtkArg *arg,
	guint arg_id)
#define __GOB_FUNCTION__ "Pong:Option:Menu::set_arg"
{
	PongOptionMenu *self;

	self = PONG_OPTION_MENU (object);

	switch (arg_id) {
	case ARG_ALLOW_ARBITRARY:
#if defined(__GNUC__) && !defined(__STRICT_ANSI__)
#define ARG ({gboolean  foo = GTK_VALUE_BOOL(*arg); foo; })
#else /* __GNUC__ && !__STRICT_ANSI__ */
#define ARG ((gboolean )GTK_VALUE_BOOL(*arg))
#endif /* __GNUC__ && !__STRICT_ANSI__ */

		{
#line 63 "pong-option-menu.gob"
self->_priv->allow_arbitrary = ARG;
#line 315 "pong-option-menu.c"
		}
		break;
#undef ARG
	default:
		break;
	}
	return;
	self = NULL;
	arg = NULL;
}
#undef __GOB_FUNCTION__

static void
___object_get_arg (GtkObject *object,
	GtkArg *arg,
	guint arg_id)
#define __GOB_FUNCTION__ "Pong:Option:Menu::get_arg"
{
	PongOptionMenu *self;

	self = PONG_OPTION_MENU (object);

	switch (arg_id) {
	case ARG_ALLOW_ARBITRARY:
#define ARG (GTK_VALUE_BOOL(*arg))
		{
#line 63 "pong-option-menu.gob"
ARG = self->_priv->allow_arbitrary;
#line 344 "pong-option-menu.c"
		}
		break;
#undef ARG
	default:
		break;
	}
	return;
	self = NULL;
	arg = NULL;
}
#undef __GOB_FUNCTION__



/**
 * pong_option_menu_new:
 *
 * Description:  Create a new #PongOptionMenu widget
 *
 * Returns:  A new #PongOptionMenu widget
 **/
#line 90 "pong-option-menu.gob"
GtkWidget * 
pong_option_menu_new (void)
#line 369 "pong-option-menu.c"
{
#define __GOB_FUNCTION__ "Pong:Option:Menu::new"
{
#line 93 "pong-option-menu.gob"
	
		return (GtkWidget *)GET_NEW;
	}}
#line 377 "pong-option-menu.c"
#undef __GOB_FUNCTION__

/**
 * pong_option_menu_new_with_options:
 * @options:  a list of PongOption structs
 *
 * Description:  Create a new #PongOptionMenu widget and
 * setup the @options.
 *
 * Returns:  A new #PongOptionMenu widget
 **/
#line 106 "pong-option-menu.gob"
GtkWidget * 
pong_option_menu_new_with_options (GList * pong_options)
#line 392 "pong-option-menu.c"
{
#define __GOB_FUNCTION__ "Pong:Option:Menu::new_with_options"
{
#line 109 "pong-option-menu.gob"
	
		GtkWidget *w = (GtkWidget *)GET_NEW;
		add_options (w, pong_options);
		return w;
	}}
#line 402 "pong-option-menu.c"
#undef __GOB_FUNCTION__

#line 115 "pong-option-menu.gob"
static void 
pong_option_menu_changed (PongOptionMenu * self)
#line 408 "pong-option-menu.c"
{
#line 115 "pong-option-menu.gob"
	g_return_if_fail (self != NULL);
#line 115 "pong-option-menu.gob"
	g_return_if_fail (PONG_IS_OPTION_MENU (self));
#line 414 "pong-option-menu.c"
	gtk_signal_emit (GTK_OBJECT (self),
		object_signals[CHANGED_SIGNAL]);
}

#line 119 "pong-option-menu.gob"
static char * 
pong_option_menu_get_cur_value (PongOptionMenu * self)
#line 422 "pong-option-menu.c"
{
#define __GOB_FUNCTION__ "Pong:Option:Menu::get_cur_value"
#line 119 "pong-option-menu.gob"
	g_return_val_if_fail (self != NULL, (char * )0);
#line 119 "pong-option-menu.gob"
	g_return_val_if_fail (PONG_IS_OPTION_MENU (self), (char * )0);
#line 429 "pong-option-menu.c"
{
#line 121 "pong-option-menu.gob"
	
		GtkOptionMenu *option_menu = GTK_OPTION_MENU (self);

		if (option_menu->menu != NULL) {
			GtkWidget *active_widget;
			GList *li;

			active_widget = gtk_menu_get_active
				(GTK_MENU (option_menu->menu));

			for (li = self->_priv->menu_items;
			     li != NULL;
			     li = li->next) {
				MenuItem *item = li->data;
				if (item->w == active_widget)
					return item->value;
			}
		}

		return NULL;
	}}
#line 453 "pong-option-menu.c"
#undef __GOB_FUNCTION__

#line 143 "pong-option-menu.gob"
static void 
pong_option_menu_activate_item (PongOptionMenu * self, MenuItem * item)
#line 459 "pong-option-menu.c"
{
#define __GOB_FUNCTION__ "Pong:Option:Menu::activate_item"
#line 143 "pong-option-menu.gob"
	g_return_if_fail (self != NULL);
#line 143 "pong-option-menu.gob"
	g_return_if_fail (PONG_IS_OPTION_MENU (self));
#line 143 "pong-option-menu.gob"
	g_return_if_fail (item != NULL);
#line 468 "pong-option-menu.c"
{
#line 145 "pong-option-menu.gob"
	
		gtk_menu_item_activate (GTK_MENU_ITEM (item->w));
		gtk_option_menu_set_history
			(GTK_OPTION_MENU (self),
			 g_list_index (self->_priv->menu_items, item));
	}}
#line 477 "pong-option-menu.c"
#undef __GOB_FUNCTION__

#line 155 "pong-option-menu.gob"
static void 
pong_option_menu_activate_first (PongOptionMenu * self)
#line 483 "pong-option-menu.c"
{
#define __GOB_FUNCTION__ "Pong:Option:Menu::activate_first"
#line 155 "pong-option-menu.gob"
	g_return_if_fail (self != NULL);
#line 155 "pong-option-menu.gob"
	g_return_if_fail (PONG_IS_OPTION_MENU (self));
#line 490 "pong-option-menu.c"
{
#line 157 "pong-option-menu.gob"
	
		if (self->_priv->menu_items != NULL) {
			MenuItem *item = self->_priv->menu_items->data;
			activate_item (self, item);
		}
	}}
#line 499 "pong-option-menu.c"
#undef __GOB_FUNCTION__

#line 164 "pong-option-menu.gob"
static gboolean 
pong_option_menu_get_value (GtkWidget * w, const char * specifier, PongType type, GConfValue ** value)
#line 505 "pong-option-menu.c"
{
#define __GOB_FUNCTION__ "Pong:Option:Menu::get_value"
#line 164 "pong-option-menu.gob"
	g_return_val_if_fail (w != NULL, (gboolean )FALSE);
#line 164 "pong-option-menu.gob"
	g_return_val_if_fail (GTK_IS_WIDGET (w), (gboolean )FALSE);
#line 164 "pong-option-menu.gob"
	g_return_val_if_fail (value != NULL, (gboolean )FALSE);
#line 514 "pong-option-menu.c"
{
#line 170 "pong-option-menu.gob"
	
		Self *self = SELF(w);
		char *cur_value;

		*value = NULL;

		/* FIXME: add radio button like specifier behaviour */

		if (type != PONG_TYPE_STRING &&
		    type != PONG_TYPE_INT &&
		    type != PONG_TYPE_FLOAT &&
		    type != PONG_TYPE_BOOL) {
			g_warning (_("Unsupported type on Pong:Option:Menu"));
			return FALSE;
		}

		cur_value = get_cur_value (self);
		if (cur_value == NULL)
			return FALSE;

		switch (type) {
		case PONG_TYPE_STRING:
			*value = gconf_value_new (GCONF_VALUE_STRING);
			gconf_value_set_string (*value, cur_value);
			break;
		case PONG_TYPE_INT:
			{
				int ret;
				*value = gconf_value_new (GCONF_VALUE_INT);
				sscanf (cur_value, "%d", &ret);
				gconf_value_set_int (*value, ret);
				break;
			}
		case PONG_TYPE_FLOAT:
			{
				double ret;
				*value = gconf_value_new (GCONF_VALUE_FLOAT);
				pong_i18n_push_c_numeric_locale ();
				sscanf (cur_value, "%lf", &ret);
				pong_i18n_pop_c_numeric_locale ();
				gconf_value_set_float (*value, ret);
				break;
			}
		case PONG_TYPE_BOOL:
			*value = gconf_value_new (GCONF_VALUE_BOOL);
			gconf_value_set_bool (*value,
					      pong_bool_from_string (cur_value));
			break;
		default:
			g_assert_not_reached ();
			break;
		}

		return TRUE;
	}}
#line 572 "pong-option-menu.c"
#undef __GOB_FUNCTION__

#line 226 "pong-option-menu.gob"
static void 
pong_option_menu_whack_arbitrary (PongOptionMenu * self, MenuItem * cur)
#line 578 "pong-option-menu.c"
{
#define __GOB_FUNCTION__ "Pong:Option:Menu::whack_arbitrary"
#line 226 "pong-option-menu.gob"
	g_return_if_fail (self != NULL);
#line 226 "pong-option-menu.gob"
	g_return_if_fail (PONG_IS_OPTION_MENU (self));
#line 585 "pong-option-menu.c"
{
#line 228 "pong-option-menu.gob"
	
		if (self->_priv->arbit_item != NULL &&
		    self->_priv->arbit_item != cur) {
			gtk_widget_destroy (self->_priv->arbit_item->w);
			self->_priv->arbit_item->w = NULL;
			self->_priv->menu_items =
				g_list_remove (self->_priv->menu_items,
					       self->_priv->arbit_item);
			free_menu_item (self->_priv->arbit_item);
		}
	}}
#line 599 "pong-option-menu.c"
#undef __GOB_FUNCTION__

#line 240 "pong-option-menu.gob"
static void 
pong_option_menu_add_arbitrary (PongOptionMenu * self, GConfValue * value)
#line 605 "pong-option-menu.c"
{
#define __GOB_FUNCTION__ "Pong:Option:Menu::add_arbitrary"
#line 240 "pong-option-menu.gob"
	g_return_if_fail (self != NULL);
#line 240 "pong-option-menu.gob"
	g_return_if_fail (PONG_IS_OPTION_MENU (self));
#line 612 "pong-option-menu.c"
{
#line 242 "pong-option-menu.gob"
	
		MenuItem *item;

		if (self->_priv->arbit_item == NULL) {
			self->_priv->arbit_item = g_new0 (MenuItem, 1);
			self->_priv->arbit_item->w = NULL;
			self->_priv->arbit_item->value =
				pong_string_from_gconf_value (value);

			self->_priv->menu_items = 
				g_list_prepend (self->_priv->menu_items,
						self->_priv->arbit_item);
		}

		item = self->_priv->arbit_item;

		if (item->w != NULL)
			gtk_widget_destroy (item->w);

		item->w = gtk_menu_item_new_with_label
			(pong_sure_string (item->value));

		gtk_signal_connect (GTK_OBJECT (item->w), "activate",
				    GTK_SIGNAL_FUNC (item_activated),
				    self);

		gtk_widget_show (item->w);

		gtk_menu_prepend (GTK_MENU (GTK_OPTION_MENU (self)->menu),
				  item->w);
	}}
#line 646 "pong-option-menu.c"
#undef __GOB_FUNCTION__

#line 274 "pong-option-menu.gob"
static gboolean 
pong_option_menu_set_value (GtkWidget * w, const char * specifier, GConfValue * value)
#line 652 "pong-option-menu.c"
{
#define __GOB_FUNCTION__ "Pong:Option:Menu::set_value"
#line 274 "pong-option-menu.gob"
	g_return_val_if_fail (w != NULL, (gboolean )FALSE);
#line 274 "pong-option-menu.gob"
	g_return_val_if_fail (GTK_IS_WIDGET (w), (gboolean )FALSE);
#line 274 "pong-option-menu.gob"
	g_return_val_if_fail (value != NULL, (gboolean )FALSE);
#line 661 "pong-option-menu.c"
{
#line 279 "pong-option-menu.gob"
	
		Self *self = SELF(w);
		GList *li;

		/* FIXME: add radio button like specifier behaviour */

		if (value->type != GCONF_VALUE_STRING &&
		    value->type != GCONF_VALUE_INT &&
		    value->type != GCONF_VALUE_FLOAT &&
		    value->type != GCONF_VALUE_BOOL) {
			g_warning (_("Unsupported type on Pong:Option:Menu"));
			return FALSE;
		}

		for (li = self->_priv->menu_items;
		     li != NULL;
		     li = li->next) {
			MenuItem *item = li->data;
			switch (value->type) {
			case GCONF_VALUE_STRING:
				if (strcmp (gconf_value_get_string (value), item->value) == 0) {
					whack_arbitrary (self, item);
					activate_item (self, item);
					return TRUE;
				}
				break;
			case GCONF_VALUE_INT:
				if (gconf_value_get_int (value) == atoi (item->value)) {
					whack_arbitrary (self, item);
					activate_item (self, item);
					return TRUE;
				}
				break;
			case GCONF_VALUE_FLOAT:
				{
					double foo;

					pong_i18n_push_c_numeric_locale ();
					foo = atof (item->value);
					pong_i18n_pop_c_numeric_locale ();

					/* FIXME: EEEEK! float comparison !!!! */
					if (gconf_value_get_float (value) == foo) {
						whack_arbitrary (self, item);
						activate_item (self, item);
						return TRUE;
					}
				}
				break;
			case GCONF_VALUE_BOOL:
				/* The reason for the ?: is that comparing bools
				 * directly is evil */
				if ((gconf_value_get_bool (value) ? 1 : 0) ==
				   (pong_bool_from_string (item->value) ? 1 : 0)) {
					whack_arbitrary (self, item);
					activate_item (self, item);
					return TRUE;
				}
				break;
			default:
				g_assert_not_reached ();
				break;
			}
		}

		if (self->_priv->allow_arbitrary) {
			add_arbitrary (self, value);
		} else {
			/* FIXME: support no-value-state */
			activate_first (self);
		}
		return FALSE;
	}}
#line 737 "pong-option-menu.c"
#undef __GOB_FUNCTION__

#line 353 "pong-option-menu.gob"
static void 
pong_option_menu_add_options (GtkWidget * w, GList * pong_options)
#line 743 "pong-option-menu.c"
{
#define __GOB_FUNCTION__ "Pong:Option:Menu::add_options"
#line 353 "pong-option-menu.gob"
	g_return_if_fail (w != NULL);
#line 353 "pong-option-menu.gob"
	g_return_if_fail (GTK_IS_WIDGET (w));
#line 750 "pong-option-menu.c"
{
#line 356 "pong-option-menu.gob"
	
		Self *self = SELF (w);
		GtkOptionMenu *option_menu = GTK_OPTION_MENU (self);
		GList *li;
		GtkWidget *menu;

		if (option_menu->menu != NULL) {
			GList *children;

			menu = option_menu->menu;

			children = gtk_container_children (GTK_CONTAINER (menu));

			g_list_free (children);
		} else {
			menu = gtk_menu_new ();

			gtk_option_menu_set_menu (option_menu, menu);
		}

		for(li = pong_options; li != NULL; li = li->next) {
			PongOption *opt = li->data;
			MenuItem *item = g_new0 (MenuItem, 1);

			item->value = g_strdup (opt->value);

			item->w = gtk_menu_item_new_with_label (opt->label != NULL?
								opt->label :
								_("???"));

			gtk_signal_connect (GTK_OBJECT (item->w), "activate",
					    GTK_SIGNAL_FUNC (item_activated),
					    self);

			gtk_widget_show (item->w);

			gtk_menu_append (GTK_MENU (menu), item->w);

			self->_priv->menu_items =
				g_list_append (self->_priv->menu_items, item);
		}
	}}
#line 795 "pong-option-menu.c"
#undef __GOB_FUNCTION__


#if (!defined __GNUC__) || (defined __GNUC__ && defined __STRICT_ANSI__)
/*REALLY BAD HACK
  This is to avoid unused warnings if you don't call
  some method.  I need to find a better way to do
  this, not needed in GCC since we use some gcc
  extentions to make saner, faster code */
static void
___pong_option_menu_really_bad_hack_to_avoid_warnings(void)
{
	((void (*)(void))new)();
	((void (*)(void))new_with_options)();
	((void (*)(void))changed)();
	((void (*)(void))get_cur_value)();
	((void (*)(void))activate_item)();
	((void (*)(void))activate_first)();
	((void (*)(void))get_value)();
	((void (*)(void))whack_arbitrary)();
	((void (*)(void))add_arbitrary)();
	((void (*)(void))set_value)();
	((void (*)(void))add_options)();
	___pong_option_menu_really_bad_hack_to_avoid_warnings();
}
#endif /* !__GNUC__ || (__GNUC__ && __STRICT_ANSI__) */


#line 400 "pong-option-menu.gob"

static void
free_menu_item (MenuItem *item)
{
	g_return_if_fail (item != NULL);

	g_free (item->value);
	item->value = NULL; /* paranoia */
	g_free (item);
}

static void
item_activated (GtkWidget *w, gpointer data)
{
	changed (SELF (data));
}

#line 842 "pong-option-menu.c"
