import unittest
from pitivi.project import Project


class TestExportSettings(unittest.TestCase):
    """Test the project.MultimediaSettings class."""

    def setUp(self):
        self.project = Project()

    def testMasterAttributes(self):
        self._testMasterAttribute('muxer', dependant_attr='containersettings')
        self._testMasterAttribute('vencoder', dependant_attr='vcodecsettings')
        self._testMasterAttribute('aencoder', dependant_attr='acodecsettings')

    def _testMasterAttribute(self, attr, dependant_attr):
        """Test changing the specified attr has effect on its dependant attr."""
        attr_value1 = "%s_value1" % attr
        attr_value2 = "%s_value2" % attr

        setattr(self.project, attr, attr_value1)
        setattr(self.project, dependant_attr, {})
        getattr(self.project, dependant_attr)["key1"] = "v1"

        setattr(self.project, attr, attr_value2)
        setattr(self.project, dependant_attr, {})
        getattr(self.project, dependant_attr)["key2"] = "v2"

        setattr(self.project, attr, attr_value1)
        self.assertTrue("key1" in getattr(self.project, dependant_attr))
        self.assertFalse("key2" in getattr(self.project, dependant_attr))
        self.assertEqual("v1", getattr(self.project, dependant_attr)["key1"])
        setattr(self.project, dependant_attr, {})

        setattr(self.project, attr, attr_value2)
        self.assertFalse("key1" in getattr(self.project, dependant_attr))
        self.assertTrue("key2" in getattr(self.project, dependant_attr))
        self.assertEqual("v2", getattr(self.project, dependant_attr)["key2"])
        setattr(self.project, dependant_attr, {})

        setattr(self.project, attr, attr_value1)
        self.assertFalse("key1" in getattr(self.project, dependant_attr))
        self.assertFalse("key2" in getattr(self.project, dependant_attr))

        setattr(self.project, attr, attr_value2)
        self.assertFalse("key1" in getattr(self.project, dependant_attr))
        self.assertFalse("key2" in getattr(self.project, dependant_attr))
