// -*- C++ -*-
///
// Copyright (C) 2002 - 2004, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
// class for reading Adobe Font Metrics.                            
#ifndef SSC_FONTMETRICS_H
#define SSC_FONTMETRICS_H
#include <glibmm/ustring.h>
#include <vector>
#include <map>

namespace font {
  class Metrics {
  public:
    Metrics(std::istream &source);
    ~Metrics();
    
    float getWidth(const Glib::ustring &str) const;
    float getAscender()  const { return ascender; }
    float getDescender() const { return descender; }
    float getExHeight()  const { return x_height; }
    float getCapHeight() const { return cap_height; }
    float getUnderlinePos() const { return underline_position; }
    float getUnderlineThickness() const { return underline_thickness; }
    float getItalicAngle() const { return italic_angle; }
    
    bool hasGlyph(const std::string &glyphname) const;
    std::string getGlyphName(const Glib::ustring &chars) const;

    int getBBox(int idx) const { /* assert(0<=idx<4); */ return bbox[idx]; }
  private:
    float ascender, descender;
    float underline_position, underline_thickness;
    float cap_height, x_height, italic_angle;
    int bbox[4];
    
    class GlyphData;
    GlyphData* glyphdata;
    
    Metrics();
    Metrics(const Metrics&);
    void operator = (const Metrics&);
  };
}

#endif
