// -*- C++ -*-
///
// Copyright (C) 2002 - 2004, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#ifndef FONTMANAGER
#define FONTMANAGER
#include <string>
#include <map>
#include <stdexcept>
#include "fontmetrics.hh"

namespace font {

struct FontError: public std::runtime_error {
  FontError(const std::string &what) : std::runtime_error(what) {}
};

using std::string;

class FontManager {
public:
  enum generic_font { serif, sans_serif, cursive, fantasy, monospace };

  FontManager();

  /** Paths are searched in the order thay are added. */
  void addFontPath(string path);

  /* A font can have more than one name. Warning: no cyclic
   * references, please! */
  void fontAlias(const string &alias, const string &fontname);

  const font::Metrics* getFont(const string &name);

  //* get real name of font */
  string unalias(const string &fontname, bool recursive = true) const;

  void reportFonts(std::ostream &out) const;

  string getMetricsFile(const string &fontname) const {
    try { return getFontFiles(fontname).first; }
    catch(FontError&) { return ""; }
  }

  string getFontFile(const string &fontname) const {
    try { return getFontFiles(fontname).second; }
    catch(FontError&) { return ""; }
  }

private:
  typedef std::map<string, font::Metrics*> MetricsMap;
  MetricsMap metrics_map;
  typedef std::multimap<string, string> FontAliases;
  FontAliases fontaliases;
  // <fontname, pair<metrics file, font file>>
  typedef std::map<string, std::pair<string, string> > FontFiles;
  FontFiles fontfiles;

  void loadFont(const string &fontname);
  void checkOutAFM(const string &filename);
  void checkOutType1(const string &filename);
  typedef std::pair<string, string> FilePair;
  FilePair getFontFiles(const string &fontname) const;
  FontManager(const FontManager &); // undefined
  FontManager& operator= (const FontManager &);	// undefined
};
}
#endif
