///
// Copyright (C) 2002, 2003, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "filewatcher.h"
#include <glibmm/main.h>
#include <sys/stat.h>
#include <iostream>
using namespace std;

FileWatcher::FileWatcher(const std::string &filename, int interval) 
  : file(filename)
{
  connection = 
    Glib::signal_timeout().connect(slot(*this, &FileWatcher::check_file), 
				   interval);
}

FileWatcher::~FileWatcher() {
  connection.disconnect();
}

bool FileWatcher::check_file() {
  // always return true - means "don't disconnect"

  // don't say the file is modified on the first stat(2)
  bool new_name = (last_file != file);
  last_file = file;

  if(file.empty())
    return true;

  struct stat buf;
  if(stat(file.c_str(), &buf) == 0) { // returns 0 on success, -1 otherwise
    if(buf.st_mtime != last_time) {
      last_time = buf.st_mtime;
      if(!new_name)
	modified_signal();
    }
  }

  return true;
}
