#ifndef PPT_RASTERVIEWENT_H	// -*- C++ -*-
#define PPT_RASTERVIEWENT_H
///
// Copyright (C) 2003, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "viewent.h"
#include "document/rasterframe.h"
#include "pixbuftransformator.h"

class RasterViewent : public Viewent {
  typedef RasterFrame* FrameRef;
public:
  RasterViewent(View& view, const FrameRef rasterframe);
  
  bool draw_content();
  void clear();
  
protected:
  const Pagent* get_frame() const { return frame; }
  
private:
  FrameRef frame;
  /** A pixbuf that is correctly scaled / transformed to be drawn directly to
   * the view. */
  Glib::RefPtr<Gdk::Pixbuf> sourcepixbuf, screenpixbuf;
  PixbufTransformator* worker;
  SigC::Connection propscon, objectcon, zoomcon;
};

#endif
