/*
 * Copyright (C) 2001 Red Hat Software
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */

#pragma once

#include <pango/pango-types.h>
#include <pango/pango-font-metrics.h>

#include <glib-object.h>

G_BEGIN_DECLS

#define PANGO_TYPE_FONTSET              (pango_fontset_get_type ())

PANGO_AVAILABLE_IN_ALL
PANGO_DECLARE_INTERNAL_TYPE (PangoFontset, pango_fontset, PANGO, FONTSET, GObject)

/**
 * PangoFontsetForeachFunc:
 * @fontset: a `PangoFontset`
 * @font: a font from @fontset
 * @user_data: callback data
 *
 * Callback used when enumerating fonts in a fontset.
 *
 * See [method@Pango.Fontset.foreach].
 *
 * Returns: if %TRUE, stop iteration and return immediately.
 */
typedef gboolean (*PangoFontsetForeachFunc) (PangoFontset  *fontset,
                                             PangoFont     *font,
                                             gpointer       user_data);

PANGO_AVAILABLE_IN_ALL
PangoFont *             pango_fontset_get_font          (PangoFontset                   *fontset,
                                                         guint                           wc);
PANGO_AVAILABLE_IN_ALL
PangoFontMetrics *      pango_fontset_get_metrics       (PangoFontset                   *fontset);
PANGO_AVAILABLE_IN_ALL
void                    pango_fontset_foreach           (PangoFontset                   *fontset,
                                                         PangoFontsetForeachFunc         func,
                                                         gpointer                        data);

G_END_DECLS
