/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999, 2000, 2001  Pan Development Team <pan@rebelbase.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef TASK_SAVE__H
#define TASK_SAVE__H

#include <pan/base/group.h>
#include <pan/task.h>


/**
***  TASK SAVE DECLARATION
**/

#define TASK_SAVE(obj) ((TaskSave*)obj)

typedef struct
{
	/* Parent */
	Task         item;

	/* private */
	gint         runval;
	Group      * group;
	GSList     * articles;
	gchar      * readable_name;

	gboolean     save_attachments;
	gchar      * path_attachments;
	gchar      * filename_attachments;

	gboolean     save_bodies;
	gchar      * path_bodies;
	gchar      * filename_bodies;
}
TaskSave;


/**
***   PUBLIC
**/

PanObject* task_save_new       (Group          * group,
                                const char     * readable_name_for_description,
                                const GSList   * articles);

void task_save_set_attachments (TaskSave      * task,
                                const gchar   * path,
                                const gchar   * filename);

void task_save_set_bodies      (TaskSave      * task,
                                const gchar   * path,
                                const gchar   * filename);

void task_save_validate_and_queue_or_self_destruct (TaskSave*, int queue_index);

#endif
