/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999, 2000, 2001  Pan Development Team <pan@rebelbase.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#include <config.h>

#include <libgnomeui/libgnomeui.h>

#include <pan/base/debug.h>
#include <pan/base/pan-i18n.h>

#include <pan/articlelist.h>
#include <pan/globals.h>
#include <pan/grouplist.h>
#include <pan/gui.h>
#include <pan/gui-notebook.h>
#include <pan/text.h>
#include <pan/util.h>


GtkWidget * notebook = NULL;

/*---[ gui_notebook_construct ]---------------------------------------
 * Build and pack the notebook GUI layout into Pan's main vbox
 *--------------------------------------------------------------------*/
void
gui_notebook_construct (void)
{
	debug_enter ("gui_notebook_construct");

	if (Pan.viewmode == GUI_NOTEBOOK)
		return;

	Pan.viewmode = GUI_NOTEBOOK;

	pan_lock ();

	/* hide everything */
	gtk_widget_hide_all (GTK_WIDGET(contents_vbox));

	/* ref so that we don't lose the three panes */
	gtk_widget_ref (groups_vbox);
	if (groups_vbox->parent != NULL)
		gtk_container_remove (GTK_CONTAINER(groups_vbox->parent), groups_vbox);
	gtk_widget_unrealize (groups_vbox);
	gtk_widget_ref (articlelist_ctree);
	if (articlelist_ctree->parent != NULL)
		gtk_container_remove (GTK_CONTAINER(articlelist_ctree->parent), articlelist_ctree);
	gtk_widget_unrealize (articlelist_ctree);
	gtk_widget_ref (text_box);
	if (text_box->parent != NULL)
		gtk_container_remove (GTK_CONTAINER(text_box->parent), text_box);
	gtk_widget_unrealize (text_box);

	/* build a new UI */
	contents_vbox = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (groups_vbox);
	gtk_widget_show (articlelist_ctree);
	gtk_widget_show (text_box);
	notebook = gtk_notebook_new ();
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), groups_vbox, gtk_label_new (_("Groups")));
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), articlelist_ctree, gtk_label_new (_("Articles")));
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), text_box, gtk_label_new (_("Message")));
	gtk_box_pack_start (GTK_BOX (contents_vbox), notebook, TRUE, TRUE, 0);
	gtk_notebook_set_tab_border (GTK_NOTEBOOK (notebook), 2);
	gui_restore_column_widths (Pan.group_clist, "group");
	gui_restore_column_widths (Pan.article_ctree, "thread_pane");
	gtk_widget_show_all (GTK_WIDGET(contents_vbox));
	gnome_app_set_contents (GNOME_APP (Pan.window), contents_vbox);

	/* balance the earlier ref */
	gtk_widget_unref (groups_vbox);
	gtk_widget_unref (articlelist_ctree);
	gtk_widget_unref (text_box);

	pan_unlock ();
	debug_exit ("gui_notebook_construct");
}

void
gui_notebook_page_set (int page, GtkWidget * focus_item)
{
	pan_lock();
	gtk_notebook_set_page (GTK_NOTEBOOK (notebook), page);
	gtk_widget_grab_focus (focus_item);
	pan_unlock();
}

int
gui_notebook_get_current_pane (void)
{
	return gtk_notebook_get_current_page (GTK_NOTEBOOK (notebook));
}

