/* -*- mode: C; c-file-style: "gnu"; indent-tabs-mode: nil; -*-
 *
 * Copyright (C) 2012,2013 Colin Walters <walters@verbum.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#pragma once

#include "ostree.h"
#include "ostree-ordered-hash.h"
#include "ostree-bootloader.h"

G_BEGIN_DECLS

struct OstreeSysroot {
  GObject parent;

  GFile *path;
  int sysroot_fd;

  gboolean loaded;
  
  GPtrArray *deployments;
  int bootversion;
  int subbootversion;
  OstreeDeployment *booted_deployment;
};

gboolean
_ostree_sysroot_read_boot_loader_configs (OstreeSysroot *self,
                                          int            bootversion,
                                          GPtrArray    **out_loader_configs,
                                          GCancellable  *cancellable,
                                          GError       **error);

gboolean
_ostree_sysroot_read_current_subbootversion (OstreeSysroot *self,
                                             int            bootversion,
                                             int           *out_subbootversion,
                                             GCancellable  *cancellable,
                                             GError       **error);

gboolean
_ostree_sysroot_parse_deploy_path_name (const char *name,
                                        char      **out_csum,
                                        int        *out_serial,
                                        GError    **error);

gboolean
_ostree_sysroot_list_deployment_dirs_for_os (GFile               *osdir,
                                             GPtrArray           *inout_deployments,
                                             GCancellable        *cancellable,
                                             GError             **error);

gboolean
_ostree_sysroot_get_devino (GFile         *path,
                            guint32       *out_device,
                            guint64       *out_inode,
                            GCancellable  *cancellable,
                            GError       **error);

char *_ostree_sysroot_join_lines (GPtrArray  *lines);

char *_ostree_sysroot_split_keyeq (char *str);

OstreeOrderedHash *_ostree_sysroot_parse_kernel_args (const char *options);

char * _ostree_sysroot_kernel_arg_string_serialize (OstreeOrderedHash *ohash);

OstreeBootloader *_ostree_sysroot_query_bootloader (OstreeSysroot         *sysroot);

G_END_DECLS

