#
# opal_inc.mak
#
# Make symbols include file for Open Phone Abstraction library
#
# Copyright (c) 2001 Equivalence Pty. Ltd.
#
# The contents of this file are subject to the Mozilla Public License
# Version 1.0 (the "License"); you may not use this file except in
# compliance with the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS"
# basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
# the License for the specific language governing rights and limitations
# under the License.
#
# The Original Code is Open Phone Abstraction library.
#
# The Initial Developer of the Original Code is Equivalence Pty. Ltd.
#
# Contributor(s): ______________________________________.
#
# $Revision: 21107 $
# $Author: ms30002000 $
# $Date: 2008-09-21 19:14:58 +0000 (Sun, 21 Sep 2008) $
#

ifndef DEBUG_BUILD
DEBUG_BUILD             = no
endif
ifndef OPAL_SHARED_LIB
OPAL_SHARED_LIB         = yes
endif


# Tool names detected by configure
CXX                     = g++
CC                      = gcc
INSTALL                 = /usr/bin/install -c
AR                      = ar
RANLIB                  = ranlib
LD                      = g++
ARCHIVE                 = ar rcs

# The install directories
prefix                  = /home/robertj/opal
exec_prefix             = ${prefix}
libdir                  = ${exec_prefix}/lib
includedir              = ${prefix}/include
datarootdir             = ${prefix}/share

# The opal source and destination dirs
OPALDIR                 = /home/robertj/opal
OPAL_SRCDIR             = $(OPALDIR)/src
OPAL_INCDIR             = $(OPALDIR)/include
OPAL_LIBDIR             = ${OPALDIR}/lib_linux_x86

# The library file names
RELEASE_LIB_NAME                = libopal
RELEASE_LIB_FILENAME_STATIC     = libopal_s.a
RELEASE_LIB_FILENAME_SHARED     = libopal.so
RELEASE_LIB_FILENAME_SHARED_MAJ = libopal.so.3
RELEASE_LIB_FILENAME_SHARED_MIN = libopal.so.3.5
RELEASE_LIB_FILENAME_SHARED_PAT = libopal.so.3.5-beta0
RELEASE_CFLAGS                  =  -Os
RELEASE_LIBS                    = -L/home/robertj/ptlib/lib_linux_x86 -L/usr/kerberos/lib -lpt -lpthread -lsasl2 -lssl -lcrypto -lz -lexpat -lresolv -ldl  
RELEASE_OPAL_OBJDIR	        = ${OPALDIR}/lib_linux_x86/obj
RELEASE_OPAL_DEPDIR	        = ${OPALDIR}/lib_linux_x86/obj

# The library file names
DEBUG_LIB_NAME                  = libopal_d
DEBUG_LIB_FILENAME_STATIC       = libopal_d_s.a
DEBUG_LIB_FILENAME_SHARED       = libopal_d.so
DEBUG_LIB_FILENAME_SHARED_MAJ   = libopal_d.so.3
DEBUG_LIB_FILENAME_SHARED_MIN   = libopal_d.so.3.5
DEBUG_LIB_FILENAME_SHARED_PAT   = libopal_d.so.3.5-beta0
DEBUG_CFLAGS                    =  -g3 -ggdb -O0 -D_DEBUG
DEBUG_LIBS                      = -L/home/robertj/ptlib/lib_linux_x86 -L/usr/kerberos/lib -lpt_d -lpthread -lsasl2 -lssl -lcrypto -lz -lexpat -lresolv -ldl  
DEBUG_OPAL_OBJDIR	        = ${OPALDIR}/lib_linux_x86/obj_d
DEBUG_OPAL_DEPDIR	        = ${OPALDIR}/lib_linux_x86/obj_d

# Compile and linker flags
CFLAGS                  =  -Wall -Wextra -Winit-self -Wstrict-aliasing=2 -Wfloat-equal -Wno-comment -Wno-missing-field-initializers -Wno-unused -fPIC -DPTRACING=1 -D_REENTRANT -fno-exceptions -I/home/robertj/ptlib/include -I/usr/kerberos/include   
CXXFLAGS                =  -Wall -Wextra -Winit-self -Wstrict-aliasing=2 -Wfloat-equal -Wno-comment -Wno-missing-field-initializers -Wno-unused -fPIC -DPTRACING=1 -D_REENTRANT -fno-exceptions -I/home/robertj/ptlib/include -I/usr/kerberos/include   -felide-constructors -Wreorder 
CFLAGS                  =  -Wall -Wextra -Winit-self -Wstrict-aliasing=2 -Wfloat-equal -Wno-comment -Wno-missing-field-initializers -Wno-unused -fPIC -DPTRACING=1 -D_REENTRANT -fno-exceptions -I/home/robertj/ptlib/include -I/usr/kerberos/include   
LIBS                    =  -ldl
LDSOOPTS                = -shared -Wl,-soname,$(LIB_FILENAME_SHARED_PAT)
HAVE_RANLIB             = no

OPAL_H323         = yes
OPAL_SIP          = yes
OPAL_IAX2         = yes
OPAL_VIDEO        = yes
OPAL_ZRTP         = no
OPAL_LID	  = yes
OPAL_IVR	  = yes
OPAL_H224FECC     = yes
OPAL_H460         = yes
OPAL_SRTP	  = no
OPAL_RFC4175	  = yes
OPAL_AEC          = yes
OPAL_G711PLC      = yes
OPAL_T38_CAP	  = yes
OPAL_FAX          = yes
OPAL_JAVA         = no
SPEEX_SYSTEM      = no

OPAL_PLUGINS      = yes
OPAL_SAMPLES      = no

OPAL_PTLIB_SSL    = yes
OPAL_PTLIB_SSL_AES= yes
OPAL_PTLIB_ASN    = yes
OPAL_PTLIB_EXPAT  = yes
OPAL_PTLIB_AUDIO  = yes
OPAL_PTLIB_VIDEO  = yes
OPAL_PTLIB_WAVFILE= yes
OPAL_PTLIB_DTMF   = yes
OPAL_PTLIB_IPV6   = yes
OPAL_PTLIB_DNS    = yes
OPAL_PTLIB_LDAP   = no
OPAL_PTLIB_VXML   = yes
OPAL_PTLIB_CONFIG_FILE=yes


ifeq ($(DEBUG_BUILD),yes)
  CFLAGS   := $(DEBUG_CFLAGS) $(CFLAGS)
  CXXFLAGS := $(DEBUG_CFLAGS) $(CXXFLAGS)
  LIBS     += $(DEBUG_LIBS)
  LIB_NAME  = $(DEBUG_LIB_NAME)
else
  CFLAGS   := $(RELEASE_CFLAGS) $(CFLAGS)
  CXXFLAGS := $(RELEASE_CFLAGS) $(CXXFLAGS)
  LIBS     += $(RELEASE_LIBS)
  LIB_NAME  = $(RELEASE_LIB_NAME)
endif

CXXFLAGS   += -I$(OPAL_INCDIR)
CFLAGS     += -I$(OPAL_INCDIR)


# End of file
