
import threading

class AsyncItem(object):

    def __init__(self, target_method, target_method_args, finish_callback, finish_callback_args = ()):
        self.target_method = target_method
        self.target_method_args = target_method_args
        self.finish_callback = finish_callback
        self.finish_callback_args = finish_callback_args
        self.canceled = False

    def run(self):
        if self.canceled:
            return
        print 'GOING FOR', self.target_method_args
        results = self.target_method(*self.target_method_args)
        self.finish_callback_args += (results,)
        if self.canceled:
            return
        return self.finish_callback(*self.finish_callback_args)

    def cancel(self):
        self.canceled = True

class AsyncWorker(threading.Thread):

    def __init__(self, queue):
        threading.Thread.__init__(self)
        self.queue = queue
        self.stopped = False
        self.async_item = None
        self.item_number = -1

    def run(self):
        while not self.stopped:
            if self.queue.empty():
                self.stop()
                break
            try:
                self.async_item = self.queue.get()
                self.item_number += 1
                self.async_item.run()
                self.queue.task_done()
                self.async_item = None
            except:
                self.stop()

    def stop(self):
        self.stopped = True
        if self.async_item:
            self.async_item.cancel()
