/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/* 
 * TrilobiteRootClient is a GtkObject wrapper for the corba object
 * PasswordQueryClient.
 *
 * Copyright (C) 2000 Eazel, Inc
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authors: Robey Pointer <robey@eazel.com>
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <liboaf/liboaf.h>
#include <bonobo.h>
#include "libtrilobite.h"
#include "trilobite-service.h"		/* autogenerated */
#include "trilobite-root-client-public.h"
#include "trilobite-root-client-private.h"


static GtkObject *parent_class;

/* signals that a TrilobiteRootClient can emit */
/* LAST_SIGNAL is just a sentinel marking the end of the list */
enum {
	NEED_PASSWORD,
	LAST_SIGNAL
};
static guint root_client_signals[LAST_SIGNAL] = { 0 };


/**********   corba stuff   **********/

static PortableServer_ServantBase__epv base_epv = { NULL, NULL, NULL };

typedef struct {
	POA_Trilobite_PasswordQueryClient servant;
	BonoboObject *bonobo_object;
} impl_POA_Trilobite_PasswordQueryClient;

/* emit the signal to get the password */
static CORBA_char *
impl_Trilobite_PasswordQueryClient_get_password (impl_POA_Trilobite_PasswordQueryClient *trilobite,
						 CORBA_char *prompt,
						 CORBA_Environment *ev)
{
	char *password;
	char *result;

	/* now emit a signal and get the password */
	password = NULL;
	gtk_signal_emit (GTK_OBJECT (trilobite->bonobo_object), root_client_signals[NEED_PASSWORD], prompt, &password);
	if (password == NULL) {
		/* bummer.  nobody caught the signal. */
		password = g_strdup ("");
	}

	/* make it be owned by corba */
	result = CORBA_string_dup (password);
	g_free (password);

	return result;
};

POA_Trilobite_PasswordQueryClient__epv *
trilobite_root_client_get_epv(void) 
{
	POA_Trilobite_PasswordQueryClient__epv *epv;

	epv = g_new0 (POA_Trilobite_PasswordQueryClient__epv, 1);
	epv->get_password = (gpointer)&impl_Trilobite_PasswordQueryClient_get_password;

	return epv;
};

static Trilobite_PasswordQueryClient
trilobite_root_client_create_corba_object (BonoboObject *trilobite)
{
	impl_POA_Trilobite_PasswordQueryClient *servant;
	CORBA_Environment ev;

	g_assert (trilobite != NULL);

	CORBA_exception_init (&ev);
	
	servant = g_new0 (impl_POA_Trilobite_PasswordQueryClient, 1);
	((POA_Trilobite_PasswordQueryClient *)servant)->vepv =
		TRILOBITE_ROOT_CLIENT_CLASS (GTK_OBJECT (trilobite)->klass)->servant_vepv;
	servant->bonobo_object = trilobite;

	POA_Trilobite_PasswordQueryClient__init (servant, &ev);
	ORBIT_OBJECT_KEY (((POA_Trilobite_PasswordQueryClient *)servant)->_private)->object = NULL;	

	if (ev._major != CORBA_NO_EXCEPTION) {
		g_warning ("Cannot instantiate Trilobite_PasswordQueryClient corba object"); 
		g_free (servant);
		CORBA_exception_free (&ev);		
		return CORBA_OBJECT_NIL;
	}

	CORBA_exception_free (&ev);

	return (Trilobite_PasswordQueryClient) bonobo_object_activate_servant (trilobite, servant);
}


/**********   gtk object stuff   **********/

/* have to make my own signal marshaller for STRING__STRING (grumble) */
typedef gchar *(*GtkSignal_STRING__STRING) (GtkObject *object, gchar *arg1, gpointer user_data);
static void
gtk_marshal_STRING__STRING (GtkObject *object, GtkSignalFunc func, gpointer func_data, GtkArg *args)
{
	GtkSignal_STRING__STRING rfunc;
	gchar **return_value;

	return_value = GTK_RETLOC_STRING (args[1]);
	rfunc = (GtkSignal_STRING__STRING)func;
	*return_value = (*rfunc) (object, GTK_VALUE_STRING (args[0]), func_data);
}


/* destroy callback, and accessible from the outside world */
void
trilobite_root_client_unref (GtkObject *object)
{
	TrilobiteRootClient *root_client;

	g_return_if_fail (object != NULL);
	g_return_if_fail (TRILOBITE_IS_ROOT_CLIENT (object));
	trilobite_debug ("<-- trilobite_root_client");

	root_client = TRILOBITE_ROOT_CLIENT (object);

	bonobo_object_unref (BONOBO_OBJECT (object));
}

static void
trilobite_root_client_finalize (GtkObject *object)
{
	TrilobiteRootClient *root_client;

	g_return_if_fail (object != NULL);
	g_return_if_fail (TRILOBITE_IS_ROOT_CLIENT (object));

	root_client = TRILOBITE_ROOT_CLIENT (object);

	g_free (root_client->private);
	root_client->private = NULL;

	/* call parent destructor */
	if (GTK_OBJECT_CLASS (parent_class)->finalize) {
		GTK_OBJECT_CLASS (parent_class)->finalize (object);
	}
}

/* class initializer */
static void
trilobite_root_client_class_initialize (TrilobiteRootClientClass *klass)
{
	GtkObjectClass *object_class;

	parent_class = gtk_type_class (GTK_TYPE_OBJECT);

	object_class = (GtkObjectClass *)klass;
	object_class->finalize = trilobite_root_client_finalize;

	klass->servant_init = POA_Trilobite_PasswordQueryClient__init;
	klass->servant_fini = POA_Trilobite_PasswordQueryClient__fini;
	klass->servant_vepv = g_new0 (POA_Trilobite_PasswordQueryClient__vepv, 1);

	((POA_Trilobite_PasswordQueryClient__vepv*)klass->servant_vepv)->_base_epv = &base_epv; 
	((POA_Trilobite_PasswordQueryClient__vepv*)klass->servant_vepv)->Bonobo_Unknown_epv = bonobo_object_get_epv ();
	((POA_Trilobite_PasswordQueryClient__vepv*)klass->servant_vepv)->Trilobite_PasswordQueryClient_epv = 
		trilobite_root_client_get_epv ();

	root_client_signals[NEED_PASSWORD] =
		gtk_signal_new ("need_password", 0, object_class->type, 0,
				gtk_marshal_STRING__STRING, GTK_TYPE_STRING, 1, GTK_TYPE_STRING);
	gtk_object_class_add_signals (object_class, root_client_signals, LAST_SIGNAL);
}

gboolean
trilobite_root_client_construct (TrilobiteRootClient *root_client,
				 Trilobite_PasswordQueryClient corba_trilobite)
{
	g_assert (root_client != NULL);
	g_assert (TRILOBITE_IS_ROOT_CLIENT (root_client));
	g_return_val_if_fail (corba_trilobite != CORBA_OBJECT_NIL, FALSE);

	if (!bonobo_object_construct (BONOBO_OBJECT (root_client), (CORBA_Object) corba_trilobite)) {
		return FALSE;
	}

	return TRUE;
}

/* object initializer */
static void
trilobite_root_client_initialize (TrilobiteRootClient *object)
{
	TrilobiteRootClient *root_client;
	Trilobite_PasswordQueryClient corba_trilobite;

	g_assert (object != NULL);
	g_assert (TRILOBITE_IS_ROOT_CLIENT (object));
	trilobite_debug ("--> trilobite_root_client");

	root_client = TRILOBITE_ROOT_CLIENT (object);

	corba_trilobite = trilobite_root_client_create_corba_object (BONOBO_OBJECT (object));
	if (trilobite_root_client_construct (object, corba_trilobite) == FALSE) {
		/* FIXME: no good way to bail out now */
		corba_trilobite = CORBA_OBJECT_NIL;
	}

	object->private = g_new0 (TrilobiteRootClientPrivate, 1);
	object->private->pq_client = corba_trilobite;
}

/* generate the GtkType for TrilobiteRootClient */
GtkType
trilobite_root_client_get_type (void)
{
	static GtkType trilobite_root_client_type = 0;

	/* First time it's called ? */
	if (! trilobite_root_client_type) {
		static const GtkTypeInfo root_client_info = {
			"TrilobiteRootClient",
			sizeof (TrilobiteRootClient),
			sizeof (TrilobiteRootClientClass),
			(GtkClassInitFunc) trilobite_root_client_class_initialize,
			(GtkObjectInitFunc) trilobite_root_client_initialize,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		/* Get a unique GtkType */
		trilobite_root_client_type = gtk_type_unique (bonobo_object_get_type(), &root_client_info);
	}

	return trilobite_root_client_type;
}

TrilobiteRootClient *
trilobite_root_client_new (void)
{
	return TRILOBITE_ROOT_CLIENT (gtk_object_new (TRILOBITE_TYPE_ROOT_CLIENT, NULL));
}


/**********   functions that actually implement the root client   **********/

/* returns the actual corba object for the PasswordQueryClient.
 * only needed if you feel like writing your own _attach function instead of using the one below.
 */
Trilobite_PasswordQueryClient
trilobite_root_client_get_passwordqueryclient (TrilobiteRootClient *root_client)
{
	g_return_val_if_fail (root_client != NULL, CORBA_OBJECT_NIL);
	g_return_val_if_fail (TRILOBITE_IS_ROOT_CLIENT (root_client), CORBA_OBJECT_NIL);

	return root_client->private->pq_client;
}

/* if 'service' implements PasswordQuery, this function attaches the TrilobiteRootClient to that
 * PasswordQuery as the callback mechanism.
 * --- this is a necessary step, if you want a working TrilobiteRootClient.
 * returns TRUE on success
 */
gboolean
trilobite_root_client_attach (TrilobiteRootClient *root_client, BonoboObjectClient *service)
{
	Trilobite_PasswordQuery trilobite_password;
	CORBA_Environment ev;

	g_return_val_if_fail (root_client != NULL, FALSE);
	g_return_val_if_fail (TRILOBITE_IS_ROOT_CLIENT (root_client), FALSE);
	g_return_val_if_fail (service != NULL, FALSE);
	g_return_val_if_fail (BONOBO_IS_OBJECT_CLIENT (service), FALSE);
	g_assert (root_client->private->pq_client != CORBA_OBJECT_NIL);

	CORBA_exception_init (&ev);
	if (! bonobo_object_client_has_interface (service, "IDL:Trilobite/PasswordQuery:1.0", &ev)) {
		goto fail;
	}

	trilobite_password = bonobo_object_query_interface (BONOBO_OBJECT (service),
							    "IDL:Trilobite/PasswordQuery:1.0");
	if (trilobite_password == CORBA_OBJECT_NIL) {
		g_warning ("somehow query-interface(PasswordQuery) returned nil");
		goto fail;
	}

	Trilobite_PasswordQuery_set_query_client (trilobite_password, root_client->private->pq_client, &ev);
	if (ev._major != CORBA_NO_EXCEPTION) {
		g_warning ("set-query-client got exception :(");
	}
	Trilobite_PasswordQuery_unref (trilobite_password, &ev);
	CORBA_Object_release (trilobite_password, &ev);

	CORBA_exception_free (&ev);
	return TRUE;

fail:
	CORBA_exception_free (&ev);
	return FALSE;
}
