/*
 * Nautilus Actions
 * A Nautilus extension which offers configurable context menu actions.
 *
 * Copyright (C) 2005 The GNOME Foundation
 * Copyright (C) 2006, 2007, 2008 Frederic Ruaudel and others (see AUTHORS)
 * Copyright (C) 2009 Pierre Wieser and others (see AUTHORS)
 *
 * This Program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This Program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this Library; see the file COPYING.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *   Frederic Ruaudel <grumz@grumz.net>
 *   Rodrigo Moya <rodrigo@gnome-db.org>
 *   Pierre Wieser <pwieser@trychlos.org>
 *   ... and many others (see AUTHORS)
 */

#ifndef __NACT_IACTION_TAB_H__
#define __NACT_IACTION_TAB_H__

/*
 * NactIActionTab interface definition.
 *
 * This interface implements the "Nautilus Menu Item" box.
 */

#include "nact-window.h"

G_BEGIN_DECLS

#define NACT_IACTION_TAB_TYPE						( nact_iaction_tab_get_type())
#define NACT_IACTION_TAB( object )					( G_TYPE_CHECK_INSTANCE_CAST( object, NACT_IACTION_TAB_TYPE, NactIActionTab ))
#define NACT_IS_IACTION_TAB( object )				( G_TYPE_CHECK_INSTANCE_TYPE( object, NACT_IACTION_TAB_TYPE ))
#define NACT_IACTION_TAB_GET_INTERFACE( instance )	( G_TYPE_INSTANCE_GET_INTERFACE(( instance ), NACT_IACTION_TAB_TYPE, NactIActionTabInterface ))

typedef struct NactIActionTab NactIActionTab;

typedef struct NactIActionTabInterfacePrivate NactIActionTabInterfacePrivate;

typedef struct {
	GTypeInterface                  parent;
	NactIActionTabInterfacePrivate *private;

	/* api */
	NAObject *  ( *get_selected )     ( NactWindow *window );
	NAAction *  ( *get_edited_action )( NactWindow *window );
	void        ( *field_modified )   ( NactWindow *window );
}
	NactIActionTabInterface;

GType    nact_iaction_tab_get_type( void );

void     nact_iaction_tab_initial_load( NactWindow *dialog );
void     nact_iaction_tab_runtime_init( NactWindow *dialog );
void     nact_iaction_tab_all_widgets_showed( NactWindow *dialog );
void     nact_iaction_tab_dispose( NactWindow *dialog );

void     nact_iaction_tab_set_action( NactWindow *dialog, const NAAction *action, GSList *selected_items );
gboolean nact_iaction_tab_has_label( NactWindow *window );

G_END_DECLS

#endif /* __NACT_IACTION_TAB_H__ */
