#!/usr/bin/env python

# Copyright (C) 2009,2010 Junta de Andalucia
# 
# Authors:
#   Roberto Majadas <roberto.majadas at openshine.com>
#   Cesar Garcia Tapia <cesar.garcia.tapia at openshine.com>
#   Luis de Bethencourt <luibg at openshine.com>
#   Pablo Vieytes <pvieytes at openshine.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
# USA

import os
import sys
import gettext

from SystrayNanny import SystrayNanny

if os.name == "posix":
    icons_files_dir= os.path.join("/usr","share/icons/hicolor")
    locale_dir = os.path.join("/usr", "share/" ,"locale/")
elif os.name == "nt":
    if not hasattr(sys, "frozen") :
        file_dir = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))
        for x in range(8):
            file_dir = os.path.dirname(file_dir)

        root_path = file_dir
        icons_files_dir = os.path.join(root_path, "share" , "icons", "hicolor" )
        locale_dir = os.path.join(root_path, "share" ,"locale")
    else:
        root_path = os.path.dirname(os.path.dirname(unicode(sys.executable, sys.getfilesystemencoding( ))))
        icons_files_dir = os.path.join(root_path, "share" , "icons", "hicolor" )
        locale_dir = os.path.join(root_path, "share" ,"locale")

GETTEXT_DOMAIN = 'nanny'

gettext.bindtextdomain(GETTEXT_DOMAIN, locale_dir)
gettext.textdomain(GETTEXT_DOMAIN)
