/* -*- Mode: C; indent-tabs-mode:nil; c-basic-offset: 8-*- */
/*
 *This file is part of MlView.
 *
 *MlView is free software; you can redistribute 
 *it and/or modify it under the terms of 
 *the GNU General Public License as published by the 
 *Free Software Foundation; either version 2, 
 *or (at your option) any later version.
 *
 *GNU MlView is distributed in the hope that it will 
 *be useful, but WITHOUT ANY WARRANTY; 
 *without even the implied warranty of 
 *MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *See the GNU General Public License for more details.
 *
 *You should have received a copy of the 
 *GNU General Public License along with MlView; 
 *see the file COPYING. 
 *If not, write to the Free Software Foundation, 
 *Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 *Copyright 2001-2002 dodji SEKETELI, Gal CHAMOULAUD.
 *http://www.freespiders.org
 */

#ifndef __MLVIEW_XML_DOC_TREE_VIEW_H__
#define __MLVIEW_XML_DOC_TREE_VIEW_H__

#include <libxml/tree.h>
#define TREE_EDITOR2 1

#ifdef TREE_EDITOR2
#include "mlview-tree-editor2.h"
#else
#include "mlview-tree-editor.h"
#endif
#include "mlview-node-editor.h"
#include "mlview-app-context.h"
#include "mlview-xml-document-view.h"

G_BEGIN_DECLS
#define MLVIEW_TYPE_XML_DOC_TREE_VIEW (mlview_xml_doc_tree_view_get_type ())
#define MLVIEW_XML_DOC_TREE_VIEW(widget) (G_TYPE_CHECK_INSTANCE_CAST ((widget), MLVIEW_TYPE_XML_DOC_TREE_VIEW, MlViewXMLDocTreeView))
#define MLVIEW_XML_DOC_TREE_VIEW_CLASS(widget) (G_TYPE_CHECK_CLASS_CAST ((widget), MLVIEW_TYPE_XML_DOC_TREE_VIEW, MlViewXMLDocTreeViewClass))
#define MLVIEW_IS_XML_DOC_TREE_VIEW(widget) (G_TYPE_CHECK_INSTANCE_TYPE ((widget),MLVIEW_TYPE_XML_DOC_TREE_VIEW))
#define MLVIEW_IS_XML_DOC_TREE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MLVIEW_TYPE_XML_DOC_TREE_VIEW))
typedef struct _MlViewXMLDocTreeView MlViewXMLDocTreeView;
typedef struct _MlViewXMLDocTreeViewClass MlViewXMLDocTreeViewClass;
typedef struct _MlViewXMLDocTreeViewPrivate MlViewXMLDocTreeViewPrivate;

struct _MlViewXMLDocTreeView {
        MlViewXMLDocumentView view;
        MlViewXMLDocTreeViewPrivate *priv;
};

struct _MlViewXMLDocTreeViewClass {
        MlViewXMLDocumentViewClass parent_class;
        /*signal default handlers */
        void (*document_changed) (MlViewXMLDocTreeView *
                                  tree_view, gpointer a_data);
};

guint mlview_xml_doc_tree_view_get_type (void);

GtkWidget *mlview_xml_doc_tree_view_new (MlViewXMLDocument *
                                         a_mlview_xml_doc,
                                         gchar * a_name,
                                         MlViewAppContext *
                                         a_app_context);

void mlview_xml_doc_tree_view_set_app_context (MlViewXMLDocTreeView * a_tree_view,
                                               MlViewAppContext * a_app_context);
#ifdef TREE_EDITOR2
MlViewTreeEditor2 * mlview_xml_doc_tree_view_get_tree_editor (MlViewXMLDocTreeView * a_tree_view);
#else
MlViewTreeEditor * mlview_xml_doc_tree_view_get_tree_editor (MlViewXMLDocTreeView * a_tree_view);
#endif

MlViewNodeEditor * mlview_xml_doc_tree_view_get_node_editor (MlViewXMLDocTreeView * a_tree_view);

void mlview_xml_doc_tree_view_construct (MlViewXMLDocTreeView * a_tree_view,
                                     MlViewXMLDocument *
                                     a_mlview_xml_doc,
                                     gchar * a_name,
                                     MlViewAppContext *
                                     a_app_context);

void mlview_xml_doc_tree_view_add_child_node_interactive (MlViewXMLDocTreeView * a_tree_view);

void mlview_xml_doc_tree_view_insert_sibling_node_interactive (MlViewXMLDocTreeView * a_tree_view);

void mlview_xml_doc_tree_view_insert_prev_sibling_node_interactive (MlViewXMLDocTreeView * a_tree_view);

void mlview_xml_doc_tree_view_insert_next_sibling_node_interactive (MlViewXMLDocTreeView * a_tree_view);

void mlview_xml_doc_tree_view_cut_node (MlViewXMLDocTreeView * a_tree_view);

void mlview_xml_doc_tree_view_copy_node (MlViewXMLDocTreeView * a_tree_view);

void mlview_xml_doc_tree_view_paste_node_as_child (MlViewXMLDocTreeView * a_tree_view);

void mlview_xml_doc_tree_view_paste_node_as_prev_sibling (MlViewXMLDocTreeView * a_tree_view);

void mlview_xml_doc_tree_view_paste_node_as_next_sibling (MlViewXMLDocTreeView * a_tree_view);

void mlview_xml_doc_tree_view_set_upper_paned1_proportions (MlViewXMLDocTreeView * a_tree_view,
                                                            const guint a_percentage);

GtkCTreeNode * mlview_xml_doc_tree_view_find_xml_node_that_contains_str_interactive (MlViewXMLDocTreeView * a_tree_view);

void mlview_xml_doc_tree_view_set_main_paned_proportions (MlViewXMLDocTreeView * a_tree_view,
                                                          const guint a_percentage);

void mlview_xml_doc_tree_view_set_all_paned_proportions (MlViewXMLDocTreeView * a_tree_view,
                                                         const guint a_main_paned_percentage,
                                                         const guint
                                                         a_node_editor_paned_percentage);

void mlview_xml_doc_tree_view_set_xml_document_path (MlViewXMLDocTreeView * a_view,
                                                     gchar * a_file_path);

void mlview_xml_doc_tree_view_expand_tree_to_depth_interactive (MlViewXMLDocTreeView * a_view);

void mlview_xml_doc_tree_view_update_contextual_menu (MlViewXMLDocTreeView * a_view,
                                                      GtkMenu ** a_menu_ptr);

G_END_DECLS
#endif
