/*
 *This file is part of MlView.
 *
 *MlView is free software; you can redistribute 
 *it and/or modify it under the terms of 
 *the GNU General Public License as published by the 
 *Free Software Foundation; either version 2, 
 *or (at your option) any later version.
 *
 *GNU MlView is distributed in the hope that it will 
 *be useful, but WITHOUT ANY WARRANTY; 
 *without even the implied warranty of 
 *MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *See the GNU General Public License for more details.
 *
 *You should have received a copy of the 
 *GNU General Public License along with MlView; 
 *see the file COPYING. 
 *If not, write to the Free Software Foundation, 
 *Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 *Copyright 2001-2002 dodji SEKETELI, Gal CHAMOULAUD.
 *http://www.freespiders.org
 */

/**
 *Is the abstraction of a name/value pair based on the GTK typing system. 
 *
 */

#include "mlview-name-value-pair.h"
static void
 mlview_name_value_pair_init_class (MlViewNameValuePairClass *
                                    a_klass);
static void mlview_name_value_pair_init (MlViewNameValuePair *
                                         a_object);
static void mlview_name_value_pair_destroy (GtkObject *
                                            a_object);
static GtkObject *parent_class = NULL;

/*
 *common functions to comply with the GtkObject typing system.
 */

/**
 *simple type getter.
 *@author Dodji Seketeli <sdodji@yahoo.com> 
 *
 */
guint
mlview_name_value_pair_get_type (void)
{
        static guint mlview_name_value_pair_type = 0;

        if (!mlview_name_value_pair_type) {

                static const GTypeInfo t_info = {
                        sizeof (MlViewNameValuePairClass),
                        NULL,   /* base_init */
                        NULL,   /* base_finalize */
                        (GClassInitFunc)
                                mlview_name_value_pair_init_class,
                        NULL,   /* class_finalize */
                        NULL,   /* class_data */
                        sizeof (MlViewNameValuePair),
                        0,
                        (GInstanceInitFunc)
                        mlview_name_value_pair_init
                };

                mlview_name_value_pair_type =
                        g_type_register_static (GTK_TYPE_OBJECT,
                                                "MlViewNameValuePair",
                                                &t_info, 0);
        }
        return mlview_name_value_pair_type;
}

/**
 *The class struct initialyzer.
 *For the moment, we don't define neither signal nor argument.
 *@author Dodji Seketeli <sdodji@yahoo.com> 
 *
 */
static void
mlview_name_value_pair_init_class (MlViewNameValuePairClass *
                                   a_klass)
{
        GtkObjectClass *object_class;

        g_return_if_fail (a_klass != NULL);

        object_class = GTK_OBJECT_CLASS (a_klass);
        object_class->destroy = mlview_name_value_pair_destroy;
        parent_class = gtk_type_new (GTK_TYPE_OBJECT);
        /*We don't define any new signal now */
}

/**
 *@author Dodji Seketeli <sdodji@yahoo.com> 
 *
 */
static void
mlview_name_value_pair_init (MlViewNameValuePair * a_object)
{
        g_return_if_fail (a_object != NULL);
        a_object->name = a_object->value = NULL;
}

/**
 *Creates a new instance of name/value pair.
 *@author Dodji Seketeli <sdodji@yahoo.com> 
 *
 */
GtkObject *
mlview_name_value_pair_new (gchar * a_name, gchar * a_value)
{
        MlViewNameValuePair *nvpair;

        g_return_val_if_fail (a_name != NULL, NULL);
        g_return_val_if_fail (a_value != NULL, NULL);

        nvpair = gtk_type_new (GTK_TYPE_MLVIEW_NAME_VALUE_PAIR);
        nvpair->name = g_strdup (a_name);
        nvpair->value = g_strdup (a_value);

        return GTK_OBJECT (nvpair);
}

/**
 *@author Dodji Seketeli <sdodji@yahoo.com> 
 *
 */
static void
mlview_name_value_pair_destroy (GtkObject * a_object)
{
        MlViewNameValuePair *nvpair;

        g_return_if_fail (a_object != NULL);

        nvpair = MLVIEW_NAME_VALUE_PAIR (a_object);
        if (nvpair->name) {
                g_free (nvpair->name);
                nvpair->name = NULL;
        }
        if (nvpair->value) {
                g_free (nvpair->value);
                nvpair->value = NULL;
        }
        if (GTK_OBJECT_CLASS (parent_class)->destroy) {
                (*GTK_OBJECT_CLASS (parent_class)->
                 destroy) (a_object);
        }
}

/**
 *@author Dodji Seketeli <sdodji@yahoo.com> 
 *
 */
void
mlview_name_value_pair_set_name (MlViewNameValuePair * a_nvpair,
                                 gchar * a_name)
{
        g_return_if_fail (a_nvpair);
        g_return_if_fail (a_name);
        if (a_nvpair->name)
                g_free (a_nvpair->name);
        a_nvpair->name = g_strdup (a_name);
}

/**
 *@author Dodji Seketeli <sdodji@yahoo.com> 
 *
 */
void
mlview_name_value_pair_set_value (MlViewNameValuePair * a_nvpair,
                                  gchar * a_value)
{
        g_return_if_fail (a_nvpair);
        g_return_if_fail (a_value);

        if (a_nvpair->value)
                g_free (a_nvpair->value);
        a_nvpair->value = g_strdup (a_value);
}
