#include "screenshot.h"
#include <gdk/gdkx.h>
#include "io-png.h"

#define SCALE_WIDTH 640
#define SCALE_HEIGHT 480

#include <gnome.h>

static GdkPixbuf*
scale_aspect (GdkPixbuf *buf)
{
	int width, height;
	int rwidth, rheight;

	g_return_val_if_fail (buf != NULL, NULL);

	rwidth = gdk_pixbuf_get_width (buf);
	rheight = gdk_pixbuf_get_height (buf);

	if (rwidth < SCALE_WIDTH && rheight < SCALE_HEIGHT)
		return gdk_pixbuf_copy (buf);
	else if (rwidth > rheight)
	{
		width = SCALE_WIDTH;
		height = SCALE_HEIGHT * (((double)rheight)/rwidth);
	}
	else
	{
		height = SCALE_HEIGHT;
		width = SCALE_WIDTH * (((double)rwidth)/rheight);
	}

	return gdk_pixbuf_scale_simple (buf, width, height, GDK_INTERP_BILINEAR);
}
		
gboolean
screenshot_grab (const gchar *filename)
{
	GdkPixbuf *buf, *scaled;
	GdkWindow *root;
	int width, height;
	gboolean result;
	
	g_return_val_if_fail (filename != NULL, FALSE);

	/* Say cheese! */
	root = GDK_ROOT_PARENT ();
	gdk_window_get_size (root, &width, &height);
			
	buf = gdk_pixbuf_get_from_drawable (NULL, root, NULL,
		       			    0, 0, 0, 0, width, height);
	scaled = scale_aspect (buf);
	gdk_pixbuf_unref (buf);

	result = save_png (scaled, filename);
	gdk_pixbuf_unref (scaled);
	
	return result;
}
