/* settings.h
 *
 * Copyright (C) 2002 Rodrigo Moya
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __SETTINGS_H__
#define __SETTINGS_H__

#include <gtk/gtkwidget.h>
#include "conf-manager.h"

/* configuration entries accessors */
gchar   *settings_get_default_datasource (void);
void     settings_set_default_datasource (const gchar *ds);
gchar   *settings_get_plugins_dir (void);
void     settings_set_plugins_dir (const gchar *dir);

gboolean settings_get_delete_confirmation_dialog (void);
void     settings_set_delete_confirmation_dialog (gboolean confirm);
gboolean settings_get_insert_confirmation_dialog (void);
void     settings_set_insert_confirmation_dialog (gboolean confirm);
gboolean settings_get_select_confirmation_dialog (void);
void     settings_set_select_confirmation_dialog (gboolean confirm);
gboolean settings_get_update_confirmation_dialog (void);
void     settings_set_update_confirmation_dialog (gboolean confirm);

/* settings dialog */
void settings_dialog_display (GtkWidget *parent, ConfManager *conf);

#endif
