/* mg-canvas-entity.h
 *
 * Copyright (C) 2004 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __MG_CANVAS_ENTITY__
#define __MG_CANVAS_ENTITY__

#include "mg-canvas-item.h"
#include <libmergeant/mg-defs.h>

G_BEGIN_DECLS

/*
 * 
 * "Drag item" GnomeCanvas item: a MgCanvasItem item which is used to represent
 * an element being dragged, and destroys itself when the mouse button is released
 *
 */

#define MG_CANVAS_ENTITY_TYPE          (mg_canvas_entity_get_type())
#define MG_CANVAS_ENTITY(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, mg_canvas_entity_get_type(), MgCanvasEntity)
#define MG_CANVAS_ENTITY_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, mg_canvas_entity_get_type (), MgCanvasEntityClass)
#define IS_MG_CANVAS_ENTITY(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, mg_canvas_entity_get_type ())


/* struct for the object's data */
struct _MgCanvasEntity
{
	MgCanvasItem           object;

	MgCanvasEntityPrivate *priv;
};

/* struct for the object's class */
struct _MgCanvasEntityClass
{
	MgCanvasItemClass   parent_class;
};

/* generic widget's functions */
guint          mg_canvas_entity_get_type       (void);
MgCanvasField *mg_canvas_entity_get_field_item (MgCanvasEntity *ce, MgField *field);
gdouble        mg_canvas_entity_get_field_ypos (MgCanvasEntity *ce, MgField *field);

G_END_DECLS

#endif
