#include <stdio.h>
#include <string.h>
#include "../libmergeant/libmergeant.h"

#define MAKE_DUMPS 1

#define STEP_SEPARATOR "------------------"
#define xmlfile "SQL_tests.xml"

void make_query_test (MgConf *conf, FILE *stream, const gchar *sql, gboolean expected_result);

gint main (int argc, char **argv) {
	MgConf *conf = NULL;
	GError *error = NULL;
	xmlDocPtr doc;
	xmlNodePtr node, subnode;
	FILE *out = stdout;
	gboolean in_file = FALSE;

	gtk_init (&argc, &argv);

	g_print ("# This test creates\n");
	g_print ("# Queries FROM SQL statements\n\n");


	if (! g_file_test (xmlfile, G_FILE_TEST_EXISTS)) {
		g_print ("cant' find file '%s'", xmlfile);
		exit (1);
	}

	doc = xmlParseFile (xmlfile);
	if (!doc) {
		g_print ("Cant' load XML file '%s'", xmlfile);
		exit (1);
	}

	node = xmlDocGetRootElement (doc);
	if (strcmp (node->name, "test_scenario")) {
		g_print ("XML file top node is not <test_scenario>\n");
		exit (1);
	}

	subnode = node->children;
	while (subnode) {
		/* new dictionnary */
		if (!strcmp (subnode->name, "dictionnary")) {
			gchar *filename = xmlGetProp (subnode, "name");
			if (conf) {
				g_object_unref (G_OBJECT (conf));
				conf = NULL;
			}

			if (filename) {
				conf = MG_CONF (mg_conf_new ());
				g_print ("Loading dictionnary %s\n", filename);
				if (!mg_conf_load_xml_file (conf, filename, &error)) {
					g_print ("Error occurred:\n\t%s\n", error->message);
					g_error_free (error);
					exit (1);
				}
				g_free (filename);
			}
		}
		
		/* new output file */
		if (!strcmp (subnode->name, "output_file")) {
			gchar *filename = xmlGetProp (subnode, "name");
			if (in_file) {
				/* HTML end */
				g_fprintf (out, "</table>\n");
				g_fprintf (out, "</body>\n");
				g_fprintf (out, "</html>\n");
				fclose (out);
			}
			out = stdout;

			if (filename) {
				g_print ("Writing to %s\n", filename);
				out = fopen (filename, "w");
				if (!out) {
					g_print ("Can't open '%s' to write\n", filename);
					exit (1);
				}
				g_free (filename);
			}

			/* HTML init */
			g_fprintf (out, "<html>\n");
			g_fprintf (out, "<body>\n");
			g_fprintf (out, "<table cellspacing=\"3\" cellpadding=\"3\" border=\"1\" width=\"100%\">\n");

			in_file = TRUE;
		}
		
		/* new test group */
		if (!strcmp (subnode->name, "test_group")) {
			xmlNodePtr test = subnode->children;
			gchar *descr = xmlGetProp (subnode, "descr");

			g_fprintf (out, "<tr><th colspan=\"3\" bgcolor=\"green4\">%s</th></tr>\n", descr);
			g_fprintf (out, "<tr><th>SQL to parse</th><th>Result SQL</th><th>Error</th></tr>\n", descr);
			g_free (descr);

			while (test) {
				if (!strcmp (test->name, "test")) {
					gchar *sql = xmlGetProp (test, "sql");
					gchar *expected = xmlGetProp (test, "expect");

					if (sql) {
						make_query_test (conf, out, sql, 
								 expected && (*expected=='N') ? FALSE : TRUE);
						g_free (sql);
					}
					if (expected)
						g_free (expected);
				}
				test = test->next;
			}
		}
		subnode = subnode->next;
	}
	xmlFreeDoc (doc);

	if (in_file) {
		/* HTML end */
		g_fprintf (out, "</table>\n");
		g_fprintf (out, "</body>\n");
		g_fprintf (out, "</html>\n");
		fclose (out);
	}

	if (conf)
		g_object_unref (G_OBJECT (conf));
	return 0;
}

void
make_query_test (MgConf *conf, FILE *stream, const gchar *sql, gboolean expected_result)
{
	MgQuery *query;
	GError *error = NULL;

	g_fprintf (stream, "\t<tr><td>%s</td>", sql);
	query = (MgQuery *) mg_query_new_from_sql (conf, sql, &error);
	if (mg_query_get_query_type (query) != MG_QUERY_TYPE_NON_PARSED_SQL) {
		gchar *sql2, *extra = "";
		
		if (!expected_result)
			extra = "bgcolor=\"red\"";

		sql2 = mg_renderer_render_as_sql (MG_RENDERER (query), NULL, MG_RENDERER_EXTRA_VAL_ATTRS, &error);
		if (sql2)
			g_fprintf (stream, "<td>%s</td><td></td>", sql2);
		else {
			if (error && error->message)
				g_fprintf (stream, "<td>---</td><td %s>PARSING gen. error: %s</td>", 
					   extra, error->message);
			else
				g_fprintf (stream, "<td>---</td><td %s>PARSING gen. error: NO ERROR MSG</td>", 
					   extra);
			if (error)
				g_error_free (error);
		}
	}
	else {
		gchar *extra = "";		
		if (expected_result)
			extra = "bgcolor=\"red\"";

		if (error && error->message)
			g_fprintf (stream, "<td>---</td><td %s>PARSING gen. error: %s</td>", 
				   extra, error->message);
		else
			g_fprintf (stream, "<td>---</td><td %s>PARSING gen. error: NO ERROR MSG</td>", 
				   extra);
		if (error)
			g_error_free (error);
	}
	g_fprintf (stream, "</tr>\n");
}
