/* mg-work-widget.h
 *
 * Copyright (C) 2004 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


#ifndef __MG_WORK_WIDGET_H_
#define __MG_WORK_WIDGET_H_

#include <glib-object.h>
#include "mg-defs.h"

G_BEGIN_DECLS

#define MG_WORK_WIDGET_TYPE          (mg_work_widget_get_type())
#define MG_WORK_WIDGET(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, mg_work_widget_get_type(), MgWorkWidget)
#define IS_MG_WORK_WIDGET(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, mg_work_widget_get_type ())
#define MG_WORK_WIDGET_GET_IFACE(obj)  (G_TYPE_INSTANCE_GET_INTERFACE ((obj), MG_WORK_WIDGET_TYPE, MgWorkWidgetIface))



/* struct for the interface */
struct _MgWorkWidgetIface
{
	GTypeInterface           g_iface;

	/* virtual table */
	void         (* run)                 (MgWorkWidget *iface, guint mode);
	void         (* set_mode)            (MgWorkWidget *iface, guint mode);
	void         (* set_entry_editable)  (MgWorkWidget *iface, MgQfield *field, gboolean editable);
	void         (* show_entry_actions)  (MgWorkWidget *iface, MgQfield *field, gboolean show_actions);
	void         (* show_global_actions) (MgWorkWidget *iface, gboolean show_actions);
	MgParameter *(* get_param_for_field) (MgWorkWidget *iface, MgQfield *field);
	gboolean     (* has_been_changed)    (MgWorkWidget *iface);
	MgContext   *(* get_exec_context)    (MgWorkWidget *iface);
};

GType           mg_work_widget_get_type            (void) G_GNUC_CONST;

void            mg_work_widget_run                 (MgWorkWidget *iface, guint mode);
void            mg_work_widget_set_mode            (MgWorkWidget *iface, guint mode);
void            mg_work_widget_set_entry_editable  (MgWorkWidget *iface, MgQfield *field, gboolean editable);
void            mg_work_widget_show_entry_actions  (MgWorkWidget *iface, MgQfield *field, gboolean show_actions);
void            mg_work_widget_show_global_actions (MgWorkWidget *iface, gboolean show_actions);
MgParameter    *mg_work_widget_get_param_for_field (MgWorkWidget *iface, MgQfield *field);
gboolean        mg_work_widget_has_been_changed    (MgWorkWidget *iface);
MgContext      *mg_work_widget_get_exec_context    (MgWorkWidget *iface);

void            mg_work_widget_bind_to_work_widget (MgWorkWidget *dest_iface, const gchar *dest_field_xml_id, 
						    MgWorkWidget *source_iface, const gchar *source_field_xml_id);
void            mg_work_widget_bind_to_context     (MgWorkWidget *dest_iface, const gchar *dest_field_xml_id,
						    MgContext *source_context, const gchar *source_field_xml_id);
void            mg_work_widget_bind_to_context_all (MgWorkWidget *dest_iface, MgContext *source_context);

G_END_DECLS

#endif
