/* object-selector.h
 *
 * Copyright (C) 2002 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __OBJECT_SELECTOR__
#define __OBJECT_SELECTOR__

#include <gnome.h>
#include <config.h>
#include "conf-manager.h"

G_BEGIN_DECLS

#define OBJECT_SELECTOR_TYPE          (object_selector_get_type())
#define OBJECT_SELECTOR(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, object_selector_get_type(), ObjectSelector)
#define OBJECT_SELECTOR_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, object_selector_get_type (), ObjectSelectorClass)
#define IS_OBJECT_SELECTOR(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, object_selector_get_type ())


typedef struct _ObjectSelector ObjectSelector;
typedef struct _ObjectSelectorClass ObjectSelectorClass;
typedef struct _ObjectSelectorPriv ObjectSelectorPriv;
typedef enum   _ObjectDescriptorMode ObjectDescriptorMode;

enum _ObjectDescriptorMode
{
	OBJECT_SELECTOR_TABLES      = 1 << 0,
	OBJECT_SELECTOR_VIEWS       = 1 << 1,
	OBJECT_SELECTOR_DBFIELDS    = 1 << 2, /* needs TABLES and/or FIELDS */
	OBJECT_SELECTOR_SEQUENCES   = 1 << 3,
	OBJECT_SELECTOR_DATA_TYPES  = 1 << 4,
	OBJECT_SELECTOR_PROCS       = 1 << 5,
	OBJECT_SELECTOR_AGGS        = 1 << 6,
	OBJECT_SELECTOR_QUERIES     = 1 << 7,
	OBJECT_SELECTOR_QFIELDS     = 1 << 8, /* needs QUERIES */
	OBJECT_SELECTOR_QENVS       = 1 << 9, /* needs QUERIES */
	OBJECT_SELECTOR_QVIEWS      = 1 << 10,
	OBJECT_SELECTOR_QVIEW_FS    = 1 << 11 /* needs QVIEWS */
};

enum _ObjectSelectorParams {
	OBJECT_SELECTOR_PARAM_TOP_QUERY,    /* pointer to a Query */
	OBJECT_SELECTOR_PARAM_SUB_QUERIES   /* boolean */
};


/* struct for the object's data */
struct _ObjectSelector
{
	GtkVBox             object;

	ObjectSelectorPriv *priv;
};

/* struct for the object's class */
struct _ObjectSelectorClass
{
	GtkVBoxClass        parent_class;

	void              (*selection_changed) (ObjectSelector * combo, GObject *sel_object);
};

/* 
 * Generic widget's methods 
*/
guint      object_selector_get_type            (void);
GtkWidget *object_selector_new                 (ConfManager *conf, ObjectDescriptorMode mode, ...);

/*
 * Widget's manipulations
 */
void       object_selector_set_selection              (ObjectSelector *os, GObject *selection);
void       object_selector_set_selection_parent       (ObjectSelector *os, 
						       GObject *selection, GObject *parent);
void       object_selector_set_headers_visible        (ObjectSelector *os, gboolean visible);
void       object_selector_set_comments_visible       (ObjectSelector *os, gboolean visible);
void       object_selector_set_column_label           (ObjectSelector *os, guint column, 
						       const gchar *label);

/*
 * Getting information
 */
GObject   *object_selector_get_selected_object        (ObjectSelector *os);
GObject   *object_selector_get_selected_object_parent (ObjectSelector *os);

G_END_DECLS

#endif



