/* item-selector.h
 *
 * Copyright (C) 2002 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __ITEM_SELECTOR__
#define __ITEM_SELECTOR__

#include <gnome.h>
#include <config.h>

G_BEGIN_DECLS

#define ITEM_SELECTOR_TYPE          (item_selector_get_type())
#define ITEM_SELECTOR(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, item_selector_get_type(), ItemSelector)
#define ITEM_SELECTOR_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, item_selector_get_type (), ItemSelectorClass)
#define IS_ITEM_SELECTOR(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, item_selector_get_type ())


typedef struct _ItemSelector            ItemSelector;
typedef struct _ItemSelectorClass       ItemSelectorClass;
typedef struct _ItemSelectorPrivate     ItemSelectorPrivate;
typedef enum   _ItemSelectorDisplayMode ItemSelectorDisplayMode;

typedef gchar * (*ItemSelectorFunc) (gpointer data);

enum _ItemSelectorDisplayMode 
{
	ITEM_SELECTOR_MENU,
	ITEM_SELECTOR_COMBO
};


/* struct for the object's data */
struct _ItemSelector
{
	GtkVBox              object;
	
	ItemSelectorPrivate *priv;
};

/* struct for the object's class */
struct _ItemSelectorClass
{
	GtkVBoxClass         parent_class;

	void               (*selection_changed) (ItemSelector * is, gpointer data);
};

/* 
 * default widget's methods 
*/
guint      item_selector_get_type                  (void);
GtkWidget *item_selector_new                       (ItemSelectorDisplayMode mode);

/*
 * Content setting
 */
void       item_selector_set_static_content_offset (ItemSelector * is, GSList * list, gint offset);
void       item_selector_set_static_content_func   (ItemSelector * is, GSList * list, ItemSelectorFunc func);
void       item_selector_set_dyn_content           (ItemSelector * is, GObject *manager,
						    const gchar *creation_signal_name,
						    const gchar *destroy_signal_name,
						   GSList * initial_list, ItemSelectorFunc func);

void       item_selector_set_selection_txt         (ItemSelector * is, const gchar * item);
void       item_selector_set_selection_num         (ItemSelector * is, gint num);
void       item_selector_set_selection_ptr         (ItemSelector * is, gpointer ptr);

/*
 * Getting information
 */
gpointer   item_selector_get_selection             (ItemSelector * is);

G_END_DECLS

#endif
