/* conds-view.h
 *
 * Copyright (C) 2002 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __CONDS_VIEW__
#define __CONDS_VIEW__

#include <gnome.h>
#include "query.h"
#include "canvas-base.h"

G_BEGIN_DECLS

#define CONDS_VIEW_TYPE          (conds_view_get_type())
#define CONDS_VIEW(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, conds_view_get_type(), CondsView)
#define CONDS_VIEW_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, conds_view_get_type (), CondsViewClass)
#define IS_CONDS_VIEW(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, conds_view_get_type ())


typedef struct _CondsView        CondsView;
typedef struct _CondsViewClass   CondsViewClass;
typedef struct _CondsViewPrivate CondsViewPrivate;

/* struct for the object's data */
struct _CondsView
{
	GnomeCanvas         widget;

	CondsViewPrivate   *priv;
};

/* struct for the object's class */
struct _CondsViewClass
{
	GnomeCanvasClass parent_class;
};

/* generic widget's functions */
guint            conds_view_get_type        (void);
GtkWidget       *conds_view_new             (GObject *manager);
GtkWidget       *conds_view_new_in_sw       (GObject *manager);

void             conds_view_refresh_items   (CondsView *conds);

G_END_DECLS

#endif
