/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */

/*
 *  Medusa
 *
 *  Copyright (C) 1999, 2000 Eazel, Inc.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Author: Rebecca Schulman <rebecka@eazel.com>
 *
 *  medusa-utils.h -  Utility functions used across medusa
 */

#ifndef MEDUSA_UTILS_H
#define MEDUSA_UTILS_H

typedef gboolean (*MedusaGPredicateFunc) 	(gpointer	data,
						 gpointer	user_data);


char *           medusa_full_path_from_directory_and_file      (char *directory_name,
								char *file_name);
char *           medusa_full_uri_from_directory_and_file       (char *directory_name,
								char *file_name);

gboolean         medusa_string_has_prefix                      (char *string,
                                                                char *prefix);

/* Returns TRUE if a group gid contains the user with user id uid, FALSE otherwise */
gboolean         medusa_group_contains                         (int gid, int uid);


GList *          medusa_g_list_partition                       (GList	          *list,
                                                                MedusaGPredicateFunc  predicate,
                                                                gpointer	           user_data,
                                                                GList                 **failed);

/* Takes the intersection of two integer lists, both sorted in descending order.
   returns the merged list and 
   stores the number of entries in the merged_list in number_of_results */
gint32 *          medusa_intersect_two_descending_integer_lists          (gint32 *first_list,
                                                                          int first_list_entry_count,
                                                                          gint32 *second_list,
                                                                          int second_list_entry_count,
                                                                          int *number_of_results);

/* Takes the difference of two integer lists, both sorted in descending order.
   (ie the set of element in the first list, but not in the second )
   returns the merged_list and
   stores the number of entries in the merged_list in number_of_results */
gint32 *         medusa_difference_of_two_descending_integer_lists     (gint32 *first_list,
                                                                        int first_list_entry_count,
                                                                        gint32 *second_list,
                                                                        int second_list_entry_count,
                                                                        int *number_of_results);

void             medusa_g_list_free_deep_custom                        (GList *list, 
                                                                        GFunc element_free_func, 
                                                                        gpointer user_data);
void             medusa_g_list_free_deep                               (GList *list);
#endif /* MEDUSA_UTILS_H */
