'''
Defines a L{Task} to execute when a L{AEEvent.InputGesture} occurs.

@author: Peter Parente
@organization: IBM Corporation
@copyright: Copyright (c) 2005, 2006 IBM Corporation
@license: The BSD License

All rights reserved. This program and the accompanying materials are made 
available under the terms of the BSD license which accompanies
this distribution, and is available at
U{http://www.opensource.org/licenses/bsd-license.php}
'''
import Base, Constants

class InputTask(Base.Task):
  '''
  Executes when an input gesture occurs.

  This class registers its name and whether it should be monitored by default
  in an L{AEMonitor} using the L{Constants.registerTaskType}
  function when this module is first imported. The L{AEMonitor}
  can use this information to build its menus.  
  '''
  Constants.registerTaskType('InputTask', False)
