'''
Defines a L{Perk} for the gdm login screen.

@author: Peter Parente
@organization: IBM Corporation
@copyright: Copyright (c) 2006 IBM Corporation
@license: Common Public License 1.0

All rights reserved. This program and the accompanying materials are made 
available under the terms of the Common Public License v1.0 which accompanies
this distribution, and is available at
U{http://www.opensource.org/licenses/cpl1.0.php}
'''
# import useful modules for Perks
import Perk, Task
from POR import POR
from i18n import _

# metadata describing this Perk
# apply it to all Tiers since the login greeter name can change and run it in
# a special login profile
__uie__ = dict(kind='perk', tier=None, all_tiers=True)

class GdmPerk(Perk.Perk):
  '''
  Registers L{Task}s to announce the focused control on startup, typically the
  username field.  
  '''
  def init(self):
    self.registerTask(AnnounceStartup())
    self.registerTask(AnnounceLabelChange())
    
  def getDescription(self):
    return _('Corrects username/password accessibility problems at login. '
             'Applies to gdm by default. Works best with the plain greeter.')
  
class AnnounceStartup(Task.ViewTask):
  '''
  Announces the control that has the focus on startup.
  '''
  def executeFirstGained(self, por, title, **kwargs):
    self.sayWindow(text=_('GDM Login'))
    # find the widget that has the focus
    por = self.getAccFocus()
    # now synthesize a focus and caret announcement
    self.doTask('default focus', por=por, gained=True)
    self.doTask('default caret', por=por, text=u'', text_offset=0, added=None)
    return False
  
class AnnounceLabelChange(Task.CaretTask):
  '''
  Announces the changing role of the text box that serves dual duty as the 
  username and password field.
  '''
  def execute(self, por, text, text_offset, added, **kwargs):
    if not text and text_offset == 0 and added is not None:
      if added:
        self.doTask('default focus', por=por, gained=True)
        self.doTask('default caret', por=por, text=u'', text_offset=0,
                    added=None)
      return False
