'''
Defines a L{Task} to execute when the selector changes.

@author: Pete Brunet
@organization: IBM Corporation
@copyright: Copyright (c) 2005 IBM Corporation
@license: Common Public License 1.0

All rights reserved. This program and the accompanying materials are made 
available under the terms of the Common Public License v1.0 which accompanies
this distribution, and is available at
U{http://www.opensource.org/licenses/cpl1.0.php}
'''

import Base, Constants
import AEEvent

class SelectorTask(Base.Task):
  '''
  Executed when a selector change occurs. 

  This class registers its name and whether it should be monitored by default in
  an L{AEMonitor.EventMonitor} using the L{Constants.registerTaskType} function
  when this module is first imported. The L{AEMonitor.EventMonitor} can use this
  information to build its menus.
  '''
  Constants.registerTaskType('SelectorTask', True)

  def getType(self):
    '''
    @return: Type of L{AEEvent} this L{Task} wants to handle
    @rtype: class
    '''
    return AEEvent.SelectorChange
  
  def update(self, por, item_text, layer, **kwargs):
    '''
    Update this L{Task} in response to a consumed selector change event. Called 
    by L{Tier.Tier._executeTask}.
    
    @param item_text: The accessible text or name of the item at the por.
    @type item_text: string
    @param por: Point of regard for the related accessible
    @type por: L{POR}
    @param layer: Layer on which the event occurred, one of L{Task.FOCUS_LAYER},
      L{Task.TIER_LAYER}, or L{Task.BACKGROUND_LAYER}
    @type layer: integer
    '''
    pass
  
  def execute(self, por, item_text, layer, **kwargs):
    '''
    Executes this L{Task} in response to a selector change event. Called by 
    L{Tier.Tier._executeTask}.
    
    @param item_text: The accessible text or name of the item at the por.
    @type item_text: string
    @param por: Point of regard for the related accessible
    @type por: L{POR}
    @param layer: Layer on which the event occurred, one of L{Task.FOCUS_LAYER},
      L{Task.TIER_LAYER}, or L{Task.BACKGROUND_LAYER}
    @type layer: integer
    @return: Should processing continue? Always returns True by default.
    @rtype: boolean
    '''
    return True
